/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.IdFunction;
import ice.mozilla.javascript.IdFunctionMaster;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.NativeGlobal;
import ice.mozilla.javascript.PropertyException;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.ScriptableObject;
import ice.mozilla.javascript.UniqueTag;

public abstract class IdScriptable
extends ScriptableObject
implements IdFunctionMaster {
    private int maxId;
    private Object[] idMapData;
    private byte[] attributesArray;
    private static final boolean CACHE_NAMES = true;
    private int lastIdCache;
    private static final int USE_DYNAMIC_SCOPE_FLAG = 1;
    private static final int SEAL_FUNCTIONS_FLAG = 2;
    private byte setupFlags;
    private byte extraIdAttributes;

    public boolean has(String name, Scriptable start) {
        int id;
        if (this.maxId != 0 && (id = this.mapNameToId_writeCached(name)) != 0) {
            return this.hasValue(id);
        }
        return super.has(name, start);
    }

    public Object get(String name, Scriptable start) {
        int id;
        if (this.maxId != 0 && (id = this.mapNameToId_writeCached(name)) != 0) {
            Object[] data = this.idMapData;
            if (data == null) {
                return this.getIdValue(id);
            }
            Object value = data[id - 1];
            if (value == null) {
                value = this.getIdValue(id);
            } else if (value == UniqueTag.NULL_VALUE) {
                value = null;
            }
            return value;
        }
        return super.get(name, start);
    }

    public void put(String name, Scriptable start, Object value) {
        int id;
        if (this.maxId != 0 && (id = this.mapNameToId_cached(name)) != 0) {
            int attr = this.getAttributes(id);
            if ((attr & 1) == 0) {
                if (start == this) {
                    this.setIdValue(id, value);
                } else {
                    start.put(name, start, value);
                }
            }
            return;
        }
        super.put(name, start, value);
    }

    public void delete(String name) {
        int id;
        if (this.maxId != 0 && (id = this.mapNameToId(name)) != 0 && !this.isSealed()) {
            int attr = this.getAttributes(id);
            if ((attr & 4) == 0) {
                this.deleteIdValue(id);
            }
            return;
        }
        super.delete(name);
    }

    public int getAttributes(String name, Scriptable start) throws PropertyException {
        int id;
        if (this.maxId != 0 && (id = this.mapNameToId(name)) != 0 && this.hasValue(id)) {
            return this.getAttributes(id);
        }
        return super.getAttributes(name, start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(String name, Scriptable start, int attributes) throws PropertyException {
        int id;
        if (this.maxId != 0 && (id = this.mapNameToId(name)) != 0 && this.hasValue(id)) {
            IdScriptable idScriptable = this;
            synchronized (idScriptable) {
                this.setAttributes(id, attributes);
            }
            return;
        }
        super.setAttributes(name, start, attributes);
    }

    synchronized void addPropertyAttribute(int attribute) {
        this.extraIdAttributes = (byte)(this.extraIdAttributes | (byte)attribute);
        super.addPropertyAttribute(attribute);
    }

    public void defineProperty(String propertyName, Object value, int attributes) {
        int id;
        if (this.maxId != 0 && (id = this.mapNameToId(propertyName)) != 0) {
            int default_attributes = this.getIdDefaultAttributes(id);
            if ((default_attributes & 1) != 0) {
                throw new RuntimeException("Attempt to redefine read-only id " + propertyName);
            }
            this.setAttributes(id, attributes);
            this.setIdValue(id, value);
            return;
        }
        super.defineProperty(propertyName, value, attributes);
    }

    Object[] getIds(boolean getAll) {
        Object[] result = super.getIds(getAll);
        if (this.maxId != 0) {
            Object[] ids = null;
            int count = 0;
            for (int id = this.maxId; id != 0; --id) {
                if (!this.hasValue(id) || !getAll && (this.getAttributes(id) & 2) != 0) continue;
                if (count == 0) {
                    ids = new Object[id];
                }
                ids[count++] = this.getIdName(id);
            }
            if (count != 0) {
                if (result.length == 0 && ids.length == count) {
                    result = ids;
                } else {
                    Object[] tmp = new Object[result.length + count];
                    System.arraycopy(result, 0, tmp, 0, result.length);
                    System.arraycopy(ids, 0, tmp, result.length, count);
                    result = tmp;
                }
            }
        }
        return result;
    }

    private int mapNameToId_cached(String name) {
        int id;
        Object[] data = this.idMapData;
        if (data != null && data[(id = this.lastIdCache) - 1 + this.maxId] == name) {
            return id;
        }
        return this.mapNameToId(name);
    }

    private int mapNameToId_writeCached(String name) {
        Object[] data = this.idMapData;
        if (data != null) {
            int id = this.lastIdCache;
            if (data[id - 1 + this.maxId] == name) {
                return id;
            }
            id = this.mapNameToId(name);
            if (id != 0) {
                data[id - 1 + this.maxId] = name;
                this.lastIdCache = id;
            }
            return id;
        }
        return this.mapNameToId(name);
    }

    protected abstract int mapNameToId(String var1);

    protected abstract String getIdName(int var1);

    protected int getIdDefaultAttributes(int id) {
        return 2;
    }

    protected boolean hasIdValue(int id) {
        return true;
    }

    protected Object getIdValue(int id) {
        IdFunction f = this.newIdFunction(id);
        f.setParentScope(this.getParentScope());
        return this.cacheIdValue(id, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setIdValue(int id, Object value) {
        IdScriptable idScriptable = this;
        synchronized (idScriptable) {
            Object[] data = this.ensureIdData();
            data[id - 1] = value != null ? value : UniqueTag.NULL_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object cacheIdValue(int id, Object value) {
        IdScriptable idScriptable = this;
        synchronized (idScriptable) {
            Object[] data = this.ensureIdData();
            Object curValue = data[id - 1];
            if (curValue == null) {
                data[id - 1] = value != null ? value : UniqueTag.NULL_VALUE;
            } else {
                value = curValue;
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteIdValue(int id) {
        IdScriptable idScriptable = this;
        synchronized (idScriptable) {
            this.ensureIdData()[id - 1] = NOT_FOUND;
        }
    }

    public Object execMethod(int methodId, IdFunction function, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        throw IdFunction.onBadMethodId(this, methodId);
    }

    public int methodArity(int methodId) {
        return -1;
    }

    protected final int getMaxId() {
        return this.maxId;
    }

    protected void setMaxId(int maxId) {
        if (maxId < this.maxId) {
            Context.codeBug();
        }
        this.maxId = maxId;
    }

    protected void setSealFunctionsFlag(boolean sealed) {
        this.setSetupFlag(2, sealed);
    }

    protected void setFunctionParametrs(Context cx) {
        this.setSetupFlag(1, cx.hasCompileFunctionsWithDynamicScope());
    }

    private void setSetupFlag(int flag, boolean value) {
        this.setupFlags = (byte)(value ? this.setupFlags | flag : this.setupFlags & ~flag);
    }

    public void addAsPrototype(int maxId, Context cx, Scriptable scope, boolean sealed) {
        this.setMaxId(maxId);
        this.setSealFunctionsFlag(sealed);
        this.setFunctionParametrs(cx);
        int constructorId = this.mapNameToId("constructor");
        if (constructorId == 0) {
            throw new RuntimeException("No id for constructor property");
        }
        IdFunction ctor = this.newIdFunction(this.getClassName(), constructorId);
        ctor.initAsConstructor(scope, this);
        this.fillConstructorProperties(cx, ctor, sealed);
        if (sealed) {
            ctor.sealObject();
            ctor.addPropertyAttribute(1);
        }
        this.setParentScope(ctor);
        this.setPrototype(IdScriptable.getObjectPrototype(scope));
        this.cacheIdValue(constructorId, ctor);
        if (sealed) {
            this.sealObject();
        }
        IdScriptable.defineProperty(scope, this.getClassName(), ctor, 2);
    }

    protected void fillConstructorProperties(Context cx, IdFunction ctor, boolean sealed) {
    }

    protected void addIdFunctionProperty(Scriptable obj, int id, boolean sealed) {
        IdFunction f = this.newIdFunction(id);
        if (sealed) {
            f.sealObject();
        }
        IdScriptable.defineProperty(obj, this.getIdName(id), f, 2);
    }

    protected Scriptable nextInstanceCheck(Scriptable thisObj, IdFunction f, boolean readOnly) {
        if (readOnly && 0 != (this.setupFlags & 1) && (thisObj = thisObj.getPrototype()) != null) {
            return thisObj;
        }
        throw NativeGlobal.typeError1("msg.incompat.call", f.getFunctionName(), f);
    }

    protected IdFunction newIdFunction(int id) {
        return this.newIdFunction(this.getIdName(id), id);
    }

    protected IdFunction newIdFunction(String name, int id) {
        IdFunction f = new IdFunction(this, name, id);
        if (0 != (this.setupFlags & 2)) {
            f.sealObject();
        }
        return f;
    }

    protected final Object wrap_double(double x) {
        return x == x ? new Double(x) : ScriptRuntime.NaNobj;
    }

    protected final Object wrap_int(int x) {
        byte b = (byte)x;
        if (b == x) {
            return new Byte(b);
        }
        return new Integer(x);
    }

    protected final Object wrap_long(long x) {
        int i = (int)x;
        if ((long)i == x) {
            return this.wrap_int(i);
        }
        return new Long(x);
    }

    protected final Object wrap_boolean(boolean x) {
        return x ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean hasValue(int id) {
        Object value;
        Object[] data = this.idMapData;
        if (data == null || (value = data[id - 1]) == null) {
            return this.hasIdValue(id);
        }
        return value != NOT_FOUND;
    }

    private Object[] ensureIdData() {
        Object[] data = this.idMapData;
        if (data == null) {
            data = new Object[this.maxId * 2];
            this.idMapData = data;
        }
        return data;
    }

    private int getAttributes(int id) {
        int attributes = this.getIdDefaultAttributes(id) | this.extraIdAttributes;
        byte[] array = this.attributesArray;
        if (array != null) {
            attributes |= 0xFF & array[id - 1];
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttributes(int id, int attributes) {
        int defaultAttrs = this.getIdDefaultAttributes(id);
        if ((attributes & defaultAttrs) != defaultAttrs) {
            throw new RuntimeException("Attempt to unset default attributes");
        }
        byte[] array = this.attributesArray;
        if (array == null && (attributes &= ~defaultAttrs) != 0) {
            IdScriptable idScriptable = this;
            synchronized (idScriptable) {
                array = this.attributesArray;
                if (array == null) {
                    this.attributesArray = array = new byte[this.maxId];
                }
            }
        }
        if (array != null) {
            array[id - 1] = (byte)attributes;
        }
    }
}

