/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Context;
import java.io.IOException;
import java.io.Reader;

final class LineBuffer {
    static final int BUFLEN = 256;
    private static final int EOL_HINT_MASK = 57296;
    private Reader in;
    private char[] otherBuffer = null;
    private char[] buffer = null;
    private int offset = 0;
    private int end = 0;
    private int otherEnd;
    private int lineno;
    private int lineStart = 0;
    private int otherStart = 0;
    private int prevStart = 0;
    private boolean lastWasCR = false;
    private boolean hitEOF = false;
    private static final boolean checkSelf = true;

    LineBuffer(Reader in, int lineno) {
        this.in = in;
        this.lineno = lineno;
    }

    int read() throws IOException {
        char c;
        do {
            if (this.end == this.offset && !this.fill()) {
                return -1;
            }
            c = this.buffer[this.offset];
            ++this.offset;
            if ((c & 0xDFD0) != 0) continue;
            switch (c) {
                case '\r': {
                    if (this.offset != this.end) {
                        if (this.buffer[this.offset] == '\n') {
                            ++this.offset;
                        }
                    } else {
                        this.lastWasCR = true;
                    }
                }
                case '\n': 
                case '\u2028': 
                case '\u2029': {
                    this.prevStart = this.lineStart;
                    this.lineStart = this.offset;
                    ++this.lineno;
                    return 10;
                }
            }
        } while (c >= '\u0080' && LineBuffer.formatChar(c));
        return c;
    }

    void unread() {
        if (this.offset == 0 && !this.hitEOF) {
            Context.codeBug();
        }
        if (this.offset == 0) {
            return;
        }
        --this.offset;
        char c = this.buffer[this.offset];
        if ((c & 0xDFD0) == 0 && LineBuffer.eolChar(c)) {
            this.lineStart = this.prevStart;
            --this.lineno;
        }
    }

    private void skipFormatChar() {
        if (!LineBuffer.formatChar(this.buffer[this.offset])) {
            Context.codeBug();
        }
        if (this.offset != 0) {
            char tmp = this.buffer[this.offset];
            this.buffer[this.offset] = this.buffer[this.offset - 1];
            this.buffer[this.offset - 1] = tmp;
        } else if (this.otherEnd != 0) {
            char tmp = this.buffer[this.offset];
            this.buffer[this.offset] = this.otherBuffer[this.otherEnd - 1];
            this.otherBuffer[this.otherEnd - 1] = tmp;
        }
        ++this.offset;
    }

    int peek() throws IOException {
        while (this.end != this.offset || this.fill()) {
            char c = this.buffer[this.offset];
            if ((c & 0xDFD0) == 0 && LineBuffer.eolChar(c)) {
                return 10;
            }
            if (c < '\u0080' || !LineBuffer.formatChar(c)) {
                return c;
            }
            this.skipFormatChar();
        }
        return -1;
    }

    boolean match(int test) throws IOException {
        if ((test & 0xDFD0) == 0 && LineBuffer.eolChar(test)) {
            Context.codeBug();
        }
        if (test >= 128 && LineBuffer.formatChar(test)) {
            Context.codeBug();
        }
        while (this.end != this.offset || this.fill()) {
            char c = this.buffer[this.offset];
            if (test == c) {
                ++this.offset;
                return true;
            }
            if (c < '\u0080' || !LineBuffer.formatChar(c)) {
                return false;
            }
            this.skipFormatChar();
        }
        return false;
    }

    String getLine() {
        int i = this.offset;
        while (true) {
            char c;
            if (i == this.end) {
                if (this.end == this.buffer.length) {
                    char[] tmp = new char[this.buffer.length * 2];
                    System.arraycopy(this.buffer, 0, tmp, 0, this.end);
                    this.buffer = tmp;
                }
                int charsRead = 0;
                try {
                    charsRead = this.in.read(this.buffer, this.end, this.buffer.length - this.end);
                }
                catch (IOException ioe) {
                    break;
                }
                if (charsRead < 0) break;
                this.end += charsRead;
            }
            if (((c = this.buffer[i]) & 0xDFD0) == 0 && LineBuffer.eolChar(c)) break;
            ++i;
        }
        int start = this.lineStart;
        if (this.lineStart < 0) {
            StringBuffer sb = new StringBuffer(this.otherEnd - this.otherStart + i);
            sb.append(this.otherBuffer, this.otherStart, this.otherEnd - this.otherStart);
            sb.append(this.buffer, 0, i);
            return sb.toString();
        }
        return new String(this.buffer, this.lineStart, i - this.lineStart);
    }

    int getOffset() {
        if (this.lineStart < 0) {
            return this.offset + (this.otherEnd - this.otherStart);
        }
        return this.offset - this.lineStart;
    }

    private boolean fill() throws IOException {
        if (this.end != this.offset) {
            Context.codeBug();
        }
        char[] tempBuffer = this.buffer;
        this.buffer = this.otherBuffer;
        this.otherBuffer = tempBuffer;
        if (this.buffer == null) {
            this.buffer = new char[256];
        }
        this.otherStart = this.lineStart >= 0 ? this.lineStart : 0;
        this.otherEnd = this.end;
        this.lineStart = this.otherBuffer == null ? 0 : -1;
        this.prevStart = this.lineStart;
        this.offset = 0;
        this.end = this.in.read(this.buffer, 0, this.buffer.length);
        if (this.end < 0) {
            this.end = 0;
            this.hitEOF = true;
            return false;
        }
        if (this.lastWasCR) {
            if (this.buffer[0] == '\n') {
                ++this.offset;
                if (this.end == 1) {
                    return this.fill();
                }
            }
            this.lineStart = this.offset;
            this.lastWasCR = false;
        }
        return true;
    }

    int getLineno() {
        return this.lineno;
    }

    boolean eof() {
        return this.hitEOF;
    }

    private static boolean formatChar(int c) {
        return Character.getType((char)c) == 16;
    }

    private static boolean eolChar(int c) {
        return c == 13 || c == 10 || c == 8232 || c == 8233;
    }
}

