/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript.regexp;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.Function;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.ObjArray;
import ice.mozilla.javascript.RegExpProxy;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.ScriptableObject;
import ice.mozilla.javascript.Undefined;
import ice.mozilla.javascript.regexp.GlobData;
import ice.mozilla.javascript.regexp.MatchData;
import ice.mozilla.javascript.regexp.NativeRegExp;
import ice.mozilla.javascript.regexp.ReplaceData;
import ice.mozilla.javascript.regexp.SubString;

public class RegExpImpl
implements RegExpProxy {
    String input;
    boolean multiline;
    ObjArray parens = new ObjArray();
    SubString lastMatch;
    SubString lastParen;
    SubString leftContext;
    SubString rightContext;

    public boolean isRegExp(Object obj) {
        return obj instanceof NativeRegExp;
    }

    public Object newRegExp(Context cx, Scriptable scope, String source, String global, boolean flat) {
        return new NativeRegExp(cx, scope, source, global, flat);
    }

    public Object match(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        MatchData mdata = new MatchData();
        mdata.optarg = 1;
        mdata.mode = 1;
        mdata.parent = ScriptableObject.getTopLevelScope(scope);
        Object rval = RegExpImpl.matchOrReplace(cx, scope, thisObj, args, this, mdata, false);
        return mdata.arrayobj == null ? rval : mdata.arrayobj;
    }

    public Object search(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        MatchData mdata = new MatchData();
        mdata.optarg = 1;
        mdata.mode = (byte)3;
        mdata.parent = ScriptableObject.getTopLevelScope(scope);
        return RegExpImpl.matchOrReplace(cx, scope, thisObj, args, this, mdata, false);
    }

    public Object replace(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        char[] charArray;
        Scriptable arg1 = args.length < 2 ? Undefined.instance : args[1];
        String repstr = null;
        Function lambda = null;
        if (arg1 instanceof Function) {
            lambda = (Function)arg1;
        } else {
            repstr = ScriptRuntime.toString(arg1);
        }
        ReplaceData rdata = new ReplaceData();
        rdata.optarg = 2;
        rdata.mode = (byte)2;
        rdata.lambda = lambda;
        rdata.repstr = repstr == null ? null : repstr.toCharArray();
        rdata.dollar = repstr == null ? -1 : repstr.indexOf(36);
        rdata.charArray = null;
        rdata.length = 0;
        rdata.index = 0;
        rdata.leftIndex = 0;
        Object val = RegExpImpl.matchOrReplace(cx, scope, thisObj, args, this, rdata, true);
        if (rdata.charArray == null) {
            if (rdata.global || val == null || !val.equals(Boolean.TRUE)) {
                return rdata.str;
            }
            int leftlen = this.leftContext.length;
            int length = leftlen + rdata.findReplen(cx, this);
            charArray = new char[length];
            SubString leftContext = this.leftContext;
            System.arraycopy(leftContext.charArray, leftContext.index, charArray, 0, leftlen);
            rdata.doReplace(cx, this, charArray, leftlen);
            rdata.charArray = charArray;
            rdata.length = length;
        }
        SubString rc = this.rightContext;
        int rightlen = rc.length;
        int length = rdata.length + rightlen;
        charArray = new char[length];
        System.arraycopy(rdata.charArray, 0, charArray, 0, rdata.charArray.length);
        System.arraycopy(rc.charArray, rc.index, charArray, rdata.length, rightlen);
        return new String(charArray, 0, length);
    }

    private static Object matchOrReplace(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RegExpImpl reImpl, GlobData data, boolean forceFlat) throws JavaScriptException {
        NativeRegExp re;
        String str;
        data.str = str = ScriptRuntime.toString(thisObj);
        Scriptable topScope = ScriptableObject.getTopLevelScope(scope);
        if (args.length == 0) {
            re = new NativeRegExp(cx, topScope, "", "", false);
        } else if (args[0] instanceof NativeRegExp) {
            re = (NativeRegExp)args[0];
        } else {
            String opt;
            String src = ScriptRuntime.toString(args[0]);
            if (data.optarg < args.length) {
                args[0] = src;
                opt = ScriptRuntime.toString(args[data.optarg]);
            } else {
                opt = null;
            }
            re = new NativeRegExp(cx, topScope, src, opt, forceFlat);
        }
        data.regexp = re;
        data.global = (re.getFlags() & 1) != 0;
        int[] indexp = new int[]{0};
        Object result = null;
        if (data.mode == 3) {
            result = re.executeRegExp(cx, scope, reImpl, str, indexp, 0);
            result = result != null && result.equals(Boolean.TRUE) ? new Integer(reImpl.leftContext.length) : new Integer(-1);
        } else if (data.global) {
            re.setLastIndex(0.0);
            int count = 0;
            while (indexp[0] <= str.length() && (result = re.executeRegExp(cx, scope, reImpl, str, indexp, 0)) != null && result.equals(Boolean.TRUE)) {
                data.doGlobal(cx, scope, count, reImpl);
                if (reImpl.lastMatch.length == 0) {
                    if (indexp[0] == str.length()) break;
                    indexp[0] = indexp[0] + 1;
                }
                ++count;
            }
        } else {
            result = re.executeRegExp(cx, scope, reImpl, str, indexp, data.mode == 2 ? 0 : 1);
        }
        return result;
    }

    public int find_split(Scriptable scope, String target, String separator, Object reObj, int[] ip, int[] matchlen, boolean[] matched, String[][] parensp) {
        int result;
        block5: {
            int i = ip[0];
            int length = target.length();
            Context cx = Context.getCurrentContext();
            int version = cx.getLanguageVersion();
            NativeRegExp re = (NativeRegExp)reObj;
            while (true) {
                int ipsave = ip[0];
                ip[0] = ++i;
                Object ret = re.executeRegExp(cx, scope, this, target, ip, 0);
                if (ret != Boolean.TRUE) {
                    ip[0] = ipsave;
                    matchlen[0] = 1;
                    matched[0] = false;
                    return length;
                }
                i = ip[0];
                ip[0] = ipsave;
                matched[0] = true;
                SubString sep = this.lastMatch;
                matchlen[0] = sep.length;
                if (matchlen[0] != 0 || i != ip[0]) break;
                if (i != length) continue;
                if (version == 120) {
                    matchlen[0] = 1;
                    result = i;
                } else {
                    result = -1;
                }
                break block5;
            }
            result = i - matchlen[0];
        }
        int size = this.parens.size();
        parensp[0] = new String[size];
        for (int num = 0; num < size; ++num) {
            SubString parsub = this.getParenSubString(num);
            parensp[0][num] = parsub.toString();
        }
        return result;
    }

    SubString getParenSubString(int i) {
        SubString parsub;
        if (i < this.parens.size() && (parsub = (SubString)this.parens.get(i)) != null) {
            return parsub;
        }
        return SubString.emptySubString;
    }
}

