/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.dialog.swing;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class DecimalJTextField
extends JTextField {
    public DecimalJTextField(double value, final int maxLength, int columns) {
        super(columns);
        this.setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent comp) {
                boolean returnValue = true;
                JTextField textField = (JTextField)comp;
                String content = textField.getText();
                if (content.length() != 0 && textField.getText().length() < maxLength) {
                    try {
                        Double.parseDouble(textField.getText());
                    }
                    catch (NumberFormatException e) {
                        returnValue = false;
                    }
                } else if (textField.getText().length() > 0) {
                    textField.setText(textField.getText().substring(0, maxLength));
                } else {
                    textField.setText("0");
                }
                return returnValue;
            }

            public boolean shouldYieldFocus(JComponent input) {
                boolean valid = super.shouldYieldFocus(input);
                if (!valid) {
                    DecimalJTextField.this.getToolkit().beep();
                }
                return valid;
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (!Character.isDigit(c) && c != '\b' && c != '\u007f' && c != '.') {
                    DecimalJTextField.this.getToolkit().beep();
                    e.consume();
                }
            }
        });
        this.setText(value + "");
    }

    public double getValue() {
        return Double.parseDouble(this.getText());
    }

    public void setValue(double value) {
        this.setText(value + "");
    }
}

