/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.wizard;

import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.dbtools.autorest.generator.AutoRestCodeGenerator;
import oracle.dbtools.autorest.model.RestObjectData;
import oracle.dbtools.autorest.ui.RestObjectDetailsPanel;
import oracle.dbtools.autorest.wizard.AbstractScriptRunnerTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;

public class RestWizObjectDetailsPanel
extends AbstractScriptRunnerTraversablePanel {
    private RestObjectDetailsPanel objectDetailsPanel;
    private transient RestObjectData objectDataModel;
    private transient ObjectDataModelListener objectDataModelListener = new ObjectDataModelListener();
    private GridBagLayout gridBagLayout = new GridBagLayout();
    transient WizardCallbacks wizardCallbacks = null;

    private void jbInit(TraversableContext traversableContext) {
        this.setName("RestWizObjectDetailsPanel");
        this.wizardCallbacks = traversableContext.getWizardCallbacks();
        this.objectDataModel = (RestObjectData)traversableContext.get("KEY_REST_OBJECT_DATA");
        this.objectDataModel.addPropertyChangeListener(this.objectDataModelListener);
        this.objectDetailsPanel = new RestObjectDetailsPanel(this.objectDataModel);
        if (this.wizardCallbacks != null) {
            this.wizardCallbacks.wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(!this.objectDataModel.isInvalidObject()), Boolean.valueOf(!this.objectDataModel.isInvalidObject()));
        }
        this.setLayout(this.gridBagLayout);
        this.add(this.objectDetailsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 10, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        if (this.objectDetailsPanel == null) {
            this.jbInit(traversableContext);
        } else {
            this.objectDetailsPanel.addListeners();
            this.objectDetailsPanel.updatePanel();
        }
        if (this.objectDataModel != null) {
            traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(!this.objectDataModel.isInvalidObject()), Boolean.valueOf(!this.objectDataModel.isInvalidObject()));
        } else {
            traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1 && this.objectDetailsPanel != null) {
            if (!this.objectDetailsPanel.validInfo()) {
                throw new TraversalException(this.objectDetailsPanel.getErrorMessage());
            }
            this.objectDataModel = this.objectDetailsPanel.getValues();
            traversableContext.put("KEY_REST_OBJECT_DATA", (Object)this.objectDataModel);
            this.objectDetailsPanel.removeListeners();
        }
    }

    public Object getExitTransition() {
        return "Transition.Members";
    }

    @Override
    protected String getScriptForProcessing() {
        String string = null;
        AutoRestCodeGenerator autoRestCodeGenerator = AutoRestCodeGenerator.getInstance();
        string = autoRestCodeGenerator.generate(this.objectDataModel.getVersion(), "AUTO_REST_ENABLE_OBJECT", "restObjectData", this.objectDataModel);
        return string;
    }

    @Override
    protected String getTitle() {
        return "DetailTitle";
    }

    @Override
    protected void validateData(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1 && this.objectDetailsPanel != null) {
            if (!this.objectDetailsPanel.validInfo()) {
                throw new TraversalException(this.objectDetailsPanel.getErrorMessage());
            }
            this.objectDataModel = this.objectDetailsPanel.getValues();
            traversableContext.put("KEY_REST_OBJECT_DATA", (Object)this.objectDataModel);
            this.objectDetailsPanel.removeListeners();
        }
    }

    private class ObjectDataModelListener
    implements PropertyChangeListener {
        private ObjectDataModelListener() {
        }

        public void propertyChangeImpl(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("invalidObject")) {
                boolean bl = propertyChangeEvent.getNewValue() == null || !(propertyChangeEvent.getNewValue() instanceof Boolean) ? false : (Boolean)propertyChangeEvent.getNewValue();
                if (RestWizObjectDetailsPanel.this.wizardCallbacks != null) {
                    RestWizObjectDetailsPanel.this.wizardCallbacks.wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(!bl), Boolean.valueOf(!bl));
                }
            }
        }

        @Override
        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            if (EventQueue.isDispatchThread()) {
                this.propertyChangeImpl(propertyChangeEvent);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ObjectDataModelListener.this.propertyChangeImpl(propertyChangeEvent);
                    }
                });
            }
        }
    }
}

