/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.wizard;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.autorest.AutoRestArb;
import oracle.dbtools.autorest.model.RestObjectData;
import oracle.dbtools.autorest.ui.RestObjectSummaryPanel;
import oracle.dbtools.autorest.wizard.AbstractScriptRunnerTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class RestWizObjectSummaryPanel
extends AbstractScriptRunnerTraversablePanel {
    private transient RestObjectData objectDataModel;
    private RestObjectSummaryPanel objectSummaryPanel;
    private GridBagLayout gridBagLayout = new GridBagLayout();

    private void jbInit(TraversableContext traversableContext) {
        this.setName("RestWizObjectSummaryPanel");
        this.objectDataModel = (RestObjectData)traversableContext.get("KEY_REST_OBJECT_DATA");
        this.objectSummaryPanel = new RestObjectSummaryPanel(this.objectDataModel, this.getScriptProcessor().getScriptEditorTabName(), this.createScriptPane());
        this.setLayout(this.gridBagLayout);
        this.add(this.objectSummaryPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 10, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        if (this.objectSummaryPanel == null) {
            this.jbInit(traversableContext);
        }
        this.objectSummaryPanel.addListeners();
        this.objectSummaryPanel.updatePanel();
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
    }

    public void onExitImpl(TraversableContext traversableContext) throws TraversalException {
        this.objectSummaryPanel.removeListeners();
    }

    @Override
    protected void validateData(TraversableContext traversableContext) throws TraversalException {
        RestObjectData restObjectData = (RestObjectData)traversableContext.get("KEY_REST_OBJECT_DATA");
        if (restObjectData.isEnabled()) {
            Pattern pattern = Pattern.compile("\\p{Alpha}([[\\p{Alnum}]#$_])*$");
            if (restObjectData.getMemberNames() != null) {
                for (String string : restObjectData.getMemberNames()) {
                    Matcher matcher;
                    if (string == null || (matcher = pattern.matcher(string)).matches()) continue;
                    throw new TraversalException(AutoRestArb.format("PANEL_OBJECT_SUMMARY_UNSUPPORTED_MEMBER_NAME", string));
                }
            }
        }
    }

    @Override
    protected String getTitle() {
        return "ObjectSummaryTitle";
    }

    @Override
    protected String getScriptForProcessing() {
        String string = null;
        string = this.scriptEditor.getText();
        return string;
    }
}

