/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallDBUtils;
import oracle.dbtools.rest.install.RestVersionObject;
import oracle.dbtools.rest.install.wizard.WizBaseCDBOptionsPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class RepairWizCDBOptionsPanel
extends WizBaseCDBOptionsPanel {
    private Logger logger = Logger.getLogger(RepairWizCDBOptionsPanel.class.getName());
    private String m_prevConnInfo = "";
    private boolean m_init;

    public RepairWizCDBOptionsPanel() {
        super("REPAIR", "LABEL_LC_REPAIR", "WIZ_TITLE_CDB_REPAIR", "LABEL_UL_REPAIR");
    }

    @Override
    protected void setupDisplayValues(Map<String, Map<String, String>> map, boolean bl, boolean bl2) throws Exception {
        block31: {
            try {
                if (map == null) break block31;
                for (String string : map.keySet()) {
                    String string2;
                    String string3;
                    String string4;
                    boolean bl3;
                    boolean bl4;
                    int n;
                    String string5;
                    block33: {
                        block32: {
                            Map<String, String> map2 = map.get(string);
                            string5 = map2.get("OPEN_MODE");
                            n = Integer.parseInt(map2.get("CON_ID"));
                            String string6 = map2.get("ORDS_VERSION");
                            bl4 = false;
                            bl3 = false;
                            string4 = string6;
                            string3 = string6;
                            string2 = "SKIP";
                            if (string5 == null || string5.isEmpty()) break block32;
                            if (string5.equals("MOUNTED") && !bl) continue;
                            switch (string5) {
                                case "READ WRITE": 
                                case "MIGRATE": {
                                    if (string6 == null || string6.isEmpty()) {
                                        if (!this.isCommonUser(string, map2)) {
                                            string4 = RestArb.getString("LABEL_NONE");
                                            break;
                                        }
                                    } else {
                                        if (string6.equals("UNKNOWN")) break;
                                        if (string6.equals(this.m_productVersion)) {
                                            bl4 = true;
                                            string2 = "REPAIR";
                                            break;
                                        }
                                        if (InstallDBUtils.isEarlierVersion(string6, this.m_productVersion)) {
                                            break;
                                        }
                                    }
                                    break block33;
                                }
                                case "READ ONLY": {
                                    if (string6 == null || string6.isEmpty()) {
                                        if (!this.isCommonUser(string, map2)) {
                                            string4 = RestArb.getString("LABEL_NONE");
                                            break;
                                        }
                                    } else {
                                        if (string6.equals("UNKNOWN")) break;
                                        if (string6.equals(this.m_productVersion)) {
                                            string2 = "REPAIR";
                                            bl4 = true;
                                            if (!string.equals("PDB$SEED")) {
                                                bl3 = true;
                                                break;
                                            }
                                        } else if (InstallDBUtils.isEarlierVersion(string6, this.m_productVersion)) {
                                            break;
                                        }
                                    }
                                    break block33;
                                }
                                case "MOUNTED": {
                                    if (string6 == null || string6.isEmpty()) {
                                        if (!this.isCommonUser(string, map2)) {
                                            string4 = RestArb.getString("LABEL_NONE");
                                            break;
                                        }
                                    } else {
                                        if (string6.equals("UNKNOWN")) break;
                                        if (string6.equals(this.m_productVersion)) {
                                            string2 = "REPAIR";
                                            bl4 = true;
                                            bl3 = true;
                                            break;
                                        }
                                        if (InstallDBUtils.isEarlierVersion(string6, this.m_productVersion)) {
                                            break;
                                        }
                                    }
                                    break block33;
                                }
                                default: {
                                    string4 = RestArb.getString("LABEL_UKNOWN");
                                }
                            }
                            break block33;
                        }
                        string5 = RestArb.getString("LABEL_UKNOWN");
                        string4 = RestArb.getString("LABEL_UKNOWN");
                    }
                    this.addRow(string, n, string5, string3, string4, string2, bl4, bl3);
                }
            }
            catch (Exception exception) {
                this.logger.warning(exception.getLocalizedMessage());
                throw exception;
            }
        }
    }

    private void repairParameterValues(Map<String, Object> map) throws TraversalException {
        Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
        List<RestVersionObject> list = this.getTableModel().getData();
        if (list != null && list.size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<RestVersionObject> arrayList2 = new ArrayList<RestVersionObject>();
            int n = 0;
            String string = (String)map.get("product.version");
            boolean bl = string.startsWith("3.0.");
            for (RestVersionObject restVersionObject : list) {
                String string2 = restVersionObject.getName();
                String string3 = restVersionObject.getMode();
                String string4 = restVersionObject.getInstallType();
                if (!restVersionObject.isSelected()) continue;
                if (string4.equals("REPAIR")) {
                    ++n;
                }
                arrayList2.add(restVersionObject);
                if (bl) {
                    if (!string3.equals("READ ONLY") || string2.equals("PDB$SEED")) continue;
                    arrayList.add(restVersionObject.getName());
                    continue;
                }
                if (this.m_includeAllCB.isSelected() || !string3.equals("MOUNTED") && (!string3.equals("READ ONLY") || string2.equals("PDB$SEED"))) continue;
                arrayList.add(restVersionObject.getName());
            }
            if (n == 0) {
                throw new TraversalException(RestArb.getString("WARNING_REPAIR_GENERAL_INFO"));
            }
            if (!bl && this.m_includeAllCB.isSelected()) {
                map2.put("pdb.open.asneeded", "true");
            } else if (!arrayList.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (i == 0) {
                        stringBuilder.append((String)arrayList.get(i));
                        continue;
                    }
                    stringBuilder.append(",").append((String)arrayList.get(i));
                }
                map2.put("pdb.open.readwrite", stringBuilder.toString());
            }
            map.put("cdb.pdb.list", arrayList2);
            this.logger.info("Total CDB repair: " + n);
            map2.put("pdb.skip.closed", "true");
            map2.put("pdb.skip.readonly", "true");
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        Map map;
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (traversableContext.getDirection() == 1 && (map = (Map)traversableContext.get("ORDS_PARAMS")) != null && map.containsKey("INSTALL_KEY_PARAMS")) {
            final Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            String string = (String)map2.get("db.url") + (String)map2.get("sys.user");
            String string2 = (String)map.get("product.version");
            this.m_init = !this.m_productVersion.isEmpty() && this.m_productVersion.equals(string2) ? !string.equals(this.m_prevConnInfo) || this.m_containers == null || this.m_containers.isEmpty() : true;
            this.m_productVersion = (String)map.get("product.version");
            if (this.m_init) {
                this.init();
                this.m_processDescrip.setVisible(true);
                this.retrieveCdbPdbInfo(map2, false);
                this.m_showClosedBtn.addActionListener(new ActionListener(){
                    final Map<String, String> params;
                    {
                        this.params = map2;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RepairWizCDBOptionsPanel.this.showClosedPDBs(this.params);
                        RepairWizCDBOptionsPanel.this.m_showClosedBtn.setEnabled(false);
                    }
                });
                this.m_includeAllCB.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        RepairWizCDBOptionsPanel.this.updateProcessSelection();
                    }
                });
            }
            this.m_prevConnInfo = (String)map2.get("db.url") + (String)map2.get("sys.user");
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            if (this.getTable().getCellEditor() != null) {
                this.getTable().getCellEditor().stopCellEditing();
            }
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            this.repairParameterValues(map);
            map.put("cdb.total.containers", this.m_totalContainers);
        }
    }

    public Object getExitTransition() {
        return "Transition.Finish";
    }
}

