/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Frame;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JDialog;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.RestInstallController;
import oracle.dbtools.rest.install.wizard.InstallWizAPEXUsersPanel;
import oracle.dbtools.rest.install.wizard.InstallWizCDBOptionsPanel;
import oracle.dbtools.rest.install.wizard.InstallWizCDBTablespacesPanel;
import oracle.dbtools.rest.install.wizard.InstallWizMigrateAPEXPanel;
import oracle.dbtools.rest.install.wizard.InstallWizORDSUsersPanel;
import oracle.dbtools.rest.install.wizard.InstallWizPLSQLGatewayPanel;
import oracle.dbtools.rest.install.wizard.InstallWizSchemaPanel;
import oracle.dbtools.rest.install.wizard.InstallWizStandalonePanel;
import oracle.dbtools.rest.install.wizard.InstallWizSummaryPanel;
import oracle.dbtools.rest.install.wizard.InstallWizTablespacePanel;
import oracle.dbtools.rest.install.wizard.InstallWizWarFilePanel;
import oracle.dbtools.rest.install.wizard.RunWizWarFilePanel;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class RestInstallWizard {
    public static final String TRANSITION_WAR_FILE = "Transition.WarFile";
    public static final String STATE_WAR_FILE = "State.WarFile";
    public static final String TRANSITION_ORDS_SCHEMA = "Transition.DBConn";
    public static final String STATE_ORDS_SCHEMA = "State.DBConn";
    public static final String TRANSITION_ORDS_USERS = "Transition.ORDSUsers";
    public static final String STATE_ORDS_USERS = "State.ORDSUsers";
    public static final String TRANSITION_SYSDBA = "Transition.SYSDBA";
    public static final String STATE_SYSDBA = "State.SYSDBA";
    public static final String TRANSITION_PLSQL_GATEWAY = "Transition.PLSQLGateway";
    public static final String STATE_PLSQL_GATEWAY = "State.PLSQLGateway";
    public static final String TRANSITION_TABLESPACE = "Transition.Tablespace";
    public static final String STATE_TABLESPACE = "State.Tablespace";
    public static final String TRANSITION_APEX_USERS = "Transition.APEXUsers";
    public static final String STATE_APEX_USERS = "State.APEXUsers";
    public static final String TRANSITION_MIGRATE = "Transition.Migrate";
    public static final String STATE_MIGRATE = "State.Migrate";
    public static final String TRANSITION_STANDALONE = "Transition.Standalone";
    public static final String STATE_STANDALONE = "State.Standalone";
    public static final String TRANSITION_CDB_OPTIONS = "Transition.CdbOptions";
    public static final String STATE_CDB_OPTIONS = "State.CdbOptions";
    public static final String TRANSITION_CDB_TABLESPACES = "Transition.CdbTablespaces";
    public static final String STATE_CDB_TABLESPACES = "State.CdbTablespaces";
    public static final String TRANSITION_FINISH = "Transition.Finish";
    public static final String STATE_FINISH = "State.Finish";
    public static final String KEY_PARAMS = "ORDS_PARAMS";
    public static final String INSTALL_KEY_PARAMS = "INSTALL_KEY_PARAMS";
    public static final String INSTALL_ID = "INSTALL_ID";

    public static Map<String, Object> ORDSInstallWizard(int n) {
        return new RestInstallWizard().launchORDSInstallWiz(n);
    }

    private Map<String, Object> launchORDSInstallWiz(int n) {
        HashSet hashSet;
        Namespace namespace = new Namespace();
        namespace.put(KEY_PARAMS, new HashMap());
        ((Map)namespace.get(KEY_PARAMS)).put(INSTALL_ID, new Integer(n));
        FSM fSM = n == RestInstallController.INSTALL_CMD_ID ? RestInstallWizard.getFSMforORDSDBInstall() : (n == RestInstallController.RUN_STANDALONE_CMD_ID ? this.getFSMforRunStandalone() : this.getFSMforRunStandalone());
        boolean bl = this.launchWizard(fSM, namespace, n);
        if (bl) {
            return (Map)namespace.get(KEY_PARAMS);
        }
        Map map = (Map)namespace.get(KEY_PARAMS);
        if (map != null && (hashSet = (HashSet)map.get("config.dir.created")) != null && !hashSet.isEmpty()) {
            for (String string : hashSet) {
                File file = new File(string);
                file.delete();
            }
        }
        return null;
    }

    private boolean launchWizard(FSM fSM, Namespace namespace, int n) {
        FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
        fSMWizard.setLogoImage(RestArb.getImage("WIZ_LOGO_IMAGE"));
        fSMWizard.setRoadmapVisible(true);
        fSMWizard.setSize(800, 800);
        if (n == RestInstallController.INSTALL_CMD_ID) {
            fSMWizard.setWizardTitle(RestArb.getString("WIZ_INSTALL_TITLE"));
        } else {
            fSMWizard.setWizardTitle(RestArb.getString("WIZ_RUN_TITLE"));
        }
        boolean bl = WizardLauncher.runDialog((JDialog)fSMWizard.getDialog((Frame)Ide.getMainWindow()));
        return bl;
    }

    private static FSM getFSMforORDSDBInstall() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(RestArb.getString("WIZ_STEP_ORDS_LOCATIONS"), InstallWizWarFilePanel.class, "f1_install_ords_locations_html");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_ORDS_SCHEMA, (Object)STATE_ORDS_SCHEMA);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step2 = new Step(RestArb.getString("WIZ_STEP_ORDS_SCHEMA"), InstallWizSchemaPanel.class, "f1_rest_install_ords_schema_html");
        fSMBuilder.newState((Object)STATE_ORDS_SCHEMA, step2, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_CDB_OPTIONS, (Object)STATE_CDB_OPTIONS);
        fSMBuilder.addStateTrans((Object)TRANSITION_TABLESPACE, (Object)STATE_TABLESPACE);
        fSMBuilder.addStateTrans((Object)TRANSITION_PLSQL_GATEWAY, (Object)STATE_PLSQL_GATEWAY);
        fSMBuilder.addStateTrans((Object)TRANSITION_STANDALONE, (Object)STATE_STANDALONE);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step3 = new Step(RestArb.getString("WIZ_STEP_CDB_OPTIONS"), InstallWizCDBOptionsPanel.class, "f1_rest_install_cdb_options_html");
        fSMBuilder.newState((Object)STATE_CDB_OPTIONS, step3, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_CDB_TABLESPACES, (Object)STATE_CDB_TABLESPACES);
        fSMBuilder.addStateTrans((Object)TRANSITION_PLSQL_GATEWAY, (Object)STATE_PLSQL_GATEWAY);
        fSMBuilder.addStateTrans((Object)TRANSITION_STANDALONE, (Object)STATE_STANDALONE);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step4 = new Step(RestArb.getString("WIZ_STEP_CDB_TABLESPACES"), InstallWizCDBTablespacesPanel.class, "f1_rest_install_cdb_tablespaces_html");
        fSMBuilder.newState((Object)STATE_CDB_TABLESPACES, step4, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_PLSQL_GATEWAY, (Object)STATE_PLSQL_GATEWAY);
        fSMBuilder.addStateTrans((Object)TRANSITION_STANDALONE, (Object)STATE_STANDALONE);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step5 = new Step(RestArb.getString("WIZ_STEP_TABLESPACE"), InstallWizTablespacePanel.class, "f1_rest_install_tablespace_html");
        fSMBuilder.newState((Object)STATE_TABLESPACE, step5, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_PLSQL_GATEWAY, (Object)STATE_PLSQL_GATEWAY);
        fSMBuilder.addStateTrans((Object)TRANSITION_MIGRATE, (Object)STATE_MIGRATE);
        fSMBuilder.addStateTrans((Object)TRANSITION_STANDALONE, (Object)STATE_STANDALONE);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step6 = new Step(RestArb.getString("WIZ_STEP_PLSQL_GATEWAY"), InstallWizPLSQLGatewayPanel.class, "f1_rest_install_plsql_gateway_html");
        fSMBuilder.newState((Object)STATE_PLSQL_GATEWAY, step6, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_APEX_USERS, (Object)STATE_APEX_USERS);
        fSMBuilder.addStateTrans((Object)TRANSITION_MIGRATE, (Object)STATE_MIGRATE);
        fSMBuilder.addStateTrans((Object)TRANSITION_STANDALONE, (Object)STATE_STANDALONE);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step7 = new Step(RestArb.getString("WIZ_STEP_APEX_USERS"), InstallWizAPEXUsersPanel.class, "f1_rest_install_apex_users_html");
        fSMBuilder.newState((Object)STATE_APEX_USERS, step7, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_MIGRATE, (Object)STATE_MIGRATE);
        fSMBuilder.addStateTrans((Object)TRANSITION_STANDALONE, (Object)STATE_STANDALONE);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step8 = new Step(RestArb.getString("WIZ_STEP_MIGRATE"), InstallWizMigrateAPEXPanel.class, "f1_rest_install_migrate_apex_rest_html");
        fSMBuilder.newState((Object)STATE_MIGRATE, step8, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_STANDALONE, (Object)STATE_STANDALONE);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step9 = new Step(RestArb.getString("WIZ_STEP_STANDALONE"), InstallWizStandalonePanel.class, "f1_rest_install_standalone_html");
        fSMBuilder.newState((Object)STATE_STANDALONE, step9, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_ORDS_USERS, (Object)STATE_ORDS_USERS);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step10 = new Step(RestArb.getString("WIZ_STEP_ORDS_USERS"), InstallWizORDSUsersPanel.class, "f1_rest_install_ords_users_html");
        fSMBuilder.newState((Object)STATE_ORDS_USERS, step10, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step11 = new Step(RestArb.getString("WIZ_STEP_INSTALL_SUMMARY"), InstallWizSummaryPanel.class, "f1_rest_install_summary_html");
        fSMBuilder.newFinalState((Object)STATE_FINISH, step11);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    private FSM getFSMforRunStandalone() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(RestArb.getString("WIZ_STEP_ORDS_LOCATIONS"), RunWizWarFilePanel.class, "f1_install_ords_locations_html");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_STANDALONE, (Object)STATE_STANDALONE);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step2 = new Step(RestArb.getString("WIZ_STEP_STANDALONE"), InstallWizStandalonePanel.class, "f1_rest_install_standalone_html");
        fSMBuilder.newState((Object)STATE_STANDALONE, step2, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_ORDS_USERS, (Object)STATE_ORDS_USERS);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step3 = new Step(RestArb.getString("WIZ_STEP_ORDS_USERS"), InstallWizORDSUsersPanel.class, "f1_rest_install_ords_users_html");
        fSMBuilder.newState((Object)STATE_ORDS_USERS, step3, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step4 = new Step(RestArb.getString("WIZ_STEP_INSTALL_SUMMARY"), InstallWizSummaryPanel.class, "f1_rest_install_summary_html");
        fSMBuilder.newFinalState((Object)STATE_FINISH, step4);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }
}

