/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.RestVersionObject;
import oracle.dbtools.rest.install.wizard.WizBaseCDBOptionsPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class UninstallWizCDBOptionsPanel
extends WizBaseCDBOptionsPanel {
    private Logger logger = Logger.getLogger(UninstallWizCDBOptionsPanel.class.getName());
    private String m_prevConnInfo = "";
    private boolean m_init;

    public UninstallWizCDBOptionsPanel() {
        super("UNINSTALL", "LABEL_LC_UNINSTALL", "WIZ_TITLE_CDB_UNINSTALL", "LABEL_UL_UNINSTALL");
    }

    @Override
    protected void setupDisplayValues(Map<String, Map<String, String>> map, boolean bl, boolean bl2) throws Exception {
        try {
            if (map != null) {
                for (String string : map.keySet()) {
                    Map<String, String> map2 = map.get(string);
                    String string2 = map2.get("OPEN_MODE");
                    int n = Integer.parseInt(map2.get("CON_ID"));
                    String string3 = map2.get("ORDS_VERSION");
                    boolean bl3 = false;
                    boolean bl4 = false;
                    String string4 = string3;
                    String string5 = string3;
                    String string6 = "UNINSTALL";
                    if (string2 != null && !string2.isEmpty()) {
                        if (string2.equals("MOUNTED") && !bl) continue;
                        switch (string2) {
                            case "READ WRITE": 
                            case "MIGRATE": {
                                bl3 = true;
                                break;
                            }
                            case "READ ONLY": {
                                if (string.equals("PDB$SEED")) {
                                    bl3 = true;
                                    break;
                                }
                                bl4 = true;
                                break;
                            }
                            case "MOUNTED": {
                                if (bl2) break;
                                bl4 = true;
                                break;
                            }
                            default: {
                                string4 = RestArb.getString("LABEL_UKNOWN");
                            }
                        }
                        if (string3 == null || string3.isEmpty()) {
                            string4 = "";
                        }
                    } else {
                        string2 = RestArb.getString("LABEL_UKNOWN");
                        string4 = RestArb.getString("LABEL_UKNOWN");
                    }
                    this.addRow(string, n, string2, string5, string4, string6, bl3, bl4);
                }
            } else {
                this.logger.warning(((Object)((Object)this)).getClass().getName() + " - the container information is null.");
            }
        }
        catch (Exception exception) {
            this.logger.warning(((Object)((Object)this)).getClass().getName() + exception.getLocalizedMessage());
            throw exception;
        }
    }

    private void uninstallParameterValues(Map<String, Object> map) {
        Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
        List<RestVersionObject> list = this.getTableModel().getData();
        if (list != null && list.size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<RestVersionObject> arrayList2 = new ArrayList<RestVersionObject>();
            int n = 0;
            String string = (String)map.get("product.version");
            boolean bl = string.startsWith("3.0.");
            for (RestVersionObject restVersionObject : list) {
                String string2 = restVersionObject.getName();
                String string3 = restVersionObject.getMode();
                String string4 = restVersionObject.getInstallType();
                if (!restVersionObject.isSelected()) continue;
                if (string4.equals("UNINSTALL")) {
                    ++n;
                }
                arrayList2.add(restVersionObject);
                if (bl) {
                    if (!string3.equals("READ ONLY") || string2.equals("PDB$SEED")) continue;
                    arrayList.add(restVersionObject.getName());
                    continue;
                }
                if (this.m_includeAllCB.isSelected() || !string3.equals("MOUNTED") && (!string3.equals("READ ONLY") || string2.equals("PDB$SEED"))) continue;
                arrayList.add(restVersionObject.getName());
            }
            if (!bl && this.m_includeAllCB.isSelected()) {
                map2.put("pdb.open.asneeded", "true");
            } else if (!arrayList.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (i == 0) {
                        stringBuilder.append((String)arrayList.get(i));
                        continue;
                    }
                    stringBuilder.append(",").append((String)arrayList.get(i));
                }
                map2.put("pdb.open.readwrite", stringBuilder.toString());
            }
            map.put("cdb.pdb.list", arrayList2);
            this.logger.info("Total CDB uinstall: " + n);
            map2.put("pdb.skip.closed", "true");
            map2.put("pdb.skip.readonly", "true");
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        Map map;
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (traversableContext.getDirection() == 1 && (map = (Map)traversableContext.get("ORDS_PARAMS")) != null && map.containsKey("INSTALL_KEY_PARAMS")) {
            Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            String string = (String)map2.get("db.url") + (String)map2.get("sys.user");
            String string2 = (String)map.get("product.version");
            this.m_init = !this.m_productVersion.isEmpty() && this.m_productVersion.equals(string2) ? !string.equals(this.m_prevConnInfo) || this.m_containers == null || this.m_containers.isEmpty() : true;
            this.m_productVersion = (String)map.get("product.version");
            if (this.m_init) {
                this.init();
                this.m_processDescrip.setVisible(true);
                this.retrieveCdbPdbInfo(map2, true);
            }
            this.m_prevConnInfo = (String)map2.get("db.url") + (String)map2.get("sys.user");
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            if (this.getTable().getCellEditor() != null) {
                this.getTable().getCellEditor().stopCellEditing();
            }
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            this.uninstallParameterValues(map);
            map.put("cdb.total.containers", this.m_totalContainers);
        }
    }

    public Object getExitTransition() {
        return "Transition.Finish";
    }
}

