/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallCDBUtils;
import oracle.dbtools.rest.install.InstallUtils;
import oracle.dbtools.rest.install.RestVersionObject;
import oracle.dbtools.rest.install.RestVersionTableModel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;

public abstract class WizBaseCDBOptionsPanel
extends DefaultTraversablePanel {
    protected static final int CDB_PDB_INFO = 0;
    protected static final int CLOSED_PDB_INFO = 1;
    private JTable m_table;
    private RestVersionTableModel m_tableModel = new RestVersionTableModel();
    private InstallCheckBoxRenderer m_installCheckBoxRenderer = new InstallCheckBoxRenderer();
    protected JPanel m_closedPDBPanel;
    protected JPanel m_includeAllPanel;
    protected JPanel m_migratePanel;
    protected JCheckBox m_includeAllCB = new JCheckBox();
    protected JButton m_showClosedBtn = new JButton();
    protected JTextPane m_processDescrip = new JTextPane();
    protected JTextPane m_statusLineDescrip = new JTextPane();
    protected Map<String, Map<String, String>> m_closedPdbs;
    protected Map<String, Map<String, String>> m_containers;
    protected String m_productVersion = "";
    protected String m_nlsProcessLCKey;
    protected String m_nlsProcessTitleKey;
    protected String m_nlsDescripKey;
    protected String m_nlsProcessULKey;
    protected String m_processType;
    protected String m_installer;
    protected int m_totalContainers = 0;
    protected boolean m_isCurrentContainers;
    protected boolean m_isMigrateCdb;
    private JScrollPane m_scrollPane = new JScrollPane();
    private JPanel m_cdbPdbPanel;
    private Logger logger = Logger.getLogger(WizBaseCDBOptionsPanel.class.getName());

    public WizBaseCDBOptionsPanel(String string) {
        this.m_processType = string;
    }

    public WizBaseCDBOptionsPanel(String string, String string2, String string3, String string4) {
        this.m_processType = string;
        this.m_nlsProcessLCKey = string2;
        this.m_nlsProcessTitleKey = string3;
        this.m_nlsProcessULKey = string4;
        this.buildPanel();
    }

    protected void setProcessType(String string) {
        this.m_processType = string;
    }

    protected String getProcessType() {
        return this.m_processType;
    }

    protected void init() {
        this.m_processDescrip.setText(RestArb.format("WIZ_CDB_PROCESS_DESCRIP", RestArb.getString(this.m_nlsProcessULKey), ""));
        this.m_isCurrentContainers = false;
        this.m_isMigrateCdb = false;
        if (this.m_containers != null && !this.m_containers.isEmpty()) {
            this.m_containers.clear();
        }
        if (this.getTableModel().getRowCount() > 0) {
            this.getTableModel().removeAll();
        }
        this.m_showClosedBtn.setEnabled(true);
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.m_showClosedBtn, (String)RestArb.getString("SHOW_CLOSED_PDBS"));
        ResourceUtils.resButton((AbstractButton)this.m_includeAllCB, (String)RestArb.format("CDB_INCLUDE_ALL1", RestArb.getString(this.m_nlsProcessLCKey)));
        String string = RestArb.format("WIZ_CDB_PROCESS_DESCRIP", RestArb.getString(this.m_nlsProcessULKey), "");
        this.m_processDescrip.setText(string);
        this.m_processDescrip.setEditable(false);
        this.m_processDescrip.setOpaque(false);
        this.m_processDescrip.setRequestFocusEnabled(false);
        this.m_processDescrip.setFocusable(false);
        this.m_processDescrip.setVisible(false);
        int n = 0;
        String string2 = RestArb.getString("WIZ_CDB_PROCESS_MIGRATE_REQ");
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(string2);
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        jTextPane.setVisible(true);
        this.m_migratePanel = LayoutControl.GBC.createPanel();
        this.m_migratePanel.add((Component)jTextPane, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)this.m_migratePanel, (int)(++n));
        this.m_migratePanel.setVisible(false);
        n = 0;
        JLabel jLabel = new JLabel();
        String string3 = RestArb.getString("SHOW_CLOSED_LABEL");
        jLabel.setText(string3);
        this.m_closedPDBPanel = LayoutControl.GBC.createPanel();
        this.m_closedPDBPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        this.m_closedPDBPanel.add((Component)this.m_showClosedBtn, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        LayoutControl.GBC.addHSpring((JPanel)this.m_closedPDBPanel, (int)2);
        this.m_closedPDBPanel.setVisible(false);
        n = 0;
        this.m_includeAllPanel = LayoutControl.GBC.createPanel();
        this.m_includeAllPanel.add((Component)this.m_includeAllCB, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        LayoutControl.GBC.addHSpring((JPanel)this.m_includeAllPanel, (int)2);
        this.m_includeAllPanel.setVisible(false);
        n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)this.m_processDescrip, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        jPanel.add((Component)this.m_migratePanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.Y));
        LayoutControl.GBC.addHSpring((JPanel)jPanel, (int)1);
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        jPanel.add((Component)this.m_closedPDBPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this.m_includeAllPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.m_includeAllPanel.setEnabled(false);
        JPanel jPanel2 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString(this.m_nlsProcessTitleKey), (Component)jPanel);
        this.m_statusLineDescrip.setText(RestArb.format("WIZ_DESCRIP_CDBINSTALLUPG", RestArb.getString(this.m_nlsProcessULKey)));
        this.m_statusLineDescrip.setEditable(false);
        this.m_statusLineDescrip.setOpaque(false);
        this.m_statusLineDescrip.setRequestFocusEnabled(false);
        this.m_statusLineDescrip.setFocusable(false);
        this.m_table = new JTable(this.m_tableModel);
        this.m_table.getColumnModel().getColumn(3).setHeaderValue(RestArb.getString(this.m_nlsProcessULKey));
        this.m_table.getColumnModel().getColumn(3).setCellRenderer(this.m_installCheckBoxRenderer);
        this.m_scrollPane.setViewportView(this.m_table);
        n = 0;
        this.m_cdbPdbPanel = LayoutControl.GBC.createPanel();
        this.m_cdbPdbPanel.add((Component)this.m_statusLineDescrip, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.m_cdbPdbPanel.add((Component)this.m_scrollPane, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        n = 0;
        this.add(jPanel2, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(this.m_cdbPdbPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)2, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
    }

    protected void addRow(String string, int n, String string2, String string3, String string4, String string5, boolean bl, boolean bl2) {
        this.m_tableModel.addRow(string, n, string2, string3, string4, string5, new Boolean(bl), new Boolean(bl2));
    }

    protected void showClosedPDBs(Map<String, String> map) {
        if (this.m_closedPdbs != null && !this.m_closedPdbs.isEmpty()) {
            this.retrieveClosedPDBInfo(map);
        }
    }

    protected void retrieveClosedPDBInfo(final Map<String, String> map) {
        final WaitCursor waitCursor = new WaitCursor((Component)((Object)this));
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(RestArb.getString("LOAD_CONTAINERS"), true, IRaptorTaskRunMode.MODAL){

            protected Void doWork() throws TaskException {
                Connection connection = null;
                try {
                    connection = WizBaseCDBOptionsPanel.this.getConnection(map);
                    InstallCDBUtils.closedPdbOrdsInfo(connection, WizBaseCDBOptionsPanel.this.m_closedPdbs);
                }
                catch (Exception exception) {
                    throw new TaskException((Throwable)exception);
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                            connection = null;
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                return null;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                this.cleanup();
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Throwable throwable;
                Throwable throwable2 = raptorTaskEvent.getThrowable();
                while (throwable2 instanceof DBException && (throwable = throwable2.getCause()) instanceof Exception) {
                    throwable2 = throwable;
                }
                ExceptionHandler.handleException((Throwable)((Exception)throwable2));
                this.cleanup();
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (WizBaseCDBOptionsPanel.this.m_closedPdbs != null && !WizBaseCDBOptionsPanel.this.m_closedPdbs.isEmpty()) {
                            if (!WizBaseCDBOptionsPanel.this.m_closedPDBPanel.isVisible()) {
                                WizBaseCDBOptionsPanel.this.m_closedPDBPanel.setVisible(true);
                            }
                            try {
                                WizBaseCDBOptionsPanel.this.setupDisplayValues(WizBaseCDBOptionsPanel.this.m_closedPdbs, true, false);
                                WizBaseCDBOptionsPanel.this.displayIncludeAllPanel();
                                String string = (String)map.get("installer");
                                WizBaseCDBOptionsPanel.this.checkCurrentContainers(string);
                            }
                            catch (Exception exception) {
                                WizBaseCDBOptionsPanel.this.logger.warning(this.getClass().getName() + exception.getLocalizedMessage());
                            }
                        }
                        waitCursor.hide();
                    }
                });
            }

            private void cleanup() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        waitCursor.hide();
                    }
                });
            }
        });
        waitCursor.show();
        raptorTask.setCancellable(true);
        raptorTask.setPausable(false);
        raptorTask.setMessage("Retrieving ords statuse in the closed containers");
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    protected boolean checkCurrentContainers(String string) {
        boolean bl = this.isCurrentContainers();
        if (string.equals("cdb.upgrade") && bl) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (WizBaseCDBOptionsPanel.this.m_includeAllPanel.isVisible()) {
                        WizBaseCDBOptionsPanel.this.m_includeAllPanel.setVisible(false);
                    }
                    if (WizBaseCDBOptionsPanel.this.m_statusLineDescrip.isVisible()) {
                        WizBaseCDBOptionsPanel.this.m_statusLineDescrip.setVisible(false);
                    }
                    WizBaseCDBOptionsPanel.this.m_processDescrip.setText(RestArb.format("WIZ_CDB_PDB_ALL_CURRENT", WizBaseCDBOptionsPanel.this.m_productVersion));
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
            return true;
        }
        return false;
    }

    protected boolean isCurrentContainers() {
        boolean bl = true;
        List<RestVersionObject> list = this.m_tableModel.getData();
        for (RestVersionObject restVersionObject : list) {
            String string = restVersionObject.getVersion();
            if (string == null) {
                string = "";
            }
            if (string.equals(this.m_productVersion)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    protected void displayContainerData(Connection connection, final boolean bl) throws Exception {
        InstallCDBUtils.cdbPdbOrdsInfo(connection, this.m_containers, bl);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    WizBaseCDBOptionsPanel.this.setupDisplayValues(WizBaseCDBOptionsPanel.this.m_containers, bl, bl);
                }
                catch (Exception exception) {
                    WizBaseCDBOptionsPanel.this.logger.warning(this.getClass().getName() + exception.getLocalizedMessage());
                }
            }
        });
    }

    protected void displayIncludeAllPanel() {
        boolean bl = false;
        List<RestVersionObject> list = ((RestVersionTableModel)this.m_table.getModel()).getData();
        if (list != null) {
            for (RestVersionObject restVersionObject : list) {
                String string = restVersionObject.getMode();
                String string2 = restVersionObject.getInstallType();
                boolean bl2 = string2 != null && (string2.equals("INSTALL") || string2.equals("UPGRADE") || string2.equals("UNINSTALL"));
                if (!bl2 || !string.equals("MOUNTED") && (!string.equals("READ ONLY") || restVersionObject.getName().equals("PDB$SEED"))) continue;
                bl = true;
                break;
            }
        }
        if (bl != this.m_includeAllCB.isEnabled()) {
            this.m_includeAllCB.setEnabled(bl);
        }
        if (!this.m_includeAllPanel.isVisible()) {
            this.m_includeAllPanel.setVisible(true);
        }
    }

    protected Connection getConnection(Map<String, String> map) throws Exception {
        String string = map.get("db.url");
        String string2 = map.get("sys.user");
        String string3 = map.get("sys.password");
        if (!string2.toUpperCase().equals("SYSTEM") && !string2.toUpperCase().contains(" AS SYSDBA")) {
            string2 = string2 + " AS SYSDBA";
        }
        if (string3 != null && string3.startsWith("@")) {
            string3 = string3.substring(1);
            string3 = Passwords.comingIn((String)string3);
        }
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(string, string2, string3);
        }
        catch (Exception exception) {
            this.logger.warning(exception.getLocalizedMessage());
            if (connection != null) {
                try {
                    connection.close();
                    connection = null;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw exception;
        }
        return connection;
    }

    protected Map<String, Map<String, String>> getClosedPdbs(Map<String, Map<String, String>> map) {
        LinkedHashMap<String, Map<String, String>> linkedHashMap = new LinkedHashMap<String, Map<String, String>>();
        for (String string : map.keySet()) {
            Map<String, String> map2 = map.get(string);
            String string2 = map2.get("OPEN_MODE");
            if (InstallUtils.nullOrEmpty(string2) || !string2.equals("MOUNTED")) continue;
            linkedHashMap.put(string, map2);
        }
        return linkedHashMap;
    }

    protected Map<String, Map<String, String>> getReadOnlyPdbs(Map<String, Map<String, String>> map) {
        LinkedHashMap<String, Map<String, String>> linkedHashMap = new LinkedHashMap<String, Map<String, String>>();
        for (String string : map.keySet()) {
            Map<String, String> map2 = map.get(string);
            String string2 = map2.get("OPEN_MODE");
            if (InstallUtils.nullOrEmpty(string2) || !string2.equals("READ ONLY") || string.equals("PDB$SEED")) continue;
            linkedHashMap.put(string, map2);
        }
        return linkedHashMap;
    }

    protected RestVersionTableModel getTableModel() {
        return this.m_tableModel;
    }

    protected JTable getTable() {
        return this.m_table;
    }

    protected void setupDisplayValues(Map<String, Map<String, String>> map, boolean bl, boolean bl2) throws Exception {
    }

    protected boolean isCommonUser(String string, Map<String, String> map) {
        String string2;
        return "CDB$ROOT".equals(string) && "COMMON_USER".equals(string2 = map.get("ORDS_INSTALL_TYPE"));
    }

    protected void retrieveCdbPdbInfo(final Map<String, String> map, final boolean bl) {
        final WaitCursor waitCursor = new WaitCursor((Component)((Object)this));
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(RestArb.getString("LOAD_CONTAINERS"), true, IRaptorTaskRunMode.MODAL){

            protected Void doWork() throws TaskException {
                Connection connection = null;
                try {
                    connection = WizBaseCDBOptionsPanel.this.getConnection(map);
                    WizBaseCDBOptionsPanel.this.m_containers = InstallCDBUtils.getContainersMode(connection);
                    WizBaseCDBOptionsPanel.this.displayContainerData(connection, bl);
                }
                catch (Exception exception) {
                    throw new TaskException((Throwable)exception);
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                            connection = null;
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                return null;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                this.cleanup();
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Throwable throwable;
                Throwable throwable2 = raptorTaskEvent.getThrowable();
                while (throwable2 instanceof DBException && (throwable = throwable2.getCause()) instanceof Exception) {
                    throwable2 = throwable;
                }
                ExceptionHandler.handleException((Throwable)((Exception)throwable2));
                this.cleanup();
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (WizBaseCDBOptionsPanel.this.m_containers != null && !WizBaseCDBOptionsPanel.this.m_containers.isEmpty()) {
                            WizBaseCDBOptionsPanel.this.m_totalContainers = WizBaseCDBOptionsPanel.this.m_containers.size();
                            if (WizBaseCDBOptionsPanel.this.m_productVersion.startsWith("3.0.")) {
                                WizBaseCDBOptionsPanel.this.updateUIVersion30X();
                            } else {
                                WizBaseCDBOptionsPanel.this.updateUIVersion(bl);
                            }
                            waitCursor.hide();
                        }
                    }
                });
            }

            private void cleanup() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        waitCursor.hide();
                    }
                });
            }
        });
        waitCursor.show();
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void updateUIVersion30X() {
        Map<String, Map<String, String>> map;
        if (this.m_closedPDBPanel.isVisible()) {
            this.m_closedPDBPanel.setVisible(false);
        }
        if ((map = this.getReadOnlyPdbs(this.m_containers)).isEmpty()) {
            if (this.m_includeAllPanel.isVisible()) {
                this.m_processDescrip.setText(RestArb.format("WIZ_CDB_PROCESS_DESCRIP", RestArb.getString(this.m_nlsProcessULKey), ""));
                this.m_includeAllPanel.setVisible(false);
            }
        } else {
            this.m_processDescrip.setText(RestArb.format("WIZ_CDB_PROCESS_DESCRIP", RestArb.getString(this.m_nlsProcessULKey), RestArb.format("WIZ_CDB_PROCESS_READONLY", RestArb.getString(this.m_nlsProcessLCKey))));
            ResourceUtils.resButton((AbstractButton)this.m_includeAllCB, (String)RestArb.format("CDB_INCLUDE_ALL2", RestArb.getString(this.m_nlsProcessLCKey)));
            if (!this.m_includeAllPanel.isEnabled()) {
                this.m_includeAllPanel.setEnabled(true);
            }
            if (!this.m_includeAllPanel.isVisible()) {
                this.m_includeAllPanel.setVisible(true);
            }
        }
    }

    private void updateUIVersion(boolean bl) {
        if (this.m_isMigrateCdb) {
            this.m_migratePanel.setVisible(true);
            this.m_processDescrip.setVisible(false);
            this.m_includeAllPanel.setVisible(false);
            this.m_closedPDBPanel.setVisible(false);
        } else if (!bl) {
            this.m_closedPdbs = this.getClosedPdbs(this.m_containers);
            if (this.m_closedPdbs != null && !this.m_closedPdbs.isEmpty() && !this.m_closedPDBPanel.isVisible()) {
                this.m_processDescrip.setText(RestArb.format("WIZ_CDB_PROCESS_DESCRIP", RestArb.getString(this.m_nlsProcessULKey), RestArb.format("WIZ_CDB_PROCESS_READONLY_CLOSED", RestArb.getString(this.m_nlsProcessLCKey))));
                this.m_includeAllCB.setEnabled(false);
                this.m_includeAllPanel.setVisible(true);
                this.m_closedPDBPanel.setVisible(true);
            }
        }
    }

    protected void updateProcessSelection() {
        this.getTableModel().updateProcessSelection(this.m_includeAllCB.isSelected(), this.m_processType);
    }

    protected boolean isMigrateCdb(Map<String, String> map) {
        return Boolean.parseBoolean(map.get("cdb.common.user.public")) && Boolean.parseBoolean(map.get("cdb.common.user.metadata"));
    }

    class InstallCheckBoxRenderer
    extends DefaultTableCellRenderer {
        InstallCheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            RestVersionObject restVersionObject = ((RestVersionTableModel)jTable.getModel()).getRowObject(n);
            JCheckBox jCheckBox = (JCheckBox)jTable.getDefaultRenderer(jTable.getColumnClass(n2)).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jCheckBox.setSelected(restVersionObject.isSelected());
            jCheckBox.setEnabled(restVersionObject.isEditable());
            return jCheckBox;
        }
    }
}

