/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallDBUtils;
import oracle.dbtools.rest.install.InstallValidator;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class WizBaseSchemaPanel
extends DefaultTraversablePanel {
    protected static final String REPAIR = "repair";
    protected static final String UNINSTALL = "uninstall";
    private static String DEFAULT_DB_HOST = "localhost";
    private static String DEFAULT_DB_PORT = "1521";
    private static String DEFAULT_DB_SID = "orcl";
    private JTextField m_host = new JTextField();
    private JTextField m_port = new JTextField();
    private JTextField m_sid = new JTextField();
    private JTextField m_serviceName = new JTextField();
    private JRadioButton m_sidBtn = new JRadioButton();
    private JRadioButton m_servicenameBtn = new JRadioButton();
    private JLabel m_dbUsername = new JLabel();
    private JPasswordField m_dbPassword = new JPasswordField();
    private JPasswordField m_dbConfirmPassword = new JPasswordField();
    private String m_prevConnInfo = "";
    private boolean m_isCDB;
    private String _processType;
    private String _nlsProcessKey;

    public WizBaseSchemaPanel(String string, String string2) {
        this._processType = string;
        this._nlsProcessKey = string2;
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        this.m_servicenameBtn.setSelected(true);
        this.m_dbUsername.setText("SYS AS SYSDBA");
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_host, (String)RestArb.getString("HOST"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_port, (String)RestArb.getString("PORT"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.m_dbUsername, (String)RestArb.getString("USERNAME"));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.m_dbPassword, (String)RestArb.getString("PASSWORD"));
        ResourceUtils.resLabel((JLabel)jLabel5, (Component)this.m_dbConfirmPassword, (String)RestArb.getString("CONFIRM_PASSWORD"));
        ResourceUtils.resButton((AbstractButton)this.m_sidBtn, (String)RestArb.getString("SID"));
        ResourceUtils.resButton((AbstractButton)this.m_servicenameBtn, (String)RestArb.getString("SERVICE_NAME"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_sidBtn);
        buttonGroup.add(this.m_servicenameBtn);
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_host, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_port, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this.m_servicenameBtn, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_serviceName, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this.m_sidBtn, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_sid, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        JPanel jPanel2 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_DB_CONN"), (Component)jPanel);
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(RestArb.getString(this._nlsProcessKey));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        n = 0;
        JPanel jPanel3 = LayoutControl.GBC.createPanel();
        jPanel3.add((Component)jTextPane, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel3.add((Component)jLabel3, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel3.add((Component)this.m_dbUsername, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel3.add((Component)jLabel4, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel3.add((Component)this.m_dbPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel3.add((Component)jLabel5, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel3.add((Component)this.m_dbConfirmPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel3, (int)(++n));
        JPanel jPanel4 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_DB_USER"), (Component)jPanel3);
        n = 0;
        this.add(jPanel2, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(jPanel4, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)((Object)this), (int)(++n));
        this.m_sidBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    WizBaseSchemaPanel.this.enableDisableSidServiceNameFields();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.m_servicenameBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    WizBaseSchemaPanel.this.enableDisableSidServiceNameFields();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void enableDisableSidServiceNameFields() {
        this.m_sid.setEnabled(this.m_sidBtn.isSelected());
        this.m_serviceName.setEnabled(this.m_servicenameBtn.isSelected());
    }

    private void verifyORDSSchema(TraversableContext traversableContext) throws TraversalException {
        block17: {
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            String string = null;
            Connection connection = null;
            this.m_isCDB = false;
            String string2 = InstallDBUtils.getUrl(this.m_host.getText(), this.m_port.getText(), this.m_sid.isEnabled() ? this.m_sid.getText() : null, this.m_serviceName.isEnabled() ? this.m_serviceName.getText() : null);
            String string3 = InstallDBUtils.getDBAUsername(this.m_dbUsername.getText());
            try {
                connection = DriverManager.getConnection(string2, string3, new String(this.m_dbPassword.getPassword()));
                if (InstallDBUtils.hasSYSDBAPrivileges(connection)) {
                    List<String> list;
                    String string4 = (String)map.get("product.version");
                    if (InstallDBUtils.isCDBRoot(connection)) {
                        if (InstallDBUtils.isEarlierVersion(string4, "3.0.5.0.0")) {
                            String string5 = UNINSTALL.equals(this._processType) ? RestArb.getString("LABEL_LC_UNINSTALL") : RestArb.getString("LABEL_LC_REPAIR");
                            throw new TraversalException(RestArb.format("ERROR_INVALID_VERSION_CDB", string4, string5));
                        }
                        this.m_isCDB = true;
                        map2.put("pdb.skip.closed", "true");
                        map2.put("pdb.skip.readonly", "true");
                    }
                    if ((list = InstallDBUtils.getORDSDBUsers(connection)).size() > 0) {
                        if (list.contains("ORDS_METADATA")) {
                            string = InstallDBUtils.getORDSVersion(connection);
                            map2.put("schema.version", string);
                        }
                        map.put("ords.db.users", list);
                    }
                    if (!(this.m_isCDB || !this.getProcessingType().equals("validate") || string != null && string.equals(string4))) {
                        throw new TraversalException(RestArb.getString("WARNING_REPAIR_GENERAL_INFO"));
                    }
                    break block17;
                }
                throw new TraversalException(RestArb.getString(this._nlsProcessKey));
            }
            catch (SQLException sQLException) {
                String string6 = RestArb.format("ERR_CONN_FAILED", string3, string2, sQLException.getLocalizedMessage());
                throw new TraversalException(string6);
            }
            catch (Exception exception) {
                throw new TraversalException(exception.getLocalizedMessage());
            }
            finally {
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void validateValues(TraversableContext traversableContext) throws TraversalException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_host.getText() == null || this.m_host.getText().trim().length() == 0) {
            stringBuffer.append(RestArb.getString("ERROR_HOST_MISSING"));
            this.m_host.requestFocus();
        }
        if (this.m_port.getText() == null || this.m_port.getText().trim().length() == 0) {
            if (stringBuffer.toString().length() > 0) {
                stringBuffer.append("\n");
            } else {
                this.m_port.requestFocus();
            }
            stringBuffer.append(RestArb.getString("ERROR_PORT_MISSING"));
        }
        String string2 = string = this.m_sidBtn.isSelected() ? this.m_sid.getText() : this.m_serviceName.getText();
        if (string == null || string.trim().length() == 0) {
            if (stringBuffer.toString().length() > 0) {
                stringBuffer.append("\n");
            } else if (this.m_sidBtn.isSelected()) {
                this.m_sid.requestFocus();
            } else {
                this.m_serviceName.requestFocus();
            }
            stringBuffer.append(this.m_sidBtn.isSelected() ? RestArb.getString("ERROR_SID_MISSING") : RestArb.getString("ERROR_SERVICENAME_MISSING"));
        }
        if (stringBuffer.toString().length() > 0) {
            throw new TraversalException(stringBuffer.toString());
        }
        InstallValidator.validatePasswords(this.m_dbUsername.getText(), this.m_dbPassword, this.m_dbConfirmPassword);
        String string3 = InstallDBUtils.getUrl(this.m_host.getText(), this.m_port.getText(), this.m_sid.isEnabled() ? this.m_sid.getText() : null, this.m_serviceName.isEnabled() ? this.m_serviceName.getText() : null);
        if (!string3.equals(this.m_prevConnInfo)) {
            this.verifyORDSSchema(traversableContext);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        Map map;
        Map map2;
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (traversableContext.getDirection() == 1 && (map2 = (Map)traversableContext.get("ORDS_PARAMS")) != null && map2.containsKey("INSTALL_KEY_PARAMS") && (map = (Map)map2.get("INSTALL_KEY_PARAMS")) != null) {
            this.m_host.setText(map.get("db.hostname") != null ? (String)map.get("db.hostname") : DEFAULT_DB_HOST);
            this.m_port.setText(map.get("db.port") != null ? (String)map.get("db.port") : DEFAULT_DB_PORT);
            String string = (String)map.get("db.servicename");
            String string2 = (String)map.get("db.sid");
            if (string == null || string.trim().length() == 0) {
                string = "";
            }
            if (string2 == null || string2.trim().length() == 0) {
                string2 = "";
            }
            if (!string.isEmpty()) {
                this.m_servicenameBtn.setSelected(true);
            } else if (!string2.isEmpty()) {
                this.m_sidBtn.setSelected(true);
            } else {
                this.m_servicenameBtn.setSelected(true);
                string = DEFAULT_DB_SID;
            }
            this.m_sid.setText(string2);
            this.m_serviceName.setText(string);
            this.enableDisableSidServiceNameFields();
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this.validateValues(traversableContext);
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            map2.put("db.hostname", this.m_host.getText());
            map2.put("db.port", this.m_port.getText());
            if (this.m_sidBtn.isSelected()) {
                map2.put("db.sid", this.m_sid.getText());
                map2.remove("db.servicename");
            } else {
                map2.put("db.servicename", this.m_serviceName.getText());
                map2.remove("db.sid");
            }
            String string = InstallDBUtils.getUrl(this.m_host.getText(), this.m_port.getText(), this.m_sid.isEnabled() ? this.m_sid.getText() : null, this.m_serviceName.isEnabled() ? this.m_serviceName.getText() : null);
            map2.put("db.url", string);
            map2.put("sys.user", this.m_dbUsername.getText());
            String string2 = "@" + Passwords.goingOut((String)new String(this.m_dbPassword.getPassword()));
            map2.put("sys.password", string2);
            map2.put("installer", this.getProcessingType());
            this.m_prevConnInfo = string;
        }
    }

    private String getProcessingType() {
        return this._processType;
    }

    public Object getExitTransition() {
        if (this.m_isCDB) {
            return "Transition.CdbOptions";
        }
        return "Transition.Finish";
    }
}

