/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.config.RestConfig;
import oracle.dbtools.rest.install.InstallUtils;
import oracle.dbtools.rest.install.RestInstallConstants;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class WizBaseWarFilePanel
extends DefaultTraversablePanel {
    public static final WildcardURLFilter WAR_FILTER = new WildcardURLFilter(RestArb.getString("WAR_FILTER_MASK"), URLFileSystem.isLocalFileSystemCaseSensitive(), RestArb.getString("WAR_FILTER_NAME"));
    private static final int ORDS_MIN_VERSION = 3;
    private RestInstallConstants.InstallType m_installType = RestInstallConstants.InstallType.REQUIRES_CONFIG;
    private JRadioButton m_SQLDevORDSWarFile = new JRadioButton();
    private JRadioButton m_userORDSWarFile = new JRadioButton();
    private ButtonGroup m_btnGrp = new ButtonGroup();
    private URLFileChooser.URLFileChooserPanel m_warChooser;
    private URLFileChooser.URLFileChooserPanel m_configChooser;
    private JLabel m_versionLbl = new JLabel();
    private JButton m_resetBtn = new JButton();
    private String m_sqldev_ords_path;
    private String m_sqldev_warConfigDir;
    private String m_sqldev_warVersion;
    private String m_warProductVersion;
    private String m_warConfigDir;
    private File m_prevWarFile;
    private File m_prevConfigPath;
    private Set<String> createdConfigFolders = new HashSet<String>();
    private boolean m_showConfig;

    public WizBaseWarFilePanel(String string, String string2) {
        this(string, string2, false);
    }

    public WizBaseWarFilePanel(String string, String string2, boolean bl) {
        this.m_showConfig = bl;
        this.m_btnGrp.add(this.m_SQLDevORDSWarFile);
        this.m_btnGrp.add(this.m_userORDSWarFile);
        this.m_SQLDevORDSWarFile.setSelected(true);
        this.m_sqldev_ords_path = this.getSQLDevDefaultWarFile();
        try {
            if (this.m_sqldev_ords_path != null && this.validWarFile(this.m_sqldev_ords_path)) {
                this.m_sqldev_warVersion = this.m_warProductVersion;
                this.m_versionLbl.setText(RestArb.format("WIZ_WAR_VERSION", this.m_sqldev_warVersion));
                if (this.m_showConfig) {
                    if (this.m_warConfigDir == null || this.m_warConfigDir.trim().isEmpty()) {
                        this.m_warConfigDir = RestConfig.getInstance().getString("SQLDEV_ORDS_CONFIGDIR");
                    }
                    this.m_sqldev_warConfigDir = this.m_warConfigDir != null && this.m_warConfigDir.isEmpty() ? null : this.m_warConfigDir;
                }
            } else {
                this.hideSQLDEVDefaultORDSOption();
            }
        }
        catch (Exception exception) {
            this.hideSQLDEVDefaultORDSOption();
        }
        this.buildPanel(string, string2);
    }

    private String getSQLDevDefaultWarFile() {
        String string = System.getProperty("oracle.home") + RestInstallConstants.SQLDEV_ORDS_WAR_FILE;
        try {
            if (this.checkWarFileExists(string)) {
                return string;
            }
        }
        catch (TraversalException traversalException) {
            // empty catch block
        }
        try {
            string = System.getenv("ORACLE_HOME") + RestInstallConstants.SQLDEV_ORDS_WAR_FILE;
            if (this.checkWarFileExists(string)) {
                return string;
            }
        }
        catch (TraversalException traversalException) {
            // empty catch block
        }
        return null;
    }

    private void hideSQLDEVDefaultORDSOption() {
        this.m_warChooser.setText(null);
        this.m_versionLbl.setText(RestArb.getString("WIZ_WAR_SELECT_ORDS"));
        this.m_SQLDevORDSWarFile.setSelected(false);
        this.m_userORDSWarFile.setSelected(true);
        this.m_SQLDevORDSWarFile.setEnabled(false);
        this.m_userORDSWarFile.setEnabled(true);
        this.m_warProductVersion = "";
        if (this.m_showConfig) {
            this.m_configChooser.setText(null);
            this.m_warConfigDir = null;
        }
    }

    private void buildPanel(String string, String string2) {
        this.setLayout(new GridBagLayout());
        this.m_warChooser = URLFileChooser.createURLFileChooserPanel((int)0, (String)RestArb.getString("WIZ_WAR_FILE_NAME"), (String)RestArb.getString("WIZ_SELECT_WAR_FILE"), (boolean)false, (boolean)true, (String)RestArb.getString("ORDS_BTN"));
        this.m_warChooser.setEnabled(false);
        this.m_warChooser.clearChooseableURLFilters();
        this.m_warChooser.setURLFilter((URLFilter)WAR_FILTER);
        this.m_warChooser.setSelectionScope(0);
        this.m_warChooser.setSelectionMode(0);
        this.m_warChooser.setShowJarsAsDirs(false);
        this.m_warChooser.setCheckIfFileExists(true);
        this.m_warChooser.setSelectedURL(null);
        this.m_warChooser.setPathContext("oracle.dbtools.rest.install.wizard.*WarFilePanel.WAR");
        this.m_warChooser.setText(null);
        ResourceUtils.resButton((AbstractButton)this.m_SQLDevORDSWarFile, (String)RestArb.getString("WIZ_WAR_FILE_SQLDEV"));
        ResourceUtils.resButton((AbstractButton)this.m_userORDSWarFile, (String)RestArb.getString("WIZ_WAR_FILE_USER"));
        JTextPane jTextPane = null;
        if (string2 != null) {
            jTextPane = new JTextPane();
            jTextPane.setText(string2);
            jTextPane.setEditable(false);
            jTextPane.setOpaque(false);
            jTextPane.setRequestFocusEnabled(false);
            jTextPane.setFocusable(false);
        }
        JTextPane jTextPane2 = new JTextPane();
        jTextPane2.setText(string);
        jTextPane2.setEditable(false);
        jTextPane2.setOpaque(false);
        jTextPane2.setRequestFocusEnabled(false);
        jTextPane2.setFocusable(false);
        JPanel jPanel = LayoutControl.GBC.createPanel();
        if (this.m_sqldev_ords_path != null) {
            jPanel.add((Component)this.m_SQLDevORDSWarFile, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
            jPanel.add((Component)this.m_userORDSWarFile, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        } else {
            JTextPane jTextPane3 = new JTextPane();
            jTextPane3.setText(RestArb.getString("WIZ_WAR_FILE_USER"));
            jTextPane3.setEditable(false);
            jTextPane3.setOpaque(false);
            jTextPane3.setRequestFocusEnabled(false);
            jTextPane3.setFocusable(false);
            jPanel.add((Component)jTextPane3, LayoutControl.GBC.gbc((int)0, (int)0, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        }
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)1);
        int n = 0;
        JPanel jPanel2 = LayoutControl.GBC.createPanel();
        jPanel2.add((Component)jTextPane2, LayoutControl.GBC.gbc((int)0, (int)n, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        if (this.m_sqldev_ords_path != null) {
            jPanel2.add((Component)jPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        } else {
            jPanel2.add((Component)jPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        }
        jPanel2.add((Component)this.m_warChooser, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel2, (int)(++n));
        JPanel jPanel3 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_WAR_FILE"), (Component)jPanel2);
        n = 0;
        int n2 = 0;
        JPanel jPanel4 = LayoutControl.GBC.createPanel();
        jPanel4.add((Component)this.m_versionLbl, LayoutControl.GBC.gbc((int)n2, (int)n, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        LayoutControl.GBC.addHSpring((JPanel)jPanel4, (int)(++n2));
        JPanel jPanel5 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_VERSION"), (Component)jPanel4);
        JPanel jPanel6 = null;
        if (this.m_showConfig) {
            this.m_configChooser = URLFileChooser.createURLFileChooserPanel((int)0, (String)RestArb.getString("CONFIG_FOLDER"), (String)RestArb.getString("WIZ_SELECT_CONFIG_DIR"), (boolean)false, (boolean)true, (String)RestArb.getString("BROWSE_BTN"));
            this.m_configChooser.setEnabled(true);
            this.m_configChooser.clearChooseableURLFilters();
            this.m_configChooser.setSelectionScope(1);
            this.m_configChooser.setSelectionMode(0);
            this.m_configChooser.setShowJarsAsDirs(false);
            this.m_configChooser.setCheckIfFileExists(true);
            this.m_configChooser.setSelectedURL(null);
            this.m_configChooser.setPathContext("oracle.dbtools.rest.install.wizard.*WarFilePanel.CONFIG");
            if (this.m_SQLDevORDSWarFile.isSelected()) {
                this.m_configChooser.setText(this.m_sqldev_warConfigDir);
            } else {
                this.m_configChooser.setText(null);
            }
            JTextPane jTextPane4 = new JTextPane();
            jTextPane4.setText(RestArb.getString("WIZ_CONFIG_DIR_DESCRIP"));
            jTextPane4.setEditable(false);
            jTextPane4.setOpaque(false);
            jTextPane4.setRequestFocusEnabled(false);
            jTextPane4.setFocusable(false);
            n = 0;
            n2 = 0;
            JPanel jPanel7 = LayoutControl.GBC.createPanel();
            jPanel7.add((Component)jTextPane4, LayoutControl.GBC.gbc((int)n2, (int)n, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
            jPanel7.add((Component)this.m_configChooser, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            JLabel jLabel = new JLabel();
            ResourceUtils.resButton((AbstractButton)this.m_resetBtn, (String)RestArb.getString("RESET_BTN"));
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_resetBtn, (String)RestArb.getString("WIZ_WAR_RESET_CONFIG"));
            jPanel7.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
            jPanel7.add((Component)this.m_resetBtn, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
            LayoutControl.GBC.addVSpring((JPanel)jPanel7, (int)(++n));
            jPanel6 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_CONFIG_FILE"), (Component)jPanel7);
        }
        n = 0;
        if (jTextPane != null) {
            this.add(jTextPane, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            ++n;
        }
        this.add(jPanel3, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)((Object)this), (int)(++n));
        if (this.m_showConfig) {
            this.add(jPanel6, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            LayoutControl.GBC.addVSpring((JPanel)((Object)this), (int)(++n));
        }
        this.add(jPanel5, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)((Object)this), (int)(++n));
        this.m_warChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WizBaseWarFilePanel.this.m_userORDSWarFile.isSelected() && WizBaseWarFilePanel.this.m_warChooser.getSelectedFile() != null) {
                    try {
                        if (WizBaseWarFilePanel.this.checkWarFileExists(WizBaseWarFilePanel.this.m_warChooser.getSelectedFile()) && WizBaseWarFilePanel.this.validWarFile(WizBaseWarFilePanel.this.m_warChooser.getSelectedFile().getPath())) {
                            if (WizBaseWarFilePanel.this.m_showConfig) {
                                WizBaseWarFilePanel.this.m_configChooser.setText(WizBaseWarFilePanel.this.m_warConfigDir);
                            }
                            WizBaseWarFilePanel.this.m_versionLbl.setText(RestArb.format("WIZ_WAR_VERSION", WizBaseWarFilePanel.this.m_warProductVersion));
                        }
                    }
                    catch (Exception exception) {
                        if (WizBaseWarFilePanel.this.m_showConfig) {
                            WizBaseWarFilePanel.this.m_configChooser.setText(null);
                        }
                        WizBaseWarFilePanel.this.m_versionLbl.setText(RestArb.getString("WIZ_WAR_SELECT_ORDS"));
                    }
                }
            }
        });
        this.enableDisableComponents();
        if (this.m_showConfig) {
            this.m_resetBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (WizBaseWarFilePanel.this.m_SQLDevORDSWarFile.isSelected()) {
                        WizBaseWarFilePanel.this.m_configChooser.setText(WizBaseWarFilePanel.this.m_sqldev_warConfigDir);
                    } else {
                        WizBaseWarFilePanel.this.m_configChooser.setText(WizBaseWarFilePanel.this.m_warConfigDir);
                    }
                }
            });
        }
        this.m_SQLDevORDSWarFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    WizBaseWarFilePanel.this.enableDisableComponents();
                    if (WizBaseWarFilePanel.this.m_SQLDevORDSWarFile.isSelected()) {
                        if (WizBaseWarFilePanel.this.m_showConfig) {
                            WizBaseWarFilePanel.this.m_configChooser.setText(WizBaseWarFilePanel.this.m_sqldev_warConfigDir);
                        }
                        WizBaseWarFilePanel.this.m_versionLbl.setText(RestArb.format("WIZ_WAR_VERSION", WizBaseWarFilePanel.this.m_sqldev_warVersion));
                    } else if (WizBaseWarFilePanel.this.m_showConfig) {
                        WizBaseWarFilePanel.this.m_configChooser.setSelectedURL(null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.m_userORDSWarFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    WizBaseWarFilePanel.this.enableDisableComponents();
                    if (WizBaseWarFilePanel.this.m_userORDSWarFile.isSelected()) {
                        if (WizBaseWarFilePanel.this.m_warChooser.getText() != null && WizBaseWarFilePanel.this.m_warChooser.getText().trim().length() > 0) {
                            if (WizBaseWarFilePanel.this.m_showConfig) {
                                WizBaseWarFilePanel.this.m_configChooser.setText(WizBaseWarFilePanel.this.m_warConfigDir);
                            }
                            WizBaseWarFilePanel.this.m_versionLbl.setText(RestArb.format("WIZ_WAR_VERSION", WizBaseWarFilePanel.this.m_warProductVersion));
                        } else {
                            if (WizBaseWarFilePanel.this.m_showConfig) {
                                WizBaseWarFilePanel.this.m_configChooser.setText(null);
                            }
                            WizBaseWarFilePanel.this.m_versionLbl.setText(RestArb.getString("WIZ_WAR_SELECT_ORDS"));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void enableDisableComponents() {
        boolean bl = this.m_SQLDevORDSWarFile.isSelected();
        this.m_warChooser.setEnabled(!bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validConfigLocation() throws TraversalException {
        File file = null;
        String string = this.m_configChooser.getText();
        if (RestUtils.emptyValue(string)) {
            throw new TraversalException(RestArb.getString("ERROR_MISSING_CONFIG_DIR"));
        }
        file = new File(string);
        if (!file.exists()) {
            boolean bl = MessageDialog.confirm(null, (Object)RestArb.getString("WIZ_QUESTION_CREATE_DIR"), (String)RestArb.getString("WIZ_CONFIRM_CREATE_DIR"), null);
            if (!bl) throw new TraversalException(RestArb.getString("WARNING_CONFIG_DIR_REQUIRED"));
            try {
                boolean bl2 = file.mkdir();
                if (!bl2) {
                    throw new TraversalException(RestArb.getString("WARNING_CONFIG_DIR_REQUIRED"));
                }
                this.createdConfigFolders.add(file.getAbsolutePath());
                return true;
            }
            catch (Exception exception) {
                throw new TraversalException(exception.getLocalizedMessage());
            }
        } else {
            if (file.isDirectory()) return true;
            throw new TraversalException(RestArb.format("ERROR_CONFIG_DIR_INVALID", file.getPath()));
        }
    }

    private boolean checkWarFileExists(String string) throws TraversalException {
        if (RestUtils.emptyValue(string)) {
            throw new TraversalException(RestArb.getString("ERROR_MISSING_WAR_FILE"));
        }
        return this.checkWarFileExists(new File(string));
    }

    private boolean checkWarFileExists(File file) throws TraversalException {
        if (file == null) {
            throw new TraversalException(RestArb.getString("ERROR_MISSING_WAR_FILE"));
        }
        if (file.isDirectory()) {
            throw new TraversalException(RestArb.format("ERROR_WAR_FILE_INVALID", file.getPath()));
        }
        if (!file.exists()) {
            throw new TraversalException(RestArb.format("ERROR_WAR_FILE_NOT_EXIST", file.getPath()));
        }
        return true;
    }

    private boolean validWarFile(String string) throws TraversalException {
        this.m_warProductVersion = "";
        this.m_warConfigDir = null;
        try {
            File file = new File(string);
            Map<String, String> map = InstallUtils.getWEBXMLParams(file);
            String string2 = map.get("product.version");
            if (this.isValidORDSVersion(string2)) {
                if (this.m_showConfig) {
                    this.m_warConfigDir = map.get("config.dir");
                    if (this.m_warConfigDir != null && this.m_warConfigDir.isEmpty()) {
                        this.m_warConfigDir = null;
                    }
                }
            } else {
                throw new TraversalException(RestArb.format("ERROR_WAR_FILE_VERSION", string2));
            }
            this.m_warProductVersion = string2;
        }
        catch (IOException iOException) {
            throw new TraversalException((Object)iOException);
        }
        return true;
    }

    private boolean isValidORDSVersion(String string) {
        String[] stringArray;
        int n;
        return string != null && !string.isEmpty() && (n = Integer.parseInt((stringArray = string.split("\\."))[0])) >= 3;
    }

    /*
     * Unable to fully structure code
     */
    private void validateValues() throws TraversalException {
        if (this.m_userORDSWarFile.isSelected()) {
            try {
                if (!this.checkWarFileExists(this.m_warChooser.getSelectedFile())) ** GOTO lbl14
                this.validWarFile(this.m_warChooser.getSelectedFile().getPath());
            }
            catch (Exception var1_1) {
                throw new TraversalException(var1_1.getLocalizedMessage());
            }
        } else if (this.m_SQLDevORDSWarFile.isSelected()) {
            if (this.m_sqldev_warVersion == null) {
                throw new TraversalException(RestArb.getString("ERROR_SQLDEV_WAR_FILE"));
            }
        } else {
            throw new TraversalException("No selection made.");
        }
lbl14:
        // 3 sources

        if (this.m_showConfig) {
            this.validConfigLocation();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this.validateValues();
            try {
                String string;
                File file;
                Map map = (Map)traversableContext.get("ORDS_PARAMS");
                if (this.m_SQLDevORDSWarFile.isSelected()) {
                    file = new File(this.m_sqldev_ords_path);
                    string = this.m_sqldev_warVersion;
                    if (this.m_showConfig) {
                        map.put("use.sqldev.configdir", Boolean.TRUE);
                    }
                } else {
                    file = new File(this.m_warChooser.getText());
                    string = this.m_warProductVersion;
                    if (this.m_showConfig) {
                        map.put("use.sqldev.configdir", Boolean.FALSE);
                    }
                }
                File file2 = null;
                if (this.m_showConfig) {
                    file2 = new File(this.m_configChooser.getText());
                    if (this.m_prevConfigPath == null || !this.m_prevConfigPath.getCanonicalPath().equals(file2.getCanonicalPath())) {
                        this.m_installType = InstallUtils.getInstallType(file2);
                        map.put("config.status", this.m_installType);
                        map.put("config.dir", file2);
                    }
                }
                if (this.m_prevWarFile == null || !this.m_prevWarFile.getCanonicalPath().equals(file.getCanonicalPath())) {
                    map.put("ords.warfile", file);
                    map.put("product.version", string);
                    Map<String, String> map2 = InstallUtils.getInstallParamsFromFile(file);
                    if (this.m_showConfig) {
                        map.put("config.dir.update", Boolean.TRUE);
                        map2.put("config.status", this.m_installType.toString());
                    }
                    map.put("INSTALL_KEY_PARAMS", map2);
                }
                this.m_prevWarFile = file;
                if (this.m_showConfig) {
                    map.put("config.dir.created", this.createdConfigFolders);
                    this.m_prevConfigPath = file2;
                }
            }
            catch (Exception exception) {
                throw new TraversalException(exception.getLocalizedMessage());
            }
        }
    }

    public Object getExitTransition() {
        return "Transition.DBConn";
    }
}

