/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestRole;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.util.ResourceUtils;

public class RestRolePanel
extends JPanel {
    private RestRole _role;
    private JTextField _name;
    private List<String> _existingNames;
    private List<String> _errMsg;

    public RestRolePanel() {
        this((RestRole)null);
    }

    public RestRolePanel(RestRole restRole) {
        this(restRole, null);
    }

    public RestRolePanel(RestRole restRole, String string) {
        this._role = restRole;
        this.createPanel();
    }

    private void initializeComponents() {
        this._name = new JTextField();
        if (this._role != null) {
            this._name.setText(this._role.getName());
        }
        this._name.requestFocusInWindow();
    }

    private void createPanel() {
        this.initializeComponents();
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._name, (String)RestArb.getString("LABEL_ROLE"));
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._name, new GridBagConstraints(1, n, 1, 1, 1.0, 0.5, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, n, 2, 1, 1.0, 0.5, 23, 2, new Insets(8, 8, 8, 8), 0, 0));
        n = 0;
        this.add((Component)jPanel, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.1, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.addListeners();
    }

    public void addListeners() {
    }

    public void removeListeners() {
    }

    public boolean validInfo() {
        if (this._errMsg == null) {
            this._errMsg = new ArrayList<String>();
        } else {
            this._errMsg.clear();
        }
        String string = this._name.getText();
        if (RestUtils.emptyValue(string)) {
            this.setErrorMessage(RestArb.format("VALUE_REQUIRED", RestArb.getString("LABEL_ROLE")));
        } else if (this.isExistRoleName(string)) {
            this.setErrorMessage(RestArb.format("VALUE_ALREADY_EXIST", RestArb.getString("LABEL_ROLE")));
        }
        if (this._errMsg.size() > 0) {
            this._name.requestFocusInWindow();
        }
        return this._errMsg.size() == 0;
    }

    public RestRole getValues() {
        if (this._role == null) {
            this._role = new RestRole();
        }
        String string = this._name.getText() != null ? this._name.getText().trim() : "";
        this._role.setName(string);
        return this._role;
    }

    public String getErrorMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this._errMsg) {
            stringBuffer.append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    private void setErrorMessage(String string) {
        if (this._errMsg == null) {
            this._errMsg = new ArrayList<String>();
        }
        this._errMsg.add(string);
    }

    public void setExistingNames(List<String> list) {
        this._existingNames = list;
    }

    public boolean isExistRoleName(String string) {
        if (this._existingNames == null || this._existingNames.isEmpty()) {
            return false;
        }
        return this._existingNames.contains(string);
    }
}

