/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.common.util.Template;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.patterns.NamedPattern;
import oracle.dbtools.rest.patterns.RoutePattern;
import oracle.dbtools.rest.patterns.RoutePatternsProvider;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.dbtools.rt.uri.URITemplateValidator;

public class RestTemplatePattern {
    private static final Pattern QUESTIONMARK_KEY_EQUAL = Pattern.compile("\\?(\\p{Alpha}[\\p{Alnum}_\\-\\.]*)\\=");

    public static RoutePattern getRoutePattern(String string) {
        String string2 = string;
        RoutePatternsProvider routePatternsProvider = new RoutePatternsProvider();
        RoutePattern routePattern = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            if (string2.contains("//")) {
                stringBuilder.append(RestArb.format("SEC_ERR_MULTIPLE_FORWARD_SLASH", string2));
            }
            if (RestTemplatePattern.hasQueryString(string2)) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(RestArb.format("ERR_ROUTE_PATTERN_QUERY_STRING", string2));
            }
            routePattern = routePatternsProvider.routePattern(string2);
        }
        catch (Exception exception) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(exception.getMessage());
        }
        if (stringBuilder.length() > 0) {
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        return routePattern;
    }

    public static List<String> getParameters(String string) {
        List<String> list = new ArrayList<String>();
        if (!RestUtils.nullOrEmpty(string)) {
            if (RestTemplatePattern.isURITemplatePattern(string)) {
                list = RestTemplatePattern.getURITemplateParameters(string);
            } else {
                RoutePattern routePattern = RestTemplatePattern.getRoutePattern(string);
                if (routePattern instanceof NamedPattern) {
                    Set<String> set = ((NamedPattern)routePattern).parameters();
                    list = new ArrayList<String>(set);
                }
            }
        }
        return list;
    }

    public static List<String> getURITemplateParameters(String string) {
        List<String> list = new ArrayList<String>();
        if (string != null && !string.isEmpty()) {
            Template template = new Template(string);
            list = template.parameters();
        }
        return list;
    }

    public static boolean isURITemplatePattern(String string) {
        String string2 = string;
        if (string2.indexOf(123) != -1) {
            return true;
        }
        if (string2.indexOf(63) != -1) {
            try {
                RoutePattern routePattern;
                if (!RestTemplatePattern.hasQueryString(string)) {
                    return false;
                }
                if (string2.indexOf(58) != -1 && (routePattern = RestTemplatePattern.getRoutePattern(string)) instanceof NamedPattern) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public static boolean isValidRoutePattern(String string) {
        try {
            RestTemplatePattern.getRoutePattern(string);
        }
        catch (Exception exception) {
            Logger.getLogger(RestTemplatePattern.class.getName()).log(Level.FINE, exception.getStackTrace()[0].toString(), exception);
            return false;
        }
        return true;
    }

    public static boolean isValidURITemplate(String string) {
        if (string.contains("//")) {
            return false;
        }
        URITemplateValidator uRITemplateValidator = new URITemplateValidator();
        return uRITemplateValidator.isValid(string);
    }

    public static boolean hasQueryString(String string) {
        if (string == null) {
            return false;
        }
        if (string.lastIndexOf(63) != -1) {
            Matcher matcher = QUESTIONMARK_KEY_EQUAL.matcher(string);
            return matcher.find();
        }
        return false;
    }
}

