/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.utils;

import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DBNavigatorManager;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.connection.RestConnection;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestPrivilege;
import oracle.dbtools.rest.navigator.RestFolder;
import oracle.dbtools.rest.navigator.RestModuleFolder;
import oracle.dbtools.rest.navigator.RestModuleNode;
import oracle.dbtools.rest.navigator.RestRoot;
import oracle.dbtools.rest.navigator.RestTemplateNode;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.view.View;

public class RestUtils {
    public static final WildcardURLFilter ZIP_FILTER = new WildcardURLFilter(RestArb.getString("ZIP_FILTER_MASK"), URLFileSystem.isLocalFileSystemCaseSensitive(), RestArb.getString("ZIP_FILTER_NAME"));
    public static final String DEFAULT_CHARSET = "UTF-8";

    public static List<RestModule> getModules() {
        return RestRoot.getInstance().getModules();
    }

    public static List<RestPrivilege> getPrivileges() {
        return RestRoot.getInstance().getPrivileges();
    }

    public static List<String> getRoles() {
        return RestRoot.getInstance().getRoles();
    }

    public static boolean loadAdmin(List<RestModule> list, List<RestPrivilege> list2) {
        RestRoot.getInstance().loadData(list, list2);
        return true;
    }

    public static void loadRoles(List<String> list) {
        RestRoot.getInstance().loadRoles(list);
    }

    public static void loadSchemas(List<String> list) {
        RestRoot.getInstance().loadSchemas(list);
    }

    public static RestModuleNode createModuleNode(RestModule restModule) {
        return RestRoot.getInstance().createModuleNode(restModule);
    }

    public static List<String> getModuleNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<RestModule> list = RestUtils.getModules();
        if (list != null) {
            for (RestModule restModule : list) {
                String string2 = restModule.getName();
                if (string2 == null || string != null && string.equals(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public static List<String> getModuleUriPrefixes(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<RestModule> list = RestUtils.getModules();
        if (list != null) {
            for (RestModule restModule : list) {
                String string2 = restModule.getURIPrefix();
                if (string2 == null || string != null && string.equals(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public static List<String> getPrivilegeNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<RestPrivilege> list = RestUtils.getPrivileges();
        if (list != null) {
            for (RestPrivilege restPrivilege : list) {
                if (restPrivilege.getName() == null || string != null && string.equals(restPrivilege.getName())) continue;
                arrayList.add(restPrivilege.getName());
            }
        }
        return arrayList;
    }

    public static List<String> getExistingURIs(RestFolder restFolder, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = restFolder.getChildren();
        if (iterator != null) {
            String string2 = null;
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                string2 = null;
                if (restFolder instanceof RestModuleFolder) {
                    string2 = ((RestModuleNode)((Object)iterator2.next())).getModule().getURIPrefix();
                } else if (restFolder instanceof RestModuleNode) {
                    string2 = ((RestTemplateNode)((Object)iterator2.next())).getTemplate().getURIPattern();
                }
                if (string2 == null || string != null && string.equals(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public static Charset getCharacterSet(String string) {
        Charset charset = null;
        if (string != null) {
            try {
                charset = Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                Logger.getLogger(RestUtils.class.getName()).log(Level.WARNING, RestArb.format("UNEXPECTED_CHARSET", string));
            }
        }
        if (charset == null) {
            try {
                charset = Charset.forName(DEFAULT_CHARSET);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                Logger.getLogger(RestUtils.class.getName()).log(Level.WARNING, RestArb.format("UNEXPECTED_CHARSET", DEFAULT_CHARSET));
                charset = Charset.defaultCharset();
            }
        }
        return charset;
    }

    public static URI getBaseURI() {
        if (RestConnection.getInstance().isConnectionOpen()) {
            return RestConnection.getInstance().getConnection().getDefaultServiceURI();
        }
        return null;
    }

    public static void setAPEXRestfulServices(boolean bl) {
        RestConnection.getInstance().setAPEXRestfulServices(bl);
    }

    public static boolean isAPEXRestfulServices() {
        return RestConnection.getInstance().isAPEXRestfulServices();
    }

    public static List<String> getChildrenNames(Context context) {
        NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(context);
        return RestUtils.getChildrenNames(navigatorTreeNode);
    }

    public static List<String> getChildrenNames(NavigatorTreeNode navigatorTreeNode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (navigatorTreeNode != null) {
            Enumeration enumeration = navigatorTreeNode.children();
            while (enumeration.hasMoreElements()) {
                NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)enumeration.nextElement();
                Element element = navigatorTreeNode2.getElement();
                arrayList.add(element.getShortLabel());
            }
        }
        return arrayList;
    }

    public static List<String> getChildrenNames(ObjectFolder objectFolder) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            DBFolderInstance dBFolderInstance = objectFolder.getFolderInstance();
            List list = dBFolderInstance.listChildren();
            for (DBChildInstance dBChildInstance : list) {
                String string = (String)dBChildInstance.getProperty("NAME");
                if (string == null) continue;
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(RestUtils.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList;
    }

    public static NavigatorTreeNode findTreeNode(Context context) {
        NavigatorTreeNode navigatorTreeNode = null;
        View view = context.getView();
        if (view instanceof NavigatorWindow) {
            Element element;
            Element[] elementArray;
            navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext((Context)context);
            if (navigatorTreeNode == null && (elementArray = context.getSelection()) != null && elementArray.length == 1 && (element = elementArray[0]) != null) {
                NavigatorTree navigatorTree = ((NavigatorWindow)view).getTree();
                navigatorTreeNode = navigatorTree.findTreeNode(element, navigatorTree.getRoot());
            }
        } else {
            NavigatorTree navigatorTree;
            NavigatorWindow navigatorWindow = DBNavigatorManager.getInstance().getNavigatorWindow();
            if (navigatorWindow != null && (navigatorTree = navigatorWindow.getTree()) != null) {
                DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
                if (dBObject == null) {
                    dBObject = new DBObject(context.getElement());
                }
                navigatorTreeNode = navigatorTree.findTreeNode(dBObject.getURL(), navigatorTree.getRoot());
            }
        }
        return navigatorTreeNode;
    }

    public static NavigatorTreeNode findTreeNode(DBObject dBObject) {
        if (dBObject != null) {
            return RestUtils.findTreeNode(dBObject.getURL());
        }
        return null;
    }

    public static NavigatorTreeNode findTreeNode(URL uRL) {
        NavigatorTree navigatorTree;
        NavigatorWindow navigatorWindow;
        NavigatorTreeNode navigatorTreeNode = null;
        if (uRL != null && (navigatorWindow = DBNavigatorManager.getInstance().getNavigatorWindow()) != null && (navigatorTree = navigatorWindow.getTree()) != null) {
            navigatorTreeNode = navigatorTree.findTreeNode(uRL, navigatorTree.getRoot());
        }
        return navigatorTreeNode;
    }

    public static boolean emptyValue(String string) {
        return RestUtils.nullOrEmpty(string);
    }

    public static boolean nullOrEmpty(String string) {
        return string == null || string.isEmpty() || string.trim().length() == 0;
    }

    public static boolean nullOrEmpty(Iterable<?> iterable) {
        return iterable == null || !iterable.iterator().hasNext();
    }

    public static boolean valuesDifferent(String string, String string2) {
        String string3;
        String string4 = string != null ? string : "";
        String string5 = string3 = string2 != null ? string2 : "";
        return !string4.equals(string3);
    }

    public static String getNLSObjectType(String string) {
        switch (string) {
            case "REST_MODULE": {
                return RestArb.getString("LABEL_MODULE");
            }
            case "REST_MODULE_FOLDER": {
                return RestArb.getString("MODULES_FOLDER");
            }
            case "REST_PRIVILEGE": {
                return RestArb.getString("LABEL_PRIVILEGE");
            }
            case "REST_PRIVILEGE_FOLDER": {
                return RestArb.getString("PRIVILEGES_FOLDER");
            }
            case "REST_ROLE": {
                return RestArb.getString("LABEL_ROLE");
            }
            case "REST_ROLE_FOLDER": {
                return RestArb.getString("ROLES_FOLDER");
            }
        }
        return "";
    }
}

