/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.rest.model.RestHandlerParameter;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;

public class RestXMLUtil {
    private LinkedHashMap<String, String> _restMap = new LinkedHashMap();
    private StringBuilder _xmlFormat;
    private final int _indent = 0;
    private long _modulePaginationSize;

    public static String resourceModulestoXML(List<RestModule> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return new RestXMLUtil().modulesToXML(list);
    }

    public static String resourceModuletoXML(RestModule restModule) {
        if (restModule == null) {
            return null;
        }
        return new RestXMLUtil().moduletoXML(restModule, true);
    }

    public static List<RestModule> getModules(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        return new RestXMLUtil().createModules(inputStream, null);
    }

    public static List<RestModule> getModules(InputStream inputStream, String string) {
        if (inputStream == null) {
            return null;
        }
        return new RestXMLUtil().createModules(inputStream, string);
    }

    public static RestModule getModule(InputStream inputStream, String string) {
        if (inputStream == null) {
            return null;
        }
        List<RestModule> list = RestXMLUtil.getModules(inputStream);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    private RestXMLUtil() {
    }

    private String modulesToXML(List<RestModule> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getXMLDeclaration());
        stringBuilder.append(this.formatStartTag("rest", this._restMap, 0, false));
        for (RestModule restModule : list) {
            stringBuilder.append(this.moduletoXML(restModule, false));
        }
        stringBuilder.append(this.formatEndTag("rest", 0));
        return stringBuilder.toString();
    }

    private String moduletoXML(RestModule restModule, boolean bl) {
        if (restModule == null) {
            return null;
        }
        this._restMap.clear();
        this._xmlFormat = new StringBuilder();
        if (bl) {
            this._xmlFormat.append(this.getXMLDeclaration());
        }
        this.formatModule(restModule);
        return this._xmlFormat.toString();
    }

    private String getXMLDeclaration() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    }

    private void formatModule(RestModule restModule) {
        this._restMap.clear();
        this._restMap.put("xmlns", "http://xmlns.oracle.com/apex/resource-template");
        String string = RestUtils.emptyValue(restModule.getName()) ? "defaults" : restModule.getName();
        this._restMap.put("name", string);
        if (restModule.isPublished()) {
            this._restMap.put("published", "true");
        }
        if (!RestUtils.emptyValue(restModule.getURIPrefix())) {
            this._restMap.put("uri-prefix", restModule.getURIPrefix());
        }
        this._restMap.put("page-size", Long.toString(restModule.getPaginationSize()));
        String string2 = this.formatCommaDelimitedList(restModule.getOrigins());
        if (!RestUtils.emptyValue(string2)) {
            this._restMap.put("origins-allowed", string2);
        }
        this._xmlFormat.append(this.formatStartTag("module", this._restMap, 1, false));
        this.formatTemplates(restModule.getTemplates());
        this._xmlFormat.append(this.formatEndTag("module", 1));
    }

    private void formatTemplates(List<RestTemplate> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (RestTemplate restTemplate : list) {
            this._restMap.clear();
            this._restMap.put("pattern", restTemplate.getURIPattern());
            if (restTemplate.getPriority() != 0) {
                this._restMap.put("priority", Integer.toString(restTemplate.getPriority()));
            }
            this._xmlFormat.append(this.formatStartTag("template", this._restMap, 2, false));
            this._restMap.clear();
            if (restTemplate.getEntityTag() == RestTemplate.ENTITY_TAG_TYPE.SECURE_HASH) {
                this._xmlFormat.append(this.formatStartTag("etag", null, 3, true));
            } else if (restTemplate.getEntityTag() == RestTemplate.ENTITY_TAG_TYPE.QUERY && !RestUtils.emptyValue(restTemplate.getEntityTagQuery())) {
                this._xmlFormat.append(this.formatStartTag("etag", null, 3, false));
                this._xmlFormat.append(this.formatCDATA(restTemplate.getEntityTagQuery(), 4));
                this._xmlFormat.append(this.formatEndTag("etag", 3));
            }
            this.formatHandler(restTemplate.getResourceHandlers());
            this._xmlFormat.append(this.formatEndTag("template", 2));
        }
    }

    private void formatHandler(Map<RestResourceHandler.HTTP_METHOD_TYPE, RestResourceHandler> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string;
            RestResourceHandler.HTTP_METHOD_TYPE hTTP_METHOD_TYPE = (RestResourceHandler.HTTP_METHOD_TYPE)objectArray[i];
            RestResourceHandler restResourceHandler = map.get(hTTP_METHOD_TYPE);
            this._restMap.clear();
            this._restMap.put("method", restResourceHandler.getMethodType().getType());
            this._restMap.put("type", restResourceHandler.getSourceTypeGenerator());
            if (RestUtils.isAPEXRestfulServices()) {
                this._restMap.put("security-constraint", restResourceHandler.isSecuredAccess() ? "secure" : "none");
            }
            if (hTTP_METHOD_TYPE == RestResourceHandler.HTTP_METHOD_TYPE.GET && restResourceHandler.getSourceType() != null && restResourceHandler.getSourceType() != RestResourceHandler.SOURCE_TYPE.QUERY_ONE_ROW) {
                this._restMap.put("page-size", Long.toString(restResourceHandler.getPaginationSize()));
            }
            if (!(hTTP_METHOD_TYPE != RestResourceHandler.HTTP_METHOD_TYPE.POST && hTTP_METHOD_TYPE != RestResourceHandler.HTTP_METHOD_TYPE.PUT || RestUtils.emptyValue(string = this.formatCommaDelimitedList(restResourceHandler.getMimeTypes())))) {
                this._restMap.put("accept", string);
            }
            this._xmlFormat.append(this.formatStartTag("handler", this._restMap, 3, false));
            this._xmlFormat.append(this.formatStartTag("content", null, 4, false));
            this._xmlFormat.append(this.formatCDATA(restResourceHandler.getSQL(), 5));
            this._xmlFormat.append(this.formatEndTag("content", 4));
            this.formatHandlerParameters(restResourceHandler.getParameters());
            this._xmlFormat.append(this.formatEndTag("handler", 3));
        }
    }

    private void formatHandlerParameters(List<RestHandlerParameter> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (RestHandlerParameter restHandlerParameter : list) {
            RestHandlerParameter.ACCESS_METHOD_TYPE aCCESS_METHOD_TYPE;
            RestHandlerParameter.DATA_TYPE dATA_TYPE;
            this._restMap.clear();
            this._restMap.put("name", restHandlerParameter.getBindVariable());
            this._restMap.put("aliasing", restHandlerParameter.getName());
            RestHandlerParameter.SOURCE_TYPE sOURCE_TYPE = restHandlerParameter.getSourceType();
            if (sOURCE_TYPE != null) {
                this._restMap.put("source", sOURCE_TYPE.getType());
            }
            if ((dATA_TYPE = restHandlerParameter.getDataType()) != null) {
                this._restMap.put("type", dATA_TYPE.getType());
            }
            if ((aCCESS_METHOD_TYPE = restHandlerParameter.getAccessMethod()) != null) {
                this._restMap.put("access", aCCESS_METHOD_TYPE.getType());
            }
            this._xmlFormat.append(this.formatStartTag("parameter", this._restMap, 4, true));
        }
    }

    private String formatCDATA(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getSpaceIndent(n)).append("<![CDATA[").append(string).append("]]>").append("\n");
        return stringBuffer.toString();
    }

    private String formatStartTag(String string, Map<String, String> map, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getSpaceIndent(n));
        stringBuffer.append("<").append(string);
        if (map != null) {
            Object[] objectArray = map.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string2 = (String)objectArray[i];
                String string3 = map.get(string2);
                string3 = this.convertXMLReservedCharacters(string3);
                stringBuffer.append(" ").append(string2).append("=").append("\"").append(string3).append("\"");
            }
        }
        if (bl) {
            stringBuffer.append(" />").append("\n");
        } else {
            stringBuffer.append(">").append("\n");
        }
        return stringBuffer.toString();
    }

    private String formatEndTag(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getSpaceIndent(n));
        stringBuffer.append("</").append(string).append(">").append("\n");
        return stringBuffer.toString();
    }

    private String formatCommaDelimitedList(List<String> list) {
        String string = "";
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                String string2 = list.get(i);
                if (RestUtils.emptyValue(string2)) continue;
                string = string + string2;
                if (i >= list.size() - 1) continue;
                string = string + ",";
            }
        }
        return string;
    }

    private String convertXMLReservedCharacters(String string) {
        if (string != null && string.length() != 0) {
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n);
            block6: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '&': {
                        stringBuilder.append("&amp;");
                        continue block6;
                    }
                    case '<': {
                        stringBuilder.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        stringBuilder.append("&gt;");
                        continue block6;
                    }
                    case '\"': {
                        stringBuilder.append("&quot;");
                        continue block6;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
            }
            return stringBuilder.toString();
        }
        return string;
    }

    private String getSpaceIndent(int n) {
        String string = "";
        int n2 = n + 0;
        for (int i = 0; i < n2; ++i) {
            string = string + " ";
        }
        return string;
    }

    private List<RestModule> createModules(InputStream inputStream, String string) {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            Charset charset;
            if (string == null) {
                dOMParser.parse(inputStream);
            } else {
                charset = RestUtils.getCharacterSet(string);
                dOMParser.parse((Reader)new BufferedReader(new InputStreamReader(inputStream, charset)));
            }
            charset = dOMParser.getDocument();
            if (charset != null) {
                return this.parseModules((XMLDocument)charset);
            }
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error the parsed document is null.");
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        return null;
    }

    private List<RestModule> parseModules(XMLDocument xMLDocument) {
        ArrayList<RestModule> arrayList = new ArrayList<RestModule>();
        XMLNode[] xMLNodeArray = null;
        XMLNode xMLNode = (XMLNode)XMLHelper.getChildNode((Node)xMLDocument, (String)"rest");
        xMLNodeArray = xMLNode == null ? XMLHelper.getChildNodes((Node)xMLDocument, (String)"module") : XMLHelper.getChildNodes((Node)xMLNode, (String)"module");
        if (xMLNodeArray != null) {
            for (XMLNode xMLNode2 : xMLNodeArray) {
                RestModule restModule = new RestModule();
                this.populateModule((Node)xMLNode2, restModule);
                arrayList.add(restModule);
            }
        }
        return arrayList;
    }

    private void populateModule(Node node, RestModule restModule) {
        String string = XMLHelper.getAttributeNode((Node)node, (String)"name");
        restModule.setName(string != null ? string : "defaults");
        string = XMLHelper.getAttributeNode((Node)node, (String)"page-size");
        if (!RestUtils.emptyValue(string)) {
            restModule.setPaginationSize((long)Integer.parseInt(string));
        }
        this._modulePaginationSize = restModule.getPaginationSize();
        string = XMLHelper.getAttributeNode((Node)node, (String)"published");
        if (!RestUtils.emptyValue(string)) {
            restModule.setPublished(Boolean.parseBoolean(string));
        }
        restModule.setSchema(XMLHelper.getAttributeNode((Node)node, (String)"parsing-schema"));
        restModule.setURIPrefix(XMLHelper.getAttributeNode((Node)node, (String)"uri-prefix"));
        restModule.setOrigins(this.createList(XMLHelper.getAttributeNode((Node)node, (String)"origins-allowed")));
        this.parseTemplate(node, restModule);
    }

    private void parseTemplate(Node node, RestModule restModule) {
        XMLNode[] xMLNodeArray = XMLHelper.getChildNodes((Node)node, (String)"template");
        if (xMLNodeArray != null) {
            ArrayList<RestTemplate> arrayList = new ArrayList<RestTemplate>();
            for (XMLNode xMLNode : xMLNodeArray) {
                RestTemplate restTemplate = new RestTemplate();
                this.populateTemplate((Node)xMLNode, restTemplate);
                arrayList.add(restTemplate);
            }
            if (!arrayList.isEmpty()) {
                restModule.setTemplates(arrayList);
            }
        }
    }

    private void populateTemplate(Node node, RestTemplate restTemplate) {
        Node node2;
        restTemplate.setURIPattern(XMLHelper.getAttributeNode((Node)node, (String)"pattern"));
        String string = XMLHelper.getAttributeNode((Node)node, (String)"priority");
        if (!RestUtils.emptyValue(string)) {
            restTemplate.setPriority(Integer.parseInt(string));
        }
        if ((node2 = XMLHelper.getChildNode((Node)node, (String)"etag")) == null) {
            restTemplate.setEntityTag(RestTemplate.ENTITY_TAG_TYPE.NONE);
        } else {
            string = XMLHelper.getNodeValue((Node)node, (String)"etag");
            if (string == null) {
                restTemplate.setEntityTag(RestTemplate.ENTITY_TAG_TYPE.SECURE_HASH);
            } else {
                restTemplate.setEntityTag(RestTemplate.ENTITY_TAG_TYPE.QUERY);
                restTemplate.setEntityTagQuery(string.trim());
            }
        }
        this.parseHandler(node, restTemplate);
    }

    private void parseHandler(Node node, RestTemplate restTemplate) {
        XMLNode[] xMLNodeArray = XMLHelper.getChildNodes((Node)node, (String)"handler");
        if (xMLNodeArray != null) {
            for (XMLNode xMLNode : xMLNodeArray) {
                RestResourceHandler restResourceHandler = new RestResourceHandler();
                this.populateHandler((Node)xMLNode, restResourceHandler);
                restTemplate.addResourceHandler(restResourceHandler.getMethodType(), restResourceHandler);
            }
        }
    }

    private void populateHandler(Node node, RestResourceHandler restResourceHandler) {
        String string = XMLHelper.getAttributeNode((Node)node, (String)"method");
        RestResourceHandler.HTTP_METHOD_TYPE hTTP_METHOD_TYPE = RestResourceHandler.HTTP_METHOD_TYPE.GET;
        if (!RestUtils.emptyValue(string)) {
            if (string.equalsIgnoreCase(RestResourceHandler.HTTP_METHOD_TYPE.POST.getType())) {
                hTTP_METHOD_TYPE = RestResourceHandler.HTTP_METHOD_TYPE.POST;
            } else if (string.equalsIgnoreCase(RestResourceHandler.HTTP_METHOD_TYPE.PUT.getType())) {
                hTTP_METHOD_TYPE = RestResourceHandler.HTTP_METHOD_TYPE.PUT;
            } else if (string.equalsIgnoreCase(RestResourceHandler.HTTP_METHOD_TYPE.DELETE.getType())) {
                hTTP_METHOD_TYPE = RestResourceHandler.HTTP_METHOD_TYPE.DELETE;
            }
        }
        restResourceHandler.setMethodType(hTTP_METHOD_TYPE);
        string = XMLHelper.getAttributeNode((Node)node, (String)"type");
        restResourceHandler.setSourceType(string);
        string = XMLHelper.getAttributeNode((Node)node, (String)"security-constraint");
        if (!RestUtils.emptyValue(string) && (string.equalsIgnoreCase("secure") || string.equalsIgnoreCase("none"))) {
            restResourceHandler.setSecuredAccess(string.equalsIgnoreCase("secure"));
            RestUtils.setAPEXRestfulServices(true);
        } else {
            RestUtils.setAPEXRestfulServices(false);
        }
        string = XMLHelper.getAttributeNode((Node)node, (String)"page-size");
        if (!RestUtils.emptyValue(string)) {
            restResourceHandler.setPaginationSize((long)Integer.parseInt(string));
        } else {
            restResourceHandler.setPaginationSize(this._modulePaginationSize);
        }
        string = XMLHelper.getAttributeNode((Node)node, (String)"accept");
        if (!RestUtils.emptyValue(string)) {
            restResourceHandler.setMimeTypes(this.createList(string));
        }
        if (!RestUtils.emptyValue(string = XMLHelper.getNodeValue((Node)node, (String)"content"))) {
            restResourceHandler.setSQL(string.trim());
        }
        this.parseParameter(node, restResourceHandler);
    }

    private void parseParameter(Node node, RestResourceHandler restResourceHandler) {
        XMLNode[] xMLNodeArray = XMLHelper.getChildNodes((Node)node, (String)"parameter");
        if (xMLNodeArray != null) {
            ArrayList<RestHandlerParameter> arrayList = new ArrayList<RestHandlerParameter>();
            for (XMLNode xMLNode : xMLNodeArray) {
                RestHandlerParameter restHandlerParameter = new RestHandlerParameter();
                this.populateParameter((Node)xMLNode, restHandlerParameter);
                arrayList.add(restHandlerParameter);
            }
            if (!arrayList.isEmpty()) {
                restResourceHandler.setParameters(arrayList);
            }
        }
    }

    private void populateParameter(Node node, RestHandlerParameter restHandlerParameter) {
        restHandlerParameter.setBindVariable(XMLHelper.getAttributeNode((Node)node, (String)"name"));
        restHandlerParameter.setName(XMLHelper.getAttributeNode((Node)node, (String)"aliasing"));
        RestHandlerParameter.ACCESS_METHOD_TYPE aCCESS_METHOD_TYPE = RestHandlerParameter.ACCESS_METHOD_TYPE.IN;
        String string = XMLHelper.getAttributeNode((Node)node, (String)"access");
        if (!RestUtils.emptyValue(string)) {
            if (string.equalsIgnoreCase(RestHandlerParameter.ACCESS_METHOD_TYPE.IN_OUT.getType())) {
                aCCESS_METHOD_TYPE = RestHandlerParameter.ACCESS_METHOD_TYPE.IN_OUT;
            } else if (string.equalsIgnoreCase(RestHandlerParameter.ACCESS_METHOD_TYPE.OUT.getType())) {
                aCCESS_METHOD_TYPE = RestHandlerParameter.ACCESS_METHOD_TYPE.OUT;
            }
        }
        restHandlerParameter.setAccessMethod(aCCESS_METHOD_TYPE);
        RestHandlerParameter.SOURCE_TYPE sOURCE_TYPE = RestHandlerParameter.SOURCE_TYPE.HTTP_HEADER;
        string = XMLHelper.getAttributeNode((Node)node, (String)"source");
        if (!RestUtils.emptyValue(string) && string.equalsIgnoreCase(RestHandlerParameter.SOURCE_TYPE.URI_TEMPLATE.getType())) {
            sOURCE_TYPE = aCCESS_METHOD_TYPE == RestHandlerParameter.ACCESS_METHOD_TYPE.OUT ? RestHandlerParameter.SOURCE_TYPE.RESPONSE : RestHandlerParameter.SOURCE_TYPE.URI_TEMPLATE;
        }
        restHandlerParameter.setSourceType(sOURCE_TYPE);
        RestHandlerParameter.DATA_TYPE dATA_TYPE = RestHandlerParameter.DATA_TYPE.STRING;
        string = XMLHelper.getAttributeNode((Node)node, (String)"type");
        if (!RestUtils.emptyValue(string)) {
            if (string.equalsIgnoreCase(RestHandlerParameter.DATA_TYPE.INTEGER.getType())) {
                dATA_TYPE = RestHandlerParameter.DATA_TYPE.INTEGER;
            } else if (string.equalsIgnoreCase(RestHandlerParameter.DATA_TYPE.BOOLEAN.getType())) {
                dATA_TYPE = RestHandlerParameter.DATA_TYPE.BOOLEAN;
            } else if (string.equalsIgnoreCase(RestHandlerParameter.DATA_TYPE.DOUBLE.getType())) {
                dATA_TYPE = RestHandlerParameter.DATA_TYPE.DOUBLE;
            } else if (string.equalsIgnoreCase(RestHandlerParameter.DATA_TYPE.TIMESTAMP.getType())) {
                dATA_TYPE = RestHandlerParameter.DATA_TYPE.TIMESTAMP;
            } else if (string.equalsIgnoreCase(RestHandlerParameter.DATA_TYPE.RESULTSET.getType())) {
                dATA_TYPE = RestHandlerParameter.DATA_TYPE.RESULTSET;
            }
        }
        restHandlerParameter.setDataType(dATA_TYPE);
    }

    private List<String> createList(String string) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray = string.split(",")) {
            arrayList.add(string2);
        }
        return arrayList;
    }
}

