/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest2.grid.contextmenu;

import java.awt.Component;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.controls.grid.AbstractRaptorGridModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.dbtools.rest.wizard.RestPublishWizard;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.javatools.db.DBException;

public class RestGrid
extends GridContextMenuItem {
    public static final int PUBLISH_TO_REST_ID = Ide.findOrCreateCmdID((String)"rest2.PUBLISH_REST");
    private static RestGrid _instance = null;
    private IdeAction _actionPublishRest;

    private RestGrid() {
        this.initAction();
    }

    public static RestGrid getInstance() {
        if (_instance == null) {
            _instance = new RestGrid();
        }
        return _instance;
    }

    private void initAction() {
        if (this._actionPublishRest == null) {
            this._actionPublishRest = this.createAction(PUBLISH_TO_REST_ID, RestArb.getString("REST_MENU_PUBLISH"), null);
        }
    }

    protected boolean canShow(ContextMenu contextMenu) {
        return true;
    }

    protected void createAndShowMenu(ContextMenu contextMenu) {
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)this._actionPublishRest);
        contextMenu.add((Component)jMenuItem);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == PUBLISH_TO_REST_ID) {
            if (this._table instanceof ResultSetTable) {
                String string = ((ResultSetTable)this._table).getGridModel().getConnectionName();
                String string2 = ((ResultSetTable)this._table).getGridModel().getSql();
                if (string != null && !RestUtils.nullOrEmpty(string2)) {
                    Map map = ((ResultSetTableModel)this._table.getGridModel()).getBindMap();
                    List list = ((ResultSetTableModel)this._table.getGridModel()).getBindList();
                    RestPublishWizard.getInstance().launchPublishToRest(string, string2, map, list);
                }
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        if (this._table != null) {
            String string;
            AbstractRaptorGridModel abstractRaptorGridModel = this._table.getGridModel();
            if (abstractRaptorGridModel != null && abstractRaptorGridModel instanceof ResultSetTableModel && (string = ((ResultSetTableModel)abstractRaptorGridModel).getConnectionName()) != null) {
                Connection connection = null;
                try {
                    connection = Connections.getInstance().getConnection(string, false);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (connection != null && Connections.getInstance().isOracle(string)) {
                    bl = true;
                }
            }
            if (!bl) {
                ideAction.setEnabled(false);
            } else {
                ideAction.setEnabled(true);
            }
        }
        return true;
    }
}

