/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.DataAccessObject;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.ConnectionProperties;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.utils.ConfigUtils;
import oracle.dmt.dataminer.core.utils.DebugTimer;
import oracle.jdbc.OracleCallableStatement;

public final class SqlDataAccessObject
implements DataAccessObject {
    private static final Logger LOGGER = Logger.getLogger(SqlDataAccessObject.class.getName());
    private ConnectionProperties[] _connectionProperties;
    private ConnectionManager _connectionManager;
    private PreparedStatement _stmt;
    private Connection _connection;
    private ResultSet _resultSet;

    public SqlDataAccessObject(ConnectionManager connectionManager) {
        assert (connectionManager != null) : "The connection manager cannot be null";
        this._connectionManager = connectionManager;
    }

    @Override
    public <T> List<T> readItems(Query<T> query) throws ODMrDAOException {
        List<T> list = this.executeQueryList(query, -1, -1);
        return list;
    }

    @Override
    public <T> List<T> readItems(Query<T> query, int n, int n2) throws ODMrDAOException {
        assert (n <= n2) : "Invalid Range";
        List<T> list = this.executeQueryList(query, n, n2);
        return list;
    }

    private <T> List<T> executeQueryList(Query<T> query, int n, int n2) throws ODMrDAOException {
        SqlQuery sqlQuery = (SqlQuery)query;
        List list = null;
        try {
            this._resultSet = (ResultSet)this.executeQuery(query, ExecuteOptions.QUERY, n, n2);
            list = ((SqlMapper)sqlQuery.getMapper()).mapAll(this._resultSet);
        }
        catch (Exception exception) {
            throw new ODMrDAOException(exception);
        }
        finally {
            this.close();
        }
        list = list != null ? list : Collections.emptyList();
        return list;
    }

    @Override
    public <T> Optional<T> readItem(Query<T> query) throws ODMrDAOException {
        T t = this.executeQueryObject(query);
        return Optional.ofNullable(t);
    }

    private <T> T executeQueryObject(Query<T> query) throws ODMrDAOException {
        SqlQuery sqlQuery = (SqlQuery)query;
        T t = null;
        try {
            this._resultSet = (ResultSet)this.executeQuery(query, ExecuteOptions.QUERY, -1, -1);
            t = ((SqlMapper)sqlQuery.getMapper()).mapOne(this._resultSet);
        }
        catch (Exception exception) {
            throw new ODMrDAOException(exception);
        }
        finally {
            this.close();
        }
        return t;
    }

    @Override
    public int insert(Query<Void> query) throws ODMrDAOException {
        return this.executeVoidQuery(query);
    }

    @Override
    public int update(Query<Void> query) throws ODMrDAOException {
        return this.executeVoidQuery(query);
    }

    @Override
    public int delete(Query<Void> query) throws ODMrDAOException {
        return this.executeVoidQuery(query);
    }

    private int executeVoidQuery(Query<Void> query) throws ODMrDAOException {
        int n = -1;
        try {
            n = (Integer)this.executeQuery(query, ExecuteOptions.UPDATE, -1, -1);
        }
        catch (SQLException sQLException) {
            throw new ODMrDAOException(sQLException);
        }
        finally {
            this.close();
        }
        return n;
    }

    private Object executeQuery(Query<?> query, ExecuteOptions executeOptions, int n, int n2) throws SQLException {
        SqlQuery sqlQuery = (SqlQuery)query;
        this._connection = this._connectionProperties == null ? this._connectionManager.getConnection() : this._connectionManager.getConnection(this._connectionProperties);
        String string = this.getSQL(sqlQuery, n, n2);
        this._stmt = this.isCallableStatement(sqlQuery) ? this._connection.prepareCall(string) : this._connection.prepareStatement(string);
        sqlQuery.setParameters(this._stmt);
        DebugTimer debugTimer = new DebugTimer().start();
        Object object = null;
        switch (executeOptions) {
            case UPDATE: {
                object = this._stmt.executeUpdate();
                break;
            }
            case QUERY: {
                object = this._stmt.executeQuery();
                break;
            }
            default: {
                assert (false) : "Option not supported";
                break;
            }
        }
        debugTimer.stop();
        if (ConfigUtils.isDebugBuild()) {
            Object[] objectArray = new Object[]{query.getClass().getName(), debugTimer.getElapsedTime()};
            LOGGER.log(Level.FINER, "{0} duration: {1}", objectArray);
        }
        return object;
    }

    private boolean isCallableStatement(Query<?> query) {
        Class<?> clazz = query.getClass();
        Type type = clazz.getGenericSuperclass();
        while (!(type instanceof ParameterizedType)) {
            clazz = clazz.getSuperclass();
            type = clazz.getGenericSuperclass();
        }
        Type[] typeArray = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments();
        if (typeArray[1] instanceof Class) {
            Class clazz2 = (Class)typeArray[1];
            boolean bl = clazz2.equals(OracleCallableStatement.class);
            return bl;
        }
        return false;
    }

    private String getSQL(SqlQuery sqlQuery, int n, int n2) {
        if (n2 < n || n < 0 || n2 < 1) {
            return sqlQuery.getSQLCommand();
        }
        String string = String.format("SELECT * \nFROM (SELECT A$STK.*, rownum rn FROM ( \n%s) A$STK \n) \nWHERE rn BETWEEN %d AND %d", sqlQuery.getSQLCommand(), n, n2);
        return string;
    }

    public void setConnectionProperties(ConnectionProperties ... connectionPropertiesArray) {
        this._connectionProperties = connectionPropertiesArray;
    }

    private final void close() {
        if (null != this._resultSet) {
            try {
                this._resultSet.close();
                this._resultSet = null;
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.FINEST, sQLException.getMessage(), sQLException);
            }
        }
        if (null != this._stmt) {
            try {
                this._stmt.close();
                this._stmt = null;
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.FINEST, sQLException.getMessage(), sQLException);
            }
        }
        if (null != this._connection) {
            try {
                this._connection.close();
                this._connection = null;
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.FINEST, sQLException.getMessage(), sQLException);
            }
        }
    }

    private static enum ExecuteOptions {
        QUERY,
        UPDATE;

    }
}

