/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.mapping.ar.ap;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.ISqlMapper;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.model.ar.Item;
import oracle.dmt.dataminer.core.model.ar.Rule;
import oracle.dmt.dataminer.core.model.ar.RuleAggregateData;
import oracle.dmt.dataminer.core.model.generated.server.DmPredicates;
import oracle.dmt.dataminer.core.utils.Patterns;
import oracle.dmt.dataminer.core.utils.Strings;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleResultSet;

public class GetRulesMapper
extends SqlMapper<Rule> {
    private static final String NAMES = "INAMES";
    private static final String SUBNAMES = "ISUBNAMES";
    private static final String VALUES = "IVALUES";
    private List<String> aggregates;
    private Integer transactionCount;
    private ISqlMapper<Rule> mapper;

    public GetRulesMapper(Version version, List<String> list, Integer n) {
        super(version);
        assert (!DbVersionHelper.isDB122Up(version) || DbVersionHelper.isDB122Up(version) && n != null) : "TransactionCount can't be null on 12.2 and above";
        this.aggregates = list != null ? list : Collections.emptyList();
        this.transactionCount = n;
        this.mapper = DbVersionHelper.isDB122Up(version) ? new Db12_2Mapper() : new OriginalMapper();
    }

    @Override
    public Rule map(ResultSet resultSet) throws Exception {
        Rule rule = this.mapper.map(resultSet);
        return rule;
    }

    private Rule mapCommon(ResultSet resultSet) throws SQLException {
        Rule rule = new Rule(resultSet.getInt("RULE_ID"));
        rule.setSupport(resultSet.getDouble("RULE_SUPPORT"));
        rule.setLift(resultSet.getDouble("RULE_LIFT"));
        rule.setConfidence(resultSet.getDouble("RULE_CONFIDENCE"));
        rule.setNumberOfItems(resultSet.getInt("NUMBER_OF_ITEMS"));
        rule.setConsequentSupport(resultSet.getDouble("CONSEQUENT_SUPPORT"));
        rule.setAntecedentSupport(resultSet.getDouble("ANTECEDENT_SUPPORT"));
        return rule;
    }

    private class Db12_2Mapper
    implements ISqlMapper<Rule> {
        private Db12_2Mapper() {
        }

        @Override
        public Rule map(ResultSet resultSet) throws Exception {
            Rule rule = GetRulesMapper.this.mapCommon(resultSet);
            rule.setReverseConfidence(resultSet.getDouble("RULE_REVCONFIDENCE"));
            Item item = new Item();
            item.setAttributeName(resultSet.getString("CONSEQUENT_NAME"));
            item.setAttributeSubname("");
            rule.setConsequent(item);
            List<Item> list = this.parseAntecedentItemset(resultSet, rule);
            rule.setAntecedent(list);
            HashMap<String, RuleAggregateData> hashMap = new HashMap<String, RuleAggregateData>();
            for (String string : GetRulesMapper.this.aggregates) {
                String string2 = "ANT_" + string;
                String string3 = "ANT_RULE_" + string;
                String string4 = "CON_" + string;
                String string5 = "CON_RULE_" + string;
                Double d = resultSet.getDouble(string3);
                Double d2 = resultSet.getDouble(string5);
                Double d3 = d + d2;
                Double d4 = resultSet.getDouble(string2);
                Double d5 = resultSet.getDouble(string4);
                Double d6 = d / ((double)GetRulesMapper.this.transactionCount.intValue() * rule.getSupport());
                Double d7 = d2 / ((double)GetRulesMapper.this.transactionCount.intValue() * rule.getSupport());
                Double d8 = d3 / ((double)GetRulesMapper.this.transactionCount.intValue() * rule.getSupport());
                RuleAggregateData ruleAggregateData = new RuleAggregateData();
                ruleAggregateData.setName(string);
                ruleAggregateData.setRule(d3);
                ruleAggregateData.setAntecedentRule(d);
                ruleAggregateData.setAntecedentItemset(d4);
                ruleAggregateData.setConsequentRule(d2);
                ruleAggregateData.setConsequentItemset(d5);
                ruleAggregateData.setAntecedentRuleAvg(d6);
                ruleAggregateData.setConsequentRuleAvg(d7);
                ruleAggregateData.setRuleAvg(d8);
                hashMap.put(string, ruleAggregateData);
                rule.addAggregateData(string, ruleAggregateData);
            }
            return rule;
        }

        private List<Item> parseAntecedentItemset(ResultSet resultSet, Rule rule) throws SQLException {
            int n = rule.getNumberOfItems() - 1;
            String string = resultSet.getString(GetRulesMapper.NAMES);
            String string2 = resultSet.getString(GetRulesMapper.SUBNAMES);
            String string3 = resultSet.getString(GetRulesMapper.VALUES);
            String[] stringArray = new String[GetRulesMapper.this.aggregates.size()];
            for (int i = 0; i < GetRulesMapper.this.aggregates.size(); ++i) {
                stringArray[i] = resultSet.getString("IASSO_AGG" + i + "S");
            }
            String[] stringArray2 = string != null ? string.split(Strings.SEPARATOR) : new String[n];
            String[] stringArray3 = string2 != null ? string2.split(Strings.SEPARATOR) : new String[n];
            String[] stringArray4 = string3 != null ? string3.split(Strings.SEPARATOR) : new String[n];
            String[][] stringArray5 = new String[GetRulesMapper.this.aggregates.size()][n];
            for (int i = 0; i < stringArray5.length; ++i) {
                stringArray5[i] = stringArray[i].split(Strings.SEPARATOR);
            }
            ArrayList<Item> arrayList = new ArrayList<Item>(n);
            for (int i = 0; i < n; ++i) {
                boolean bl;
                String string4 = stringArray2[i];
                String string5 = stringArray3[i];
                String string6 = stringArray4[i];
                Double d = null;
                boolean bl2 = bl = string6 != null && Patterns.DIGIT.matcher(string6).matches();
                if (bl) {
                    d = Double.parseDouble(string6);
                    string6 = null;
                }
                Item item = new Item(string4, string5, d, string6);
                for (int j = 0; j < GetRulesMapper.this.aggregates.size(); ++j) {
                    Double d2 = Double.parseDouble(stringArray5[j][i]);
                    Double d3 = d2 / ((double)GetRulesMapper.this.transactionCount.intValue() * rule.getSupport());
                    item.addAggregate((String)GetRulesMapper.this.aggregates.get(j), d2, d3);
                }
                arrayList.add(item);
            }
            return arrayList;
        }
    }

    private class OriginalMapper
    implements ISqlMapper<Rule> {
        private OriginalMapper() {
        }

        @Override
        public Rule map(ResultSet resultSet) throws Exception {
            OracleResultSet oracleResultSet = (OracleResultSet)resultSet;
            Rule rule = GetRulesMapper.this.mapCommon((ResultSet)oracleResultSet);
            DmPredicates dmPredicates = (DmPredicates)oracleResultSet.getORAData("CONSEQUENT", DmPredicates.getORADataFactory());
            List<Item> list = Item.createItemsFrom(dmPredicates);
            rule.setConsequent(list.get(0));
            DmPredicates dmPredicates2 = (DmPredicates)oracleResultSet.getORAData("ANTECEDENT", DmPredicates.getORADataFactory());
            List<Item> list2 = Item.createItemsFrom(dmPredicates2);
            rule.setAntecedent(list2);
            return rule;
        }
    }
}

