/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.mapping.clas.nb;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.model.common.build.AttributeBiCoefficient;

public class GetPropensitiesMapper
extends SqlMapper<AttributeBiCoefficient> {
    private static String PROPENSITY_TARGET_ONE = "propensity_target_one";
    private static String PROPENSITY_TARGET_TWO = "propensity_target_two";
    private static String ATTR_NAME_SUBNAME = "attribute_name_subname";
    private boolean binaryClassModel;

    public GetPropensitiesMapper(boolean bl) {
        this.binaryClassModel = bl;
    }

    @Override
    public AttributeBiCoefficient map(ResultSet resultSet) throws Exception {
        return this.mapRow(resultSet);
    }

    public AttributeBiCoefficient mapRow(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString(ATTR_NAME_SUBNAME);
        String string2 = resultSet.getString("ATTRIBUTE_VALUE");
        BigDecimal bigDecimal = resultSet.getBigDecimal(PROPENSITY_TARGET_ONE);
        BigDecimal bigDecimal2 = resultSet.getBigDecimal(PROPENSITY_TARGET_TWO);
        if (this.binaryClassModel) {
            if (bigDecimal == null && bigDecimal2 != null) {
                bigDecimal = new BigDecimal(-1.0 * bigDecimal2.doubleValue());
            } else if (bigDecimal2 == null && bigDecimal != null) {
                bigDecimal2 = new BigDecimal(-1.0 * bigDecimal.doubleValue());
            }
        }
        Double d = bigDecimal != null ? Double.valueOf(bigDecimal.doubleValue()) : null;
        Double d2 = bigDecimal2 != null ? Double.valueOf(bigDecimal2.doubleValue()) : null;
        AttributeBiCoefficient attributeBiCoefficient = new AttributeBiCoefficient(string, string2, d, d2);
        return attributeBiCoefficient;
    }
}

