/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.mapping.common;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.utils.StringUtils;

public class SqlDefaultMapper<T>
extends SqlMapper<T> {
    private Map<String, Method> _setterMap;
    private Class<T> _classToMap;
    private String[] _columns;

    public SqlDefaultMapper(Class<T> clazz) {
        assert (clazz != null) : "Class to Map Cannot be Null.";
        this._classToMap = clazz;
    }

    public SqlDefaultMapper(String[] stringArray, Class<T> clazz) {
        this(clazz);
        assert (stringArray != null && stringArray.length > 0) : "Column Definition is Required.";
        this._columns = stringArray;
    }

    private void initSetterMap() {
        this._setterMap = new HashMap<String, Method>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object[] objectArray = this._columns;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            String string = objectArray[i];
            hashMap.put(this.getSetterName(this.underscoreToCamelCase(string), false), string);
        }
        for (Object object : objectArray = this._classToMap.getMethods()) {
            if (hashMap.isEmpty()) break;
            if (!hashMap.containsKey(((Method)object).getName())) continue;
            this._setterMap.put((String)hashMap.get(((Method)object).getName()), (Method)object);
            hashMap.remove(((Method)object).getName());
        }
    }

    private String underscoreToCamelCase(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.toLowerCase());
        int n = stringBuilder.lastIndexOf("_");
        while (n != -1) {
            stringBuilder.replace(n, n + 2, stringBuilder.substring(n + 1, n + 2).toUpperCase());
            n = stringBuilder.lastIndexOf("_");
        }
        return stringBuilder.toString();
    }

    private String getSetterName(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (bl) {
            stringBuilder.replace(0, 2, stringBuilder.substring(1, 2).toUpperCase());
        } else {
            stringBuilder.replace(0, 1, stringBuilder.substring(0, 1).toUpperCase());
        }
        stringBuilder.insert(0, "set");
        return stringBuilder.toString();
    }

    @Override
    public T map(ResultSet resultSet) throws Exception {
        this.initColumnsIfNeeded(resultSet);
        T t = this._classToMap.newInstance();
        for (Map.Entry<String, Method> entry : this._setterMap.entrySet()) {
            String string = entry.getKey();
            Method method = entry.getValue();
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1) continue;
            Class<?> clazz = classArray[0];
            if (String.class.equals(clazz)) {
                method.invoke(t, resultSet.getString(string));
                continue;
            }
            if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
                method.invoke(t, resultSet.getInt(string));
                continue;
            }
            if (Double.TYPE.equals(clazz) || Double.class.equals(clazz)) {
                method.invoke(t, resultSet.getDouble(string));
                continue;
            }
            if (Character.TYPE.equals(clazz) || Character.class.equals(clazz)) {
                String string2 = resultSet.getString(string);
                if (!StringUtils.isNotEmpty(string2)) continue;
                method.invoke(t, Character.valueOf(string2.charAt(0)));
                continue;
            }
            if (BigDecimal.class.equals(clazz)) {
                method.invoke(t, resultSet.getBigDecimal(string));
                continue;
            }
            if (Boolean.TYPE.equals(clazz)) {
                method.invoke(t, resultSet.getBoolean(string));
                continue;
            }
            if (Clob.class.equals(clazz)) {
                method.invoke(t, resultSet.getClob(string));
                continue;
            }
            if (Date.class.equals(clazz) || java.util.Date.class.equals(clazz)) {
                method.invoke(t, resultSet.getDate(string));
                continue;
            }
            if (Long.TYPE.equals(clazz)) {
                method.invoke(t, resultSet.getLong(string));
                continue;
            }
            if (Short.TYPE.equals(clazz)) {
                method.invoke(t, resultSet.getShort(string));
                continue;
            }
            if (Float.TYPE.equals(clazz)) {
                method.invoke(t, Float.valueOf(resultSet.getFloat(string)));
                continue;
            }
            if (Byte.TYPE.equals(clazz)) {
                method.invoke(t, resultSet.getByte(string));
                continue;
            }
            if (Timestamp.class.equals(clazz)) {
                method.invoke(t, resultSet.getTimestamp(string));
                continue;
            }
            if (Time.class.equals(clazz)) {
                method.invoke(t, resultSet.getTime(string));
                continue;
            }
            if (!Blob.class.equals(clazz)) continue;
            method.invoke(t, resultSet.getBlob(string));
        }
        return t;
    }

    private void initColumnsIfNeeded(ResultSet resultSet) throws SQLException {
        if (this._columns == null) {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this._columns = new String[resultSetMetaData.getColumnCount()];
            int n = 0;
            while (n < this._columns.length) {
                this._columns[n++] = resultSetMetaData.getColumnLabel(n);
            }
            this.initSetterMap();
        }
    }
}

