/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.ar.ap;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.ar.ap.GetItemSetsMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.ar.ItemSet;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.filter.SortSpec;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetItemSetsQuery
extends SqlBaseModelQuery<ItemSet, OraclePreparedStatement> {
    private static final String MODEL = "MODEL";
    private static final String SUPPORT = "SUPPORT";
    private static final String FETCH_SIZE = "FETCH_SIZE";
    private int fetchSize;
    private Double minSupport;
    private Integer maxItemsetLength;
    private List<SortSpec> sorting;
    private List<SortSpec> sortingWithoutAggregates;
    private List<String> aggregates;
    private Integer aggregateSortIndex;
    private ISqlQuery<OraclePreparedStatement> queryGenerator;

    public GetItemSetsQuery(Version version, ModelDescriptor modelDescriptor, int n, List<String> list, List<SortSpec> list2, int n2) {
        super(version, null, modelDescriptor);
        assert (list2 != null && list2.size() > 0) : "Sorting can't be null";
        if (list == null) {
            list = Collections.emptyList();
        }
        this.aggregates = list;
        super.setMapper(new GetItemSetsMapper(version, list, n2));
        this.fetchSize = n;
        this.sorting = new ArrayList<SortSpec>(list2);
        this.initAggregateSort();
        this.queryGenerator = DbVersionHelper.isDB122Up(version) ? new DB12_2Query() : new DBOriginalQuery();
    }

    private void initAggregateSort() {
        this.sortingWithoutAggregates = new ArrayList<SortSpec>(this.sorting);
        if (this.sorting.size() > 0) {
            SortSpec sortSpec = this.sorting.get(0);
            for (int i = 0; i < this.aggregates.size(); ++i) {
                if (!sortSpec.getAttributeName().equals(this.aggregates.get(i))) continue;
                this.aggregateSortIndex = i;
                this.sortingWithoutAggregates.remove(0);
                break;
            }
        }
    }

    public GetItemSetsQuery setMinSupport(Double d) {
        this.minSupport = d;
        return this;
    }

    public GetItemSetsQuery setMaxItemSetLength(Integer n) {
        this.maxItemsetLength = n;
        return this;
    }

    @Override
    protected String getSQLCommand() {
        String string = this.queryGenerator.getSQLCommand();
        return string;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        SqlUtils.setDoubleAtName(oraclePreparedStatement, SUPPORT, this.minSupport);
        this.queryGenerator.setParameters(oraclePreparedStatement);
    }

    private class DB12_2Query
    implements ISqlQuery<OraclePreparedStatement> {
        private static final String BASE_12_2_QUERY = "WITH TOP_ITEMS AS\n (SELECT * FROM\n  ({$FILTER_SQL})\n   WHERE RNK <= {$FETCH}),\nSELECTED_ITEMS AS\n (SELECT TOP_ITEMS.RNK, ALL_ITEMS.*\n  FROM TOP_ITEMS, {$ITEMSET_VIEW} ALL_ITEMS\n  WHERE TOP_ITEMS.ITEMSET_ID = ALL_ITEMS.ITEMSET_ID\n  {$PARTITION_FILTER}),\nFULL_INFO AS\n (SELECT * \n  FROM SELECTED_ITEMS,  \n       XMLTABLE('/itemset/item' PASSING SELECTED_ITEMS.ITEMSET \n         COLUMNS\n{$AGGREGATE_COLS}          INAME    VARCHAR(128) PATH 'item_name',\n          ISUBNAME VARCHAR(128) PATH 'item_subname',\n          IVALUE   VARCHAR(128) PATH 'item_value') ITEMSETS),\nFINAL_RESULT AS\n (SELECT RNK, {$PARTITION_COL} ITEMSET_ID, SUPPORT, NUMBER_OF_ITEMS, \n{$AGGREGATES}         LISTAGG(INAME,    CHR(0)) WITHIN GROUP(ORDER BY ROWNUM) AS INAMES,\n         LISTAGG(ISUBNAME, CHR(0)) WITHIN GROUP(ORDER BY ROWNUM) AS ISUBNAMES,\n         LISTAGG(IVALUE  , CHR(0)) WITHIN GROUP(ORDER BY ROWNUM) AS IVALUES\n FROM FULL_INFO\n GROUP BY RNK, {$PARTITION_COL} ITEMSET_ID, SUPPORT, NUMBER_OF_ITEMS \n ORDER BY RNK)\nSELECT * FROM FINAL_RESULT";

        private DB12_2Query() {
        }

        @Override
        public String getSQLCommand() {
            String string = GetItemSetsQuery.this.isPartitioned() ? "AND PARTITION_NAME = :PARTITION_NAME" : "";
            String string2 = GetItemSetsQuery.this.isPartitioned() ? "PARTITION_NAME," : "";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("FETCH", Integer.toString(GetItemSetsQuery.this.fetchSize));
            hashMap.put("FILTER_SQL", this.getFilterSql());
            hashMap.put("AGGREGATE_COLS", this.getAggregatesColumnSql());
            hashMap.put("AGGREGATES", this.getAggregatesSql());
            hashMap.put("PARTITION_FILTER", string);
            hashMap.put("PARTITION_COL", string2);
            String string3 = StringUtils.getReplacedString(BASE_12_2_QUERY, hashMap);
            hashMap.clear();
            hashMap.put("ITEMSET_VIEW", GetItemSetsQuery.this.getViewName("DM$VI"));
            hashMap.put("SORT", SortSpec.getSortSql(GetItemSetsQuery.this.sortingWithoutAggregates));
            String string4 = StringUtils.getReplacedString(string3, hashMap);
            return string4;
        }

        private String getFilterSql() {
            String string = "";
            string = GetItemSetsQuery.this.aggregateSortIndex != null ? this.getFilterSortingAggregatesSql() : this.getFilterTableSql();
            return string;
        }

        private String getFilterTableSql() {
            SqlBuilder sqlBuilder = new SqlBuilder().select("ITEMSET_ID", "row_number() over (order by {$SORT}) rnk").from("{$ITEMSET_VIEW}").where(Conditional.equals("PARTITION_NAME", GetItemSetsQuery.this.getPartitionId()), Conditional.lessEquals("NUMBER_OF_ITEMS", GetItemSetsQuery.this.maxItemsetLength), Conditional.greaterEquals(GetItemSetsQuery.SUPPORT, GetItemSetsQuery.this.minSupport));
            return sqlBuilder.toString();
        }

        private String getFilterSortingAggregatesSql() {
            String string = (String)GetItemSetsQuery.this.aggregates.get(GetItemSetsQuery.this.aggregateSortIndex);
            String[] stringArray = new String[GetItemSetsQuery.this.sorting.size()];
            stringArray[0] = "ITEMSET_ID";
            for (int i = 1; i < stringArray.length; ++i) {
                stringArray[i] = ((SortSpec)GetItemSetsQuery.this.sorting.get(i)).getAttributeName();
            }
            String string2 = ((SortSpec)GetItemSetsQuery.this.sorting.get(0)).getSortDirection().getSqlKeyword();
            SqlBuilder sqlBuilder = new SqlBuilder().select("ITEMSET_ID", "SUM(" + string + ") agg").from("{$ITEMSET_VIEW}, \n     XMLTABLE('/itemset/item' PASSING ITEMSET \n       COLUMNS\n         " + string + " NUMBER PATH 'ASSO_AGG" + GetItemSetsQuery.this.aggregateSortIndex + "')").where(Conditional.equals("PARTITION_NAME", GetItemSetsQuery.this.getPartitionId()), Conditional.lessEquals("NUMBER_OF_ITEMS", GetItemSetsQuery.this.maxItemsetLength), Conditional.greaterEquals(GetItemSetsQuery.SUPPORT, GetItemSetsQuery.this.minSupport)).groupBy(stringArray).orderBy("agg " + string2 + ", {$SORT}");
            String string3 = "SELECT ITEMSET_ID, ROWNUM AS RNK \n  FROM \n(" + sqlBuilder.toString() + ")";
            return string3;
        }

        private String getAggregatesColumnSql() {
            int n = 0;
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : GetItemSetsQuery.this.aggregates) {
                stringBuilder.append("          I");
                stringBuilder.append(string.toUpperCase());
                stringBuilder.append(" VARCHAR(128) PATH '");
                stringBuilder.append("ASSO_AGG");
                stringBuilder.append(n++);
                stringBuilder.append("', \n");
            }
            return stringBuilder.toString();
        }

        private String getAggregatesSql() {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : GetItemSetsQuery.this.aggregates) {
                stringBuilder.append("         LISTAGG(I");
                stringBuilder.append(string.toUpperCase());
                stringBuilder.append(" , chr(0)) WITHIN GROUP(ORDER BY ROWNUM) AS I");
                stringBuilder.append(string);
                stringBuilder.append("S, \n");
            }
            return stringBuilder.toString();
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", GetItemSetsQuery.this.getPartitionId());
            SqlUtils.setIntAtName(oraclePreparedStatement, "NUMBER_OF_ITEMS", GetItemSetsQuery.this.maxItemsetLength);
        }
    }

    private class DBOriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private static final String BASE_QUERY = "SELECT * FROM \n({$SQL_QUERY}) \nWHERE ROWNUM <= {$FETCH_SIZE}";

        private DBOriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            SqlBuilder sqlBuilder = new SqlBuilder().select("ITEMSET_ID", "ITEMS", GetItemSetsQuery.SUPPORT, "NUMBER_OF_ITEMS").from("TABLE(DBMS_DATA_MINING.GET_FREQUENT_ITEMSETS( :MODEL, {$SUPPORT_FETCH}, :NUMBER_OF_ITEMS))").where(Conditional.greaterEquals(GetItemSetsQuery.SUPPORT, GetItemSetsQuery.this.minSupport)).orderBy(SortSpec.getSortSql(GetItemSetsQuery.this.sorting));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("SUPPORT_FETCH", this.getSupportFetch());
            String string = StringUtils.getReplacedString(sqlBuilder.toString(), hashMap);
            hashMap.put(GetItemSetsQuery.FETCH_SIZE, Integer.toString(GetItemSetsQuery.this.fetchSize));
            hashMap.put("SQL_QUERY", string);
            String string2 = StringUtils.getReplacedString(BASE_QUERY, hashMap);
            return string2;
        }

        private String getSupportFetch() {
            boolean bl;
            String string = "null";
            boolean bl2 = bl = GetItemSetsQuery.this.minSupport == null && GetItemSetsQuery.this.sorting.size() > 0 && GetItemSetsQuery.SUPPORT.equals(((SortSpec)GetItemSetsQuery.this.sorting.get(0)).getAttributeName());
            if (bl) {
                string = Integer.toString(GetItemSetsQuery.this.fetchSize);
            }
            return string;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            oraclePreparedStatement.setStringAtName(GetItemSetsQuery.MODEL, GetItemSetsQuery.this.getQualifiedName());
            SqlUtils.setIntOrNullAtName(oraclePreparedStatement, "NUMBER_OF_ITEMS", GetItemSetsQuery.this.maxItemsetLength);
        }
    }
}

