/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.cd;

import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ExtractQuery;
import oracle.dmt.dataminer.core.model.common.xmlschema.OutputAttributeType;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersions;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.FilterDetailType;
import oracle.javatools.util.Version;

public abstract class ColumnDetailsQuery
extends ExtractQuery {
    private List<AttributeType> _columns;
    private String _tableName;

    public ColumnDetailsQuery(FilterDetailType filterDetailType, List<AttributeType> list, String string, Version version) {
        super(version == null ? DbVersions.V12_2_0_0.get() : version);
        assert (list != null);
        assert (string != null);
        assert (filterDetailType != null && (FilterDetailType.ATTRIBUTE_DEPENDENCIES.equals((Object)filterDetailType) || FilterDetailType.ATTRIBUTE_IMPORTANCE.equals((Object)filterDetailType))) : "Invalid Output Type value.";
        this.outputType = filterDetailType;
        this._columns = list;
        this._tableName = string;
        this.initializeColumns();
    }

    @Override
    public String getSQLCommand() {
        StringBuilder stringBuilder = new StringBuilder();
        List<OutputAttributeType> list = this.getOutputColumnList();
        if (!this.validateOutputColumns(list, this._columns)) {
            throw new IllegalStateException("Output columns specified for filter details extract do not match the query specifications.");
        }
        stringBuilder.append(this.getSQLTemplate());
        stringBuilder = new StringBuilder(this.addColumnAlias(stringBuilder.toString(), list));
        stringBuilder = new StringBuilder(StringUtils.getReplacedString(stringBuilder.toString(), StringUtils.formatReplacement("TABLE_NAME"), this._tableName));
        return stringBuilder.toString();
    }
}

