/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.cf;

import java.sql.SQLException;
import java.util.HashMap;
import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlIntegerMapper;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetDependencyCountQuery
extends SqlQuery<Integer, OraclePreparedStatement> {
    private String table;
    private String attribute;

    public GetDependencyCountQuery(Version version, String string, String string2) {
        super(version, new SqlIntegerMapper());
        this.table = string;
        this.attribute = string2;
        assert (DbVersionHelper.isDB122Up(version)) : "DB not supported";
    }

    @Override
    protected String getSQLCommand() {
        String string = "";
        String string2 = " SELECT COUNT(*) FROM {$TABLE} WHERE LAYER = 2 AND DEPENDENCY_VALUE > 0 {$FILTER_BY_ATTRIBUTE_NAME}";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TABLE", this.table);
        if (this.attribute != null) {
            string = "AND (ATTRIBUTE_NAME_1 = :attribute_name OR ATTRIBUTE_NAME_2 = :attribute_name)";
        }
        hashMap.put("FILTER_BY_ATTRIBUTE_NAME", string);
        String string3 = StringUtils.getReplacedString(string2, hashMap);
        return string3;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        if (this.attribute != null) {
            SqlUtils.setStringAtName(oraclePreparedStatement, "attribute_name", this.attribute);
        }
    }
}

