/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.cf;

import java.sql.SQLException;
import java.util.HashMap;
import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.dal.sql.mapping.cf.GetDependencyMapper;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.cf.AttributeDependency;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetDependencyQuery
extends SqlQuery<AttributeDependency, OraclePreparedStatement> {
    private int rows;
    private String table;
    private String attribute;
    private SortDirection order;

    public GetDependencyQuery(Version version, String string, String string2, int n, SortDirection sortDirection, boolean bl) {
        super(version, new GetDependencyMapper(string2, bl));
        this.table = string;
        this.attribute = string2;
        this.rows = n;
        this.order = sortDirection;
        assert (DbVersionHelper.isDB122Up(version)) : "DB not supported";
    }

    @Override
    protected String getSQLCommand() {
        String string = "";
        String string2 = "SELECT * FROM (\n               SELECT ATTRIBUTE_NAME_1,\n                      ATTRIBUTE_NAME_2, \n                      DEPENDENCY_VALUE \n               FROM {$TABLE}\n               WHERE LAYER = 2 \n               AND DEPENDENCY_VALUE > 0 \n               {$FILTER_BY_ATTRIBUTE_NAME}               ORDER BY DEPENDENCY_VALUE {$ORDER} \n               ) \nWHERE ROWNUM <= {$ROW_NUM} \n";
        if (this.attribute != null) {
            string = "               AND (ATTRIBUTE_NAME_1 = :attribute_name \n                    OR ATTRIBUTE_NAME_2 = :attribute_name)\n";
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TABLE", this.table);
        hashMap.put("ORDER", this.order.getSqlKeyword());
        hashMap.put("ROW_NUM", Integer.toString(this.rows));
        hashMap.put("FILTER_BY_ATTRIBUTE_NAME", string);
        String string3 = StringUtils.getReplacedString(string2, hashMap);
        return string3;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        if (this.attribute != null) {
            SqlUtils.setStringAtName(oraclePreparedStatement, "attribute_name", this.attribute);
        }
    }
}

