/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clas.common;

import java.sql.SQLException;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.clas.common.GetScoringCostMatrixMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.clas.common.CostMatrixInfo;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetScoringCostMatrixQuery
extends SqlBaseModelQuery<CostMatrixInfo, OraclePreparedStatement> {
    private ISqlQuery<OraclePreparedStatement> query;

    public GetScoringCostMatrixQuery(Version version, ModelDescriptor modelDescriptor) {
        super(version, new GetScoringCostMatrixMapper(), modelDescriptor);
        this.query = DbVersionHelper.isDB122Up(this.dbVersion) ? new Db122Query() : new OriginalQuery();
    }

    @Override
    public String getSQLCommand() {
        return this.query.getSQLCommand();
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        this.query.setParameters(oraclePreparedStatement);
    }

    private class Db122Query
    implements ISqlQuery<OraclePreparedStatement> {
        private Db122Query() {
        }

        @Override
        public String getSQLCommand() {
            SqlBuilder sqlBuilder = new SqlBuilder().select("ACTUAL_TARGET_VALUE", "PREDICTED_TARGET_VALUE", "COST").from(GetScoringCostMatrixQuery.this.getViewName("DM$VC")).where(Conditional.equals("PARTITION_NAME", GetScoringCostMatrixQuery.this.getPartitionId()));
            String string = sqlBuilder.toString();
            return string;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", GetScoringCostMatrixQuery.this.getPartitionId());
        }
    }

    private class OriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private OriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            SqlBuilder sqlBuilder = new SqlBuilder().select("ACTUAL", "PREDICTED", "COST").from("TABLE(DBMS_DATA_MINING.GET_MODEL_COST_MATRIX(:model))");
            String string = sqlBuilder.toString();
            return string;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            oraclePreparedStatement.setStringAtName("model", GetScoringCostMatrixQuery.this.getQualifiedName());
        }
    }
}

