/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clas.glm;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.filter.SortSpec;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public abstract class GetPropensitiesQuery<T, V extends OraclePreparedStatement>
extends SqlBaseModelQuery<T, V> {
    private Integer fetchSize;
    private boolean sortByAbsolute;
    private Object targetValue1;
    private Object targetValue2;
    private List<SortSpec> sorting;

    public GetPropensitiesQuery(Version version, SqlMapper<T> sqlMapper, ModelDescriptor modelDescriptor, Object object, Object object2, boolean bl, List<SortSpec> list, Integer n) {
        super(version, sqlMapper, modelDescriptor);
        assert (object != null && object2 != null) : "Targets can not be null";
        this.targetValue1 = object;
        this.targetValue2 = object2;
        this.fetchSize = n;
        this.sortByAbsolute = bl;
        this.sorting = list == null ? Collections.emptyList() : list;
    }

    @Override
    public String getSQLCommand() {
        String string = "select {$COLUMNS} from (\n  select * from (\n    select TARGET, {$FEATURE_EXP}\n         nvl2( ATTRIBUTE_SUBNAME, ATTRIBUTE_NAME || '.' || ATTRIBUTE_SUBNAME, ATTRIBUTE_NAME) ATTRIBUTE_NAME_SUBNAME, \n         ATTRIBUTE_NAME, ATTRIBUTE_VALUE, \n         case when (C1 is not null) AND (C2 is not null) AND (C1 > C2) then C1 \n              when (C2 is null) then C1 \n             else null \n         end PROPENSITY_TARGET_ONE,\n         case when (C2 is not null) and (C1 is not null) AND (C2 > C1) then C2 \n              when (C1 is null) then C2 \n              else null \n         end PROPENSITY_TARGET_TWO, \n         ({$ABSOLUTE_VALUE}(nvl(C1,0)) + {$ABSOLUTE_VALUE}(nvl(c2,0)) ) PROPENSITY_TARGET \n    from \n      (select T.{$TARGET} TARGET_ATTRIBUTE_VALUE, T.{$TARGET} TARGET, \n              T.ATTRIBUTE_NAME, T.ATTRIBUTE_SUBNAME, T.ATTRIBUTE_VALUE ATTRIBUTE_VALUE, \n              T.STD_COEFFICIENT COEFFICIENT {$FEATURE_EXP_2}\n      from {$TABLE} t \n      {$PARTITION})\n      pivot(max(\"COEFFICIENT\") for TARGET_ATTRIBUTE_VALUE in ({$TARGET_VALUE_1} C1, {$TARGET_VALUE_2} C2 ) ) \n      where C1 is not null or C2 is not null) \n {$ORDER_BY} \n){$FETCH_SIZE}";
        boolean bl = this.targetValue1 instanceof Number;
        String string2 = this.fetchSize != null ? "where rownum <= " + this.fetchSize : "";
        String string3 = this.sortByAbsolute ? "  ABS" : "";
        String string4 = bl ? this.targetValue1.toString() : "'" + StringUtils.escapeSingleQuotesForSQL(this.targetValue1.toString()) + "'";
        String string5 = bl ? this.targetValue2.toString() : "'" + StringUtils.escapeSingleQuotesForSQL(this.targetValue2.toString()) + "'";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("FETCH_SIZE", string2);
        hashMap.put("ABSOLUTE_VALUE", string3);
        hashMap.put("TARGET_VALUE_1", string4);
        hashMap.put("TARGET_VALUE_2", string5);
        hashMap.put("ORDER_BY", this.getSqlOrderBy());
        String string6 = StringUtils.getReplacedString(string, hashMap);
        String string7 = DbVersionHelper.isDB122Up(this.dbVersion) ? this.getSqlCommand122Up(string6) : this.getSqlCommandOriginal(string6);
        return string7;
    }

    private String getSqlCommandOriginal(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TABLE", "TABLE(dbms_data_mining.get_model_details_glm(:model))");
        hashMap.put("PARTITION", "");
        hashMap.put("TARGET", "CLASS");
        hashMap.put("FEATURE_EXP", "");
        hashMap.put("FEATURE_EXP_2", "");
        String string2 = StringUtils.getReplacedString(string, hashMap);
        return string2;
    }

    private String getSqlCommand122Up(String string) {
        String string2 = this.getViewName("DM$VD");
        String string3 = this.isPartitioned() ? " where PARTITION_NAME = :pname " : " where PARTITION_NAME IS NULL ";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TABLE", string2);
        hashMap.put("PARTITION", string3);
        hashMap.put("TARGET", "TARGET_VALUE");
        hashMap.put("FEATURE_EXP", "feature_expression, ");
        hashMap.put("FEATURE_EXP_2", ", T.feature_expression");
        String string4 = StringUtils.getReplacedString(string, hashMap);
        return string4;
    }

    private String getSqlOrderBy() {
        StringBuilder stringBuilder = new StringBuilder();
        List<SortSpec> list = SortSpec.getEnabledSortSpec(this.sorting);
        if (list.size() > 0) {
            stringBuilder.append("order by ");
            Iterator<SortSpec> iterator = list.iterator();
            while (iterator.hasNext()) {
                SortSpec sortSpec = iterator.next();
                if ("COEFFICIENT".equals(sortSpec.getAttributeName())) {
                    if (this.sortByAbsolute) {
                        stringBuilder.append("ABS(");
                        stringBuilder.append(sortSpec.getAttributeName());
                        stringBuilder.append(")");
                    } else {
                        stringBuilder.append(sortSpec.getAttributeName());
                    }
                } else {
                    stringBuilder.append(sortSpec.getAttributeName());
                }
                if (sortSpec.isAscending()) {
                    stringBuilder.append(" ASC ");
                } else {
                    stringBuilder.append(" DESC NULLS LAST ");
                }
                if (!iterator.hasNext()) continue;
                stringBuilder.append(",");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            SqlUtils.setStringAtName(oraclePreparedStatement, "pname", this.getPartitionId());
        } else {
            oraclePreparedStatement.setStringAtName("model", this.getQualifiedName());
        }
    }
}

