/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.ds;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlDefaultMapper;
import oracle.dmt.dataminer.core.model.ds.Table;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetAccessableTablesQuery
extends SqlQuery<Table, OraclePreparedStatement> {
    private boolean tablesOnly;
    private Set<String> schemas;
    private Set<String> synonymSchemas;

    public GetAccessableTablesQuery(Version version, Set<String> set) {
        super(version, new SqlDefaultMapper<Table>(Table.class));
        assert (set != null && set.size() > 0) : "Select at least one schema";
        this.schemas = set;
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(set);
        treeSet.add("PUBLIC");
        this.synonymSchemas = treeSet;
    }

    public GetAccessableTablesQuery setTablesOnly(boolean bl) {
        this.tablesOnly = bl;
        return this;
    }

    @Override
    public String getSQLCommand() {
        String string = "with \nTABLES_VIEWS as \n(select OWNER AS SCHEMA, TABLE_NAME AS NAME, TYPE \n from \n  (select OWNER, TABLE_NAME, '{$TABLE_STR}' as TYPE \n   from ALL_TABLES where {$LIST_OF_SCHEMAS} AND \n      {$EXCLUDE_TABLES}{$VIEWS_AND_SYNONYMS_SQL}\n) \nselect * from \n ({$SYNONYM_TABLE}  select SCHEMA, NAME, TYPE, NULL AS SYNONYM_SCHEMA, NULL AS SYNONYM_NAME\n  from TABLES_VIEWS) \norder by SCHEMA, NAME";
        String string2 = this.tablesOnly ? ")" : "\n   union all \n   select OWNER, VIEW_NAME as TABLE_NAME, '{$VIEW_STR}' as TYPE \n   from ALL_VIEWS where {$LIST_OF_SCHEMAS} AND \n      {$EXCLUDE_VIEWS} \n)\n), \nLIST_SYNONYMS as \n (select OWNER, SYNONYM_NAME AS NAME, TABLE_OWNER as SYNONYM_SCHEMA, TABLE_NAME as SYNONYM_NAME \n  from ALL_SYNONYMS where {$LIST_OF_SYNONYM_SCHEMAS} \n  ), \nSYNONYMS as \n (select S.OWNER AS SCHEMA, S.NAME, '{$SYNONYM_STR}' as TYPE, SYNONYM_SCHEMA, SYNONYM_NAME \n  from LIST_SYNONYMS S inner join ALL_OBJECTS A \n  on S.SYNONYM_NAME = A.OBJECT_NAME AND S.SYNONYM_SCHEMA = A.OWNER  where OBJECT_TYPE = 'TABLE' or OBJECT_TYPE = 'VIEW' ";
        String string3 = this.tablesOnly ? "" : "select SCHEMA, NAME, TYPE, SYNONYM_SCHEMA, SYNONYM_NAME \nfrom SYNONYMS \n  union all \n  ";
        String string4 = Conditional.in("OWNER", this.schemas);
        String string5 = Conditional.in("OWNER", "SYNONYM_OWNER", this.synonymSchemas);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("VIEWS_AND_SYNONYMS_SQL", string2);
        String string6 = StringUtils.getReplacedString(string, hashMap);
        hashMap.clear();
        hashMap.put("TABLE_STR", CoreCommonLrb.get("TABLE_UP"));
        hashMap.put("VIEW_STR", CoreCommonLrb.get("VIEW_UP"));
        hashMap.put("SYNONYM_STR", CoreCommonLrb.get("SYNONYM_UP"));
        hashMap.put("EXCLUDE_TABLES", "TABLE_NAME NOT LIKE 'BIN$%'AND TABLE_NAME NOT LIKE 'DM$%'AND TABLE_NAME NOT LIKE 'DM4J$%'AND TABLE_NAME NOT LIKE 'DR$%'AND TABLE_NAME NOT LIKE 'DM$%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'Z__@___@___@___%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMNUM@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'EUL_GW_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'SYS_IOT_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMCAT@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMR$%' ESCAPE '@'  AND TABLE_NAME NOT LIKE 'DM$%' ESCAPE '@' ");
        hashMap.put("EXCLUDE_VIEWS", "VIEW_NAME NOT LIKE 'DM$%'  ESCAPE '@' AND VIEW_NAME NOT LIKE 'DR$%'  ESCAPE '@' AND VIEW_NAME NOT LIKE 'ODMR$%' ESCAPE '@'  AND VIEW_NAME NOT LIKE 'DM4J$%'  ESCAPE '@' ");
        hashMap.put("LIST_OF_SCHEMAS", string4);
        hashMap.put("LIST_OF_SYNONYM_SCHEMAS", string5);
        hashMap.put("SYNONYM_TABLE", string3);
        string6 = StringUtils.getReplacedString(string6, hashMap);
        return string6;
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        String string;
        int n = 0;
        for (String string2 : this.schemas) {
            string = StringUtils.escapeSingleQuotesForSQL(string2);
            oraclePreparedStatement.setStringAtName("OWNER".concat(Integer.toString(n)), string);
            ++n;
        }
        if (!this.tablesOnly) {
            n = 0;
            for (String string2 : this.synonymSchemas) {
                string = StringUtils.escapeSingleQuotesForSQL(string2);
                oraclePreparedStatement.setStringAtName("SYNONYM_OWNER".concat(Integer.toString(n)), string);
                ++n;
            }
        }
        oraclePreparedStatement.setFetchSize(1000);
    }
}

