/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.fe.common;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.SortOrder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlDefaultMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.fe.common.AbstractFeatureCoefficientsQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ColumnFilter;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.fe.common.FeatureItemSet;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitSemanticAnalysisModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PCAModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SVDModelType;
import oracle.javatools.util.Version;
import oracle.jdbc.internal.OraclePreparedStatement;

public final class FeatureItemsQuery
extends AbstractFeatureCoefficientsQuery<FeatureItemSet, OraclePreparedStatement> {
    private static final String[] COLUMNS = new String[]{"PARTITION_NAME", "FEATURE_ID", "ITEMS"};
    private static final String FEATURE_FILTER_SQL = "WITH\nV$ALL AS (\n    {$FID_SOURCE}    {$PREPARTITION}\n    {$FILTER}\n    {$PREORDERING}\n),\nV$FIDS AS (\n  SELECT FEATURE_ID\n  FROM V$ALL\n      WHERE ROWNUM <= {$FETCH_SIZE}\n),\nV$COEFFICIENTS AS (\n  SELECT PARTITION_NAME, FEATURE_ID, ATTRIBUTE_NAME, TAG, COEFFICIENT\n  FROM (\n    SELECT PARTITION_NAME, FEATURE_ID, ATTRIBUTE_NAME, TAG, COEFFICIENT, RANK() OVER (PARTITION BY FEATURE_ID ORDER BY COEFFICIENT DESC, TAG, ROWNUM DESC) RANK\n    FROM (\n       SELECT * FROM (\n           SELECT PARTITION_NAME, {$FEATURE_COLUMN} FEATURE_ID, ATTRIBUTE_NAME,\n              (CASE WHEN ATTRIBUTE_SUBNAME IS NULL\n               THEN ATTRIBUTE_VALUE\n               ELSE\n                  CASE WHEN INSTR(ATTRIBUTE_SUBNAME, CHR(32)) > 0\n                  THEN\n                     '''' || ATTRIBUTE_SUBNAME ||  ''''\n                  ELSE\n                     ATTRIBUTE_SUBNAME\n                  END\n               END) TAG, {$COEFFICIENT_COLUMN} COEFFICIENT\n           FROM (\n                {$COEFFICIENT_SOURCE}\n           )\n       )\n       WHERE {$POSTPARTITION}\n          TAG IS NOT NULL AND FEATURE_ID IN (SELECT FEATURE_ID FROM V$FIDS)\n    )\n  ) WHERE RANK <= {$ITEMS_PER_FEATURE}\n)\nSELECT PARTITION_NAME, FEATURE_ID, DBMS_XMLGEN.CONVERT(XMLAGG(XMLELEMENT(E, TAG||' ') ORDER BY COEFFICIENT DESC).EXTRACT('//text()').GETCLOBVAL(), 1) ITEMS\nFROM V$COEFFICIENTS\nGROUP BY PARTITION_NAME, FEATURE_ID\n        {$POSTORDERING}";
    private static final String ATTRIBUTE_FILTER_SQL = "WITH\nV$COEFFICIENTS AS (\n  SELECT PARTITION_NAME, FEATURE_ID, ATTRIBUTE_NAME, TAG, COEFFICIENT\n  FROM (\n    SELECT PARTITION_NAME, FEATURE_ID, ATTRIBUTE_NAME, TAG, COEFFICIENT, RANK() OVER (PARTITION BY FEATURE_ID ORDER BY COEFFICIENT DESC, TAG, ROWNUM DESC) RANK\n    FROM (\n       SELECT * FROM (\n           SELECT PARTITION_NAME, {$FEATURE_COLUMN} FEATURE_ID, ATTRIBUTE_NAME,\n              (CASE WHEN ATTRIBUTE_SUBNAME IS NULL\n               THEN ATTRIBUTE_VALUE\n               ELSE\n                  CASE WHEN INSTR(ATTRIBUTE_SUBNAME, CHR(32)) > 0\n                  THEN\n                         '''' || ATTRIBUTE_SUBNAME ||  ''''\n                  ELSE\n                    ATTRIBUTE_SUBNAME\n                  END\n               END) TAG, {$COEFFICIENT_COLUMN} COEFFICIENT\n           FROM (\n               {$COEFFICIENT_SOURCE}\n           )\n       )\n       WHERE {$POSTPARTITION}\n          TAG IS NOT NULL\n          {$FILTER}\n    )\n  ) WHERE RANK <= {$ITEMS_PER_FEATURE}\n)\nSELECT * FROM (\n    SELECT PARTITION_NAME, FEATURE_ID, DBMS_XMLGEN.CONVERT(XMLAGG(XMLELEMENT(E, TAG||' ') ORDER BY COEFFICIENT DESC).EXTRACT('//text()').GETCLOBVAL(), 1) ITEMS\n    FROM V$COEFFICIENTS\n    GROUP BY PARTITION_NAME, FEATURE_ID\n        {$POSTORDERING}\n)\nWHERE ROWNUM <= {$FETCH_SIZE}\n";
    private static final String MULTIPLE_ATTRIBUTE_FILTER_SQL = "WITH NN$TAGS AS (\n  SELECT * \n    FROM (\n      SELECT PARTITION_NAME, {$FEATURE_COLUMN} FEATURE_ID, ATTRIBUTE_NAME,\n        (CASE WHEN ATTRIBUTE_SUBNAME IS NULL\n          THEN ATTRIBUTE_VALUE\n          ELSE\n            CASE WHEN INSTR(ATTRIBUTE_SUBNAME, CHR(32)) > 0\n              THEN\n                '''' || ATTRIBUTE_SUBNAME ||  ''''\n              ELSE\n                ATTRIBUTE_SUBNAME\n            END\n        END) TAG, {$COEFFICIENT_COLUMN} COEFFICIENT\n      FROM (\n        {$COEFFICIENT_SOURCE}\n      )\n    )\n  WHERE \n  TAG IS NOT NULL\n  {$AND_PARTITION}\n),\nFLT$FIDS AS (\n  SELECT FEATURE_ID\n    FROM NN$TAGS\n    WHERE\n    {$FILTER}\n    GROUP BY FEATURE_ID\n    {$DIFFERENT_ATTRIBUTES}\n),\nV$COEFFICIENTS AS (\n  SELECT PARTITION_NAME, FEATURE_ID, ATTRIBUTE_NAME, TAG, COEFFICIENT\n  FROM (\n    SELECT PARTITION_NAME, FEATURE_ID, ATTRIBUTE_NAME, TAG, COEFFICIENT, RANK() OVER (PARTITION BY FEATURE_ID ORDER BY COEFFICIENT DESC, TAG, ROWNUM DESC) RANK\n      FROM (\n        SELECT *\n          FROM NN$TAGS\n          WHERE FEATURE_ID IN (\n                SELECT FEATURE_ID \n                FROM (\n                  SELECT FEATURE_ID \n                  FROM FLT$FIDS\n                  {$PREORDERING}\n                )\n                WHERE ROWNUM <= {$FETCH_SIZE}\n              )\n            AND (\n                {$FILTER}\n            )\n      )\n  )\n  WHERE RANK <= {$ITEMS_PER_FEATURE}\n)\nSELECT PARTITION_NAME, FEATURE_ID, DBMS_XMLGEN.CONVERT(XMLAGG(XMLELEMENT(E, TAG||' ') ORDER BY COEFFICIENT DESC).EXTRACT('//text()').GETCLOBVAL(), 1) ITEMS\n  FROM V$COEFFICIENTS\n  GROUP BY PARTITION_NAME, FEATURE_ID\n  {$POSTORDERING}";
    private Integer itemSetSize;
    private SortOrder sortOrder;
    private AbstractFeatureCoefficientsQuery.Filtering filteringType = AbstractFeatureCoefficientsQuery.Filtering.NONE;
    private String attributeFilterConditional = "";
    private String featureIdsFilterConditional = "";

    public FeatureItemsQuery(Version version, Class<? extends ModelType> clazz, ModelDescriptor modelDescriptor) {
        super(version, new SqlDefaultMapper<FeatureItemSet>(COLUMNS, FeatureItemSet.class), clazz, modelDescriptor);
        this.sortOrder = SortOrder.UNSORTED;
        this.matchingType = ColumnFilter.Match.NONE;
        this.attributeFilters = new ArrayList();
    }

    @Override
    protected String getSQLCommand() {
        assert (ExplicitSemanticAnalysisModelType.class.equals((Object)this.modelType) || PCAModelType.class.equals((Object)this.modelType) || SVDModelType.class.equals((Object)this.modelType) || NonNegativeMatrixFactorModelType.class.equals((Object)this.modelType)) : "Invalid Model Type";
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "ORDER BY PARTITION_NAME";
        String string6 = "PARTITION_NAME = :PARTITION_NAME";
        if (SortOrder.DESCENDING.equals((Object)this.sortOrder)) {
            string = "ORDER BY FEATURE_ID DESC";
            string5 = string5 + ", FEATURE_ID DESC";
        }
        String string7 = this.getFilterCondition();
        if (this.isPartitioned()) {
            string2 = " AND " + string6;
            string3 = "WHERE " + string6;
            string4 = string6 + " AND ";
            if (AbstractFeatureCoefficientsQuery.Filtering.BY_FEATURE.equals((Object)this.filteringType) || AbstractFeatureCoefficientsQuery.Filtering.BY_SINGLE_ATTRIBUTE.equals((Object)this.filteringType)) {
                string7 = "AND " + string7;
            }
        } else if (AbstractFeatureCoefficientsQuery.Filtering.BY_FEATURE.equals((Object)this.filteringType)) {
            string7 = "WHERE " + string7;
        } else if (AbstractFeatureCoefficientsQuery.Filtering.BY_SINGLE_ATTRIBUTE.equals((Object)this.filteringType)) {
            string7 = "AND " + string7;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("FID_SOURCE", this.getFeatureIdSource());
        hashMap.put("COEFFICIENT_SOURCE", this.getCoefficientsSource());
        String string8 = null;
        switch (this.filteringType) {
            case BY_MULTIPLE_ATTRIBUTE: {
                string8 = MULTIPLE_ATTRIBUTE_FILTER_SQL;
                hashMap.put("AND_PARTITION", string2);
                hashMap.put("DIFFERENT_ATTRIBUTES", ColumnFilter.Match.ALL.equals((Object)this.matchingType) ? String.format("HAVING COUNT(DISTINCT ATTRIBUTE_NAME) = %d", this.distinctAttributeCount) : "");
                break;
            }
            case BY_SINGLE_ATTRIBUTE: {
                string8 = ATTRIBUTE_FILTER_SQL;
                break;
            }
            default: {
                string8 = FEATURE_FILTER_SQL;
            }
        }
        String string9 = StringUtils.getReplacedString(string8, hashMap);
        hashMap.clear();
        hashMap.put("SCHEMA", this.getSchema());
        hashMap.put("MODEL_NAME", this.getModelName());
        hashMap.put("FILTER", string7);
        hashMap.put("PREORDERING", string);
        hashMap.put("PREPARTITION", string3);
        hashMap.put("POSTORDERING", string5);
        hashMap.put("POSTPARTITION", string4);
        hashMap.put("FETCH_SIZE", this.fetchSize.toString());
        hashMap.put("FEATURE_COLUMN", this.featureColumn);
        hashMap.put("ITEMS_PER_FEATURE", this.itemSetSize.toString());
        hashMap.put("COEFFICIENT_COLUMN", this.getCoefficientColumn());
        string9 = StringUtils.getReplacedString(string9, hashMap);
        return string9;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        SqlUtils.setStringAtName((oracle.jdbc.OraclePreparedStatement)oraclePreparedStatement, "PARTITION_NAME", this.getPartitionId());
    }

    private String getFilterCondition() {
        if (ColumnFilter.Match.NONE.equals((Object)this.matchingType) || this.attributeFilters.isEmpty()) {
            this.filteringType = AbstractFeatureCoefficientsQuery.Filtering.NONE;
            return "";
        }
        this.featureIdsFilterConditional = this.getFeatureFilterCondition();
        this.attributeFilterConditional = this.getAttributeFilterCondition("TAG");
        boolean bl = StringUtils.isNotEmpty(this.featureIdsFilterConditional);
        boolean bl2 = StringUtils.isNotEmpty(this.attributeFilterConditional);
        if (bl && bl2) {
            String string = Arrays.stream(new String[]{this.featureIdsFilterConditional, this.attributeFilterConditional}).filter(StringUtils::isNotEmpty).collect(Collectors.joining(ColumnFilter.Match.ALL.equals((Object)this.matchingType) ? " AND " : " OR "));
            this.filteringType = this.distinctAttributeCount == 1L ? AbstractFeatureCoefficientsQuery.Filtering.BY_SINGLE_ATTRIBUTE : AbstractFeatureCoefficientsQuery.Filtering.BY_MULTIPLE_ATTRIBUTE;
            string = StringUtils.getReplacedString(string, "{$FEATURE_ID}", "FEATURE_ID");
            return StringUtils.addParentheses(string);
        }
        if (bl2) {
            this.filteringType = this.distinctAttributeCount == 1L ? AbstractFeatureCoefficientsQuery.Filtering.BY_SINGLE_ATTRIBUTE : AbstractFeatureCoefficientsQuery.Filtering.BY_MULTIPLE_ATTRIBUTE;
            this.attributeFilterConditional = StringUtils.getReplacedString(this.attributeFilterConditional, "{$FEATURE_ID}", "FEATURE_ID");
            return StringUtils.addParentheses(this.attributeFilterConditional);
        }
        if (bl) {
            this.filteringType = AbstractFeatureCoefficientsQuery.Filtering.BY_FEATURE;
            this.featureIdsFilterConditional = StringUtils.getReplacedString(this.featureIdsFilterConditional, "{$FEATURE_ID}", this.featureColumn);
            return StringUtils.addParentheses(this.featureIdsFilterConditional);
        }
        this.filteringType = AbstractFeatureCoefficientsQuery.Filtering.NONE;
        return "";
    }

    public FeatureItemsQuery setFetchSize(Integer n) {
        assert (n != null && n > 0) : "Fetch size must be a natural number";
        this.fetchSize = n;
        return this;
    }

    public FeatureItemsQuery setItemSetSize(Integer n) {
        assert (n != null && n > 0) : "Item set fetch size must be a natural number";
        this.itemSetSize = n;
        return this;
    }

    public FeatureItemsQuery setSortOrder(SortOrder sortOrder) {
        assert (sortOrder != null) : "Order definition cannot be null";
        this.sortOrder = sortOrder;
        return this;
    }

    public FeatureItemsQuery setMatchType(ColumnFilter.Match match) {
        assert (match != null) : "Match type cannot be null";
        this.matchingType = match;
        return this;
    }

    public FeatureItemsQuery setFilterList(List<ColumnFilter> list) {
        if (list != null) {
            this.attributeFilters.addAll(list);
        }
        return this;
    }
}

