/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class ClusterAttributeHistogramQuery
extends ModelDetailsQuery {
    private static final String BIN_ID = "BIN_ID";
    private static final String LOWER_BOUND = "LOWER_BOUND";
    private static final String UPPER_BOUND = "UPPER_BOUND";
    private static final String LABEL = "LABEL";
    private static final String COUNT = "COUNT";

    public ClusterAttributeHistogramQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl) {
        super(version, modelDetailType, list, map, bl);
    }

    public ClusterAttributeHistogramQuery(Version version, ModelDetailType modelDetailType) {
        super(version, modelDetailType);
    }

    @Override
    protected void initializeColumns() {
        this.outputColumns = DbVersionHelper.isDB122Up(this.dbVersion) ? new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PARTITION_NAME", "VARCHAR2"}, {"ID", "NUMBER"}, {"CLUSTER_ID", "VARCHAR2"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {BIN_ID, "NUMBER"}, {LOWER_BOUND, "NUMBER"}, {UPPER_BOUND, "NUMBER"}, {LABEL, "VARCHAR2"}, {COUNT, "NUMBER"}} : new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"ID", "NUMBER"}, {"CLUSTER_ID", "VARCHAR2"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {BIN_ID, "NUMBER"}, {LOWER_BOUND, "NUMBER"}, {UPPER_BOUND, "NUMBER"}, {LABEL, "VARCHAR2"}, {COUNT, "NUMBER"}};
    }

    @Override
    protected String getSQLTemplate() {
        String string = null;
        string = DbVersionHelper.isDB122Up(this.dbVersion) ? "\nSELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_SCHEMA}\", \n     CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\", \n     VH.PARTITION_NAME as \"{$PARTITION_NAME}\",\n     VD.CLUSTER_ID as \"{$ID}\",  \n     CAST(VD.CLUSTER_NAME AS VARCHAR2(4000)) as \"{$CLUSTER_ID}\",  \n     VH.ATTRIBUTE_NAME as \"{$ATTRIBUTE_NAME}\", \n     VH.ATTRIBUTE_SUBNAME as \"{$ATTRIBUTE_SUBNAME}\", \n     VH.BIN_ID as \"{$BIN_ID}\", \n     {$SPECIFIC_LOWER} as \"{$LOWER_BOUND}\", \n     {$SPECIFIC_UPPER} as \"{$UPPER_BOUND}\", \n     {$SPECIFIC_LABEL} as \"{$LABEL}\", \n     VH.COUNT as \"{$COUNT}\" \n  FROM {$MODEL_SCHEMA_VALUE}.{$ALGO_SOURCE}{$MODEL_NAME_VALUE} VH INNER JOIN {$MODEL_SCHEMA_VALUE}.DM$VD{$MODEL_NAME_VALUE} VD ON VH.CLUSTER_ID = VD.CLUSTER_ID" : "SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_SCHEMA}\", \n     CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_NAME}\", \n     a.id as \"{$ID}\", \n     a.cluster_id as \"{$CLUSTER_ID}\",  \n     hist.attribute_name as \"{$ATTRIBUTE_NAME}\", \n     hist.attribute_subname as \"{$ATTRIBUTE_SUBNAME}\", \n     hist.bin_id as \"{$BIN_ID}\", \n     hist.lower_bound as \"{$LOWER_BOUND}\", \n     hist.upper_bound as \"{$UPPER_BOUND}\", \n     hist.label as \"{$LABEL}\", \n     hist.count as \"{$COUNT}\" \n   FROM (SELECT * FROM TABLE(dbms_data_mining.{$ALGO_SOURCE}('{$GET_MODEL_NAME}'))) a, \n   TABLE(a.histogram) hist \n";
        return string;
    }

    @Override
    protected String getActualSource(MiningAlgorithmType miningAlgorithmType) {
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            return "DM$VH";
        }
        switch (miningAlgorithmType) {
            case KMEANS: {
                return "GET_MODEL_DETAILS_KM";
            }
            case O_CLUSTER: {
                return "GET_MODEL_DETAILS_OC";
            }
            case EXPECTATION_MAXIMIZATION: {
                return "GET_MODEL_DETAILS_EM";
            }
        }
        assert (false) : "Incompatible Algorithm";
        return null;
    }

    @Override
    protected Map<String, String> getSpecificColumns(MiningAlgorithmType miningAlgorithmType) {
        Map<String, String> map;
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            map = new HashMap();
            switch (miningAlgorithmType) {
                case KMEANS: 
                case EXPECTATION_MAXIMIZATION: {
                    map.put("SPECIFIC_LOWER", "VH.LOWER_BIN_BOUNDARY");
                    map.put("SPECIFIC_UPPER", "VH.UPPER_BIN_BOUNDARY");
                    map.put("SPECIFIC_LABEL", "CASE WHEN VH.LOWER_BIN_BOUNDARY IS NULL AND VH.UPPER_BIN_BOUNDARY IS NULL\n THEN VH.ATTRIBUTE_VALUE \n ELSE TO_CHAR(VH.LOWER_BIN_BOUNDARY, '9.999EEEE') || ' : ' || TO_CHAR(VH.UPPER_BIN_BOUNDARY, '9.999EEEE') END");
                    break;
                }
                case O_CLUSTER: {
                    map.put("SPECIFIC_LOWER", "null");
                    map.put("SPECIFIC_UPPER", "null");
                    map.put("SPECIFIC_LABEL", "VH.LABEL");
                }
            }
        } else {
            map = Collections.emptyMap();
        }
        return map;
    }

    @Override
    public String getUnionOrderBy() {
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            return "\nORDER BY MODEL_NAME, PARTITION_NAME, ID";
        }
        return "";
    }
}

