/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class DTFullTreeXMLQuery
extends ModelDetailsQuery {
    private static final String PMML_TREE = "PMML_TREE";

    public DTFullTreeXMLQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl) {
        super(version, modelDetailType, list, map, bl);
    }

    public DTFullTreeXMLQuery(Version version, ModelDetailType modelDetailType) {
        super(version, modelDetailType);
    }

    @Override
    protected void initializeColumns() {
        this.outputColumns = DbVersionHelper.isDB122Up(this.dbVersion) ? new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PARTITION_NAME", "VARCHAR2"}, {PMML_TREE, "XMLTYPE"}} : new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {PMML_TREE, "XMLTYPE"}};
    }

    @Override
    protected String getSQLTemplate() {
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            return "\n   SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_SCHEMA}\",\n   CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\",\n   B.PARTITION_NAME AS \"{$PARTITION_NAME}\",\n   dbms_data_mining.get_model_details_xml('{$GET_MODEL_NAME}', B.PARTITION_NAME) as \"{$PMML_TREE}\"\n   FROM (SELECT UNIQUE(PARTITION_NAME) FROM {$MODEL_SCHEMA_VALUE}.DM$VG{$MODEL_NAME_VALUE}) B\n";
        }
        return "\n   SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_SCHEMA}\",\n   CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_NAME}\",\n   dbms_data_mining.get_model_details_xml('{$GET_MODEL_NAME}') as \"{$PMML_TREE}\"\n   FROM dual\n";
    }
}

