/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class PCAScreeQuery
extends ModelDetailsQuery {
    private static final String EIGENVALUE = "EIGENVALUE";
    private static final String PCT_CUM_VARIANCE = "PCT_CUM_VARIANCE";

    public PCAScreeQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl) {
        super(version, modelDetailType, list, map, bl);
    }

    public PCAScreeQuery(Version version, ModelDetailType modelDetailType) {
        super(version, modelDetailType);
    }

    @Override
    protected void initializeColumns() {
        this.outputColumns = DbVersionHelper.isDB122Up(this.dbVersion) ? new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PARTITION_NAME", "VARCHAR2"}, {"ID", "NUMBER"}, {"FEATURE_ID", "VARCHAR2"}, {"MATRIX_TYPE", "VARCHAR2"}, {EIGENVALUE, "NUMBER"}, {"VARIANCE", "NUMBER"}, {PCT_CUM_VARIANCE, "NUMBER"}} : new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"ID", "NUMBER"}, {"FEATURE_ID", "VARCHAR2"}, {"MATRIX_TYPE", "VARCHAR2"}, {EIGENVALUE, "NUMBER"}, {"VARIANCE", "NUMBER"}, {PCT_CUM_VARIANCE, "NUMBER"}};
    }

    @Override
    protected String getSQLTemplate() {
        String string = null;
        string = DbVersionHelper.isDB122Up(this.dbVersion) ? "\nSELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_SCHEMA}\",\nCAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\",  \nPARTITION_NAME as \"{$PARTITION_NAME}\",\nFEATURE_ID as \"{$ID}\",\nCAST(FEATURE_NAME AS VARCHAR2(4000)) as \"{$FEATURE_ID}\",\nCAST('S' AS VARCHAR2(1)) as \"{$MATRIX_TYPE}\",\nVALUE * VALUE as \"{$EIGENVALUE}\", \nVARIANCE as \"{$VARIANCE}\",\nPCT_CUM_VARIANCE as \"{$PCT_CUM_VARIANCE}\"\nFROM {$MODEL_SCHEMA_VALUE}.DM$VE{$MODEL_NAME_VALUE}" : "\nSELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_SCHEMA}\",\nCAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_NAME}\",  \nT.FEATURE_ID as \"{$ID}\",\nCAST(T.MAPPED_FEATURE_ID AS VARCHAR2(4000)) as \"{$FEATURE_ID}\",\nT.MATRIX_TYPE as \"{$MATRIX_TYPE}\",\n(T.VALUE * T.VALUE) as \"{$EIGENVALUE}\", \nT.VARIANCE as \"{$VARIANCE}\",\nT.PCT_CUM_VARIANCE as \"{$PCT_CUM_VARIANCE}\"\nFROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_SVD('{$GET_MODEL_NAME}')) T\nWHERE MATRIX_TYPE = 'S'";
        return string;
    }
}

