/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.ar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dmt.dataminer.core.model.ar.Item;
import oracle.dmt.dataminer.core.model.ar.ItemSetStructure;
import oracle.dmt.dataminer.core.model.ar.RuleContentOption;
import oracle.dmt.dataminer.core.utils.StringUtils;

public class ItemSet {
    public static final String STR_BROWSER_NEXT_LINE = "<BR />";
    private Integer id;
    private List<Item> items;
    private Double support;
    private Integer numberOfItems;
    private ItemSetStructure structure;

    public ItemSet(Integer n, List<Item> list, Double d, Integer n2) {
        this.id = n;
        this.items = list;
        this.support = d;
        this.numberOfItems = n2;
    }

    public ItemSet(Integer n, Item item, Double d, Integer n2) {
        this.id = n;
        this.items = new ArrayList<Item>(1);
        this.items.add(item);
        this.support = d;
        this.numberOfItems = n2;
    }

    public Integer getId() {
        return this.id;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public Double getSupport() {
        return this.support;
    }

    public Integer getNumberOfItems() {
        return this.numberOfItems;
    }

    public String getItemSetString(RuleContentOption ruleContentOption, Boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Item> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            Item item = iterator.next();
            stringBuilder.append(item.getItemDetail(ruleContentOption));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
            if (!bl.booleanValue()) continue;
            stringBuilder.append(STR_BROWSER_NEXT_LINE);
        }
        return stringBuilder.toString();
    }

    public String getItemsToString() {
        StringBuilder stringBuilder = new StringBuilder(30);
        String[] stringArray = this.structure.name().split("_");
        for (Item item : this.items) {
            boolean bl = false;
            String[] stringArray2 = stringArray;
            int n = stringArray2.length;
            block11: for (int i = 0; i < n; ++i) {
                String string;
                switch (string = stringArray2[i]) {
                    case "NAME": {
                        stringBuilder.append(item.getAttributeName());
                        bl = true;
                        continue block11;
                    }
                    case "SUBNAME": {
                        String string2 = item.getAttributeSubname();
                        if (!StringUtils.isNotEmpty(string2)) continue block11;
                        if (bl) {
                            stringBuilder.append(".");
                        }
                        stringBuilder.append(string2);
                        continue block11;
                    }
                    case "VALUE": {
                        String string3 = item.getValue();
                        if (!StringUtils.isNotEmpty(string3)) continue block11;
                        stringBuilder.append(" = ");
                        stringBuilder.append(item.getValue());
                        continue block11;
                    }
                    default: {
                        assert (false) : "Invalid option";
                        continue block11;
                    }
                }
            }
            stringBuilder.append(", ");
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        return stringBuilder.toString();
    }

    public void setItemSetStructure(ItemSetStructure itemSetStructure) {
        this.structure = itemSetStructure;
    }

    public ItemSetStructure getItemSetStructure() {
        return this.structure;
    }
}

