/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.common;

import java.text.MessageFormat;
import java.text.NumberFormat;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.core.res.CoreErrorsLrb;

public class Range {
    private Type type;
    private Number min;
    private Number max;
    private NumberFormat formatter;
    private boolean onlyMin;

    public Range(Type type, Number number) {
        this(type, number, null);
        this.onlyMin = true;
    }

    public Range(Type type, Number number, Number number2) {
        this.type = type;
        this.min = number;
        this.max = number2;
        this.validateArguments(number, number2);
        this.createFormatter();
    }

    private void validateArguments(Number number, Number number2) {
        if (number == null && number2 == null) {
            throw new IllegalStateException(CoreErrorsLrb.get("RANGE_ERROR_BOTH"));
        }
        if (number != null && number2 != null && number.doubleValue() > number2.doubleValue()) {
            String string = MessageFormat.format(CoreErrorsLrb.get("RANGE_ERROR_MIN_GT_MAX"), number, number2);
            throw new IllegalStateException(string);
        }
        switch (this.type) {
            case PERCENTAGE: {
                if (number != null && number.doubleValue() < 0.0) {
                    throw new IllegalArgumentException(CoreErrorsLrb.get("RANGE_ERROR_MIN_PCT"));
                }
                if (number2 == null || !(number2.doubleValue() > 1.0)) break;
                throw new IllegalStateException(CoreErrorsLrb.get("RANGE_ERROR_MAX_PCT"));
            }
            case POSITIVE_DOUBLE: 
            case POSITIVE_INTEGER: {
                if (!(number != null && number.doubleValue() < 0.0) && (number2 == null || !(number2.doubleValue() < 0.0))) break;
                throw new IllegalStateException(CoreErrorsLrb.get("RANGE_ERROR_POSITIVES"));
            }
        }
    }

    private void createFormatter() {
        switch (this.type) {
            case PERCENTAGE: {
                this.formatter = NumberFormat.getPercentInstance();
                break;
            }
            case POSITIVE_DOUBLE: 
            case DOUBLE: {
                this.formatter = NumberFormat.getNumberInstance();
                break;
            }
            case POSITIVE_INTEGER: 
            case INTEGER: {
                this.formatter = NumberFormat.getIntegerInstance();
                break;
            }
            default: {
                assert (false) : "Assign formatter to this range type";
                break;
            }
        }
    }

    public void setMin(Number number) {
        this.min = number;
    }

    public Number getMin() {
        return this.min;
    }

    public void setMax(Number number) {
        this.max = number;
    }

    public Number getMax() {
        return this.max;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isOnlyMin() {
        return this.onlyMin;
    }

    public String toString() {
        String string = null;
        string = this.min == null && this.max != null ? " <= " + this.getNumberToString(this.max) : (this.min != null && this.max == null ? " >= " + this.getNumberToString(this.min) : this.getNumberToString(this.min) + " : " + this.getNumberToString(this.max));
        return string;
    }

    private String getNumberToString(Number number) {
        switch (this.type) {
            case POSITIVE_INTEGER: 
            case INTEGER: {
                return number.intValue() == Integer.MAX_VALUE ? CoreCommonLrb.get("MAXIMUM_SHORT") : this.formatter.format(number.intValue());
            }
            case POSITIVE_DOUBLE: 
            case DOUBLE: {
                return number.doubleValue() == Double.MAX_VALUE ? CoreCommonLrb.get("MAXIMUM_SHORT") : this.formatter.format(number.doubleValue());
            }
        }
        return this.formatter.format(number.doubleValue());
    }

    public static enum Type {
        INTEGER(Integer.MIN_VALUE, Integer.MAX_VALUE, 10),
        DOUBLE(-9.99999999E7, Double.MAX_VALUE, 1),
        PERCENTAGE(0, 1, 0.1),
        POSITIVE_INTEGER(0, Integer.MAX_VALUE, 10),
        POSITIVE_DOUBLE(0, Double.MAX_VALUE, 1);

        private Number minAllowed;
        private Number maxAllowed;
        private Number suggestedStep;

        private Type(Number number, Number number2, Number number3) {
            this.minAllowed = number;
            this.maxAllowed = number2;
            this.suggestedStep = number3;
        }

        public Number getMinAllowed() {
            return this.minAllowed;
        }

        public Number getMaxAllowed() {
            return this.maxAllowed;
        }

        public Number getSuggestedStep() {
            return this.suggestedStep;
        }
    }
}

