/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.common.build;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.model.CoreModelLrb;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;

public class MiningModelSettings {
    String _owner;
    String _modelName;
    String _settingName;
    String _settingValue;
    String _settingType;

    public MiningModelSettings() {
        this._owner = "";
        this._modelName = "";
        this._settingName = "";
        this._settingType = "";
        this._settingValue = "";
    }

    public MiningModelSettings(String string, String string2, String string3, String string4, String string5) {
        this._owner = string;
        this._modelName = string2;
        this._settingName = string3;
        this._settingValue = string4;
        this._settingType = string5;
    }

    public void setOwner(String string) {
        this._owner = string;
    }

    public String getOwner() {
        return this._owner;
    }

    public void setModelName(String string) {
        this._modelName = string;
    }

    public String getModelName() {
        return this._modelName;
    }

    public void setSettingName(String string) {
        this._settingName = string;
    }

    public String getSettingName() {
        return this._settingName;
    }

    public String getSettingValue() {
        return this._settingValue;
    }

    public void setSettingValue(String string) {
        this._settingValue = string;
    }

    public void setSettingType(String string) {
        this._settingType = string;
    }

    public String getSettingType() {
        return this._settingType;
    }

    public String toString() {
        String string = "OWNER:" + this._owner + ", MODEL:" + this._modelName + ", SETTING: " + this._settingName + "[" + this._settingType + "] = " + this._settingValue;
        return string;
    }

    public static MiningModelSettings findSetting(String string, List<MiningModelSettings> list) {
        MiningModelSettings miningModelSettings = null;
        for (MiningModelSettings miningModelSettings2 : list) {
            if (!miningModelSettings2._settingName.equals(string)) continue;
            miningModelSettings = miningModelSettings2;
            break;
        }
        return miningModelSettings;
    }

    public static String translateModelSettingsName(String string) {
        return (String)ALL_MINING_MODEL_SETTINGS._SETTINGS_TRANSLATIONS.get(string);
    }

    public static boolean filterOutSettings(String string) {
        boolean bl = string.equals("CLAS_WEIGHTS_TABLE_NAME") || string.equals("CLAS_PRIORS_TABLE_NAME") || string.equals("CLAS_COST_TABLE_NAME");
        return bl;
    }

    public static String translateModelSettingsValue(String string) {
        String string2 = (String)ALL_MINING_MODEL_SETTINGS._VALUES_TRANSLATIONS.get(string);
        if (string2 == null) {
            string2 = ServerConstants.Algorithm.getUIAlgorithmName(string);
        }
        return string2;
    }

    public static class ALL_MINING_MODEL_SETTINGS {
        private static Map<String, String> _VALUES_TRANSLATIONS = new HashMap<String, String>();
        private static Map<String, String> _SETTINGS_TRANSLATIONS = new HashMap<String, String>();
        public static final String CLAS_WEIGHTS_TABLE_NAME = "CLAS_WEIGHTS_TABLE_NAME";
        public static final String CLAS_PRIORS_TABLE_NAME = "CLAS_PRIORS_TABLE_NAME";
        public static final String CLAS_COST_TABLE_NAME = "CLAS_COST_TABLE_NAME";
        public static final String IMBEDDED_SCORING_COST_MATRIX_NAME = "IMBEDDED_SCORING_COST_MATRIX";
        public static final String IMBEDDED_SCORING_COST_MATRIX_TRUE = "TRUE";
        public static final String SETTING_TYPE_INPUT = "INPUT";

        static {
            _VALUES_TRANSLATIONS.put("ON", CoreCommonLrb.get("ON"));
            _VALUES_TRANSLATIONS.put("OFF", CoreCommonLrb.get("OFF"));
            _VALUES_TRANSLATIONS.put("YES", CoreCommonLrb.get("YES"));
            _VALUES_TRANSLATIONS.put("NO", CoreCommonLrb.get("NO"));
            _VALUES_TRANSLATIONS.put("SVMS_GAUSSIAN", CoreModelLrb.get("SVMS_GAUSSIAN"));
            _VALUES_TRANSLATIONS.put("SVMS_LINEAR", CoreModelLrb.get("SVMS_LINEAR"));
            _VALUES_TRANSLATIONS.put("SVMS_AL_ENABLE", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("SVMS_AL_DISABLE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("PREP_AUTO_OFF", CoreModelLrb.get("PREP_AUTO_OFF"));
            _VALUES_TRANSLATIONS.put("PREP_AUTO_ON", CoreModelLrb.get("PREP_AUTO_ON"));
            _VALUES_TRANSLATIONS.put("TREE_IMPURITY_ENTROPY", CoreModelLrb.get("TREE_IMPURITY_ENTROPY"));
            _VALUES_TRANSLATIONS.put("TREE_IMPURITY_GINI", CoreModelLrb.get("TREE_IMPURITY_GINI"));
            _VALUES_TRANSLATIONS.put("ODMS_MISSING_VALUE_MEAN_MODE", CoreModelLrb.get("ODMS_MISSING_VALUE_MEAN_MODE"));
            _VALUES_TRANSLATIONS.put("ODMS_MISSING_VALUE_DELETE_ROW", CoreModelLrb.get("ODMS_MISSING_VALUE_DELETE_ROW"));
            _VALUES_TRANSLATIONS.put("GLMS_RIDGE_REG_ENABLE", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("GLMS_RIDGE_REG_DISABLE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("GLMS_VIF_RIDGE_ENABLE", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("GLMS_VIF_RIDGE_DISABLE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("EMCS_ATTR_FILTER_ENABLE", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("EMCS_ATTR_FILTER_DISABLE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("EMCS_CLUSTER_COMP_ENABLE", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("EMCS_CLUSTER_COMP_DISABLE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("EMCS_CLUS_STATS_ENABLE", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("EMCS_CLUS_STATS_DISABLE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("EMCS_NUM_DISTR_BERNOULLI", CoreModelLrb.get("EMCS_NUM_DISTR_BERNOULLI"));
            _VALUES_TRANSLATIONS.put("EMCS_NUM_DISTR_GAUSSIAN", CoreModelLrb.get("EMCS_NUM_DISTR_GAUSSIAN"));
            _VALUES_TRANSLATIONS.put("EMCS_NUM_DISTR_SYSTEM", CoreModelLrb.get("MODEL_SETTING_SYSTEM_DETERMINED"));
            _VALUES_TRANSLATIONS.put("EMCS_CONV_CRIT_HELDASIDE", CoreModelLrb.get("EMCS_CONV_CRIT_HELDASIDE"));
            _VALUES_TRANSLATIONS.put("EMCS_CONV_CRIT_BIC", CoreModelLrb.get("EMCS_CONV_CRIT_BIC"));
            _VALUES_TRANSLATIONS.put("EMCS_LINKAGE_SINGLE", CoreModelLrb.get("EMCS_LINKAGE_SINGLE"));
            _VALUES_TRANSLATIONS.put("EMCS_LINKAGE_AVERAGE", CoreModelLrb.get("EMCS_LINKAGE_AVERAGE"));
            _VALUES_TRANSLATIONS.put("EMCS_LINKAGE_COMPLETE", CoreModelLrb.get("EMCS_LINKAGE_COMPLETE"));
            _VALUES_TRANSLATIONS.put("GLMS_PRUNE_MODEL_ENABLE", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("GLMS_PRUNE_MODEL_DISABLE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("GLMS_SELECT_BLOCK_ENABLE", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("GLMS_SELECT_BLOCK_DISABLE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("GLMS_FTR_ACCEPTANCE_STRICT", CoreModelLrb.get("GLMS_FTR_ACCEPTANCE_STRICT"));
            _VALUES_TRANSLATIONS.put("GLMS_FTR_ACCEPTANCE_RELAXED", CoreModelLrb.get("GLMS_FTR_ACCEPTANCE_RELAXED"));
            _VALUES_TRANSLATIONS.put("GLMS_FTR_SEL_AIC", CoreModelLrb.get("GLMS_FTR_SEL_AIC"));
            _VALUES_TRANSLATIONS.put("GLMS_FTR_SEL_SBIC", CoreModelLrb.get("GLMS_FTR_SEL_SBIC"));
            _VALUES_TRANSLATIONS.put("GLMS_FTR_SEL_RIC", CoreModelLrb.get("GLMS_FTR_SEL_RIC"));
            _VALUES_TRANSLATIONS.put("GLMS_FTR_SEL_ALPHA_INV", CoreModelLrb.get("GLMS_FTR_SEL_ALPHA_INV"));
            _VALUES_TRANSLATIONS.put("ODMS_APPR_COMP_ENABLE", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("ODMS_APPR_COMP_DISABLE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("GLMS_FTR_GENERATION_ENABLE", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("GLMS_FTR_GENERATION_DISABLE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("GLMS_FTR_SELECTION_ENABLE", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("GLMS_FTR_SELECTION_DISABLE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("GLMS_FTR_GEN_QUADRATIC", CoreModelLrb.get("GLMS_FTR_GEN_QUADRATIC"));
            _VALUES_TRANSLATIONS.put("GLMS_FTR_GEN_CUBIC", CoreModelLrb.get("GLMS_FTR_GEN_CUBIC"));
            _VALUES_TRANSLATIONS.put("GLMS_FTR_IDENTIFICATION_QUICK", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("GLMS_FTR_IDENTIFICATION_COMPLETE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("SVDS_SCORING_SVD", CoreModelLrb.get("SVDS_SCORING_SVD"));
            _VALUES_TRANSLATIONS.put("SVDS_SCORING_PCA", CoreModelLrb.get("SVDS_SCORING_PCA"));
            _VALUES_TRANSLATIONS.put("SVDS_U_MATRIX_ENABLE", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("SVDS_U_MATRIX_DISABLE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("ODMS_SAMPLING_DISABLE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("ODMS_SAMPLING_ENABLE", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("ODMS_MISSING_VALUE_AUTO", CoreModelLrb.get("ODMS_MISSING_VALUE_AUTO"));
            _VALUES_TRANSLATIONS.put("TERMINATION_NORMAL", CoreModelLrb.get("TERMINATION_NORMAL"));
            _VALUES_TRANSLATIONS.put("TERMINATION_EARY", CoreModelLrb.get("TERMINATION_EARY"));
            _VALUES_TRANSLATIONS.put("TERMINATION_SKIP_CATEGORICALS", CoreModelLrb.get("TERMINATION_SKIP_CATEGORICALS"));
            _VALUES_TRANSLATIONS.put("GLMS_ROW_DIAG_ENABLE", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("GLMS_ROW_DIAG_DISABLE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("GLMS_SPARSE_SOLVER_ENABLE", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("GLMS_SPARSE_SOLVER_DISABLE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("GLMS_SOLVER_SGD", CoreModelLrb.get("GLMS_SOLVER_SGD"));
            _VALUES_TRANSLATIONS.put("GLMS_SOLVER_QR", CoreModelLrb.get("GLMS_SOLVER_QR"));
            _VALUES_TRANSLATIONS.put("GLMS_SOLVER_CHOL", CoreModelLrb.get("GLMS_SOLVER_CHOL"));
            _VALUES_TRANSLATIONS.put("SVMS_SOLVER_SGD", CoreModelLrb.get("SVMS_SOLVER_SGD"));
            _VALUES_TRANSLATIONS.put("SVMS_SOLVER_IPM", CoreModelLrb.get("SVMS_SOLVER_IPM"));
            _VALUES_TRANSLATIONS.put("SVMS_REGULARIZER_L1", CoreModelLrb.get("SVMS_REGULARIZER_L1"));
            _VALUES_TRANSLATIONS.put("SVMS_REGULARIZER_L2", CoreModelLrb.get("SVMS_REGULARIZER_L1"));
            _VALUES_TRANSLATIONS.put("NMFS_NONNEG_SCORING_ENABLE", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("NMFS_NONNEG_SCORING_DISABLE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("EMCS_MODEL_SEARCH_ENABLE", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("EMCS_MODEL_SEARCH_DISABLE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("EMCS_REMOVE_COMPS_ENABLE", CoreCommonLrb.get("ENABLE"));
            _VALUES_TRANSLATIONS.put("EMCS_REMOVE_COMPS_DISABLE", CoreCommonLrb.get("DISABLE"));
            _VALUES_TRANSLATIONS.put("KMNS_DETAILS_NONE", CoreModelLrb.get("KMNS_DETAILS_NONE"));
            _VALUES_TRANSLATIONS.put("KMNS_DETAILS_HIERARCHY", CoreModelLrb.get("KMNS_DETAILS_HIERARCHY"));
            _VALUES_TRANSLATIONS.put("KMNS_DETAILS_ALL", CoreModelLrb.get("KMNS_DETAILS_ALL"));
            _VALUES_TRANSLATIONS.put("KMNS_EUCLIDEAN", CoreModelLrb.get("KMNS_EUCLIDEAN_STR"));
            _VALUES_TRANSLATIONS.put("KMNS_FAST_COSINE", CoreModelLrb.get("KMNS_COSINE_STR"));
            _VALUES_TRANSLATIONS.put("KMNS_COSINE", CoreModelLrb.get("KMNS_COSINE_STR"));
            _VALUES_TRANSLATIONS.put("KMNS_SIZE", CoreModelLrb.get("KMNS_SIZE_STR"));
            _VALUES_TRANSLATIONS.put("KMNS_VARIANCE", CoreModelLrb.get("KMNS_VARIANCE_STR"));
            _VALUES_TRANSLATIONS.put("PREP_SCALE_STDDEV", CoreModelLrb.get("PREP_SCALE_STDDEV"));
            _VALUES_TRANSLATIONS.put("PREP_SCALE_RANGE", CoreModelLrb.get("PREP_SCALE_RANGE"));
            _VALUES_TRANSLATIONS.put("PREP_SCALE_MAXABS", CoreModelLrb.get("PREP_SCALE_MAXABS"));
            _VALUES_TRANSLATIONS.put("PREP_SHIFT_MEAN", CoreModelLrb.get("PREP_SHIFT_MEAN"));
            _VALUES_TRANSLATIONS.put("PREP_SHIFT_MIN", CoreModelLrb.get("PREP_SHIFT_MIN"));
            _VALUES_TRANSLATIONS.put("SVDS_SOLVER_TSSVD", CoreModelLrb.get("SVDS_SOLVER_TSSVD"));
            _VALUES_TRANSLATIONS.put("SVDS_SOLVER_TSEIGEN", CoreModelLrb.get("SVDS_SOLVER_TSEIGEN"));
            _VALUES_TRANSLATIONS.put("SVDS_SOLVER_SSVD", CoreModelLrb.get("SVDS_SOLVER_SSVD"));
            _VALUES_TRANSLATIONS.put("SVDS_SOLVER_STEIGEN", CoreModelLrb.get("SVDS_SOLVER_STEIGEN"));
            _SETTINGS_TRANSLATIONS.put("ALGO_NAME", CoreModelLrb.get("ALGO_NAME"));
            _SETTINGS_TRANSLATIONS.put("SVMS_KERNEL_FUNCTION", CoreModelLrb.get("SVMS_KERNEL_FUNCTION"));
            _SETTINGS_TRANSLATIONS.put("SVMS_CONV_TOLERANCE", CoreModelLrb.get("CONV_TOLERANCE"));
            _SETTINGS_TRANSLATIONS.put("SVMS_ACTIVE_LEARNING", CoreModelLrb.get("SVMS_ACTIVE_LEARNING"));
            _SETTINGS_TRANSLATIONS.put("SVMS_COMPLEXITY_FACTOR", CoreModelLrb.get("SVMS_COMPLEXITY_FACTOR"));
            _SETTINGS_TRANSLATIONS.put("SVMS_STD_DEV", CoreModelLrb.get("SVMS_STD_DEV"));
            _SETTINGS_TRANSLATIONS.put("SVMS_KERNEL_CACHE_SIZE", CoreModelLrb.get("SVMS_KERNEL_CACHE_SIZE"));
            _SETTINGS_TRANSLATIONS.put("SVMS_REGULARIZER", CoreModelLrb.get("SVMS_REGULARIZER"));
            _SETTINGS_TRANSLATIONS.put("SVMS_SOLVER", CoreModelLrb.get("SOLVER"));
            _SETTINGS_TRANSLATIONS.put("SVMS_NUM_PIVOTS", CoreModelLrb.get("SVMS_NUM_PIVOTS"));
            _SETTINGS_TRANSLATIONS.put("SVMS_OUTLIER_RATE", CoreModelLrb.get("SVMS_OUTLIER_RATE"));
            _SETTINGS_TRANSLATIONS.put("SVMS_EPSILON", CoreModelLrb.get("SVMS_EPSILON"));
            _SETTINGS_TRANSLATIONS.put("NABS_PAIRWISE_THRESHOLD", CoreModelLrb.get("NABS_PAIRWISE_THRESHOLD"));
            _SETTINGS_TRANSLATIONS.put("GLMS_CONF_LEVEL", CoreModelLrb.get("GLMS_CONF_LEVEL"));
            _SETTINGS_TRANSLATIONS.put("GLMS_CONV_TOLERANCE", CoreModelLrb.get("CONV_TOLERANCE"));
            _SETTINGS_TRANSLATIONS.put("GLMS_RIDGE_VALUE", CoreModelLrb.get("GLMS_RIDGE_VALUE"));
            _SETTINGS_TRANSLATIONS.put("GLMS_DIAGNOSTICS_TABLE_NAME", CoreModelLrb.get("GLMS_DIAGNOSTICS_TABLE_NAME"));
            _SETTINGS_TRANSLATIONS.put("PREP_AUTO", CoreModelLrb.get("PREP_AUTO"));
            _SETTINGS_TRANSLATIONS.put("TREE_IMPURITY_METRIC", CoreModelLrb.get("TREE_IMPURITY_METRIC"));
            _SETTINGS_TRANSLATIONS.put("ODMS_MISSING_VALUE_TREATMENT", CoreModelLrb.get("ODMS_MISSING_VALUE_TREATMENT"));
            _SETTINGS_TRANSLATIONS.put("ODMS_ROW_WEIGHT_COLUMN_NAME", CoreModelLrb.get("ODMS_ROW_WEIGHT_COLUMN_NAME"));
            _SETTINGS_TRANSLATIONS.put("CLAS_MAX_SUP_BINS", CoreModelLrb.get("CLAS_MAX_SUP_BINS"));
            _SETTINGS_TRANSLATIONS.put("TREE_TERM_MINREC_SPLIT", CoreModelLrb.get("TREE_TERM_MINREC_SPLIT"));
            _SETTINGS_TRANSLATIONS.put("TREE_TERM_MINPCT_SPLIT", CoreModelLrb.get("TREE_TERM_MINPCT_SPLIT"));
            _SETTINGS_TRANSLATIONS.put("GLMS_RIDGE_REGRESSION", CoreModelLrb.get("GLMS_RIDGE_REGRESSION"));
            _SETTINGS_TRANSLATIONS.put("TREE_TERM_MINREC_NODE", CoreModelLrb.get("TREE_TERM_MINREC_NODE"));
            _SETTINGS_TRANSLATIONS.put("NABS_SINGLETON_THRESHOLD", CoreModelLrb.get("NABS_SINGLETON_THRESHOLD"));
            _SETTINGS_TRANSLATIONS.put("GLMS_VIF_FOR_RIDGE", CoreModelLrb.get("GLMS_VIF_FOR_RIDGE"));
            _SETTINGS_TRANSLATIONS.put("GLMS_REFERENCE_CLASS_NAME", CoreModelLrb.get("GLMS_REFERENCE_CLASS_NAME"));
            _SETTINGS_TRANSLATIONS.put("TREE_TERM_MAX_DEPTH", CoreModelLrb.get("TREE_TERM_MAX_DEPTH"));
            _SETTINGS_TRANSLATIONS.put("ASSO_MAX_RULE_LENGTH", CoreModelLrb.get("ASSO_MAX_RULE_LENGTH"));
            _SETTINGS_TRANSLATIONS.put("ASSO_MIN_SUPPORT", CoreModelLrb.get("ASSO_MIN_SUPPORT"));
            _SETTINGS_TRANSLATIONS.put("ASSO_MIN_CONFIDENCE", CoreModelLrb.get("ASSO_MIN_CONFIDENCE"));
            _SETTINGS_TRANSLATIONS.put("ASSO_MIN_REVERSE_CONF", CoreModelLrb.get("ASSO_MIN_REVERSE_CONF"));
            _SETTINGS_TRANSLATIONS.put("ASSO_MIN_SUPPORT_COUNT", CoreModelLrb.get("ASSO_MIN_SUPPORT_COUNT"));
            _SETTINGS_TRANSLATIONS.put("CLAS_MAX_SUP_BINS", CoreModelLrb.get("CLAS_MAX_SUP_BINS"));
            _SETTINGS_TRANSLATIONS.put("ASSO_ANT_IN_RULES", CoreModelLrb.get("ASSO_ANT_IN_RULES"));
            _SETTINGS_TRANSLATIONS.put("ASSO_CONS_IN_RULES", CoreModelLrb.get("ASSO_CONS_IN_RULES"));
            _SETTINGS_TRANSLATIONS.put("ASSO_ANT_EX_RULES", CoreModelLrb.get("ASSO_ANT_EX_RULES"));
            _SETTINGS_TRANSLATIONS.put("ASSO_CONS_EX_RULES", CoreModelLrb.get("ASSO_CONS_EX_RULES"));
            _SETTINGS_TRANSLATIONS.put("ASSO_FILTERS_ACTIVE", CoreModelLrb.get(CoreModelLrb.get("ASSO_FILTERS_ACTIVE")));
            _SETTINGS_TRANSLATIONS.put("ASSO_GENERATE_PREPROCESSED_TABLE", CoreModelLrb.get("ASSO_GENERATE_PREPROCESSED_TABLE"));
            _SETTINGS_TRANSLATIONS.put("ASSO_AGGREGATES", CoreModelLrb.get("ASSO_AGGREGATES"));
            _SETTINGS_TRANSLATIONS.put("ASSO_MIN_REV_CONFIDENCE", CoreModelLrb.get("ASSO_MIN_REV_CONFIDENCE"));
            _SETTINGS_TRANSLATIONS.put("ASSO_MIN_SUPPORT_INT", CoreModelLrb.get("ASSO_MIN_SUPPORT_INT"));
            _SETTINGS_TRANSLATIONS.put("FEAT_NUM_FEATURES", CoreModelLrb.get("FEAT_NUM_FEATURES"));
            _SETTINGS_TRANSLATIONS.put("NMFS_CONV_TOLERANCE", CoreModelLrb.get("CONV_TOLERANCE"));
            _SETTINGS_TRANSLATIONS.put("NMFS_NUM_ITERATIONS", CoreModelLrb.get("NUM_ITERATIONS"));
            _SETTINGS_TRANSLATIONS.put("NMFS_RANDOM_SEED", CoreModelLrb.get("RANDOM_SEED"));
            _SETTINGS_TRANSLATIONS.put("CONV_ERROR", CoreModelLrb.get("CONV_ERROR"));
            _SETTINGS_TRANSLATIONS.put("SAMPLE_SIZE", CoreModelLrb.get("ODMS_SAMPLE_SIZE"));
            _SETTINGS_TRANSLATIONS.put("NMFS_NONNEGATIVE_SCORING", CoreModelLrb.get("NMFS_NONNEGATIVE_SCORING"));
            _SETTINGS_TRANSLATIONS.put("TERMINATION", CoreModelLrb.get("TERMINATION"));
            _SETTINGS_TRANSLATIONS.put("MODEL_DF", CoreModelLrb.get("MODEL_DF"));
            _SETTINGS_TRANSLATIONS.put("MODEL_SUM_SQUARES", CoreModelLrb.get("MODEL_SUM_SQUARES"));
            _SETTINGS_TRANSLATIONS.put("MODEL_MEAN_SQUARE", CoreModelLrb.get("MODEL_MEAN_SQUARE"));
            _SETTINGS_TRANSLATIONS.put("F_VALUE", CoreModelLrb.get("F_VALUE"));
            _SETTINGS_TRANSLATIONS.put("MODEL_F_P_VALUE", CoreModelLrb.get("MODEL_F_P_VALUE"));
            _SETTINGS_TRANSLATIONS.put("ERROR_DF", CoreModelLrb.get("ERROR_DF"));
            _SETTINGS_TRANSLATIONS.put("ERROR_SUM_SQUARES", CoreModelLrb.get("ERROR_SUM_SQUARES"));
            _SETTINGS_TRANSLATIONS.put("ERROR_MEAN_SQUARE", CoreModelLrb.get("ERROR_MEAN_SQUARE"));
            _SETTINGS_TRANSLATIONS.put("CORRECTED_TOTAL_DF", CoreModelLrb.get("CORRECTED_TOTAL_DF"));
            _SETTINGS_TRANSLATIONS.put("CORRECTED_TOT_SS", CoreModelLrb.get("CORRECTED_TOT_SS"));
            _SETTINGS_TRANSLATIONS.put("ROOT_MEAN_SQ", CoreModelLrb.get("ROOT_MEAN_SQ"));
            _SETTINGS_TRANSLATIONS.put("DEPENDENT_MEAN", CoreModelLrb.get("DEPENDENT_MEAN"));
            _SETTINGS_TRANSLATIONS.put("COEFF_VAR", CoreModelLrb.get("COEFF_VAR"));
            _SETTINGS_TRANSLATIONS.put("R_SQ", CoreModelLrb.get("R_SQ"));
            _SETTINGS_TRANSLATIONS.put("ADJUSTED_R_SQUARE", CoreModelLrb.get("ADJUSTED_R_SQUARE"));
            _SETTINGS_TRANSLATIONS.put("AIC", CoreModelLrb.get("AIC"));
            _SETTINGS_TRANSLATIONS.put("SBIC", CoreModelLrb.get("SBIC"));
            _SETTINGS_TRANSLATIONS.put("GMSEP", CoreModelLrb.get("GMSEP"));
            _SETTINGS_TRANSLATIONS.put("HOCKING_SP", CoreModelLrb.get("HOCKING_SP"));
            _SETTINGS_TRANSLATIONS.put("J_P", CoreModelLrb.get("J_P"));
            _SETTINGS_TRANSLATIONS.put("NUM_PARAMS", CoreModelLrb.get("NUM_PARAMS"));
            _SETTINGS_TRANSLATIONS.put("VALID_COVARIANCE_MATRIX", CoreModelLrb.get("VALID_COVARIANCE_MATRIX"));
            _SETTINGS_TRANSLATIONS.put("AIC_INTERCEPT", CoreModelLrb.get("AIC_INTERCEPT"));
            _SETTINGS_TRANSLATIONS.put("AIC_MODEL", CoreModelLrb.get("AIC_MODEL"));
            _SETTINGS_TRANSLATIONS.put("SC_INTERCEPT", CoreModelLrb.get("SC_INTERCEPT"));
            _SETTINGS_TRANSLATIONS.put("SC_MODEL", CoreModelLrb.get("SC_MODEL"));
            _SETTINGS_TRANSLATIONS.put("NEG2_LL_INTERCEPT", CoreModelLrb.get("NEG2_LL_INTERCEPT"));
            _SETTINGS_TRANSLATIONS.put("NEG2_LL_MODEL", CoreModelLrb.get("NEG2_LL_MODEL"));
            _SETTINGS_TRANSLATIONS.put("LR_DF", CoreModelLrb.get("LR_DF"));
            _SETTINGS_TRANSLATIONS.put("LR_CHI_SQ", CoreModelLrb.get("LR_CHI_SQ"));
            _SETTINGS_TRANSLATIONS.put("LR_CHI_SQ_P_VALUE", CoreModelLrb.get("LR_CHI_SQ_P_VALUE"));
            _SETTINGS_TRANSLATIONS.put("PSEUDO_R_SQ_CS", CoreModelLrb.get("PSEUDO_R_SQ_CS"));
            _SETTINGS_TRANSLATIONS.put("PSEUDO_R_SQ_N", CoreModelLrb.get("PSEUDO_R_SQ_N"));
            _SETTINGS_TRANSLATIONS.put("PCT_CORRECT", CoreModelLrb.get("PCT_CORRECT"));
            _SETTINGS_TRANSLATIONS.put("PCT_INCORRECT", CoreModelLrb.get("PCT_INCORRECT"));
            _SETTINGS_TRANSLATIONS.put("PCT_TIED", CoreModelLrb.get("PCT_TIED"));
            _SETTINGS_TRANSLATIONS.put("GLMS_PRUNE_MODEL", CoreModelLrb.get("GLMS_PRUNE_MODEL"));
            _SETTINGS_TRANSLATIONS.put("GLMS_MAX_FEATURES", CoreModelLrb.get("GLMS_MAX_FEATURES"));
            _SETTINGS_TRANSLATIONS.put("GLMS_FTR_GENERATION", CoreModelLrb.get("GLMS_FTR_GENERATION"));
            _SETTINGS_TRANSLATIONS.put("GLMS_FTR_ACCEPTANCE", CoreModelLrb.get("GLMS_FTR_ACCEPTANCE"));
            _SETTINGS_TRANSLATIONS.put("GLMS_SELECT_BLOCK", CoreModelLrb.get("GLMS_SELECT_BLOCK"));
            _SETTINGS_TRANSLATIONS.put("GLMS_FTR_SEL_CRIT", CoreModelLrb.get("GLMS_FTR_SEL_CRIT"));
            _SETTINGS_TRANSLATIONS.put("GLMS_FTR_SELECTION", CoreModelLrb.get("GLMS_FTR_SELECTION"));
            _SETTINGS_TRANSLATIONS.put("GLMS_FTR_GEN_METHOD", CoreModelLrb.get("GLMS_FTR_GEN_METHOD"));
            _SETTINGS_TRANSLATIONS.put("GLMS_FTR_IDENTIFICATION", CoreModelLrb.get("GLMS_FTR_IDENTIFICATION"));
            _SETTINGS_TRANSLATIONS.put("GLMS_NUM_ITERATIONS", CoreModelLrb.get("NUM_ITERATIONS"));
            _SETTINGS_TRANSLATIONS.put("GLMS_BATCH_ROWS", CoreModelLrb.get("BATCH_ROWS"));
            _SETTINGS_TRANSLATIONS.put("RANK_DEFICIENCY", CoreModelLrb.get("RANK_DEFICIENCY"));
            _SETTINGS_TRANSLATIONS.put("GLMS_ROW_DIAGNOSTICS", CoreModelLrb.get("GLMS_ROW_DIAGNOSTICS"));
            _SETTINGS_TRANSLATIONS.put("GLMS_SOLVER", CoreModelLrb.get("SOLVER"));
            _SETTINGS_TRANSLATIONS.put("GLMS_SPARSE_SOLVER", CoreModelLrb.get("GLMS_SPARSE_SOLVER"));
            _SETTINGS_TRANSLATIONS.put("KMNS_BLOCK_GROWTH", CoreModelLrb.get("KMNS_BLOCK_GROWTH"));
            _SETTINGS_TRANSLATIONS.put("CLUS_NUM_CLUSTERS", CoreModelLrb.get("CLUS_NUM_CLUSTERS"));
            _SETTINGS_TRANSLATIONS.put("KMNS_NUM_BINS", CoreModelLrb.get("KMNS_NUM_BINS"));
            _SETTINGS_TRANSLATIONS.put("KMNS_CONV_TOLERANCE", CoreModelLrb.get("CONV_TOLERANCE"));
            _SETTINGS_TRANSLATIONS.put("KMNS_MIN_PCT_ATTR_SUPPORT", CoreModelLrb.get("KMNS_MIN_PCT_ATTR_SUPPORT"));
            _SETTINGS_TRANSLATIONS.put("KMNS_DISTANCE", CoreModelLrb.get("KMNS_DISTANCE"));
            _SETTINGS_TRANSLATIONS.put("KMNS_SPLIT_CRITERION", CoreModelLrb.get("KMNS_SPLIT_CRITERION"));
            _SETTINGS_TRANSLATIONS.put("KMNS_ITERATIONS", CoreModelLrb.get("NUM_ITERATIONS"));
            _SETTINGS_TRANSLATIONS.put("KMNS_DETAILS", CoreModelLrb.get("KMNS_DETAILS"));
            _SETTINGS_TRANSLATIONS.put("KMNS_RANDOM_SEED", CoreModelLrb.get("RANDOM_SEED"));
            _SETTINGS_TRANSLATIONS.put("OCLT_SENSITIVITY", CoreModelLrb.get("OCLT_SENSITIVITY"));
            _SETTINGS_TRANSLATIONS.put("OCLT_MAX_BUFFER", CoreModelLrb.get("OCLT_MAX_BUFFER"));
            _SETTINGS_TRANSLATIONS.put("EMCS_NUM_COMPONENTS", CoreModelLrb.get("EMCS_NUM_COMPONENTS"));
            _SETTINGS_TRANSLATIONS.put("EMCS_NUM_PROJECTIONS", CoreModelLrb.get("EMCS_NUM_PROJECTIONS"));
            _SETTINGS_TRANSLATIONS.put("EMCS_LINKAGE_FUNCTION", CoreModelLrb.get("EMCS_LINKAGE_FUNCTION"));
            _SETTINGS_TRANSLATIONS.put("EMCS_CONVERGENCE_CRITERION", CoreModelLrb.get("EMCS_CONVERGENCE_CRITERION"));
            _SETTINGS_TRANSLATIONS.put("EMCS_MAX_NUM_ATTR_2D", CoreModelLrb.get("EMCS_MAX_NUM_ATTR_2D"));
            _SETTINGS_TRANSLATIONS.put("EMCS_ATTRIBUTE_FILTER", CoreModelLrb.get("EMCS_ATTRIBUTE_FILTER"));
            _SETTINGS_TRANSLATIONS.put("EMCS_CLUSTER_COMPONENTS", CoreModelLrb.get("EMCS_CLUSTER_COMPONENTS"));
            _SETTINGS_TRANSLATIONS.put("EMCS_CLUSTER_THRESH", CoreModelLrb.get("EMCS_CLUSTER_THRESH"));
            _SETTINGS_TRANSLATIONS.put("EMCS_MIN_PCT_ATTR_SUPPORT", CoreModelLrb.get("EMCS_MIN_PCT_ATTR_SUPPORT"));
            _SETTINGS_TRANSLATIONS.put("EMCS_NUM_DISTRIBUTION", CoreModelLrb.get("EMCS_NUM_DISTRIBUTION"));
            _SETTINGS_TRANSLATIONS.put("EMCS_NUM_EQUIWIDTH_BINS", CoreModelLrb.get("EMCS_NUM_EQUIWIDTH_BINS"));
            _SETTINGS_TRANSLATIONS.put("EMCS_NUM_QUANTILE_BINS", CoreModelLrb.get("EMCS_NUM_QUANTILE_BINS"));
            _SETTINGS_TRANSLATIONS.put("ODMS_APPROXIMATE_COMPUTATION", CoreModelLrb.get("ODMS_APPROXIMATE_COMPUTATION"));
            _SETTINGS_TRANSLATIONS.put("EMCS_CLUSTER_STATISTICS", CoreModelLrb.get("EMCS_CLUSTER_STATISTICS"));
            _SETTINGS_TRANSLATIONS.put("EMCS_LOGLIKE_IMPROVEMENT", CoreModelLrb.get("EMCS_LOGLIKE_IMPROVEMENT"));
            _SETTINGS_TRANSLATIONS.put("EMCS_NUM_ITERATIONS", CoreModelLrb.get("EMCS_NUM_ITERATIONS"));
            _SETTINGS_TRANSLATIONS.put("EMCS_NUM_TOPN_BINS", CoreModelLrb.get("EMCS_NUM_TOPN_BINS"));
            _SETTINGS_TRANSLATIONS.put("EMCS_RANDOM_SEED", CoreModelLrb.get("RANDOM_SEED"));
            _SETTINGS_TRANSLATIONS.put("EMCS_MODEL_SEARCH", CoreModelLrb.get("EMCS_MODEL_SEARCH"));
            _SETTINGS_TRANSLATIONS.put("EMCS_REMOVE_COMPONENTS", CoreModelLrb.get("EMCS_REMOVE_COMPONENTS"));
            _SETTINGS_TRANSLATIONS.put("REMOVED_COMPONENTS", CoreModelLrb.get("REMOVED_COMPONENTS"));
            _SETTINGS_TRANSLATIONS.put("NUM_CLUSTERS", CoreModelLrb.get("NUM_CLUSTERS"));
            _SETTINGS_TRANSLATIONS.put("LOGLIKELIHOOD", CoreModelLrb.get("LOGLIKELIHOOD"));
            _SETTINGS_TRANSLATIONS.put("SVDS_SCORING_MODE", CoreModelLrb.get("SVDS_SCORING_MODE"));
            _SETTINGS_TRANSLATIONS.put("SVDS_U_MATRIX_OUTPUT", CoreModelLrb.get("SVDS_U_MATRIX_OUTPUT"));
            _SETTINGS_TRANSLATIONS.put("NMFS_NONNEGATIVE_SCORING", CoreModelLrb.get("NMFS_NONNEGATIVE_SCORING"));
            _SETTINGS_TRANSLATIONS.put("SVDS_SOLVER", CoreModelLrb.get("SOLVER"));
            _SETTINGS_TRANSLATIONS.put("SVDS_TOLERANCE", CoreModelLrb.get("SVDS_TOLERANCE"));
            _SETTINGS_TRANSLATIONS.put("SVDS_OVER_SAMPLING", CoreModelLrb.get("SVDS_OVER_SAMPLING"));
            _SETTINGS_TRANSLATIONS.put("SVDS_POWER_ITERATIONS", CoreModelLrb.get("SVDS_POWER_ITERATIONS"));
            _SETTINGS_TRANSLATIONS.put("SVDS_RANDOM_SEED", CoreModelLrb.get("RANDOM_SEED"));
            _SETTINGS_TRANSLATIONS.put("SUGGESTED_CUTOFF", CoreModelLrb.get("SUGGESTED_CUTOFF"));
            _SETTINGS_TRANSLATIONS.put("TREE_TERM_MINPCT_NODE", CoreModelLrb.get("TREE_TERM_MINPCT_NODE"));
            _SETTINGS_TRANSLATIONS.put("ODMS_PARTITION_COLUMNS", CoreModelLrb.get("ODMS_PARTITION_COLUMNS"));
            _SETTINGS_TRANSLATIONS.put("ODMS_MAX_PARTITIONS", CoreModelLrb.get("ODMS_MAX_PARTITIONS"));
            _SETTINGS_TRANSLATIONS.put("CLAS_WEIGHTS_BALANCED", CoreModelLrb.get("CLAS_WEIGHTS_BALANCED"));
            _SETTINGS_TRANSLATIONS.put("ESAS_TOPN_FEATURES", CoreModelLrb.get("ESAS_TOPN_FEATURES"));
            _SETTINGS_TRANSLATIONS.put("ESAS_MIN_ITEMS", CoreModelLrb.get("ESAS_MIN_ITEMS"));
            _SETTINGS_TRANSLATIONS.put("ESAS_VALUE_THRESHOLD", CoreModelLrb.get("ESAS_VALUE_THRESHOLD"));
            _SETTINGS_TRANSLATIONS.put("REMOVED_ROWS_BY_FILTERS", CoreModelLrb.get("REMOVED_ROWS_BY_FILTERS"));
            _SETTINGS_TRANSLATIONS.put("ODMS_SAMPLING", CoreModelLrb.get("ODMS_SAMPLING"));
            _SETTINGS_TRANSLATIONS.put("ODMS_SAMPLE_SIZE", CoreModelLrb.get("ODMS_SAMPLE_SIZE"));
            _SETTINGS_TRANSLATIONS.put("ODMS_TEXT_MIN_DOCUMENTS", CoreModelLrb.get("ODMS_TEXT_MIN_DOCUMENTS"));
            _SETTINGS_TRANSLATIONS.put("ODMS_ITEM_ID_COLUMN_NAME", CoreModelLrb.get("ODMS_ITEM_ID_COLUMN_NAME"));
            _SETTINGS_TRANSLATIONS.put("ODMS_TEXT_MAX_FEATURES", CoreModelLrb.get("ODMS_TEXT_MAX_FEATURES"));
            _SETTINGS_TRANSLATIONS.put("SVMS_SOLVER", CoreModelLrb.get("SOLVER"));
            _SETTINGS_TRANSLATIONS.put("SVMS_NUM_ITERATIONS", CoreModelLrb.get("NUM_ITERATIONS"));
            _SETTINGS_TRANSLATIONS.put("SVMS_REGULARIZER", CoreModelLrb.get("SVMS_REGULARIZER"));
            _SETTINGS_TRANSLATIONS.put("SVMS_BATCH_ROWS", CoreModelLrb.get("BATCH_ROWS"));
            _SETTINGS_TRANSLATIONS.put("SVMS_NUM_PIVOTS", CoreModelLrb.get("SVMS_NUM_PIVOTS"));
            _SETTINGS_TRANSLATIONS.put("ASSO_IN_RULES", CoreModelLrb.get("ASSO_IN_RULES"));
            _SETTINGS_TRANSLATIONS.put("ASSO_EX_RULES", CoreModelLrb.get("ASSO_EX_RULES"));
            _SETTINGS_TRANSLATIONS.put("ODMS_ITEM_VALUE_COLUMN_NAME", CoreModelLrb.get("ODMS_ITEM_VALUE_COLUMN_NAME"));
            _SETTINGS_TRANSLATIONS.put("ITEMSET_COUNT", CoreModelLrb.get("ITEMSET_COUNT"));
            _SETTINGS_TRANSLATIONS.put("MAX_SUPPORT", CoreModelLrb.get("MAX_SUPPORT"));
            _SETTINGS_TRANSLATIONS.put("RULE_COUNT", CoreModelLrb.get("RULE_COUNT"));
            _SETTINGS_TRANSLATIONS.put("TRANSACTION_COUNT", CoreModelLrb.get("TRANSACTION_COUNT"));
            _SETTINGS_TRANSLATIONS.put("PREP_SHIFT_2DNUM", CoreModelLrb.get("PREP_SHIFT_2DNUM"));
            _SETTINGS_TRANSLATIONS.put("PREP_SCALE_NNUM", CoreModelLrb.get("PREP_SCALE_NNUM"));
            _SETTINGS_TRANSLATIONS.put("PREP_SCALE_2DNUM", CoreModelLrb.get("PREP_SCALE_2DNUM"));
            _SETTINGS_TRANSLATIONS.put("NUM_ROWS", CoreModelLrb.get("NUM_ROWS"));
            _SETTINGS_TRANSLATIONS.put("MODEL_CONVERGED", CoreModelLrb.get("MODEL_CONVERGED"));
            _SETTINGS_TRANSLATIONS.put("CONVERGED", CoreModelLrb.get("MODEL_CONVERGED"));
            _SETTINGS_TRANSLATIONS.put("ITERATIONS", CoreModelLrb.get("ITERATIONS"));
            _SETTINGS_TRANSLATIONS.put("NUM_ITERATIONS", CoreModelLrb.get("NUM_ITERATIONS"));
            _SETTINGS_TRANSLATIONS.put("BATCH_ROWS", CoreModelLrb.get("BATCH_ROWS"));
            _SETTINGS_TRANSLATIONS.put("SOLVER", CoreModelLrb.get("SOLVER"));
            _SETTINGS_TRANSLATIONS.put("RANDOM_SEED", CoreModelLrb.get("RANDOM_SEED"));
            _SETTINGS_TRANSLATIONS.put("NUM_COMPONENTS", CoreModelLrb.get("NUM_COMPONENTS"));
            _SETTINGS_TRANSLATIONS.put("ALGO_EXTENSIBLE_LANG", CoreModelLrb.get("ALGO_EXTENSIBLE_LANG"));
            _SETTINGS_TRANSLATIONS.put("RALG_BUILD_FUNCTION", CoreModelLrb.get("RALG_BUILD_FUNCTION"));
            _SETTINGS_TRANSLATIONS.put("RALG_BUILD_PARAMETER", CoreModelLrb.get("RALG_BUILD_PARAMETER"));
            _SETTINGS_TRANSLATIONS.put("RALG_SCORE_FUNCTION", CoreModelLrb.get("RALG_SCORE_FUNCTION"));
            _SETTINGS_TRANSLATIONS.put("RALG_WEIGHT_FUNCTION", CoreModelLrb.get("RALG_WEIGHT_FUNCTION"));
            _SETTINGS_TRANSLATIONS.put("RALG_DETAILS_FUNCTION", CoreModelLrb.get("RALG_DETAILS_FUNCTION"));
            _SETTINGS_TRANSLATIONS.put("RALG_DETAILS_FORMAT", CoreModelLrb.get("RALG_DETAILS_FORMAT"));
        }
    }
}

