/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.generated.server;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import oracle.dmt.dataminer.core.model.generated.server.DbmsDataMiningTransformEx;
import oracle.dmt.dataminer.core.model.generated.server.OdmrAggregation;
import oracle.dmt.dataminer.core.model.generated.server.OdmrConditionClauses;
import oracle.dmt.dataminer.core.model.generated.server.OdmrImpactReports;
import oracle.dmt.dataminer.core.model.generated.server.OdmrLtableRelationships;
import oracle.dmt.dataminer.core.model.generated.server.OdmrObjectIds;
import oracle.dmt.dataminer.core.model.generated.server.OdmrObjectNames;
import oracle.dmt.dataminer.core.model.generated.server.OdmrTableColumns;
import oracle.dmt.dataminer.core.model.generated.server.OdmrTableMaps;
import oracle.dmt.dataminer.core.model.generated.server.OdmrTables;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.CLOB;
import oracle.sql.ORAData;

public class ODMRPkg_DataGroup {
    protected Connection __onn = null;
    protected DataSource __dataSource = null;

    public void setDataSource(DataSource dataSource) throws SQLException {
        this.release();
        this.__dataSource = dataSource;
    }

    public void setDataSourceLocation(String string) throws SQLException {
        try {
            Class<?> clazz = Class.forName("javax.naming.InitialContext");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("lookup", String.class);
            DataSource dataSource = (DataSource)method.invoke(obj, "java:comp/env/" + string);
            this.setDataSource(dataSource);
        }
        catch (Exception exception) {
            throw new SQLException("Error initializing DataSource at " + string + ": " + exception.getMessage());
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.__onn != null) {
            return this.__onn;
        }
        if (this.__dataSource != null) {
            this.__onn = this.__dataSource.getConnection();
        }
        return this.__onn;
    }

    public void release() throws SQLException {
        this.__onn = null;
        this.__dataSource = null;
    }

    public void closeConnection() {
        if (this.__dataSource != null) {
            try {
                if (this.__onn != null) {
                    this.__onn.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.__onn = null;
        }
    }

    public void setConnection(Connection connection) throws SQLException {
        this.__onn = connection;
    }

    public ODMRPkg_DataGroup() throws SQLException {
    }

    public ODMRPkg_DataGroup(Connection connection) throws SQLException {
        this.__onn = connection;
    }

    public ODMRPkg_DataGroup(DataSource dataSource) throws SQLException {
        this.__dataSource = dataSource;
    }

    public OdmrImpactReports removeGroupTable(BigDecimal bigDecimal, OdmrObjectIds odmrObjectIds, String string) throws SQLException {
        Connection connection = null;
        OdmrImpactReports odmrImpactReports = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.REMOVE_GROUP_TABLE(:2 ,:3 ,:4 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_IMPACT_REPORTS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
            }
            if (string == null) {
                oracleCallableStatement.setNull(4, 1);
            } else {
                oracleCallableStatement.setString(4, string);
            }
            oracleCallableStatement.executeUpdate();
            odmrImpactReports = (OdmrImpactReports)oracleCallableStatement.getORAData(1, OdmrImpactReports.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.REMOVE_GROUP_TABLE(:2 ,:3 ,:4 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_IMPACT_REPORTS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(4, 1);
                } else {
                    oracleCallableStatement.setString(4, string);
                }
                oracleCallableStatement.executeUpdate();
                odmrImpactReports = (OdmrImpactReports)oracleCallableStatement.getORAData(1, OdmrImpactReports.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrImpactReports;
    }

    public OdmrImpactReports deleteGroup(BigDecimal bigDecimal, OdmrObjectIds odmrObjectIds, String string) throws SQLException {
        Connection connection = null;
        OdmrImpactReports odmrImpactReports = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.DELETE_GROUP(:2 ,:3 ,:4 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_IMPACT_REPORTS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
            }
            if (string == null) {
                oracleCallableStatement.setNull(4, 1);
            } else {
                oracleCallableStatement.setString(4, string);
            }
            oracleCallableStatement.executeUpdate();
            odmrImpactReports = (OdmrImpactReports)oracleCallableStatement.getORAData(1, OdmrImpactReports.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.DELETE_GROUP(:2 ,:3 ,:4 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_IMPACT_REPORTS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(4, 1);
                } else {
                    oracleCallableStatement.setString(4, string);
                }
                oracleCallableStatement.executeUpdate();
                odmrImpactReports = (OdmrImpactReports)oracleCallableStatement.getORAData(1, OdmrImpactReports.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrImpactReports;
    }

    public void getLtabExpressionXform(BigDecimal bigDecimal, BigDecimal bigDecimal2, CLOB[] cLOBArray) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_GROUP.GET_LTAB_EXPRESSION_XFORM(:1 ,:2 ,:3 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal2);
            }
            oracleCallableStatement.registerOutParameter(3, 2005);
            oracleCallableStatement.executeUpdate();
            cLOBArray[0] = oracleCallableStatement.getCLOB(3);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_GROUP.GET_LTAB_EXPRESSION_XFORM(:1 ,:2 ,:3 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal2);
                }
                oracleCallableStatement.registerOutParameter(3, 2005);
                oracleCallableStatement.executeUpdate();
                cLOBArray[0] = oracleCallableStatement.getCLOB(3);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public OdmrImpactReports deleteGroup(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string) throws SQLException {
        Connection connection = null;
        OdmrImpactReports odmrImpactReports = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.DELETE_GROUP(:2 ,:3 ,:4 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_IMPACT_REPORTS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(3, 2);
            } else {
                oracleCallableStatement.setBigDecimal(3, bigDecimal2);
            }
            if (string == null) {
                oracleCallableStatement.setNull(4, 1);
            } else {
                oracleCallableStatement.setString(4, string);
            }
            oracleCallableStatement.executeUpdate();
            odmrImpactReports = (OdmrImpactReports)oracleCallableStatement.getORAData(1, OdmrImpactReports.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.DELETE_GROUP(:2 ,:3 ,:4 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_IMPACT_REPORTS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(3, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(3, bigDecimal2);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(4, 1);
                } else {
                    oracleCallableStatement.setString(4, string);
                }
                oracleCallableStatement.executeUpdate();
                odmrImpactReports = (OdmrImpactReports)oracleCallableStatement.getORAData(1, OdmrImpactReports.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrImpactReports;
    }

    public OdmrImpactReports setJoinTable(BigDecimal bigDecimal, BigDecimal bigDecimal2, OdmrTableColumns odmrTableColumns, OdmrLtableRelationships odmrLtableRelationships, OdmrConditionClauses odmrConditionClauses, String string) throws SQLException {
        Connection connection = null;
        OdmrImpactReports odmrImpactReports = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.SET_JOIN_TABLE(:2 ,:3 ,:4 ,:5 ,:6 ,:7 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_IMPACT_REPORTS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(3, 2);
            } else {
                oracleCallableStatement.setBigDecimal(3, bigDecimal2);
            }
            if (odmrTableColumns == null) {
                oracleCallableStatement.setNull(4, 2003, "ODMRSYS.ODMR_TABLE_COLUMNS");
            } else {
                oracleCallableStatement.setORAData(4, (ORAData)odmrTableColumns);
            }
            if (odmrLtableRelationships == null) {
                oracleCallableStatement.setNull(5, 2003, "ODMRSYS.ODMR_LTABLE_RELATIONSHIPS");
            } else {
                oracleCallableStatement.setORAData(5, (ORAData)odmrLtableRelationships);
            }
            if (odmrConditionClauses == null) {
                oracleCallableStatement.setNull(6, 2003, "ODMRSYS.ODMR_CONDITION_CLAUSES");
            } else {
                oracleCallableStatement.setORAData(6, (ORAData)odmrConditionClauses);
            }
            if (string == null) {
                oracleCallableStatement.setNull(7, 1);
            } else {
                oracleCallableStatement.setString(7, string);
            }
            oracleCallableStatement.executeUpdate();
            odmrImpactReports = (OdmrImpactReports)oracleCallableStatement.getORAData(1, OdmrImpactReports.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.SET_JOIN_TABLE(:2 ,:3 ,:4 ,:5 ,:6 ,:7 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_IMPACT_REPORTS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(3, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(3, bigDecimal2);
                }
                if (odmrTableColumns == null) {
                    oracleCallableStatement.setNull(4, 2003, "ODMRSYS.ODMR_TABLE_COLUMNS");
                } else {
                    oracleCallableStatement.setORAData(4, (ORAData)odmrTableColumns);
                }
                if (odmrLtableRelationships == null) {
                    oracleCallableStatement.setNull(5, 2003, "ODMRSYS.ODMR_LTABLE_RELATIONSHIPS");
                } else {
                    oracleCallableStatement.setORAData(5, (ORAData)odmrLtableRelationships);
                }
                if (odmrConditionClauses == null) {
                    oracleCallableStatement.setNull(6, 2003, "ODMRSYS.ODMR_CONDITION_CLAUSES");
                } else {
                    oracleCallableStatement.setORAData(6, (ORAData)odmrConditionClauses);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(7, 1);
                } else {
                    oracleCallableStatement.setString(7, string);
                }
                oracleCallableStatement.executeUpdate();
                odmrImpactReports = (OdmrImpactReports)oracleCallableStatement.getORAData(1, OdmrImpactReports.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrImpactReports;
    }

    public void updateDgTableMap(BigDecimal bigDecimal, OdmrTableMaps odmrTableMaps) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_GROUP.UPDATE_DG_TABLE_MAP(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (odmrTableMaps == null) {
                oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_TABLE_MAPS");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)odmrTableMaps);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_GROUP.UPDATE_DG_TABLE_MAP(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (odmrTableMaps == null) {
                    oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_TABLE_MAPS");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)odmrTableMaps);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public BigDecimal createGroup(BigDecimal bigDecimal, String string, OdmrTables odmrTables, String string2, BigDecimal bigDecimal2, String string3) throws SQLException {
        Connection connection = null;
        BigDecimal bigDecimal3 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.CREATE_GROUP(:2 ,:3 ,:4 ,:5 ,:6 ,:7 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(3, 12);
            } else {
                oracleCallableStatement.setString(3, string);
            }
            if (odmrTables == null) {
                oracleCallableStatement.setNull(4, 2003, "ODMRSYS.ODMR_TABLES");
            } else {
                oracleCallableStatement.setORAData(4, (ORAData)odmrTables);
            }
            if (string2 == null) {
                oracleCallableStatement.setNull(5, 12);
            } else {
                oracleCallableStatement.setString(5, string2);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(6, 2);
            } else {
                oracleCallableStatement.setBigDecimal(6, bigDecimal2);
            }
            if (string3 == null) {
                oracleCallableStatement.setNull(7, 1);
            } else {
                oracleCallableStatement.setString(7, string3);
            }
            oracleCallableStatement.executeUpdate();
            bigDecimal3 = oracleCallableStatement.getBigDecimal(1);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.CREATE_GROUP(:2 ,:3 ,:4 ,:5 ,:6 ,:7 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(3, 12);
                } else {
                    oracleCallableStatement.setString(3, string);
                }
                if (odmrTables == null) {
                    oracleCallableStatement.setNull(4, 2003, "ODMRSYS.ODMR_TABLES");
                } else {
                    oracleCallableStatement.setORAData(4, (ORAData)odmrTables);
                }
                if (string2 == null) {
                    oracleCallableStatement.setNull(5, 12);
                } else {
                    oracleCallableStatement.setString(5, string2);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(6, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(6, bigDecimal2);
                }
                if (string3 == null) {
                    oracleCallableStatement.setNull(7, 1);
                } else {
                    oracleCallableStatement.setString(7, string3);
                }
                oracleCallableStatement.executeUpdate();
                bigDecimal3 = oracleCallableStatement.getBigDecimal(1);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return bigDecimal3;
    }

    public OdmrImpactReports setAggregationTable(BigDecimal bigDecimal, BigDecimal bigDecimal2, OdmrAggregation odmrAggregation, String string) throws SQLException {
        Connection connection = null;
        OdmrImpactReports odmrImpactReports = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.SET_AGGREGATION_TABLE(:2 ,:3 ,:4 ,:5 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_IMPACT_REPORTS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(3, 2);
            } else {
                oracleCallableStatement.setBigDecimal(3, bigDecimal2);
            }
            if (odmrAggregation == null) {
                oracleCallableStatement.setNull(4, 2002, "ODMRSYS.ODMR_AGGREGATION");
            } else {
                oracleCallableStatement.setORAData(4, (ORAData)odmrAggregation);
            }
            if (string == null) {
                oracleCallableStatement.setNull(5, 1);
            } else {
                oracleCallableStatement.setString(5, string);
            }
            oracleCallableStatement.executeUpdate();
            odmrImpactReports = (OdmrImpactReports)oracleCallableStatement.getORAData(1, OdmrImpactReports.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.SET_AGGREGATION_TABLE(:2 ,:3 ,:4 ,:5 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_IMPACT_REPORTS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(3, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(3, bigDecimal2);
                }
                if (odmrAggregation == null) {
                    oracleCallableStatement.setNull(4, 2002, "ODMRSYS.ODMR_AGGREGATION");
                } else {
                    oracleCallableStatement.setORAData(4, (ORAData)odmrAggregation);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(5, 1);
                } else {
                    oracleCallableStatement.setString(5, string);
                }
                oracleCallableStatement.executeUpdate();
                odmrImpactReports = (OdmrImpactReports)oracleCallableStatement.getORAData(1, OdmrImpactReports.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrImpactReports;
    }

    public BigDecimal createAggregationTable(BigDecimal bigDecimal, BigDecimal bigDecimal2, OdmrAggregation odmrAggregation) throws SQLException {
        Connection connection = null;
        BigDecimal bigDecimal3 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.CREATE_AGGREGATION_TABLE(:2 ,:3 ,:4 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(3, 2);
            } else {
                oracleCallableStatement.setBigDecimal(3, bigDecimal2);
            }
            if (odmrAggregation == null) {
                oracleCallableStatement.setNull(4, 2002, "ODMRSYS.ODMR_AGGREGATION");
            } else {
                oracleCallableStatement.setORAData(4, (ORAData)odmrAggregation);
            }
            oracleCallableStatement.executeUpdate();
            bigDecimal3 = oracleCallableStatement.getBigDecimal(1);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.CREATE_AGGREGATION_TABLE(:2 ,:3 ,:4 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(3, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(3, bigDecimal2);
                }
                if (odmrAggregation == null) {
                    oracleCallableStatement.setNull(4, 2002, "ODMRSYS.ODMR_AGGREGATION");
                } else {
                    oracleCallableStatement.setORAData(4, (ORAData)odmrAggregation);
                }
                oracleCallableStatement.executeUpdate();
                bigDecimal3 = oracleCallableStatement.getBigDecimal(1);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return bigDecimal3;
    }

    public void getLtabPhysicalTables(BigDecimal bigDecimal, OdmrObjectIds[] odmrObjectIdsArray, OdmrTableColumns[] odmrTableColumnsArray) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_GROUP.GET_LTAB_PHYSICAL_TABLES(:1 ,:2 ,:3 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            oracleCallableStatement.registerOutParameter(2, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            oracleCallableStatement.registerOutParameter(3, 2003, "ODMRSYS.ODMR_TABLE_COLUMNS");
            oracleCallableStatement.executeUpdate();
            odmrObjectIdsArray[0] = (OdmrObjectIds)oracleCallableStatement.getORAData(2, OdmrObjectIds.getORADataFactory());
            odmrTableColumnsArray[0] = (OdmrTableColumns)oracleCallableStatement.getORAData(3, OdmrTableColumns.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_GROUP.GET_LTAB_PHYSICAL_TABLES(:1 ,:2 ,:3 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                oracleCallableStatement.registerOutParameter(2, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                oracleCallableStatement.registerOutParameter(3, 2003, "ODMRSYS.ODMR_TABLE_COLUMNS");
                oracleCallableStatement.executeUpdate();
                odmrObjectIdsArray[0] = (OdmrObjectIds)oracleCallableStatement.getORAData(2, OdmrObjectIds.getORADataFactory());
                odmrTableColumnsArray[0] = (OdmrTableColumns)oracleCallableStatement.getORAData(3, OdmrTableColumns.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void getMappedDataLtabSql(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string, BigDecimal bigDecimal3, BigDecimal bigDecimal4, OdmrObjectNames[] odmrObjectNamesArray, DbmsDataMiningTransformEx[] dbmsDataMiningTransformExArray) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN JPUB_PLSQL_WRAPPER.ODMR_GROUP$GET_MAPPED_DATA_LT(:1 ,:2 ,:3 ,:4 ,:5 ,:6 ,:7 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal2);
            }
            if (string == null) {
                oracleCallableStatement.setNull(3, 1);
            } else {
                oracleCallableStatement.setString(3, string);
            }
            if (bigDecimal3 == null) {
                oracleCallableStatement.setNull(4, 2);
            } else {
                oracleCallableStatement.setBigDecimal(4, bigDecimal3);
            }
            if (bigDecimal4 == null) {
                oracleCallableStatement.setNull(5, 2);
            } else {
                oracleCallableStatement.setBigDecimal(5, bigDecimal4);
            }
            oracleCallableStatement.registerOutParameter(6, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
            oracleCallableStatement.registerOutParameter(7, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
            oracleCallableStatement.executeUpdate();
            odmrObjectNamesArray[0] = (OdmrObjectNames)oracleCallableStatement.getORAData(6, OdmrObjectNames.getORADataFactory());
            dbmsDataMiningTransformExArray[0] = (DbmsDataMiningTransformEx)oracleCallableStatement.getORAData(7, DbmsDataMiningTransformEx.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN JPUB_PLSQL_WRAPPER.ODMR_GROUP$GET_MAPPED_DATA_LT(:1 ,:2 ,:3 ,:4 ,:5 ,:6 ,:7 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal2);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(3, 1);
                } else {
                    oracleCallableStatement.setString(3, string);
                }
                if (bigDecimal3 == null) {
                    oracleCallableStatement.setNull(4, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(4, bigDecimal3);
                }
                if (bigDecimal4 == null) {
                    oracleCallableStatement.setNull(5, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(5, bigDecimal4);
                }
                oracleCallableStatement.registerOutParameter(6, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
                oracleCallableStatement.registerOutParameter(7, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
                oracleCallableStatement.executeUpdate();
                odmrObjectNamesArray[0] = (OdmrObjectNames)oracleCallableStatement.getORAData(6, OdmrObjectNames.getORADataFactory());
                dbmsDataMiningTransformExArray[0] = (DbmsDataMiningTransformEx)oracleCallableStatement.getORAData(7, DbmsDataMiningTransformEx.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void dropSnapshotTable(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_GROUP.DROP_SNAPSHOT_TABLE(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal2);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_GROUP.DROP_SNAPSHOT_TABLE(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal2);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void renameGroup(BigDecimal bigDecimal, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_GROUP.RENAME_GROUP(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(2, 12);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_GROUP.RENAME_GROUP(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(2, 12);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public OdmrImpactReports synchronizeGroup(BigDecimal bigDecimal, String string) throws SQLException {
        Connection connection = null;
        OdmrImpactReports odmrImpactReports = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.SYNCHRONIZE_GROUP(:2 ,:3 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_IMPACT_REPORTS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(3, 1);
            } else {
                oracleCallableStatement.setString(3, string);
            }
            oracleCallableStatement.executeUpdate();
            odmrImpactReports = (OdmrImpactReports)oracleCallableStatement.getORAData(1, OdmrImpactReports.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.SYNCHRONIZE_GROUP(:2 ,:3 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_IMPACT_REPORTS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(3, 1);
                } else {
                    oracleCallableStatement.setString(3, string);
                }
                oracleCallableStatement.executeUpdate();
                odmrImpactReports = (OdmrImpactReports)oracleCallableStatement.getORAData(1, OdmrImpactReports.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrImpactReports;
    }

    public void getLtabExpression(BigDecimal bigDecimal, BigDecimal bigDecimal2, CLOB[] cLOBArray) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_GROUP.GET_LTAB_EXPRESSION(:1 ,:2 ,:3 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal2);
            }
            oracleCallableStatement.registerOutParameter(3, 2005);
            oracleCallableStatement.executeUpdate();
            cLOBArray[0] = oracleCallableStatement.getCLOB(3);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_GROUP.GET_LTAB_EXPRESSION(:1 ,:2 ,:3 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal2);
                }
                oracleCallableStatement.registerOutParameter(3, 2005);
                oracleCallableStatement.executeUpdate();
                cLOBArray[0] = oracleCallableStatement.getCLOB(3);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public BigDecimal createTransformationTable(BigDecimal bigDecimal, String string, BigDecimal bigDecimal2) throws SQLException {
        Connection connection = null;
        BigDecimal bigDecimal3 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.CREATE_TRANSFORMATION_TABLE(:2 ,:3 ,:4 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(3, 12);
            } else {
                oracleCallableStatement.setString(3, string);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(4, 2);
            } else {
                oracleCallableStatement.setBigDecimal(4, bigDecimal2);
            }
            oracleCallableStatement.executeUpdate();
            bigDecimal3 = oracleCallableStatement.getBigDecimal(1);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.CREATE_TRANSFORMATION_TABLE(:2 ,:3 ,:4 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(3, 12);
                } else {
                    oracleCallableStatement.setString(3, string);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(4, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(4, bigDecimal2);
                }
                oracleCallableStatement.executeUpdate();
                bigDecimal3 = oracleCallableStatement.getBigDecimal(1);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return bigDecimal3;
    }

    public BigDecimal createDgTableMaps(BigDecimal bigDecimal, String string, BigDecimal bigDecimal2, OdmrTableMaps odmrTableMaps) throws SQLException {
        Connection connection = null;
        BigDecimal bigDecimal3 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.CREATE_DG_TABLE_MAPS(:2 ,:3 ,:4 ,:5 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(3, 1);
            } else {
                oracleCallableStatement.setString(3, string);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(4, 2);
            } else {
                oracleCallableStatement.setBigDecimal(4, bigDecimal2);
            }
            if (odmrTableMaps == null) {
                oracleCallableStatement.setNull(5, 2003, "ODMRSYS.ODMR_TABLE_MAPS");
            } else {
                oracleCallableStatement.setORAData(5, (ORAData)odmrTableMaps);
            }
            oracleCallableStatement.executeUpdate();
            bigDecimal3 = oracleCallableStatement.getBigDecimal(1);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.CREATE_DG_TABLE_MAPS(:2 ,:3 ,:4 ,:5 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(3, 1);
                } else {
                    oracleCallableStatement.setString(3, string);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(4, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(4, bigDecimal2);
                }
                if (odmrTableMaps == null) {
                    oracleCallableStatement.setNull(5, 2003, "ODMRSYS.ODMR_TABLE_MAPS");
                } else {
                    oracleCallableStatement.setORAData(5, (ORAData)odmrTableMaps);
                }
                oracleCallableStatement.executeUpdate();
                bigDecimal3 = oracleCallableStatement.getBigDecimal(1);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return bigDecimal3;
    }

    public BigDecimal createJoinTable(BigDecimal bigDecimal, String string, OdmrTableColumns odmrTableColumns, OdmrLtableRelationships odmrLtableRelationships, OdmrConditionClauses odmrConditionClauses) throws SQLException {
        Connection connection = null;
        BigDecimal bigDecimal2 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.CREATE_JOIN_TABLE(:2 ,:3 ,:4 ,:5 ,:6 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(3, 12);
            } else {
                oracleCallableStatement.setString(3, string);
            }
            if (odmrTableColumns == null) {
                oracleCallableStatement.setNull(4, 2003, "ODMRSYS.ODMR_TABLE_COLUMNS");
            } else {
                oracleCallableStatement.setORAData(4, (ORAData)odmrTableColumns);
            }
            if (odmrLtableRelationships == null) {
                oracleCallableStatement.setNull(5, 2003, "ODMRSYS.ODMR_LTABLE_RELATIONSHIPS");
            } else {
                oracleCallableStatement.setORAData(5, (ORAData)odmrLtableRelationships);
            }
            if (odmrConditionClauses == null) {
                oracleCallableStatement.setNull(6, 2003, "ODMRSYS.ODMR_CONDITION_CLAUSES");
            } else {
                oracleCallableStatement.setORAData(6, (ORAData)odmrConditionClauses);
            }
            oracleCallableStatement.executeUpdate();
            bigDecimal2 = oracleCallableStatement.getBigDecimal(1);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.CREATE_JOIN_TABLE(:2 ,:3 ,:4 ,:5 ,:6 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(3, 12);
                } else {
                    oracleCallableStatement.setString(3, string);
                }
                if (odmrTableColumns == null) {
                    oracleCallableStatement.setNull(4, 2003, "ODMRSYS.ODMR_TABLE_COLUMNS");
                } else {
                    oracleCallableStatement.setORAData(4, (ORAData)odmrTableColumns);
                }
                if (odmrLtableRelationships == null) {
                    oracleCallableStatement.setNull(5, 2003, "ODMRSYS.ODMR_LTABLE_RELATIONSHIPS");
                } else {
                    oracleCallableStatement.setORAData(5, (ORAData)odmrLtableRelationships);
                }
                if (odmrConditionClauses == null) {
                    oracleCallableStatement.setNull(6, 2003, "ODMRSYS.ODMR_CONDITION_CLAUSES");
                } else {
                    oracleCallableStatement.setORAData(6, (ORAData)odmrConditionClauses);
                }
                oracleCallableStatement.executeUpdate();
                bigDecimal2 = oracleCallableStatement.getBigDecimal(1);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return bigDecimal2;
    }

    public OdmrObjectIds addGroupTable(BigDecimal bigDecimal, OdmrTables odmrTables, BigDecimal bigDecimal2, String string) throws SQLException {
        Connection connection = null;
        OdmrObjectIds odmrObjectIds = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.ADD_GROUP_TABLE(:2 ,:3 ,:4 ,:5 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (odmrTables == null) {
                oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_TABLES");
            } else {
                oracleCallableStatement.setORAData(3, (ORAData)odmrTables);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(4, 2);
            } else {
                oracleCallableStatement.setBigDecimal(4, bigDecimal2);
            }
            if (string == null) {
                oracleCallableStatement.setNull(5, 1);
            } else {
                oracleCallableStatement.setString(5, string);
            }
            oracleCallableStatement.executeUpdate();
            odmrObjectIds = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_GROUP.ADD_GROUP_TABLE(:2 ,:3 ,:4 ,:5 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (odmrTables == null) {
                    oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_TABLES");
                } else {
                    oracleCallableStatement.setORAData(3, (ORAData)odmrTables);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(4, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(4, bigDecimal2);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(5, 1);
                } else {
                    oracleCallableStatement.setString(5, string);
                }
                oracleCallableStatement.executeUpdate();
                odmrObjectIds = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrObjectIds;
    }

    public void refreshTable(BigDecimal bigDecimal, OdmrObjectIds odmrObjectIds, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_GROUP.REFRESH_TABLE(:1 ,:2 ,:3 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)odmrObjectIds);
            }
            if (string == null) {
                oracleCallableStatement.setNull(3, 1);
            } else {
                oracleCallableStatement.setString(3, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_GROUP.REFRESH_TABLE(:1 ,:2 ,:3 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)odmrObjectIds);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(3, 1);
                } else {
                    oracleCallableStatement.setString(3, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void getAtnInputDataSql(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string, OdmrObjectNames[] odmrObjectNamesArray, DbmsDataMiningTransformEx[] dbmsDataMiningTransformExArray) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN JPUB_PLSQL_WRAPPER.ODMR_GROUP$GET_ATN_INPUT_DATA(:1 ,:2 ,:3 ,:4 ,:5 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal2);
            }
            if (string == null) {
                oracleCallableStatement.setNull(3, 1);
            } else {
                oracleCallableStatement.setString(3, string);
            }
            oracleCallableStatement.registerOutParameter(4, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
            oracleCallableStatement.registerOutParameter(5, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
            oracleCallableStatement.executeUpdate();
            odmrObjectNamesArray[0] = (OdmrObjectNames)oracleCallableStatement.getORAData(4, OdmrObjectNames.getORADataFactory());
            dbmsDataMiningTransformExArray[0] = (DbmsDataMiningTransformEx)oracleCallableStatement.getORAData(5, DbmsDataMiningTransformEx.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN JPUB_PLSQL_WRAPPER.ODMR_GROUP$GET_ATN_INPUT_DATA(:1 ,:2 ,:3 ,:4 ,:5 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal2);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(3, 1);
                } else {
                    oracleCallableStatement.setString(3, string);
                }
                oracleCallableStatement.registerOutParameter(4, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
                oracleCallableStatement.registerOutParameter(5, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
                oracleCallableStatement.executeUpdate();
                odmrObjectNamesArray[0] = (OdmrObjectNames)oracleCallableStatement.getORAData(4, OdmrObjectNames.getORADataFactory());
                dbmsDataMiningTransformExArray[0] = (DbmsDataMiningTransformEx)oracleCallableStatement.getORAData(5, DbmsDataMiningTransformEx.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void createSnapshotTable(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, BigDecimal bigDecimal4, BigDecimal bigDecimal5) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_GROUP.CREATE_SNAPSHOT_TABLE(:1 ,:2 ,:3 ,:4 ,:5 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal2);
            }
            if (bigDecimal3 == null) {
                oracleCallableStatement.setNull(3, 2);
            } else {
                oracleCallableStatement.setBigDecimal(3, bigDecimal3);
            }
            if (bigDecimal4 == null) {
                oracleCallableStatement.setNull(4, 2);
            } else {
                oracleCallableStatement.setBigDecimal(4, bigDecimal4);
            }
            if (bigDecimal5 == null) {
                oracleCallableStatement.setNull(5, 2);
            } else {
                oracleCallableStatement.setBigDecimal(5, bigDecimal5);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_GROUP.CREATE_SNAPSHOT_TABLE(:1 ,:2 ,:3 ,:4 ,:5 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal2);
                }
                if (bigDecimal3 == null) {
                    oracleCallableStatement.setNull(3, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(3, bigDecimal3);
                }
                if (bigDecimal4 == null) {
                    oracleCallableStatement.setNull(4, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(4, bigDecimal4);
                }
                if (bigDecimal5 == null) {
                    oracleCallableStatement.setNull(5, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(5, bigDecimal5);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void getInputData(BigDecimal bigDecimal, OdmrObjectNames[] odmrObjectNamesArray, DbmsDataMiningTransformEx[] dbmsDataMiningTransformExArray) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN JPUB_PLSQL_WRAPPER.ODMR_GROUP$GET_INPUT_DATA(:1 ,:2 ,:3 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            oracleCallableStatement.registerOutParameter(2, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
            if (odmrObjectNamesArray[0] == null) {
                oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)odmrObjectNamesArray[0]);
            }
            oracleCallableStatement.registerOutParameter(3, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
            if (dbmsDataMiningTransformExArray[0] == null) {
                oracleCallableStatement.setNull(3, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
            } else {
                oracleCallableStatement.setORAData(3, (ORAData)dbmsDataMiningTransformExArray[0]);
            }
            oracleCallableStatement.executeUpdate();
            odmrObjectNamesArray[0] = (OdmrObjectNames)oracleCallableStatement.getORAData(2, OdmrObjectNames.getORADataFactory());
            dbmsDataMiningTransformExArray[0] = (DbmsDataMiningTransformEx)oracleCallableStatement.getORAData(3, DbmsDataMiningTransformEx.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN JPUB_PLSQL_WRAPPER.ODMR_GROUP$GET_INPUT_DATA(:1 ,:2 ,:3 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                oracleCallableStatement.registerOutParameter(2, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
                if (odmrObjectNamesArray[0] == null) {
                    oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)odmrObjectNamesArray[0]);
                }
                oracleCallableStatement.registerOutParameter(3, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
                if (dbmsDataMiningTransformExArray[0] == null) {
                    oracleCallableStatement.setNull(3, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
                } else {
                    oracleCallableStatement.setORAData(3, (ORAData)dbmsDataMiningTransformExArray[0]);
                }
                oracleCallableStatement.executeUpdate();
                odmrObjectNamesArray[0] = (OdmrObjectNames)oracleCallableStatement.getORAData(2, OdmrObjectNames.getORADataFactory());
                dbmsDataMiningTransformExArray[0] = (DbmsDataMiningTransformEx)oracleCallableStatement.getORAData(3, DbmsDataMiningTransformEx.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setGroupComment(BigDecimal bigDecimal, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_GROUP.SET_GROUP_COMMENT(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(2, 12);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_GROUP.SET_GROUP_COMMENT(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(2, 12);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }
}

