/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.format;

import java.io.IOException;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.format.CodeFragment;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.SerializedData;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPaneContainer;

public class EmbedCommand
extends Command {
    private UndoableEdit _undoableEdit;
    private boolean toClipboard;
    private Language language;

    public EmbedCommand(Context context, boolean bl, Language language) {
        super(-1, 0, "Embed SQL Command");
        this.toClipboard = bl;
        this.language = language;
        this.context = context;
    }

    public int doit() {
        if (this._undoableEdit == null) {
            View view = this.context.getView();
            if (view instanceof BasicEditorPaneContainer) {
                TextNode textNode = (TextNode)this.context.getNode();
                TextBuffer textBuffer = textNode.acquireTextBuffer();
                textBuffer.beginEdit();
                CodeFragment codeFragment = new CodeFragment(this.context);
                String string = this.formatScript(codeFragment.source);
                if (!this.toClipboard) {
                    if (0 != codeFragment.selectionEnd) {
                        textBuffer.remove(codeFragment.selectionStart, codeFragment.selectionEnd - codeFragment.selectionStart);
                    } else {
                        textBuffer.removeToEnd(0);
                    }
                    textBuffer.insert(codeFragment.selectionStart, string.toCharArray());
                } else {
                    UIUtils.setClipboard((String)string);
                }
                this._undoableEdit = textBuffer.endEdit();
                textNode.releaseTextBuffer();
            }
        } else {
            this._undoableEdit.redo();
        }
        return 0;
    }

    private String formatScript(String string) {
        StringBuilder stringBuilder = new StringBuilder("String sql = \"");
        String string2 = "\"";
        String string3 = "+";
        String string4 = "\\n\"";
        if (this.language == Language.PYTHON) {
            stringBuilder = new StringBuilder("var sql = " + string2);
        }
        if (this.language == Language.PLSQL) {
            string2 = "'";
            string3 = " || ";
            string4 = " '|| chr(10) ";
            stringBuilder = new StringBuilder("sql varchar2(4000) := " + string2);
        }
        for (LexerToken lexerToken : LexerToken.parse((String)string, (boolean)true)) {
            if (lexerToken.content.equals("\n")) {
                stringBuilder.append(string4 + string3 + "\n" + string2);
                continue;
            }
            if (lexerToken.content.equals("\r")) continue;
            stringBuilder.append(lexerToken.content);
        }
        stringBuilder.append(string2 + ";");
        Object object = stringBuilder.toString();
        if (SerializedData.getInstance().embedExposeLangIndex == 0 && SerializedData.getInstance().embedExposeIsVerbose) {
            object = this.verbose((String)object);
        }
        return object;
    }

    private String verbose(String string) {
        String string2 = string;
        try {
            string2 = Service.readFile(EmbedCommand.class, (String)"verbose.java.sql");
            string2 = string2.replace("String sql = \"select DEPTNO, DNAME, LOC from DEPT\";", string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string2;
    }

    public int undo() throws Exception {
        this._undoableEdit.undo();
        return 0;
    }

    public static enum Language {
        JAVA,
        PYTHON,
        PLSQL;

    }
}

