/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.format;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.format.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.config.CustomFormat;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;

public class FormatCommand
extends Command {
    private UndoableEdit _undoableEdit;

    public FormatCommand(Context context) {
        super(-1, 0, "Format SQL Command");
        this.context = context;
    }

    public FormatCommand(Context context, boolean bl) {
        super(-1, 0, "Format SQL Command");
        this.context = context;
    }

    public int doit() {
        if (this._undoableEdit == null) {
            View view = this.context.getView();
            if (view instanceof BasicEditorPaneContainer) {
                BasicEditorPaneContainer basicEditorPaneContainer = (BasicEditorPaneContainer)view;
                final BasicEditorPane basicEditorPane = basicEditorPaneContainer.getFocusedEditorPane();
                if (basicEditorPane == null) {
                    return 0;
                }
                final TextNode textNode = (TextNode)this.context.getNode();
                RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("FormatCommand.Formatting"), true, IRaptorTaskRunMode.IDE_STATUSBAR){
                    Thread thread;

                    protected Void doWork() throws TaskException {
                        this.thread = Thread.currentThread();
                        FormatCommand.this.formatCode(basicEditorPane, textNode);
                        return null;
                    }

                    public boolean cancel() {
                        if (this.thread != null) {
                            System.out.println("interrupting thread " + this.thread.getName());
                            this.thread.interrupt();
                        }
                        return super.cancel();
                    }
                };
                RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
            }
        } else {
            this._undoableEdit.redo();
        }
        return 0;
    }

    public void formatCode(final BasicEditorPane basicEditorPane, final TextNode textNode) {
        String string;
        Caret caret = basicEditorPane.getCaret();
        final CustomFormat customFormat = CustomFormat.getInstance();
        customFormat.inputPos = caret.getDot();
        final int n = basicEditorPane.getSelectionStart();
        final int n2 = basicEditorPane.getSelectionEnd();
        final boolean bl = n2 - n > 0;
        String string2 = null;
        if (bl) {
            try {
                string2 = basicEditorPane.getDocument().getText(n, n2 - n);
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
            }
        } else {
            string2 = basicEditorPane.getText();
        }
        try {
            string = customFormat.format(string2);
        }
        catch (IOException iOException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
            return;
        }
        catch (AssertionError assertionError) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, ((Throwable)((Object)assertionError)).getStackTrace()[0].toString(), (Throwable)((Object)assertionError));
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TextBuffer textBuffer = textNode.acquireTextBuffer();
                try {
                    String string2;
                    int n3;
                    textBuffer.beginEdit();
                    if (bl) {
                        textBuffer.remove(n, n2 - n);
                        textBuffer.insert(n, string.toCharArray());
                    } else {
                        textBuffer.removeToEnd(0);
                        textBuffer.insert(0, string.toCharArray());
                    }
                    int n22 = customFormat.outputPos;
                    if (bl && n22 < n) {
                        n22 = n;
                    }
                    if (0 < (n3 = (string2 = basicEditorPane.getDocument().getText(0, basicEditorPane.getDocument().getLength())).indexOf("/*** Syntax Error at line"))) {
                        n22 = n3;
                    }
                    basicEditorPane.setCaretPosition(n22);
                }
                catch (Throwable throwable) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
                }
                finally {
                    FormatCommand.this._undoableEdit = textBuffer.endEdit();
                    textNode.releaseTextBuffer();
                }
            }
        });
    }

    public int undo() throws Exception {
        this._undoableEdit.undo();
        return 0;
    }
}

