/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.awt.Component;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import oracle.dbtools.db.ChameleonConnection;
import oracle.dbtools.parser.plsql.Item;
import oracle.dbtools.parser.plsql.Messages;
import oracle.dbtools.parser.plsql.OrdsItem;
import oracle.dbtools.parser.plsql.Query;
import oracle.dbtools.raptor.newscriptrunner.commands.HiddenParameters;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdeveloper.db.ConnectionException;
import oracle.sql.Datum;

public class DictionaryQuery {
    private static final Logger logger = Logger.getLogger(Query.class.getName());
    private String connectionName;
    private StringBuffer query = new StringBuffer();
    private List<String> binds = new ArrayList<String>();
    private static Map<String, Map<String, Boolean>> DbaViews = new HashMap<String, Map<String, Boolean>>();
    private static final String OBJ_LIKE_CRITERIA = " and object_name like :object_name ";
    private static final String UPPER_OBJ_LIKE_CRITERIA = " and upper(object_name) like :object_name ";
    private static final String DATABASE_LINK_LIKE_CRITERIA = " and db_link like :db_link ";
    private static final String OBJ_CRITERIA = " and object_name = :object_name ";
    private static final String OBJECT_TYPE_CRITERIA = " and object_type = :object_type ";
    private static final String OBJECT_TYPES_CRITERIA_START = " and object_type in (";
    private static final String QUESTION_MARK = " :";
    private static final String NEXT = ",";
    private static final String END = " )";
    private static final String OWNER_CRITERIA = " and owner = :owner ";
    private static final String OWNER_CRITERIA_START = " and owner in (";
    private static final String O_OWNER_CRITERIA_START = " and o.owner in (";
    private static final String LOG_OWNER_CRITERIA_START = " and log_owner in (";
    private static final String OBJ_LIKE_CRITERIA_MAT_VIEW_LOG = " and master like :master ";
    private static final String REF_LIKE_CRITERIA = " and referenced_name like :referenced_name ";
    private static final String TYPES_CRITERIA_START = " and type in (";
    private static final String PARSING_SCHEMA_CRITERIA_START = " and s.parsing_schema in (";
    private final String QUERY_ALL_COLUMNS = "select c.column_name name, -1 LINE, -1 COL, null USAGE, 'COLUMN' TYPE, c.OWNER, o.object_type OBJECT_TYPE, c.table_NAME OBJECT_NAME \n from sys.all_tab_columns c, all_objects o \n where c.table_name=o.object_name and c.owner = o.owner and rownum <= " + this.limit() + " and o.object_type != 'TABLE PARTITION' and o.object_type != 'TABLE SUBPARTITION'";
    private static final String COL_LIKE_CRITERIA = " and c.column_name like :colname ";
    private final String QUERY_ALL_IDENTIFIERS = "select name, LINE, COL, USAGE, TYPE, OWNER, OBJECT_TYPE, OBJECT_NAME \n from sys.all_identifiers where rownum <= " + this.limit();
    private static final String NAME_LIKE_CRITERIA = " and name like :name ";
    private static final String USAGE_CRITERIA_START = " and usage in (";
    private static final String TYPE_CRITERIA_START = " and type in (";
    private final String QUERY_ALL_STATEMENTS = "select text name, LINE, COL, null USAGE, object_type TYPE, OWNER, OBJECT_TYPE, OBJECT_NAME \n from sys.all_statements where rownum <= " + this.limit() + " \n and upper(text) like upper(:text1) \n";
    private static final String NAME_CRITERIA = " and name = :name ";
    private final String QUERY_ORDS = "select DBMS_LOB.SUBSTR(source,32000,1) name, 1 LINE, instr(upper(source),upper(:text)) COL, h.method USAGE, '" + Item.ordsSrc + "' TYPE, s.parsing_schema OWNER, source_type OBJECT_TYPE, \nt.uri_template ||'->'|| m.name    OBJECT_NAME \n from ords_metadata.user_ords_handlers h, ords_metadata.user_ords_templates t, ords_metadata.user_ords_modules m, ords_metadata.user_ords_schemas s \n where rownum <= " + this.limit() + " \n and t.id = h.template_id and t.module_id = m.id and m.schema_id = s.id \n and upper(source) like upper(:text1) \n";
    private final String QUERY_ALL_VIEWS = "select * from all_views where text_length < 32767 \n";
    private final String QUERY_ALL_PROCEDURES = "select procedure_name name, -1 LINE, -1 COL, null USAGE, object_type TYPE, OWNER, object_type OBJECT_TYPE, OBJECT_NAME \n from sys.all_procedures where rownum < " + this.limit();
    private static final String PKG_NAME = " and object_name = :oname ";
    private static final String PROC_NAME = " and procedure_name = :procname ";
    private int pos = 1;
    private static final String PLSQL_OBJ_TYPES = " and object_type in ('PROCEDURE','FUNCTION','PACKAGE') ";
    boolean prepareAllIdCalled = false;
    PreparedStatement ps = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convert2Dba(String string, String string2) {
        String string3;
        Boolean bl;
        String string4 = string.toUpperCase();
        if (!string4.startsWith("ALL_")) {
            return string;
        }
        Map<String, Boolean> map = DbaViews.get(string2);
        if (map == null) {
            map = new HashMap<String, Boolean>();
            DbaViews.put(string2, map);
        }
        if ((bl = map.get(string3 = "Dba_" + string4.substring("ALL_".length()))) == null) {
            Statement statement = null;
            try {
                Connection connection = ChameleonConnection.getConnection(string2);
                if (connection != null) {
                    statement = connection.createStatement();
                    statement.execute("select 1 from " + string3 + " where 1=2");
                    bl = true;
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 942) {
                    logger.severe(this.query.toString());
                    logger.severe(sQLException.getMessage());
                } else {
                    bl = false;
                }
            }
            catch (DBException dBException) {
                logger.severe(dBException.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.severe(classNotFoundException.getMessage());
            }
            catch (ConnectionException connectionException) {
                logger.severe(connectionException.getMessage());
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
                map.put(string3, bl);
            }
        }
        if (bl.booleanValue()) {
            return string3;
        }
        return string;
    }

    public DictionaryQuery(String string, String string2, boolean bl) {
        this.connectionName = string;
    }

    public DictionaryQuery(String string, String string2) {
        this.connectionName = string;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public int limit() {
        return 500;
    }

    public String QUERY_ALL_OBJECTS() {
        return "select null name, -1 LINE, -1 COL, null USAGE, \ncase when obj.object_type like 'JAVA%' then 'JAVA' else obj.object_type end  TYPE, \nOWNER, case when obj.object_type like 'JAVA%' then 'JAVA' else obj.object_type end  OBJECT_TYPE, \nobj.OBJECT_NAME \n from sys." + this.convert2Dba("all_objects", this.connectionName) + " obj where rownum <= " + this.limit() + " and obj.object_type != 'TABLE PARTITION' and obj.object_type != 'TABLE SUBPARTITION' and obj.object_type != 'JAVA CLASS'";
    }

    public final String QUERY_MAT_VIEW_LOG_OBJECTS() {
        return "select null name, -1 LINE, -1 COL, null USAGE, \n 'MATERIALIZED VIEW LOG' TYPE, log_owner OWNER, \n 'MATERIALIZED VIEW LOG' OBJECT_TYPE, master||'('||LOG_TABLE||')' OBJECT_NAME \n from all_snapshot_logs where rownum <= " + this.limit();
    }

    private String QUERY_ALL_SOURCE() {
        return "select text name, LINE, instr(upper(text),upper(:text)) COL, null USAGE, TYPE, OWNER, type OBJECT_TYPE, name OBJECT_NAME \n from sys." + this.convert2Dba("all_source", this.connectionName) + " where rownum <= " + this.limit() + " \n and upper(text) like upper(:text1) and name not like 'BIN$%' \n";
    }

    private String searchViews(String string, String string2) {
        if (string2.length() < 2) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Messages.getString("Query.2"), (String)Messages.getString("Query.1"), null);
            throw new AssertionError((Object)"Query.2");
        }
        string2 = string2.toUpperCase();
        string2 = string2.replace("%", "");
        String string3 = "declare\n    l_search     varchar2(1000) := '" + string2 + "';\n    text         VARCHAR2(32767);\n    l_char       VARCHAR2(32767);\n    l_rc         SYS_REFCURSOR;\n    TYPE strtbl IS\n        TABLE OF VARCHAR2(1000) INDEX BY BINARY_INTEGER;\n    l_st         strtbl;\n    cnt          INTEGER;\n    match_pos    INTEGER;\n    line_begin   INTEGER;\n    line_end     INTEGER;\nBEGIN\n    cnt := 1;\n    FOR rec IN (" + string + ") LOOP\n        text := upper(rec.text);\n        line_begin := 1;\n        line_end := rec.text_length;\n        match_pos := instr(\n            text,\n            l_search\n        );\n        WHILE 0 < match_pos LOOP\n            IF instr(\n                text,\n                chr(10),\n                match_pos\n            ) > 0 THEN\n                line_end := instr(\n                    text,\n                    chr(10),\n                    match_pos\n                ) - 1;\n            ELSE\n                line_end := rec.text_length; \n            END IF;\n            l_char := substr(\n                    text,\n                    1,\n                    line_end\n            );\n\n            IF instr(\n                l_char,\n                chr(10),\n                -1\n            ) > 0 THEN\n                line_begin := instr(\n                    l_char,\n                    chr(10),\n                    -1\n                ) + 1;\n                l_char := substr(\n                    l_char,\n                    line_begin                \n                );\n            END IF;\n\n            l_st(cnt) := substr(rec.owner || '.' || rec.view_name ||'->' || l_char,1,1000);\n\n            cnt := cnt + 1;\n            match_pos := instr(\n                text,\n                l_search,\n                line_end\n            );\n        END LOOP;\n\n        EXIT WHEN\n            500 < cnt;\n    END LOOP;\n\n    ?:= l_st;\nEND;\n";
        return string3;
    }

    public final String QUERY_DATABASE_LINK() {
        return "select null name, -1 LINE, -1 COL, null USAGE, \n 'DATABASE LINK' TYPE, owner OWNER, \n 'DATABASE LINK' OBJECT_TYPE, db_link OBJECT_NAME \n from " + this.convert2Dba("all_db_links", this.connectionName) + " where rownum <= " + this.limit();
    }

    public String QUERY_ALL_DEPENDENCIES() {
        return "select referenced_name||'-REF' name, -1 LINE, -1 COL, null USAGE, \ncase when obj.type like 'JAVA%' then 'JAVA' else obj.type end  TYPE, \nOWNER, case when obj.type like 'JAVA%' then 'JAVA' else obj.type end  OBJECT_TYPE, \nobj.name OBJECT_NAME \n from sys." + this.convert2Dba("all_dependencies", this.connectionName) + " obj where rownum <= " + this.limit() + " and obj.type != 'TABLE PARTITION' and obj.type != 'TABLE SUBPARTITION' and obj.type != 'JAVA CLASS'";
    }

    public void prepareAllObjects(String string, String string2) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string3 = this.QUERY_ALL_OBJECTS();
        if (string != null && !"".equals(string) && string.indexOf(46) > 0) {
            String string4 = string.substring(0, string.indexOf(46));
            string = string.substring(string.indexOf(46) + 1);
            string3 = string3 + OWNER_CRITERIA;
            this.binds.add(string4.toUpperCase());
        }
        if (string != null && !"".equals(string)) {
            string3 = this.isMixedCase(string) ? string3 + UPPER_OBJ_LIKE_CRITERIA : string3 + OBJ_LIKE_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string));
        }
        if (!(string2 == null || "ALL".equals(string2) || "ALL OBJECTS".equals(string2) || "".equals(string2))) {
            string3 = string3 + OBJECT_TYPE_CRITERIA;
            this.binds.add(string2.toUpperCase());
        }
        this.query.append(string3);
    }

    protected String conditionalUpperCase(String string) {
        if (this.isMixedCase(string)) {
            return string.substring(1, string.length() - 1);
        }
        return string.toUpperCase();
    }

    protected boolean isMixedCase(String string) {
        return string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"';
    }

    public void prepareAllDependencies(String string, String[] stringArray, String[] stringArray2) {
        String string2;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string3 = this.QUERY_ALL_DEPENDENCIES();
        if (string != null && !"".equals(string)) {
            string3 = string3 + REF_LIKE_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string));
        }
        if (stringArray != null && stringArray.length > 0) {
            string3 = string3 + " and type in (";
            string2 = "";
            for (String string4 : stringArray) {
                string3 = string3 + string2 + QUESTION_MARK + this.pos++;
                this.binds.add(string4.toUpperCase());
                string2 = NEXT;
            }
            string3 = string3 + END;
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            string3 = string3 + OWNER_CRITERIA_START;
            string2 = "";
            for (String string4 : stringArray2) {
                string3 = string3 + string2 + QUESTION_MARK + this.pos++;
                this.binds.add(this.conditionalUpperCase(string4));
                string2 = NEXT;
            }
            string3 = string3 + END;
        }
        this.query.append(string3);
    }

    public void prepareAllObjects(String string, String[] stringArray, String[] stringArray2) {
        String string2;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        boolean bl = stringArray != null && stringArray.length == 0;
        boolean bl2 = stringArray != null && stringArray.length == 0;
        boolean bl3 = stringArray != null && stringArray.length == 0;
        String string3 = this.QUERY_ALL_OBJECTS();
        if (string != null && !"".equals(string)) {
            string3 = this.isMixedCase(string) ? string3 + UPPER_OBJ_LIKE_CRITERIA : string3 + OBJ_LIKE_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string));
        }
        if (stringArray != null && stringArray.length > 0) {
            string3 = string3 + OBJECT_TYPES_CRITERIA_START;
            string2 = "";
            for (String string4 : stringArray) {
                string3 = string3 + string2 + QUESTION_MARK + this.pos++;
                this.binds.add(string4.toUpperCase());
                string2 = NEXT;
                if (string4.equals("MATERIALIZED VIEW LOG")) {
                    bl = true;
                    continue;
                }
                if (string4.equals("DATABASE LINK")) {
                    bl2 = true;
                    continue;
                }
                bl3 = true;
            }
            string3 = string3 + END;
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            string3 = string3 + OWNER_CRITERIA_START;
            string2 = "";
            for (String string4 : stringArray2) {
                string3 = string3 + string2 + QUESTION_MARK + this.pos++;
                this.binds.add(this.conditionalUpperCase(string4));
                string2 = NEXT;
            }
            if (this.containsSyn(stringArray)) {
                string3 = string3 + string2 + "'PUBLIC'";
                string2 = NEXT;
            }
            string3 = string3 + END;
        }
        if (!bl3) {
            string3 = "";
            this.binds.clear();
            this.pos = 1;
        }
        if (bl) {
            if (bl3) {
                string3 = string3 + "\n union all \n";
            }
            string3 = string3 + this.QUERY_MAT_VIEW_LOG_OBJECTS();
            if (stringArray2 != null && stringArray2.length > 0) {
                string3 = string3 + LOG_OWNER_CRITERIA_START;
                string2 = "";
                for (String string4 : stringArray2) {
                    string3 = string3 + string2 + QUESTION_MARK + this.pos++;
                    this.binds.add(this.conditionalUpperCase(string4));
                    string2 = NEXT;
                }
                string3 = string3 + END;
            }
            if (string != null && !"".equals(string)) {
                string3 = string3 + OBJ_LIKE_CRITERIA_MAT_VIEW_LOG;
                this.binds.add(string.toUpperCase());
            }
        }
        if (bl2) {
            if (bl3 || bl) {
                string3 = string3 + "\n union \n";
            }
            string3 = string3 + this.QUERY_DATABASE_LINK();
            if (stringArray2 != null && stringArray2.length > 0) {
                string3 = string3 + OWNER_CRITERIA_START;
                string2 = "";
                for (String string4 : stringArray2) {
                    string3 = string3 + string2 + QUESTION_MARK + this.pos++;
                    this.binds.add(this.conditionalUpperCase(string4));
                    string2 = NEXT;
                }
                string3 = string3 + END;
            }
            if (string != null && !"".equals(string)) {
                string3 = string3 + DATABASE_LINK_LIKE_CRITERIA;
                this.binds.add(string.toUpperCase());
            }
        }
        this.query.append(string3);
    }

    private boolean containsSyn(String[] stringArray) {
        for (String string : stringArray) {
            if (!"SYNONYM".equals(string)) continue;
            return true;
        }
        return false;
    }

    public void prepareObject(String string, String string2, String string3) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string4 = this.QUERY_ALL_OBJECTS();
        if (string != null && !"".equals(string)) {
            string4 = string4 + OBJ_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string));
        }
        if (string2 != null && !"ALL".equals(string2) && !"".equals(string2)) {
            string4 = string4 + OBJECT_TYPE_CRITERIA;
            this.binds.add(string2.toUpperCase());
        }
        if (string3 != null && !"".equals(string3)) {
            string4 = string4 + OWNER_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string3));
        }
        this.query.append(string4);
    }

    public void prepareProcedure(String string, String string2) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string3 = this.QUERY_ALL_OBJECTS();
        if (string2 != null && !"".equals(string2)) {
            string3 = string3 + OBJ_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string2));
        }
        string3 = string3 + PLSQL_OBJ_TYPES;
        if (string != null && !"".equals(string)) {
            string3 = string3 + OWNER_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string));
        }
        this.query.append(string3);
        this.query.append("\n union all \n");
        string3 = this.QUERY_ALL_PROCEDURES;
        if (string2 != null && !"".equals(string2)) {
            string3 = string3 + PROC_NAME;
            this.binds.add(this.conditionalUpperCase(string2));
        }
        if (string != null && !"".equals(string)) {
            string3 = string3 + PKG_NAME;
            this.binds.add(this.conditionalUpperCase(string));
        }
        this.query.append(string3);
    }

    public void prepareAllColumns(String string, String[] stringArray) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string2 = this.QUERY_ALL_COLUMNS;
        if (string != null && !"".equals(string)) {
            string2 = string2 + COL_LIKE_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string));
        }
        if (stringArray != null && stringArray.length > 0) {
            string2 = string2 + O_OWNER_CRITERIA_START;
            String string3 = "";
            for (String string4 : stringArray) {
                string2 = string2 + string3 + QUESTION_MARK + this.pos++;
                this.binds.add(this.conditionalUpperCase(string4));
                string3 = NEXT;
            }
            string2 = string2 + END;
        }
        this.query.append(string2);
    }

    public void prepareDatabaseLink(String string) {
        if (this.query.length() > 0) {
            this.query.append("\n union \n");
        }
        String string2 = this.QUERY_DATABASE_LINK();
        if (string != null && !"".equals(string)) {
            string2 = string2 + DATABASE_LINK_LIKE_CRITERIA;
            this.binds.add(string);
        }
        this.query.append(string2);
    }

    public void prepareAllIdentifiers(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        String string2;
        if (this.prepareAllIdCalled) {
            return;
        }
        this.prepareAllIdCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string3 = this.QUERY_ALL_IDENTIFIERS;
        if (string != null && !"".equals(string)) {
            if (string.indexOf(46) > 0) {
                string2 = string.substring(0, string.indexOf(46));
                string = string.substring(string.indexOf(46) + 1);
                string3 = string3 + OBJ_CRITERIA;
                this.binds.add(this.conditionalUpperCase(string2));
            }
            string3 = string3 + NAME_LIKE_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string));
        }
        if (stringArray != null && stringArray.length > 0) {
            string3 = string3 + " and type in (";
            string2 = "";
            for (String string4 : stringArray) {
                string3 = string3 + string2 + QUESTION_MARK + this.pos++;
                this.binds.add(string4.toUpperCase());
                string2 = NEXT;
            }
            string3 = string3 + END;
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            string3 = string3 + USAGE_CRITERIA_START;
            string2 = "";
            for (String string4 : stringArray2) {
                string3 = string3 + string2 + QUESTION_MARK + this.pos++;
                this.binds.add(string4.toUpperCase());
                string2 = NEXT;
            }
            string3 = string3 + END;
        }
        if (stringArray3 != null && stringArray3.length > 0) {
            string3 = string3 + OWNER_CRITERIA_START;
            string2 = "";
            for (String string4 : stringArray3) {
                string3 = string3 + string2 + QUESTION_MARK + this.pos++;
                this.binds.add(this.conditionalUpperCase(string4));
                string2 = NEXT;
            }
            string3 = string3 + END;
        }
        this.query.append(string3);
    }

    public void prepareAllSource(String string, String[] stringArray, boolean bl) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.QUERY_ALL_SOURCE());
        this.binds.add(string);
        String string2 = bl ? "%" : "";
        this.binds.add(string2 + string + string2);
        if (stringArray != null && stringArray.length > 0) {
            this.query.append(OWNER_CRITERIA_START);
            String string3 = "";
            for (String string4 : stringArray) {
                this.query.append(string3 + QUESTION_MARK + this.pos++);
                this.binds.add(this.conditionalUpperCase(string4));
                string3 = NEXT;
            }
            this.query.append(END);
        }
    }

    public void prepareAllStatements(String string, String[] stringArray, boolean bl) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.QUERY_ALL_STATEMENTS);
        String string2 = bl ? "%" : "";
        this.binds.add(string2 + string + string2);
        if (stringArray != null && stringArray.length > 0) {
            this.query.append(OWNER_CRITERIA_START);
            String string3 = "";
            for (String string4 : stringArray) {
                this.query.append(string3 + QUESTION_MARK + this.pos++);
                this.binds.add(this.conditionalUpperCase(string4));
                string3 = NEXT;
            }
            this.query.append(END);
        }
    }

    public void prepareAllSource(String string, String string2, String string3) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append("select * from (" + this.QUERY_ALL_SOURCE());
        this.query.append("\n and type like 'PACKAGE%'");
        this.query.append(NAME_CRITERIA);
        this.query.append("\n) where col = 1 or substr(name/*text*/,col-1,1)=' '");
        this.binds.add(string3);
        this.binds.add("%" + string3 + "%");
        this.binds.add(string3);
        this.binds.add(string3);
        this.binds.add(string2.toUpperCase());
        if (string != null && !"".equals(string)) {
            this.query.append(OWNER_CRITERIA);
            this.binds.add(this.conditionalUpperCase(string));
        }
        this.query.append("\n order by type, line");
    }

    public void prepareOrds(String string, String[] stringArray, boolean bl) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.QUERY_ORDS);
        this.binds.add(string);
        String string2 = bl ? "%" : "";
        this.binds.add(string2 + string + string2);
        if (stringArray != null && stringArray.length > 0) {
            this.query.append(PARSING_SCHEMA_CRITERIA_START);
            String string3 = "";
            for (String string4 : stringArray) {
                this.query.append(string3 + QUESTION_MARK + this.pos++);
                this.binds.add(this.conditionalUpperCase(string4));
                string3 = NEXT;
            }
            this.query.append(END);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Item> fetch(String string) {
        long l = System.currentTimeMillis();
        ArrayList<Item> arrayList = new ArrayList<Item>();
        ResultSet resultSet = null;
        try {
            Connection connection = ChameleonConnection.getConnection(this.connectionName);
            this.ps = connection.prepareStatement(this.getSql());
            for (int i = 1; i <= this.binds.size(); ++i) {
                this.ps.setObject(i, this.binds.get(i - 1));
            }
            resultSet = this.ps.executeQuery();
            while (resultSet.next()) {
                if (string != null && resultSet.getRow() >= this.limit()) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)MessageFormat.format(Messages.getString("Query.0"), this.limit()), (String)Messages.getString("Query.1"), null);
                }
                Item item = null;
                int n = resultSet.getInt("LINE");
                int n2 = resultSet.getInt("COL");
                String string2 = resultSet.getString("USAGE");
                String string3 = resultSet.getString("TYPE");
                String string4 = resultSet.getString("NAME");
                if (n2 <= 0 && string4 != null && string != null) {
                    n2 = string4.toUpperCase().indexOf(string.toUpperCase()) + 1;
                }
                if (Item.ordsSrc.equals(string3)) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, "\n", false);
                    n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        ++n;
                        String string5 = stringTokenizer.nextToken();
                        n2 = string5.toUpperCase().indexOf(string.toUpperCase());
                        if (n2 < 0) continue;
                        item = new OrdsItem(string5, resultSet.getString("OBJECT_NAME"), string3, resultSet.getString("OBJECT_TYPE"), resultSet.getString("OWNER"), n, n2 + 1, string2);
                        arrayList.add(item);
                    }
                    continue;
                }
                item = new Item(string4, resultSet.getString("OBJECT_NAME"), string3, resultSet.getString("OBJECT_TYPE"), resultSet.getString("OWNER"), string2, n, n2);
                arrayList.add(item);
            }
        }
        catch (DBException dBException) {
            logger.severe(this.query.toString());
            logger.severe(dBException.getMessage());
        }
        catch (SQLException sQLException) {
            logger.severe(this.query.toString());
            logger.severe(sQLException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.severe(classNotFoundException.getMessage());
        }
        catch (ConnectionException connectionException) {
            logger.severe(connectionException.getMessage());
        }
        catch (AssertionError assertionError) {
            ((Throwable)((Object)assertionError)).printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.ps != null) {
                try {
                    this.ps.close();
                }
                catch (SQLException sQLException) {}
            }
            this.ps = null;
        }
        long l2 = System.currentTimeMillis();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryViews(ArrayList<Item> arrayList, String[] stringArray, String string) {
        long l = System.currentTimeMillis();
        OracleCallableStatement oracleCallableStatement = null;
        try {
            Object object;
            Connection connection = ChameleonConnection.getConnection(this.connectionName);
            String string2 = "select * from all_views where text_length < 32767 \n";
            if (stringArray != null && stringArray.length > 0) {
                string2 = string2 + OWNER_CRITERIA_START;
                object = "";
                for (String string3 : stringArray) {
                    string2 = string2 + (String)object + "'" + this.conditionalUpperCase(string3) + "'";
                    object = NEXT;
                }
                string2 = string2 + END;
            }
            string2 = string2 + "\n order by owner";
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(this.searchViews(string2, string));
            oracleCallableStatement.registerIndexTableOutParameter(1, 1000, 12, 1000);
            oracleCallableStatement.execute();
            object = oracleCallableStatement.getOraclePlsqlIndexTable(1);
            for (int i = 0; i < ((Datum[])object).length; ++i) {
                String string4 = object[i].stringValue();
                int n = string4.indexOf(46);
                int n2 = string4.indexOf("->");
                Item item = new Item(string4.substring(n2 + 2), string4.substring(n + 1, n2), Item.viewSrcColType, "VIEW", string4.substring(0, n), null, -1, -1);
                arrayList.add(item);
            }
        }
        catch (DBException dBException) {
            logger.severe(this.query.toString());
            logger.severe(dBException.getMessage());
        }
        catch (SQLException sQLException) {
            logger.severe(this.query.toString());
            logger.severe(sQLException.getMessage());
        }
        catch (ConnectionException connectionException) {
            logger.severe(connectionException.getMessage());
        }
        catch (AssertionError assertionError) {
            logger.severe(((Throwable)((Object)assertionError)).getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        long l2 = System.currentTimeMillis();
    }

    private String getSql() {
        String string = "SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA')";
        if ("USER".equals(HiddenParameters.parameters.get("CURRENT_SCHEMA"))) {
            string = "USER";
        }
        String string2 = "select NULL ENTRY, inner.* from ( \n" + this.query.toString() + "\n ) inner \nwhere rownum <= " + this.limit() + "\n order by case when OWNER = " + string + " then ' ' else OWNER end, type, CASE WHEN USAGE = 'DECLARATION' OR USAGE = 'DEFINITION' THEN 0 ELSE 1 END, usage, object_name, line, col, name";
        return string2;
    }

    public List<String> getBinds() {
        return this.binds;
    }

    public void cancel() {
        if (this.ps != null) {
            try {
                this.ps.cancel();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Class.forName("oracle.jdbc.OracleDriver");
        final Connection connection = DriverManager.getConnection("jdbc:oracle:thin:@gbr30060.uk.oracle.com:1521:DB12PERF", "hr", "hr");
        final PreparedStatement preparedStatement = connection.prepareStatement("select sum(1) from all_objects, all_objects, all_objects");
        new Thread(){

            @Override
            public void run() {
                try {
                    System.out.println("1");
                    Thread.sleep(10000L);
                    System.out.println("2");
                    preparedStatement.cancel();
                    PreparedStatement preparedStatement2 = connection.prepareStatement("select -1 from dual");
                    ResultSet resultSet = preparedStatement2.executeQuery();
                    resultSet.next();
                    System.out.println(resultSet.getObject(1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        System.out.println(resultSet.getObject(1));
    }
}

