/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Point;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.DictionaryQuery;
import oracle.dbtools.parser.plsql.IdentifiersDb;
import oracle.dbtools.parser.plsql.Item;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.Messages;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.raptor.RaptorDBAddin;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.ViewerOpener;
import oracle.dbtools.raptor.editors.DbEditor;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.oviewer.base.PopupDescribe;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.dbtools.raptor.plsql.language.PLSQLStyles;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.dbtools.util.Array;
import oracle.dbtools.util.Pair;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.AbstractBrowseClickPlugin;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.AbstractClickPlugin;
import oracle.javatools.util.Log;
import oracle.javatools.util.ModelUtil;

public final class IdentifierDefinitionLookup
extends AbstractBrowseClickPlugin
implements Controller {
    private static final Logger LOGGER = Logger.getLogger(IdentifierDefinitionLookup.class.getName());
    public static final int DEF_LOOKUP_ID = Ide.findOrCreateCmdID((String)"oracle.dbtools.parser.plsql.IdentifierDefinitionLookup.DEF_LOOKUP_ID");
    private ParseNode m_root;
    private LazyNode m_output;
    private List<LexerToken> m_src;
    private String m_text;
    BasicEditorPane m_pane;
    String m_connName;
    private String m_schema;
    private Action m_action;
    static int[] plsqlRules = null;
    private Context ctx;
    private URL node_url;
    private static ViewerOpener viewerOpener;
    long highlightTimestamp = System.currentTimeMillis();

    private String getConnectionName(Context context) {
        String string = null;
        Node node = context.getNode();
        View view = context.getView();
        if (node instanceof PlSqlNode) {
            PlSqlNode plSqlNode = (PlSqlNode)node;
            string = plSqlNode.getConnectionName() != null ? plSqlNode.getConnectionName() : DBURLFormatHelper.getConnectionName(plSqlNode.getURL());
        } else if (view instanceof BasicEditorPaneContainer) {
            string = view instanceof DbEditor ? ((DbEditor)view).getConnectionName() : (String)context.getProperty("Connections.db_name");
        }
        return string;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == DEF_LOOKUP_ID) {
            Node node = context.getNode();
            View view = context.getView();
            this.m_connName = this.getConnectionName(context);
            if (node instanceof PlSqlNode) {
                PlSqlNode plSqlNode = (PlSqlNode)node;
                this.m_schema = (String)plSqlNode.getProperty("SCHEMA");
                this.m_pane = ((BasicEditorPaneContainer)view).getFocusedEditorPane();
                this.m_src = plSqlNode.getParser().src;
                this.m_root = plSqlNode.getParser().root;
                this.m_output = plSqlNode.getParser().output;
                this.m_text = plSqlNode.getParser().text;
                this.finishIdLookup(plSqlNode);
            } else if (view instanceof BasicEditorPaneContainer && view instanceof EquippedWithParser && view instanceof DbEditor) {
                this.m_pane = ((BasicEditorPaneContainer)view).getFocusedEditorPane();
                BackgroundParser backgroundParser = ((EquippedWithParser)view).getParser();
                this.m_src = backgroundParser.src;
                this.m_root = backgroundParser.root;
                this.m_output = backgroundParser.output;
                this.m_text = backgroundParser.text;
                this.finishIdLookup(null);
            }
            return true;
        }
        return false;
    }

    void finishIdLookup(PlSqlNode plSqlNode) {
        int n = this.m_pane.getCaretPosition();
        this.parseIdentifierAtOffset(n, this.m_root, this.m_src, this.m_pane, plSqlNode);
        if (this.m_action != null) {
            this.m_action.schema = this.m_schema;
            this.m_action.eval();
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == DEF_LOOKUP_ID) {
            ideAction.setEnabled(this.isAvailable(context));
            return true;
        }
        return false;
    }

    private boolean isAvailable(Context context) {
        BackgroundParser backgroundParser;
        Node node = context.getNode();
        View view = context.getView();
        if (node instanceof PlSqlNode) {
            PlSqlNode plSqlNode = (PlSqlNode)node;
            if (plSqlNode.getParser() != null && plSqlNode.getParser().output != null) {
                this.m_text = plSqlNode.getParser().text;
                return true;
            }
        } else if (view instanceof BasicEditorPaneContainer && view instanceof EquippedWithParser && view instanceof DbEditor && (backgroundParser = ((EquippedWithParser)view).getParser()) != null && backgroundParser.output != null) {
            this.m_text = backgroundParser.text;
            return true;
        }
        return false;
    }

    protected void parseIdentifierAtOffset(int n, ParseNode parseNode, List<LexerToken> list, BasicEditorPane basicEditorPane, PlSqlNode plSqlNode) {
        Object object5;
        Object object2;
        LexerToken lexerToken;
        ParseNode parseNode2 = null;
        this.m_action = null;
        LexerToken lexerToken2 = null;
        int n2 = -1;
        int n3 = -1;
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            ParseNode parseNode3;
            lexerToken = object3.next();
            ++n3;
            if (".".equals(lexerToken.content)) {
                lexerToken2 = lexerToken;
            }
            if ("@".equals(lexerToken.content)) {
                n2 = n3;
            }
            if (lexerToken.begin > n || n > lexerToken.end) continue;
            if (parseNode.to < 40 && (parseNode3 = this.recognizeAtCommand(parseNode)) != null && parseNode3.from == 0) {
                String string = "";
                for (int i = 1; i < parseNode3.to; ++i) {
                    string = string + list.get((int)i).content;
                }
                if (string.startsWith("@")) {
                    string = string.substring(1);
                }
                if (string.charAt(0) == '\"') {
                    string = string.substring(1, string.length() - 1);
                }
                parseNode3.from += n2;
                parseNode3.to += n2;
                parseNode2 = parseNode3;
                if (this.m_connName != null) {
                    this.m_action = new Action.SCRIPT(string, this.m_connName, this.node_url, this.m_src.get((int)parseNode2.from).begin, this.m_src.get((int)(parseNode2.to - 1)).end);
                }
                return;
            }
            if (lexerToken.type != Token.IDENTIFIER && lexerToken.type != Token.DQUOTED_STRING) continue;
            int n4 = n3;
            if (lexerToken2 != null && lexerToken2.end == lexerToken.begin && 1 < n3) {
                n4 = n3 - 2;
            }
            if (lexerToken2 == null && n3 + 1 < list.size() && ".".equals(list.get((int)(n3 + 1)).content) && (object2 = parseNode.leafAtPos(n4).parent()) != null && object2.contains(IdentifiersDb.instance.table_reference)) {
                n3 += 2;
            }
            parseNode2 = new ParseNode(n4, n3 + 1, -1, -1, null);
            break;
        }
        if (parseNode2 == null) {
            return;
        }
        if (parseNode2.from + 1 == parseNode2.to && PLSQLStyles.isKeyword((String)(object3 = list.get((int)parseNode2.from).content.toUpperCase()))) {
            return;
        }
        object3 = this.getIdentifierDefinition(parseNode2.content(list), parseNode2.from, parseNode, list);
        if (object3 != null && ((ParseNode)object3).from <= parseNode2.from && parseNode2.to <= ((ParseNode)object3).to && (object3.contains(IdentifiersDb.instance.table_reference) || object3.contains(IdentifiersDb.instance.aliased_dml_table_expression_clause))) {
            if (this.m_connName != null) {
                this.m_action = new Action.TABLE(list, parseNode2, this.m_connName);
            }
            return;
        }
        if (object3 != null) {
            this.m_action = new Action.LOCAL(list, (ParseNode)object3, basicEditorPane, this.m_src.get((int)parseNode2.from).begin, this.m_src.get((int)(parseNode2.to - 1)).end);
            return;
        }
        if (this.memberLookup(this.m_output, list, basicEditorPane, plSqlNode, parseNode2)) {
            return;
        }
        lexerToken = parseNode.parent(parseNode2.from, parseNode2.to);
        Object object4 = parseNode2;
        if (lexerToken != null) {
            for (Object object5 : lexerToken.children()) {
                if (((ParseNode)object5).from != parseNode2.from || ((ParseNode)object5).to != parseNode2.to) continue;
                object4 = object5;
            }
            if (lexerToken != null && (lexerToken.contains("procedure_call") || lexerToken.contains("name_wo_function_call"))) {
                parseNode2 = lexerToken;
                if (this.m_connName != null) {
                    this.m_action = new Action.PLSQL(list, (ParseNode)lexerToken, this.m_connName, n, basicEditorPane);
                }
                return;
            }
            if (object4.contains("procedure_call") || object4.contains("expr") || object4.contains("unconstrained_type")) {
                parseNode2 = object4;
                if (this.m_connName != null) {
                    this.m_action = new Action.PLSQL(list, (ParseNode)object4, this.m_connName, n, basicEditorPane);
                }
                return;
            }
            if (lexerToken != null && (lexerToken.contains("adt_field") || lexerToken.contains("object_d"))) {
                if (this.m_connName != null) {
                    this.m_action = new Action.TYPE(list, parseNode2, this.m_connName);
                }
                return;
            }
        }
        if (3 < list.size() && list.size() < 1000 && parseNode.topLevel != null) {
            Cell cell;
            int n5;
            int n6;
            object2 = SqlEarley.partialRecognizer();
            object5 = new Matrix((Parser)object2);
            object2.parse(list, (Matriceable)object5);
            if (plsqlRules == null) {
                int n7 = IdentifiersDb.instance.procedure_call;
                n6 = object2.getSymbol("function_call");
                for (n5 = 0; n5 < ((SqlEarley)object2).rules.length; ++n5) {
                    Parser.Tuple tuple = ((SqlEarley)object2).rules[n5];
                    if (tuple.head != n7 && tuple.head != n6) continue;
                    plsqlRules = Array.insert((int[])plsqlRules, (int)n5);
                }
            }
            if ((cell = object5.get(parseNode2.from, parseNode2.to)) == null) {
                return;
            }
            for (n6 = 0; n6 < cell.size(); ++n6) {
                n5 = cell.getRule(n6);
                if (plsqlRules[Array.indexOf((int[])plsqlRules, (int)n5)] != n5) continue;
                if (this.m_connName != null) {
                    this.m_action = new Action.PLSQL(list, parseNode2, this.m_connName, n, basicEditorPane);
                }
                return;
            }
        }
        object2 = PopupDescribe.extractName(n, list);
        if (this.m_connName == null) {
            return;
        }
        object5 = DBObject.getDBObjectForName(((String)object2).toString(), this.m_connName);
        if (object5 != null) {
            if ("TABLE".equals(((DBObject)object5).getObjectType()) || "VIEW".equals(((DBObject)object5).getObjectType())) {
                this.m_action = new Action.TABLE(list, parseNode2, this.m_connName);
            } else if (((DBObject)object5).getObjectType().startsWith("PACKAGE") || "PROCEDURE".equals(((DBObject)object5).getObjectType()) || "TYPE".equals(((DBObject)object5).getObjectType()) || "OPERATOR".equals(((DBObject)object5).getObjectType()) || "FUNCTION".equals(((DBObject)object5).getObjectType())) {
                this.m_action = new Action.PLSQL(list, parseNode2, this.m_connName, n, basicEditorPane);
            }
        }
    }

    protected void parseUrlAtOffset(int n, String string) {
        this.m_action = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\t", true);
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ((n2 += string2.length()) < n) continue;
            String string3 = string2.toLowerCase();
            if (string3.startsWith("http://") || string3.startsWith("https://")) {
                try {
                    URL uRL = new URL(string3);
                    this.m_action = new Action.Url(uRL, n2 - string3.length(), n2);
                }
                catch (MalformedURLException malformedURLException) {
                    LOGGER.severe(malformedURLException.toString());
                }
            }
            if (n > n2) continue;
            break;
        }
    }

    private ParseNode recognizeAtCommand(ParseNode parseNode) {
        if (parseNode.contains("double_at_sign")) {
            return parseNode;
        }
        if (parseNode.contains("at_sign")) {
            return parseNode;
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            ParseNode parseNode3 = this.recognizeAtCommand(parseNode2);
            if (parseNode3 == null) continue;
            return parseNode3;
        }
        return null;
    }

    private boolean memberLookup(LazyNode lazyNode, List<LexerToken> list, BasicEditorPane basicEditorPane, PlSqlNode plSqlNode, ParseNode parseNode) {
        if (plSqlNode != null) {
            PlSqlNode plSqlNode2;
            URL uRL;
            String string;
            URL uRL2 = plSqlNode.getURL();
            if (!plSqlNode.isBody()) {
                string = DBURLFormatHelper.getBaseType(uRL2) + " BODY";
                uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL2), "", DBURLFormatHelper.getSchema(uRL2), string), DBURLFormatHelper.getName(uRL2));
                plSqlNode2 = PlSqlNode.find(uRL);
                if (plSqlNode2 != null && this.findMember(lazyNode, list, basicEditorPane, plSqlNode2, parseNode)) {
                    return true;
                }
            }
            if (this.findMember(lazyNode, list, basicEditorPane, plSqlNode, parseNode)) {
                return true;
            }
            if (plSqlNode.isBody()) {
                string = DBURLFormatHelper.getBaseType(uRL2);
                uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL2), "", DBURLFormatHelper.getSchema(uRL2), string.substring(0, string.indexOf(32))), DBURLFormatHelper.getName(uRL2));
                plSqlNode2 = PlSqlNode.find(uRL);
                if (this.findMember(lazyNode, list, basicEditorPane, plSqlNode2, parseNode)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean findMember(LazyNode lazyNode, List<LexerToken> list, BasicEditorPane basicEditorPane, PlSqlNode plSqlNode, ParseNode parseNode) {
        String string = parseNode.content(list);
        Member object = null;
        List<Member> list2 = plSqlNode.getMembers(string);
        if (list2.size() == 1) {
            object = list2.get(0);
        } else {
            ParseNode parseNode2;
            int n = 0;
            int n2 = -1;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (LexerToken object2 : list) {
                if (++n2 <= parseNode.from) continue;
                if ("(".equals(object2.content)) {
                    ++n;
                } else if (")".equals(object2.content)) {
                    --n;
                }
                if (n == 0) break;
                if (object2.type == Token.OPERATION) continue;
                if (object2.type == Token.DIGITS) {
                    arrayList.add("NUMBER");
                    continue;
                }
                if (object2.type == Token.QUOTED_STRING) {
                    arrayList.add("CHAR");
                    continue;
                }
                parseNode2 = this.getIdentifierDefinition(object2.content, n2, (ParseNode)lazyNode, list);
                if (parseNode2 == null) continue;
                arrayList.add(list.get((int)(parseNode2.from + 1)).content);
            }
            for (Member member : list2) {
                parseNode2 = member.getSignature();
                if (parseNode2.size() != arrayList.size()) continue;
                boolean bl = false;
                for (int i = 0; i < parseNode2.size(); ++i) {
                    String string2 = parseNode2.get((int)i).type;
                    String string3 = (String)arrayList.get(i);
                    if (this.typesMatch(string2, string3)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                object = member;
                break;
            }
        }
        if (object != null) {
            this.m_action = new Action.MEMBER(object, basicEditorPane, list.get((int)parseNode.from).begin, list.get((int)(parseNode.to - 1)).end);
            return true;
        }
        return false;
    }

    private boolean typesMatch(String string, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        if ("CHAR".equalsIgnoreCase(string)) {
            return string2.contains(string);
        }
        if ("CHAR".equalsIgnoreCase(string2)) {
            return string.contains(string2);
        }
        if ("INTEGER".equalsIgnoreCase(string2)) {
            return string.equalsIgnoreCase("NUMBER");
        }
        if ("INTEGER".equalsIgnoreCase(string)) {
            return string2.equalsIgnoreCase("NUMBER");
        }
        return false;
    }

    private static void goToTable(String string, String string2, String string3, String string4) {
        if (string == null) {
            return;
        }
        if (Connections.getInstance().checkLock(string)) {
            return;
        }
        DictionaryQuery dictionaryQuery = new DictionaryQuery(string, string4);
        if (string3 == null) {
            dictionaryQuery.prepareAllObjects(string2, new String[]{"TABLE", "VIEW", "SYNONYM"}, new String[0]);
        } else {
            dictionaryQuery.prepareAllObjects(string2, new String[]{"TABLE", "VIEW", "SYNONYM"}, new String[]{string3});
        }
        ArrayList<Item> arrayList = dictionaryQuery.fetch(null);
        if (arrayList.size() == 0) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)MessageFormat.format(Messages.getString("ObjectDoesntExist"), "Table", string2), (String)Messages.getString("DefinitionNotFound"), null);
            return;
        }
        arrayList.get(0).goTo(dictionaryQuery.getConnectionName());
    }

    private static void goToPlSql(String string, String string2, String string3, List<LexerToken> list, String string4) {
        Object object;
        if (string == null) {
            return;
        }
        if (Connections.getInstance().checkLock(string)) {
            return;
        }
        DictionaryQuery dictionaryQuery = new DictionaryQuery(string, string4);
        if (string3.charAt(0) != '\"') {
            string3 = string3.toUpperCase();
        }
        if (string2 == null) {
            dictionaryQuery.prepareAllObjects(string3, "FUNCTION");
            dictionaryQuery.prepareAllObjects(string3, "PROCEDURE");
            dictionaryQuery.prepareAllObjects(string3, "TYPE");
            dictionaryQuery.prepareAllObjects(string3, "OPERATOR");
            object = IdentifierDefinitionLookup.getPkgName(list);
            if (object != null) {
                dictionaryQuery.prepareAllSource(string4, (String)object, string3);
            } else {
                dictionaryQuery.prepareAllObjects(string3, "PACKAGE");
            }
        } else {
            dictionaryQuery.prepareProcedure(string2, string3);
        }
        object = dictionaryQuery.fetch(null);
        if (((ArrayList)object).size() == 0) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)MessageFormat.format(Messages.getString("ObjectDoesntExist"), "PL/SQL unit", string3), (String)Messages.getString("DefinitionNotFound"), null);
            return;
        }
        Item item = ((ArrayList)object).get(0);
        Iterator<Item> iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            Item item2 = iterator.next();
            if (item2.line >= 0) continue;
            item = item2;
            break;
        }
        item.goTo(dictionaryQuery.getConnectionName());
    }

    private static void goToType(String string, String string2, String string3, String string4) {
        if (string == null) {
            return;
        }
        if (Connections.getInstance().checkLock(string)) {
            return;
        }
        DictionaryQuery dictionaryQuery = new DictionaryQuery(string, string4);
        dictionaryQuery.prepareObject(string2, "TYPE", string3);
        dictionaryQuery.fetch(null).get(0).goTo(dictionaryQuery.getConnectionName());
    }

    private static void goToScript(String string, String string2, URL uRL) {
        Object object;
        Object object2;
        if (string == null) {
            return;
        }
        if (Connections.getInstance().checkLock(string)) {
            return;
        }
        String string3 = File.separator;
        String string4 = string2.replaceFirst("@", "").trim();
        if (string2.startsWith("?")) {
            object2 = TNSHelper.getOracleHome();
            string4 = (String)(object2 == null ? "" : object2) + string2.substring(1);
        } else if (!string2.startsWith(File.separator) && !string2.contains(":")) {
            object2 = DBConfig.getInstance().getScriptDirectory().getFile();
            string4 = (String)object2 + (!((String)object2).endsWith(string3) ? string3 : "") + string2;
        }
        object2 = new File(string4);
        if (!((File)object2).exists() && uRL != null) {
            object = uRL.getPath().substring(0, uRL.getPath().lastIndexOf(string3));
            String string5 = (String)object + (!((String)object).endsWith(string3) ? string3 : "") + string2;
            object2 = new File(string5);
        }
        if (((File)object2).exists() && ((File)object2).canRead()) {
            try {
                object = ((File)object2).toURI().toURL();
                RaptorDBAddin.getSqlOpener().openNewEditor((URL)object, string);
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("goToScript() MalformedURLException: " + string2);
            }
        } else {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"File does not exist or cannot be located. ", (String)"File Not Found", (String)"f1_ctrlclick_file_html");
        }
    }

    private static String getPkgName(List<LexerToken> list) {
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        for (LexerToken lexerToken : list) {
            if (++n > 10) break;
            if (bl2) {
                string = lexerToken.content;
            }
            bl2 = bl && "BODY".equalsIgnoreCase(lexerToken.content);
            if ("PACKAGE".equalsIgnoreCase(lexerToken.content)) {
                bl = true;
                continue;
            }
            bl = false;
        }
        return string;
    }

    public ParseNode getIdentifierDefinition(String string, int n, ParseNode parseNode, List<LexerToken> list) {
        Map<ParseNode, Pair<Integer, Integer>> map = null;
        map = parseNode instanceof LazyNode ? IdentifiersDb.collectIdentifiers(n, n + 1, (LazyNode)parseNode) : IdentifiersDb.instance.collectIdentifiers(parseNode);
        return IdentifiersDb.getIdentifierDefinition(string, n, list, map);
    }

    public IdentifierDefinitionLookup() {
        this(null);
    }

    public IdentifierDefinitionLookup(Context context) {
        this.ctx = context;
    }

    protected NumberRange getIdentifierAtOffset(int n) {
        if (this.ctx == null) {
            return null;
        }
        Node node = this.ctx.getNode();
        View view = this.ctx.getView();
        if (node instanceof PlSqlNode) {
            PlSqlNode plSqlNode = (PlSqlNode)node;
            this.m_pane = ((BasicEditorPaneContainer)view).getFocusedEditorPane();
            this.node_url = ((PlSqlNode)node).getURL();
            this.m_schema = (String)plSqlNode.getProperty("SCHEMA");
            this.m_connName = plSqlNode.getConnectionName() != null ? plSqlNode.getConnectionName() : DBURLFormatHelper.getConnectionName(plSqlNode.getURL());
            this.m_src = plSqlNode.getParser().src;
            this.m_root = plSqlNode.getParser().root;
            this.m_output = plSqlNode.getParser().output;
            this.m_text = plSqlNode.getParser().text;
            return this.finishIdSelection(n, plSqlNode);
        }
        if (view instanceof BasicEditorPaneContainer && view instanceof EquippedWithParser && view instanceof DbEditor) {
            this.m_pane = ((BasicEditorPaneContainer)view).getFocusedEditorPane();
            this.node_url = node.getURL();
            this.m_connName = ((DbEditor)view).getConnectionName();
            BackgroundParser backgroundParser = ((EquippedWithParser)view).getParser();
            this.m_src = backgroundParser.src;
            this.m_root = backgroundParser.root;
            this.m_output = backgroundParser.output;
            this.m_text = backgroundParser.text;
            return this.finishIdSelection(n, null);
        }
        return null;
    }

    private NumberRange finishIdSelection(int n, PlSqlNode plSqlNode) {
        this.parseIdentifierAtOffset(n, this.m_root, this.m_src, this.m_pane, plSqlNode);
        if (this.m_action != null && !(this.m_action instanceof Action.Url)) {
            return new NumberRange(this.m_action.from, this.m_action.to);
        }
        this.parseUrlAtOffset(n, this.m_text);
        if (this.m_action != null) {
            return new NumberRange(this.m_action.from, this.m_action.to);
        }
        this.m_action = null;
        return null;
    }

    protected void performDeclarationClick(Point point) {
        if (this.m_action != null) {
            this.m_action.schema = this.m_schema;
            this.m_action.eval();
        }
    }

    public static boolean goTo(URL uRL, boolean bl) {
        return IdentifierDefinitionLookup.goTo(uRL, bl, null);
    }

    private static boolean goTo(URL uRL, boolean bl, String string) {
        if (uRL == null) {
            return false;
        }
        String string2 = null;
        if (bl) {
            string2 = Service.from2chars((String)DBURLFormatHelper.getCatalog(uRL));
        }
        if (string2 != null) {
            int n = string2.indexOf(44);
            int n2 = Integer.parseInt(string2.substring(0, n));
            int n3 = Service.X((int)n2);
            int n4 = Service.Y((int)n2);
            URL uRL2 = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL), "", DBURLFormatHelper.getSchema(uRL), DBURLFormatHelper.getBaseType(uRL)), DBURLFormatHelper.getName(uRL));
            return viewerOpener.waitOnOpen(uRL2, n3, n4);
        }
        String string3 = DBURLFormatHelper.getName(uRL);
        boolean bl2 = viewerOpener.waitOnOpen(uRL, string);
        if (!bl2 && ModelUtil.hasLength((String)string3) && string3.indexOf(46) >= 0) {
            string3 = string3.substring(0, string3.indexOf(46));
            uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL), "", DBURLFormatHelper.getSchema(uRL), DBURLFormatHelper.getBaseType(uRL)), string3);
            return viewerOpener.waitOnOpen(uRL, string);
        }
        return bl2;
    }

    public static void registerViewerOpener(ViewerOpener viewerOpener) {
        IdentifierDefinitionLookup.viewerOpener = viewerOpener;
    }

    protected void updateHighlight(Point point, final int n) {
        Method method;
        this.highlightTimestamp = System.currentTimeMillis();
        HighlightLayer highlightLayer = null;
        try {
            method = AbstractClickPlugin.class.getDeclaredMethod("getHighlightLayer", new Class[0]);
            method.setAccessible(true);
            highlightLayer = (HighlightLayer)method.invoke((Object)this, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        method = highlightLayer;
        if (point == null) {
            if (method != null) {
                method.removeAllHighlights();
            }
            return;
        }
        final int n2 = this.getEditorPane().viewToModel(point);
        if (method != null) {
            method.removeAllHighlights();
            SwingWorker swingWorker = new SwingWorker((HighlightLayer)method){
                NumberRange offsets = null;
                HighlightStyle highlightToUse = null;
                final /* synthetic */ HighlightLayer val$layerToUse;
                {
                    this.val$layerToUse = highlightLayer;
                }

                public Object doInBackground() {
                    if (n != -1) {
                        this.highlightToUse = IdentifierDefinitionLookup.this.getHighlightStyleFor(n);
                        if (this.highlightToUse != null) {
                            this.offsets = IdentifierDefinitionLookup.this.getRegionFor(n2, n);
                        }
                    }
                    return null;
                }

                @Override
                public void done() {
                    if (this.offsets != null && this.highlightToUse != null) {
                        this.val$layerToUse.addHighlight(this.highlightToUse, this.offsets.start, this.offsets.end);
                    }
                    IdentifierDefinitionLookup.this.updateHint(n);
                }
            };
            swingWorker.execute();
        }
    }

    static abstract class Action {
        String schema = null;
        int from = -1;
        int to = -1;

        protected Action(int n, int n2) {
            this.from = n;
            this.to = n2;
        }

        abstract void eval();

        static class Url
        extends Action {
            URL url;

            Url(URL uRL, int n, int n2) {
                super(n, n2);
                this.url = uRL;
            }

            @Override
            void eval() {
                try {
                    Desktop.getDesktop().browse(new URI(this.url.toString()));
                }
                catch (Exception exception) {
                    Log.error((String)("Failed to go to URL, " + exception.getMessage()));
                }
            }
        }

        static class SCRIPT
        extends Action {
            String fileName;
            String connName;
            URL url;

            SCRIPT(String string, String string2, URL uRL, int n, int n2) {
                super(n, n2);
                this.fileName = string;
                this.connName = string2;
                this.url = uRL;
            }

            @Override
            void eval() {
                IdentifierDefinitionLookup.goToScript(this.connName, this.fileName, this.url);
            }
        }

        static class TYPE
        extends Action {
            List<LexerToken> src;
            ParseNode id;
            String connName;

            TYPE(List<LexerToken> list, ParseNode parseNode, String string) {
                super(list.get((int)parseNode.from).begin, list.get((int)(parseNode.to - 1)).end);
                this.src = list;
                this.id = parseNode;
                this.connName = string;
            }

            @Override
            void eval() {
                String string = null;
                if (this.id.from + 3 == this.id.to) {
                    string = this.src.get((int)this.id.from).content;
                }
                IdentifierDefinitionLookup.goToType(this.connName, this.src.get((int)(this.id.to - 1)).content, string, this.schema);
            }
        }

        static class PLSQL
        extends Action {
            List<LexerToken> src;
            ParseNode id;
            String connName;
            int scannerPos;
            BasicEditorPane panel;

            PLSQL(List<LexerToken> list, ParseNode parseNode, String string, int n, BasicEditorPane basicEditorPane) {
                super(list.get((int)parseNode.from).begin, list.get((int)(parseNode.to - 1)).end);
                this.src = list;
                this.id = parseNode;
                this.connName = string;
                this.scannerPos = n;
                this.panel = basicEditorPane;
            }

            @Override
            void eval() {
                String string = null;
                String string2 = this.src.get((int)this.id.from).content;
                if (this.src.size() > this.id.from + 2 && ".".equals(this.src.get((int)(this.id.from + 1)).content)) {
                    string = this.src.get((int)this.id.from).content;
                    string2 = this.src.get((int)(this.id.from + 2)).content;
                }
                IdentifierDefinitionLookup.goToPlSql(this.connName, string, string2, this.src, this.schema);
            }
        }

        static class MEMBER
        extends Action {
            Member member;
            BasicEditorPane panel = null;

            MEMBER(Member member, BasicEditorPane basicEditorPane, int n, int n2) {
                super(n, n2);
                this.member = member;
                this.panel = basicEditorPane;
            }

            @Override
            void eval() {
                if (this.panel == null) {
                    throw new AssertionError((Object)"Fix this branch");
                }
                this.panel.setSelectionStart(this.member.codeOffset);
                this.panel.setSelectionEnd(this.member.codeOffset + this.member.name.length());
            }
        }

        static class LOCAL
        extends Action {
            List<LexerToken> src;
            ParseNode def;
            BasicEditorPane panel;

            LOCAL(List<LexerToken> list, ParseNode parseNode, BasicEditorPane basicEditorPane, int n, int n2) {
                super(n, n2);
                this.src = list;
                this.def = parseNode;
                this.panel = basicEditorPane;
            }

            @Override
            void eval() {
                NumberRange numberRange = new NumberRange(this.src.get((int)this.def.from).begin, this.src.get((int)this.def.from).end);
                this.panel.setSelectionStart(numberRange.start);
                this.panel.setSelectionEnd(numberRange.end);
            }
        }

        static class TABLE
        extends Action {
            List<LexerToken> src;
            ParseNode id;
            String connName;

            TABLE(List<LexerToken> list, ParseNode parseNode, String string) {
                super(list.get((int)parseNode.from).begin, list.get((int)(parseNode.to - 1)).end);
                this.src = list;
                this.id = parseNode;
                this.connName = string;
            }

            @Override
            void eval() {
                String string = null;
                if (this.id.from + 3 == this.id.to) {
                    string = this.src.get((int)this.id.from).content;
                }
                IdentifierDefinitionLookup.goToTable(this.connName, this.src.get((int)(this.id.to - 1)).content, string, this.schema);
            }
        }
    }
}

