/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.awt.Color;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.app.Format;
import oracle.dbtools.parser.plsql.doc.DocURL;
import oracle.dbtools.parser.plsql.doc.Substr;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.util.Service;
import oracle.ide.ceditor.options.S2Highlight;
import oracle.ide.ceditor.options.SyntaxColorsOptions;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.icons.OracleIcons;

public class SuggestedItem
extends ListDataItem
implements Comparable {
    private String _owner;
    private String _name;
    private int _len = 0;
    private String _type;
    private int _pos = -1;
    public String columnType;
    public DocURL doc = null;
    static boolean isHTML = System.getProperty("java.version").startsWith("1.6");
    public static final String prefix = "[";
    public static final String suffix = "]";
    private static String placeholderPrefix = null;
    public static String placeholderSuffix = "</FONT>";

    public String getType() {
        return this._type;
    }

    public SuggestedItem(SuggestedItem suggestedItem, int n) {
        this._len = n <= suggestedItem._name.length() && !suggestedItem._name.startsWith("...") ? n : 0;
        this._name = suggestedItem._name;
        this._type = suggestedItem._type;
        this._owner = suggestedItem._owner;
        this.doc = suggestedItem.doc;
    }

    public SuggestedItem(String string, String string2, String string3) {
        this(string, string2, string3, -1);
    }

    public SuggestedItem(String string, String string2, String string3, int n) {
        this(string, string2, string3, n, true);
    }

    public SuggestedItem(String string, String string2, String string3, int n, boolean bl) {
        this._name = "KEYWORD".equals(string) ? (bl ? new Format().adjustCase(string3, Format.options.get(Format.kwCase)) : string3) : (!"SNIPPET".equals(string) && !"TEMPLATE".equals(string) ? (bl ? new Format().adjustCase(string3, Format.options.get(Format.idCase)) : string3) : string3);
        this._type = string;
        this._owner = string2;
        this._pos = n;
    }

    public Icon getIcon() {
        if ("FUNCTION".equalsIgnoreCase(this._type)) {
            return RaptorImagesArb.getIcon("FUNCTION");
        }
        if ("PROCEDURE".equalsIgnoreCase(this._type)) {
            return RaptorImagesArb.getIcon("PROCEDURE");
        }
        if ("COLUMN".equalsIgnoreCase(this._type)) {
            return RaptorImagesArb.getIcon("COLUMN");
        }
        if ("TABLE".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"table.png");
        }
        if ("VIEW".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"view.png");
        }
        if (this._type != null && this._type.indexOf("CHAR") >= 0 || "STRING".equalsIgnoreCase(this._type)) {
            return RaptorImagesArb.getIcon("STRING");
        }
        if ("INTEGER".equalsIgnoreCase(this._type) || "NUMBER".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"field.png");
        }
        if ("DATE".equalsIgnoreCase(this._type) || "TIMESTAMP".equalsIgnoreCase(this._type)) {
            return RaptorImagesArb.getIcon("DATE");
        }
        if ("BOOLEAN".equalsIgnoreCase(this._type)) {
            return RaptorImagesArb.getIcon("BOOLEAN");
        }
        if ("USER DEFINED".equals(this._type) || "TYPE".equals(this._type) || "SUBTYPE".equals(this._type)) {
            return OracleIcons.getIcon((String)"domain.png");
        }
        if ("SCHEMA".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"user.png");
        }
        if ("PACKAGE".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"package.png");
        }
        if ("SNIPPET".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"library.png");
        }
        if ("SEQUENCE".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"sequence.png");
        }
        if ("HISTORY".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"history.png");
        }
        if ("EQUIJOIN CONDITION".equalsIgnoreCase(this._type)) {
            return RaptorImagesArb.getIcon("SIGMA");
        }
        return null;
    }

    private int priority() {
        if ("ARGUMENT".equalsIgnoreCase(this._type)) {
            return -2;
        }
        if ("EQUIJOIN CONDITION".equalsIgnoreCase(this._type)) {
            return -1;
        }
        if ("COLUMN".equalsIgnoreCase(this._type)) {
            return 0;
        }
        if ("TABLE".equalsIgnoreCase(this._type)) {
            return 1;
        }
        if ("VIEW".equalsIgnoreCase(this._type)) {
            return 2;
        }
        if ("KEYWORD".equalsIgnoreCase(this._type)) {
            return 3;
        }
        if ("HISTORY".equalsIgnoreCase(this._type)) {
            return 4;
        }
        if ("SNIPPET".equalsIgnoreCase(this._type)) {
            return 5;
        }
        if ("TEMPLATE".equalsIgnoreCase(this._type)) {
            return 6;
        }
        if (this._type.indexOf("CHAR") >= 0) {
            return 7;
        }
        if ("STRING".equals(this._type)) {
            return 7;
        }
        if ("INTEGER".equals(this._type) || "NUMBER".equals(this._type)) {
            return 7;
        }
        if ("DATE".equals(this._type) || "TIMESTAMP".equals(this._type)) {
            return 7;
        }
        if ("BOOLEAN".equals(this._type)) {
            return 7;
        }
        if ("USER DEFINED".equals(this._type) || "TYPE".equals(this._type) || "SUBTYPE".equals(this._type)) {
            return 7;
        }
        if ("SCHEMA".equals(this._type)) {
            return 8;
        }
        if ("PACKAGE".equalsIgnoreCase(this._type)) {
            return 9;
        }
        if ("FUNCTION".equalsIgnoreCase(this._type)) {
            return 10;
        }
        if ("PROCEDURE".equalsIgnoreCase(this._type)) {
            return 10;
        }
        if ("SEQUENCE".equalsIgnoreCase(this._type)) {
            return 11;
        }
        return 9999;
    }

    public String getDisplayText() {
        if (!isHTML) {
            return this.toString();
        }
        int n = this._len;
        StringBuilder stringBuilder = new StringBuilder("<html>");
        if (!(this._owner == null || 0 >= this._owner.length() || this._len != 0 && this._name.indexOf(46) >= 0 && this._name.substring(0, this._len).equalsIgnoreCase(this._owner + '.') || "COLUMN".equals(this._type))) {
            stringBuilder.append("<font color=gray>" + this._owner + ".</font>");
            n -= this._owner.length() + 1;
        }
        if (n > 0 && n < this._name.length()) {
            stringBuilder.append("<b>" + this._name.substring(0, n) + "</b>" + this._name.substring(n));
        } else {
            String string;
            block6: {
                string = this._name;
                try {
                    string = string.replace(prefix, SuggestedItem.getPlaceholderPrefix());
                    string = string.replace(suffix, placeholderSuffix);
                }
                catch (Exception exception) {
                    StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                    if (!stackTraceElementArray[stackTraceElementArray.length - 1].toString().startsWith("java.awt.EventDispatchThread.run")) break block6;
                    System.err.println("Unexpected: " + exception.toString());
                }
            }
            stringBuilder.append(string);
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public String getName() {
        return this._name;
    }

    public String getOwner() {
        return this._owner;
    }

    public int getPrefixLength() {
        return this._len;
    }

    public void setPrefixLength(int n) {
        this._len = n;
    }

    public String toString() {
        if ("SCHEMA".equals(this._type)) {
            return this._name;
        }
        if (this._owner != null && 0 < this._owner.length()) {
            return this._owner + '.' + this._name;
        }
        return this._name;
    }

    public boolean isDocSnippet() {
        return "SNIPPET".equals(this.getType()) && !"...".equals(this.getName()) && !"select * from".equalsIgnoreCase(this.getName());
    }

    public boolean equals(Object object) {
        if (!(object instanceof SuggestedItem)) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        SuggestedItem suggestedItem = (SuggestedItem)object;
        if (this._pos != -1 && this._pos != suggestedItem._pos) {
            return this._pos - suggestedItem._pos;
        }
        if (this.priority() != suggestedItem.priority()) {
            return this.priority() - suggestedItem.priority();
        }
        if (this._name == null) {
            return -1;
        }
        if (suggestedItem._name == null) {
            return 1;
        }
        if (this._name.startsWith("...") && !suggestedItem._name.startsWith("...")) {
            return 1;
        }
        if (!this._name.startsWith("...") && suggestedItem._name.startsWith("...")) {
            return -1;
        }
        if (this._owner == null && suggestedItem._owner != null) {
            return -1;
        }
        if (suggestedItem._owner == null && this._owner != null) {
            return 1;
        }
        if (this._owner != null && !this._owner.equals(suggestedItem._owner)) {
            return this._owner.compareTo(suggestedItem._owner);
        }
        if ("EQUIJOIN CONDITION".equalsIgnoreCase(this._type)) {
            String string = this._name.toUpperCase();
            String string2 = suggestedItem._name.toUpperCase();
            if (string.endsWith("_ID") && !string2.endsWith("_ID") || string.endsWith("_NAME") && !string2.endsWith("_NAME")) {
                return -1;
            }
            if (!string.endsWith("_ID") && string2.endsWith("_ID") || !string.endsWith("_NAME") && string2.endsWith("_NAME")) {
                return 1;
            }
        } else if ("SNIPPET".equalsIgnoreCase(this._type)) {
            return this._name.length() - suggestedItem._name.length();
        }
        return super.compareTo(object);
    }

    public static List<SuggestedItem> addSuggestions(Set<Substr> set, String string) {
        LinkedList<SuggestedItem> linkedList = new LinkedList<SuggestedItem>();
        for (Substr substr : set) {
            String string2 = substr.cutSrc();
            string2 = string2.replace("<", "&lt;");
            string2 = string2.replace(">", "&gt;");
            SuggestedItem suggestedItem = new SuggestedItem(string, null, string2);
            suggestedItem.doc = substr.getDoc();
            linkedList.add(suggestedItem);
        }
        return linkedList;
    }

    public static int countOwners(Set<SuggestedItem> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (SuggestedItem suggestedItem : set) {
            hashSet.add(suggestedItem.getOwner());
        }
        return hashSet.size();
    }

    public static String getPlaceholderPrefix() {
        block4: {
            if (placeholderPrefix != null) {
                return placeholderPrefix;
            }
            try {
                Color color = Color.gray;
                Preferences preferences = Preferences.getPreferences();
                SyntaxColorsOptions syntaxColorsOptions = SyntaxColorsOptions.getInstance((PropertyStorage)preferences);
                for (Object e : syntaxColorsOptions.getStyleList()) {
                    S2Highlight s2Highlight;
                    if (!(e instanceof S2Highlight) || !"tab-field".equals((s2Highlight = (S2Highlight)e).getStyleName())) continue;
                    color = new Color(s2Highlight.getBackgroundRGB());
                }
                placeholderPrefix = "<FONT style=\"BACKGROUND-COLOR: #" + Integer.toHexString(color.getRGB()).substring(2) + "\">";
            }
            catch (Exception exception) {
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                if (!stackTraceElementArray[stackTraceElementArray.length - 1].toString().startsWith("java.awt.EventDispatchThread.run")) break block4;
                System.err.println("Unexpected: " + exception.toString());
            }
        }
        return placeholderPrefix;
    }

    public String format() {
        String string = this.toString();
        if (!"ARGUMENT".equals(this._type)) {
            return string;
        }
        if (!((Boolean)Format.options.get(Format.breaksProcArgs)).booleanValue()) {
            return string;
        }
        String string2 = Service.padln((String)"", (int)((Integer)Format.options.get(Format.identSpaces)));
        return "\n" + string2 + string.replace(",", ",\n" + string2);
    }
}

