/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ConnectionCloseCleanup;
import oracle.dbtools.raptor.DBDevExtensionResource;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.dialogs.LoginMessagePanel;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.scriptrunner.GuiScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionInitializer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.plsql.PlSqlCompilerOptions;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdbc.OracleConnection;

final class InitializeConnectionListener {
    private static final Logger logger = Logger.getLogger(InitializeConnectionListener.class.getName());

    InitializeConnectionListener() {
    }

    void register() {
        Connections connections = Connections.getInstance();
        connections.addInitializer(new ConnectionInitializer(){

            @Override
            public void initializeConnection(ConnectionDetails connectionDetails) {
                InitializeConnectionListener.this.initConnection(connectionDetails);
            }
        });
        connections.addConnectionDisconnectListener(ConnectionCloseCleanup.getInstance());
    }

    public void initConnection(ConnectionDetails connectionDetails) {
        String string = connectionDetails.getQualifiedConnectionName();
        Connection connection = connectionDetails.getConnection();
        Properties properties = connectionDetails.getConnectionProperties();
        boolean bl = connectionDetails.isBackgroundConnection();
        Connections connections = Connections.getInstance();
        try {
            Integer n;
            Object object;
            DatabaseConnection databaseConnection;
            if (connectionDetails.isReconnect()) {
                databaseConnection = Databases.getConnectionNode(string, false);
                if (databaseConnection != null) {
                    databaseConnection.reopenConnection(connection);
                }
                object = new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)DBDevExtensionResource.getString("RECONNECT_MESSAGE"), (String)DBDevExtensionResource.getString("RECONNECT_TITLE"), null);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    object.run();
                } else {
                    SwingUtilities.invokeLater((Runnable)object);
                }
            }
            connection.getMetaData().getUserName();
            databaseConnection = RaptorVersionTracker.getDbVersion(connection);
            object = ConnectionTypeDetails.getTypeDetails(string, connection);
            DBConfig dBConfig = DBConfig.getInstance();
            if (((ConnectionTypeDetails)object).isSupportsAutocommit()) {
                boolean bl2 = dBConfig.getBoolean("AUTOCOMMIT");
                try {
                    connection.setAutoCommit(bl2);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (!bl) {
                InitializeConnectionListener.displayLoginMessages(connection);
            }
            Connections.safePropertySetter(properties, "PreferfedFetchSize", (n = ((ConnectionTypeDetails)object).getPreferredFetchSize()) != null ? n.toString() : null);
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            if (connections.isOracle(connection)) {
                Object object2;
                String string2;
                PlSqlCompilerOptions plSqlCompilerOptions;
                Object object3;
                if (databaseConnection.compareTo(new Version("9")) < 0) {
                    object3 = new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Messages.getString("InitializeConnectionListener.2"), (String)Messages.getString("InitializeConnectionListener.3"), (String)"f1_nonsupporteddb_html");
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        object3.run();
                    } else {
                        SwingUtilities.invokeLater((Runnable)object3);
                    }
                }
                if (databaseConnection.compareTo(new Version("11")) >= 0) {
                    object3 = dBConfig.getString("PLSQLSCOPE");
                    if (object3 != null && "All".equals(((String)object3).trim())) {
                        dBUtil.execute("alter session set PLSCOPE_SETTINGS='identifiers:all'", Collections.emptyList());
                    }
                    connections.putProperty(connection, "SESSIONID", dBUtil.executeReturnOneCol("select sys_context('USERENV','SESSIONID') from dual", Collections.emptyList()));
                    connections.putProperty(connection, "SID", dBUtil.executeReturnOneCol("select sys_context('USERENV','SID') from dual", Collections.EMPTY_LIST));
                }
                if (databaseConnection.compareTo(new Version("10")) >= 0) {
                    dBUtil.execute("alter session set PLSQL_OPTIMIZE_LEVEL=" + dBConfig.getString("PLSQLOPTIMLEVEL"), Collections.emptyList());
                }
                if (!connections.isTimesTen(string) && databaseConnection.compareTo(new Version("11")) <= 0) {
                    dBUtil.execute("alter session set PLSQL_DEBUG=" + (dBConfig.getInt("PLSQLOPTIMLEVEL") < 2), Collections.emptyList());
                }
                if ((plSqlCompilerOptions = GlobalSettings.createGlobalSettings((PropertyStorage)(object3 = Preferences.getPreferences())).getPlSqlCompilerOptions()).getWarningValue(PlSqlCompilerOptions.WarningCategory.ALL) != null) {
                    dBUtil.execute("ALTER SESSION SET PLSQL_WARNINGS = '" + plSqlCompilerOptions.getWarningValue(PlSqlCompilerOptions.WarningCategory.ALL).toString().toLowerCase() + ":all'", Collections.emptyList());
                }
                if (plSqlCompilerOptions.getWarningValue(PlSqlCompilerOptions.WarningCategory.INFORMATIONAL) != null) {
                    dBUtil.execute("ALTER SESSION SET PLSQL_WARNINGS = '" + plSqlCompilerOptions.getWarningValue(PlSqlCompilerOptions.WarningCategory.INFORMATIONAL).toString().toLowerCase() + ":informational'", Collections.emptyList());
                }
                if (plSqlCompilerOptions.getWarningValue(PlSqlCompilerOptions.WarningCategory.SEVERE) != null) {
                    dBUtil.execute("ALTER SESSION SET PLSQL_WARNINGS = '" + plSqlCompilerOptions.getWarningValue(PlSqlCompilerOptions.WarningCategory.SEVERE).toString().toLowerCase() + ":severe'", Collections.emptyList());
                }
                if (plSqlCompilerOptions.getWarningValue(PlSqlCompilerOptions.WarningCategory.PERFORMANCE) != null) {
                    dBUtil.execute("ALTER SESSION SET PLSQL_WARNINGS = '" + plSqlCompilerOptions.getWarningValue(PlSqlCompilerOptions.WarningCategory.PERFORMANCE).toString().toLowerCase() + ":performance'", Collections.emptyList());
                }
                if (!(string2 = dBUtil.executeReturnOneCol("select count(1) from all_objects where object_name = ?", Collections.singletonList("APEX_RELEASE"))).equals("0") && (object2 = dBUtil.executeReturnOneCol("select  version_no from apex_release", Collections.emptyList())) != null) {
                    connections.putProperty(connection, "APEX_VERSION", new Version((String)object2));
                }
                if ((object2 = NLSProvider.getProvider((Connection)connection)) != null) {
                    object2.updateDefaults(dBConfig.getNLSMap());
                    object2.initConnection();
                }
                if (connection instanceof OracleConnection) {
                    ((OracleConnection)connection).setDefaultRowPrefetch(dBConfig.getInt("ARRAYFETCHSIZE"));
                }
                this.runLoginSql(string);
            }
        }
        catch (SQLException sQLException) {
            logger.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
    }

    private void checkDisplayWarnings(final Connection connection) throws SQLException {
        SQLWarning sQLWarning;
        if (Connections.getInstance().isOracle(connection) && (sQLWarning = connection.getWarnings()) != null && sQLWarning.getErrorCode() != 17110) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SQLErrorDialog.showWarningDialog((String)Connections.getInstance().getConnectionName(connection), null, (SQLWarning)sQLWarning);
                }
            });
        }
    }

    private static void displayLoginMessages(Connection connection) throws SQLException {
        if (Connections.getInstance().isOracle(connection)) {
            LoginMessagePanel.displayLoginMessages((String)Connections.getInstance().getConnectionName(connection), (Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLoginSql(String string) {
        DBConfig dBConfig = DBConfig.getInstance();
        String string2 = dBConfig.getString("");
        if (dBConfig.getBoolean("GLOGIN").booleanValue() && string2 != null && !string2.equals("")) {
            File file = new File(dBConfig.getString(""));
            GuiScriptRunnerContext guiScriptRunnerContext = new GuiScriptRunnerContext();
            String string3 = guiScriptRunnerContext.getSourceRef();
            if (file.exists()) {
                try {
                    guiScriptRunnerContext.setSourceRef(file.getCanonicalPath());
                    ScriptUtils.runAsScript(new FileInputStream(file), string, guiScriptRunnerContext);
                    Properties properties = Connections.getInstance().getConnectionInfo(string);
                    properties.put("GLOGIN", (Object)guiScriptRunnerContext);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    logger.fine("No " + dBConfig.getString("") + " found");
                }
                catch (IOException iOException) {
                    logger.fine("No " + dBConfig.getString("") + " found");
                }
                catch (SecurityException securityException) {
                    logger.fine("No " + dBConfig.getString("") + " found");
                }
                finally {
                    guiScriptRunnerContext.setSourceRef(string3);
                }
            }
        }
    }
}

