/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.apex.importer;

import java.awt.Cursor;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.apex.importer.ApexDeployToConnectionPanel;
import oracle.dbtools.raptor.apex.importer.ApexImportArb;
import oracle.dbtools.raptor.apex.importer.ApexImportFilePanel;
import oracle.dbtools.raptor.apex.importer.ApexImportFinalPanel;
import oracle.dbtools.raptor.apex.importer.ApexImportIDPanel;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.jdbc.OraclePreparedStatement;

public class ApexImporter {
    public static final String CONNECTION = "connection";
    public static final String APEX_NAME = "p_name";
    public static final String APEX_ALIAS = "p_alias";
    public static final String APEX_ID = "p_id";
    public static final String APEX_BUILD = "p_build_status";
    public static final String APEX_OWNER = "p_owner";
    public static final String APEX_OFFSET = "offset";
    public static final String APEX_SGID = "sgid";
    public static final String APEX_WORKSPACE = "workspace_name";
    public static final String APEX_SELECTED_COMBO = "SEL";
    public static final String APEX_ISOVERWRITE = "ISOVERWRITE";
    public static final String APEX_APP_NAME = "APP_NAME";
    public static final String APEX_FROM_DEPLOY = "APEX_FROM_DEPLOY";
    public static final String APEX_INFO = "APEX_INFO";
    public static final String APEX_AVAILID = "APEX_AVAILID";
    public static final String APEX_WORKSPACELIST = "APEX_WORKSPACELIST";
    public static final String APEX_LOCKCONNNAME = "APEX_LOCKCONNNAME";
    public static final String APEX_DBO = "APEX_DBO";
    public static final String APEX_USERNAME = "APEX_USERNAME";
    public static final String APEX_TOCONN = "APEX_TOCONN";
    public static final String APEX_FROMCONN = "APEX_FROMCONN";
    public static final String CONTEXT_KEY = "CONTEXT";
    public static final String WIZARD_KEY = "WIZ";
    public static final String FILE_KEY = "FILENAME";
    public static final String SCRIPT_STATUS_KEY = "SCRIPT.STATUS";
    public static final String RUN_SCRIPT_KEY = "SCRIPT.RUN";
    private static final Logger LOGGER = Logger.getLogger(ApexImporter.class.getName());
    public static final String ENCODING = "UTF-8";
    public static final String ENCODING_KEY = "SCRIPT.ENCODING";

    public static void showWizard(Context context) {
        DBObject dBObject = new DBObject(context.getSelection()[0]);
        context.setProperty("DB_OBJECT", (Object)dBObject);
        Step[] stepArray = new Step[3];
        stepArray[0] = new Step(ApexImportArb.getString("FILE_TITLE"), ApexImportFilePanel.class);
        stepArray[0].setHelpID("f1_apeximport_file");
        stepArray[1] = new Step(ApexImportArb.getString("ID_TITLE"), ApexImportIDPanel.class);
        stepArray[1].setHelpID("f1_apeximport_id");
        stepArray[2] = new Step(ApexImportArb.getString("FINISH_TITLE"), ApexImportFinalPanel.class);
        stepArray[2].setHelpID("f1_apeximport_finish");
        Namespace namespace = new Namespace();
        namespace.put(CONTEXT_KEY, (Object)context);
        FSMWizard fSMWizard = new FSMWizard(stepArray, namespace);
        fSMWizard.setWizardTitle(ApexImportArb.getString("IMPORT_TITLE"));
        fSMWizard.setWelcomePageAdded(false);
        fSMWizard.setFinishPageAdded(true);
        fSMWizard.setShowStepNumber(true);
        fSMWizard.updateImage(ApexImportArb.getImage("WIZ_IMAGE"));
        fSMWizard.setRoadmapVisible(false);
        WizardDialog wizardDialog = fSMWizard.getDialog((Frame)Ide.getMainWindow());
        namespace.put(WIZARD_KEY, (Object)wizardDialog);
        WizardLauncher.runDialog((JDialog)wizardDialog);
        wizardDialog.dispose();
    }

    public static void showDeployWizard(Context context) {
        ApexImporter.showDeployWizard(context, null);
    }

    public static void showDeployWizard(Context context, String string) {
        DBObject dBObject = new DBObject(context.getSelection()[0]);
        context.setProperty("DB_OBJECT", (Object)dBObject);
        Step[] stepArray = new Step[null == string ? 3 : 2];
        int n = 0;
        if (null == string) {
            stepArray[n] = new Step(ApexImportArb.getString("DEPLOY_TITLE"), ApexDeployToConnectionPanel.class);
            stepArray[n++].setHelpID("f1_apexdeployto_id");
        }
        stepArray[n] = new Step(ApexImportArb.getString("ID_TITLE"), ApexImportIDPanel.class);
        stepArray[n++].setHelpID("f1_apeximport_id");
        stepArray[n] = new Step(ApexImportArb.getString("FINISH_TITLE"), ApexImportFinalPanel.class);
        stepArray[n++].setHelpID("f1_apeximport_finish");
        Namespace namespace = new Namespace();
        namespace.put(CONTEXT_KEY, (Object)context);
        if (string != null) {
            namespace.put(CONNECTION, (Object)string);
            namespace.put(APEX_FROM_DEPLOY, (Object)true);
        }
        File file = null;
        Ide.getMainWindow().setCursor(new Cursor(3));
        try {
            file = File.createTempFile("apex", ".sql");
        }
        catch (IOException iOException) {
            Logger.getLogger(ApexImporter.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        File file2 = file;
        namespace.put(FILE_KEY, (Object)file.getAbsolutePath());
        FSMWizard fSMWizard = new FSMWizard(stepArray, namespace);
        fSMWizard.setWizardTitle(ApexImportArb.getString("DEPLOY_WIZ_TITLE"));
        fSMWizard.setWelcomePageAdded(false);
        fSMWizard.setFinishPageAdded(true);
        fSMWizard.setShowStepNumber(true);
        fSMWizard.updateImage(ApexImportArb.getImage("WIZ_IMAGE"));
        fSMWizard.setRoadmapVisible(false);
        WizardDialog wizardDialog = fSMWizard.getDialog((Frame)Ide.getMainWindow());
        namespace.put(WIZARD_KEY, (Object)wizardDialog);
        WizardLauncher.runDialog((JDialog)wizardDialog);
        wizardDialog.dispose();
        Ide.getMainWindow().setCursor(new Cursor(0));
    }

    public static Map<String, String> getInfo(String string) {
        return ApexImporter.getInfo(string, ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getInfo(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            string2 = ENCODING;
        }
        BufferedReader bufferedReader = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(APEX_BUILD, "RUN_AND_BUILD");
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), string2));
            boolean bl = false;
            int n = 0;
            while (true) {
                ++n;
                String string3 = bufferedReader.readLine();
                if (string3 == null) {
                    break;
                }
                if (bl) {
                    if (string3.trim().toLowerCase().startsWith("end")) {
                        break;
                    }
                    String[] stringArray = string3.split("=>");
                    if (stringArray.length > 1) {
                        String string4 = stringArray[1].trim();
                        if (string4.indexOf("nvl(") > -1) {
                            string4 = string4.substring(string4.indexOf(",") + 1);
                            string4 = string4.substring(0, string4.indexOf(")"));
                        }
                        if (string4.charAt(string4.length() - 1) == ',') {
                            string4 = string4.substring(0, string4.length() - 1);
                        }
                        string4 = string4.trim().replaceAll("'", "");
                        String string5 = stringArray[0].trim();
                        if (string5.startsWith(",")) {
                            string5 = string5.substring(1);
                        }
                        hashMap.put(string5, string4);
                    }
                }
                if (!string3.trim().toLowerCase().startsWith("wwv_flow_api.create_flow")) continue;
                bl = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.severe(Messages.getString("ApexImporter.27") + string);
        }
        catch (IOException iOException) {
            LOGGER.severe(Messages.getString("ApexImporter.28") + string);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        hashMap.put(APEX_ID, (String)hashMap.get("p_display_id"));
        return hashMap;
    }

    public static boolean processFile(File file, File file2, Map<String, String> map) {
        return ApexImporter.processFile(file, file2, map, ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processFile(File file, File file2, Map<String, String> map, String string) {
        if (string == null || string.equals("")) {
            string = ENCODING;
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), ENCODING));
            bufferedWriter.write("set scan off");
            bufferedWriter.newLine();
            bufferedWriter.write("begin");
            bufferedWriter.newLine();
            if (map.get(APEX_ID).equals("AUTO")) {
                bufferedWriter.write("    apex_application_install.generate_application_id;");
            } else {
                bufferedWriter.write("    apex_application_install.set_application_id(" + map.get(APEX_ID) + ");");
            }
            bufferedWriter.newLine();
            if (map.get(RUN_SCRIPT_KEY).equals("TRUE")) {
                bufferedWriter.write("    apex_application_install.set_auto_install_sup_obj(true);");
            } else {
                bufferedWriter.write("    apex_application_install.set_auto_install_sup_obj(false);");
            }
            bufferedWriter.newLine();
            bufferedWriter.write("    apex_application_install.generate_offset;");
            bufferedWriter.newLine();
            bufferedWriter.write("    apex_application_install.set_application_name('" + map.get(APEX_NAME) + "');");
            bufferedWriter.newLine();
            bufferedWriter.write("    apex_application_install.set_workspace_id(" + map.get(APEX_SGID) + ");");
            bufferedWriter.newLine();
            bufferedWriter.write("    apex_application_install.set_application_alias('" + map.get(APEX_ALIAS) + "');");
            bufferedWriter.newLine();
            bufferedWriter.write("    apex_application_install.set_schema('" + map.get(APEX_OWNER) + "');");
            bufferedWriter.newLine();
            bufferedWriter.write("end;");
            bufferedWriter.newLine();
            bufferedWriter.write("/");
            bufferedWriter.newLine();
            bufferedWriter.write("@'" + file.getAbsolutePath() + "'");
            bufferedWriter.newLine();
            bufferedWriter.write("commit;");
            bufferedWriter.newLine();
        }
        catch (Exception exception) {
            LOGGER.severe(Messages.getString("ApexImporter.47") + file2);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static String procedurealRegexp(String string, String string2, String string3) {
        try {
            new Long(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return string.replaceAll(string2, string3);
        }
        Matcher matcher = Pattern.compile(string2).matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        boolean bl = false;
        while (matcher.find()) {
            String string4 = "";
            string4 = matcher.start() != 0 && Character.isDigit(string.charAt(matcher.start() - 1)) || matcher.end() != string.length() && Character.isDigit(string.charAt(matcher.end())) ? (matcher.end() == string.length() ? string.substring(matcher.start()) : string.substring(matcher.start(), matcher.end())) : string3;
            if (matcher.start() > 0) {
                stringBuffer.append(string.substring(n, matcher.start()));
            }
            stringBuffer.append(string4);
            n = matcher.end();
            bl = true;
        }
        if (!bl) {
            stringBuffer.append(string);
        } else if (n != string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    public static void saveToFile(DBObject dBObject, File file) {
        if (dBObject != null) {
            DDLGenerator.getInstance().setFile(file.getAbsolutePath(), ENCODING);
            try {
                DDLGenerator.getInstance().openFile();
                DDLGenerator.getInstance().getWriter().write(DDLGenerator.getInstance().getDDL(dBObject));
                DDLGenerator.getInstance().closeFile();
            }
            catch (IOException iOException) {
                Logger.getLogger(ApexImporter.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            catch (Exception exception) {
                Logger.getLogger(ApexImporter.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    public static ScriptStatus getScriptStatus(String string) {
        return ApexImporter.getScriptStatus(string, ENCODING);
    }

    public static ScriptStatus getScriptStatus(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            string2 = ENCODING;
        }
        ScriptStatus scriptStatus = ScriptStatus.NONE;
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), string2));
            String string4 = null;
            while (scriptStatus == ScriptStatus.NONE && scriptStatus != ScriptStatus.CONDTIONAL && (string3 = bufferedReader.readLine()) != null) {
                if (string3.indexOf("wwv_flow_api.create_install_script") <= -1) continue;
                if (scriptStatus != ScriptStatus.CONDTIONAL) {
                    scriptStatus = ScriptStatus.NONCONDITIONAL;
                }
                string4 = bufferedReader.readLine();
                while (string4.indexOf("end;") == -1) {
                    if (string4.indexOf("p_condition") > 0) {
                        scriptStatus = ScriptStatus.CONDTIONAL;
                    }
                    string4 = bufferedReader.readLine();
                }
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(ApexImporter.class.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger(ApexImporter.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        return scriptStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUnInstallScript(Connection connection, BigDecimal bigDecimal) {
        StringBuilder stringBuilder = new StringBuilder();
        if (Connections.getInstance().lock(connection)) {
            try {
                OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement("select  DEINSTALLATION_SCRIPT||chr(10) script  from APEX_APPLICATION_SUPP_OBJECTS    where application_id = :APPLICATION_ID");
                oraclePreparedStatement.setBigDecimalAtName("APPLICATION_ID", bigDecimal);
                ResultSet resultSet = oraclePreparedStatement.executeQuery();
                while (resultSet.next()) {
                    stringBuilder.append(resultSet.getString(1));
                    stringBuilder.append("\n");
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNewID(Connection connection) {
        CallableStatement callableStatement = null;
        String string = null;
        if (Connections.getInstance().lock(connection)) {
            try {
                callableStatement = connection.prepareCall("begin ? := apex_util.minimum_free_application_id; end; ");
                callableStatement.registerOutParameter(1, -5);
                callableStatement.execute();
                string = callableStatement.getBigDecimal(1).toString();
            }
            catch (SQLException sQLException) {
            }
            finally {
                try {
                    if (callableStatement != null) {
                        callableStatement.close();
                    }
                }
                catch (SQLException sQLException) {}
                Connections.getInstance().unlock(connection);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkAvail(Connection connection, Long l, Long l2) {
        int n = -1;
        if (Connections.getInstance().lock(connection)) {
            try {
                CallableStatement callableStatement = null;
                try {
                    callableStatement = connection.prepareCall("begin ? := apex_util.get_application_id_status(?,?); end; ");
                    callableStatement.setLong(2, (long)l);
                    callableStatement.setLong(3, (long)l2);
                    callableStatement.registerOutParameter(1, -5);
                    callableStatement.execute();
                    n = callableStatement.getBigDecimal(1).intValue();
                }
                catch (SQLException sQLException) {
                    ExceptionHandler.handleException((Throwable)sQLException);
                }
                finally {
                    try {
                        if (callableStatement != null) {
                            callableStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkAvailAccess(Connection connection, String string) {
        boolean bl = true;
        if (Connections.getInstance().lock(connection)) {
            try {
                CallableStatement callableStatement = null;
                try {
                    callableStatement = connection.prepareCall("begin ? := apex_util.find_security_group_id(?); end; ");
                    callableStatement.setString(2, string);
                    callableStatement.registerOutParameter(1, -5);
                    callableStatement.execute();
                    if (callableStatement.getBigDecimal(1) == null) {
                        bl = false;
                    }
                }
                catch (SQLException sQLException) {
                    bl = false;
                }
                finally {
                    try {
                        if (callableStatement != null) {
                            callableStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        bl = false;
                    }
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    public static String getAppId(Connection connection, String string, String string2, String string3) {
        String string4 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(string2);
        arrayList.add(string3);
        string4 = DBUtil.getInstance((Connection)connection).executeReturnOneCol("select application_id from apex_applications where application_name=:APP_NAME and alias=:APP_ALIAS and workspace_id=:WS_ID", arrayList);
        return string4;
    }

    public static String getAppName(Connection connection, Long l, Long l2) {
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(l2.toString());
        arrayList.add(l.toString());
        string = DBUtil.getInstance((Connection)connection).executeReturnOneCol("select application_name from apex_applications where application_id=:APP_ID and workspace_id=:WORKSPACE_ID", arrayList);
        return string;
    }

    public static boolean validateApexVersion(String string) {
        String string2 = DBUtil.getInstance((String)string).executeReturnOneCol("select count(1) from all_objects where object_name = 'APEX_RELEASE'", Collections.emptyList());
        return Integer.parseInt(string2) > 0;
    }

    public static enum ScriptStatus {
        NONE,
        NONCONDITIONAL,
        CONDTIONAL;

    }
}

