/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection;

import javax.naming.NamingException;
import javax.naming.Reference;
import oracle.dbtools.connections.ConnectionReferenceable;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.raptor.cloud.connection.CConnectionInfoFactory;

public final class ConnectionInfoReferenceable
implements ConnectionReferenceable {
    private final SessionInfo mInfo;

    public ConnectionInfoReferenceable(SessionInfo sessionInfo) {
        this.mInfo = sessionInfo;
    }

    public SessionInfo getConnectionInfo() {
        return this.mInfo;
    }

    public Reference getReference() throws NamingException {
        SessionInfo.OssInfo ossInfo;
        Reference reference = new Reference(ConnectionInfoReferenceable.class.getName(), CConnectionInfoFactory.class.getName(), null);
        CConnectionInfoFactory.setURIValue(reference, "ROOT_URI", this.mInfo.getServerRoot());
        CConnectionInfoFactory.setURIValue(reference, "SERVICE_URI", this.mInfo.getServiceRoot());
        CConnectionInfoFactory.setStringValue(reference, "USERNAME", this.mInfo.getUsername());
        CConnectionInfoFactory.setSecureValue(reference, "AUTHENTICATION", this.mInfo.getPassword(), this.mInfo.getName());
        SessionInfo.SftpInfo sftpInfo = this.mInfo.getSftpInfo();
        if (sftpInfo != null) {
            CConnectionInfoFactory.setStringValue(reference, "SFTP_HOST", sftpInfo.getSftpHost());
            CConnectionInfoFactory.setStringValue(reference, "SFTP_USERNAME", sftpInfo.getSftpUser());
            CConnectionInfoFactory.setSecureValue(reference, "SFTP_AUTHENTICATION", sftpInfo.getSftpPass(), this.mInfo.getName());
            CConnectionInfoFactory.setIntValue(reference, "SFTP_PORT", sftpInfo.getSftpPort());
        }
        if ((ossInfo = this.mInfo.getOssInfo()) != null) {
            CConnectionInfoFactory.setBooleanValue(reference, "OSS_ENABLED", ossInfo.isOssEnabled());
            CConnectionInfoFactory.setStringValue(reference, "OSS_SERVICE_NAME", ossInfo.getOssServiceName());
            CConnectionInfoFactory.setStringValue(reference, "OSS_IDENTITY_DOMAIN", ossInfo.getOssIdentityDomain());
            CConnectionInfoFactory.setStringValue(reference, "OSS_USERNAME", ossInfo.getOssUserName());
            CConnectionInfoFactory.setSecureValue(reference, "OSS_AUTHENICATION", ossInfo.getOssPassword(), this.mInfo.getName());
            CConnectionInfoFactory.setStringValue(reference, "OSS_SERVICE_URL", ossInfo.getOssServiceUrl());
        }
        return reference;
    }
}

