/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.text.BadLocationException;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.app.Format;
import oracle.dbtools.format.SQLFormatterArb;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.CustomFormat;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.FormatSQLOptionsPanel;
import oracle.dbtools.raptor.plsql.structure.ArboriEditor;
import oracle.dbtools.raptor.runner.RunnerArb;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.util.Service;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.icons.OracleIcons;

public class FormatSQLCustomOptions
extends FormatSQLOptionsPanel
implements ChangeListener {
    final JButton importJB = new JButton(StringUtils.stripMnemonic((String)Messages.getString("FormatSQLAdvancedOptions.import")));
    final JButton exportJB = new JButton(StringUtils.stripMnemonic((String)Messages.getString("FormatSQLAdvancedOptions.export")));
    final JButton resetJB = new JButton(StringUtils.stripMnemonic((String)RunnerArb.getString("LABEL_RESET")));
    ArboriEditor code = new ArboriEditor();
    private static String[] parenthesisSpacing = new String[]{Messages.getString("FormatSQLAdvancedOptions.inside"), Messages.getString("FormatSQLAdvancedOptions.outside"), Messages.getString("FormatSQLAdvancedOptions.noSpace")};
    private static final String fname = "format.arbori";

    public FormatSQLCustomOptions() {
        this.setHelpID("f1_formatcustomoptions_html");
        JPanel jPanel = new JPanel(new GridBagLayout());
        JButton jButton = new JButton(OracleIcons.getIcon((String)"run.png"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FormatSQLCustomOptions.this.run();
            }
        });
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(150));
        this.importJB.addActionListener(this);
        jPanel.add(this.importJB);
        this.exportJB.addActionListener(this);
        jPanel.add(Box.createHorizontalStrut(50));
        jPanel.add(this.exportJB);
        this.resetJB.addActionListener(this);
        jPanel.add(Box.createHorizontalStrut(50));
        jPanel.add(this.resetJB);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Last");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add(this.code);
        JScrollPane jScrollPane = new JScrollPane(jPanel3, 22, 32);
        jScrollPane.setMinimumSize(new Dimension(300, 300));
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)new JScrollPane((Component)this.editor), "Center");
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setLeftComponent(jPanel2);
        jSplitPane.setRightComponent(jPanel4);
        this.setLayout(new BorderLayout());
        this.add(jSplitPane, "Center");
    }

    private void run() {
        try {
            this.saveCustomProgram();
            this.updatePreview();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void loadProgram() {
        Format.resetProgramInstance();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        System.out.println("stateChanged");
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        System.out.println("valueChanged");
    }

    @Override
    public void onEntry(TraversableContext traversableContext) {
        String string = null;
        try {
            string = CustomFormat.getInstance().getActiveFormatProgram();
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
        }
        try {
            this.code.getDocument().remove(0, this.code.getDocument().getLength());
            this.code.getDocument().insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.code.setCaretPosition(0);
        this.updatePreview();
    }

    @Override
    public void onExit(TraversableContext traversableContext) {
        try {
            this.saveCustomProgram();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void saveCustomProgram() throws IOException {
        String string;
        String string2 = FormatSQLCustomOptions.getDefaultCustomURL().getFile();
        String string3 = this.code.getText();
        boolean bl = (string3 = string3.replace("\r\r", "\r")).equals(string = Service.readFile(Format.class, (String)"/oracle/dbtools/app/format.prg"));
        if (bl) {
            Format.resetProgramInstance();
            Format.options.put(Format.formatProgramURL, "default");
            FormatSQLOptionsPanel.saveOptions();
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        fileOutputStream.write(string3.getBytes());
        fileOutputStream.close();
        Format.resetProgramInstance();
        Format.options.put(Format.formatProgramURL, string2);
        FormatSQLOptionsPanel.saveOptions();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.importExportResetArboriCode(actionEvent.getSource());
    }

    private URL lastImportExportURL() {
        DBConfig dBConfig = DBConfig.getInstance();
        try {
            String string = dBConfig.getString("FORMAT_PROFILE_URL");
            if (!"N/A".equals(string)) {
                return new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return null;
    }

    public static URL getDefaultCustomURL() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        URL uRL = extensionRegistry.getSystemDirectory("oracle.sqldeveloper");
        return URLFactory.newURL((URL)uRL, (String)fname);
    }

    private void importExportResetArboriCode(Object object) {
        if (object == this.resetJB) {
            try {
                try {
                    this.code.getDocument().remove(0, this.code.getDocument().getLength());
                    this.code.getDocument().insertString(0, Service.readFile(Format.class, (String)"format.prg"), null);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
                this.code.setCaretPosition(0);
                this.saveCustomProgram();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.editor.setText(FormatSQLCustomOptions.getSample());
            this.updatePreview();
            return;
        }
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.clearChooseableURLFilters();
        DefaultURLFilter defaultURLFilter = new DefaultURLFilter(SQLFormatterArb.getString("PROFILE_FILTER_NAME"), ".arbori");
        uRLFileChooser.addChooseableURLFilter((URLFilter)defaultURLFilter);
        uRLFileChooser.addChooseableURLFilter(URLFileChooser.ALL_FILES_FILTER);
        uRLFileChooser.setURLFilter((URLFilter)defaultURLFilter);
        if (this.lastImportExportURL() != null) {
            uRLFileChooser.setSelectedURL(this.lastImportExportURL());
        } else {
            URL uRL = this.getUserHomeDirectory();
            if (uRL != null) {
                uRLFileChooser.setSelectedURL(uRL);
            }
        }
        int n = -1;
        n = object == this.importJB ? uRLFileChooser.showOpenDialog((Component)((Object)this), SQLFormatterArb.getString("IMPORT_CUSTOM_PROGRAM")) : uRLFileChooser.showSaveDialog((Component)((Object)this), SQLFormatterArb.getString("EXPORT_CUSTOM_PROGRAM"));
        if (n == 0) {
            Object object2;
            URL uRL = uRLFileChooser.getSelectedURL();
            if (object == this.importJB) {
                try {
                    this.code.getDocument().remove(0, this.code.getDocument().getLength());
                    this.code.getDocument().insertString(0, Service.readFile((String)uRL.getFile()), null);
                    this.saveCustomProgram();
                }
                catch (IOException | BadLocationException exception) {
                    exception.printStackTrace();
                }
                this.updatePreview();
            } else if (this.checkExistingFile(uRL)) {
                try {
                    object2 = uRL.getFile();
                    FileOutputStream fileOutputStream = new FileOutputStream((String)object2);
                    fileOutputStream.write(this.code.getText().getBytes());
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            object2 = DBConfig.getInstance();
            object2.putString("FORMAT_PROFILE_URL", uRL.toString());
        }
    }

    private URL getUserHomeDirectory() {
        URL uRL = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
        return URLFileSystem.exists((URL)uRL) ? uRL : null;
    }

    private boolean checkExistingFile(URL uRL) {
        if (URLFileSystem.exists((URL)uRL)) {
            String string = SQLFormatterArb.format("EXPORT_OVERWRITE_WARNING_MESSAGE", URLFileSystem.getPlatformPathName((URL)uRL));
            String string2 = SQLFormatterArb.getString("EXPORT_OVERWRITE_WARNING_TITLE");
            int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), string, string2, 2);
            return n == 0;
        }
        return true;
    }
}

