/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config.homesupport;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.config.homesupport.ConfigureClientPanel;
import oracle.dbtools.raptor.config.homesupport.OracleHomeSettings;
import oracle.dbtools.raptor.startup.OracleHomeType;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;

public class OracleClientPanel
extends DefaultTraversablePanel
implements ActionListener {
    private static final String CONFIGURE_CLIENT_CMD = "AdvancedInfo.ConfigureClient";
    private JTextField m_fldClientInfo = new JTextField();
    private JButton m_btnClientConfig = new JButton();
    private OracleHomeSettings.OracleHome m_home;

    public OracleClientPanel() {
        this.setLayout(new GridBagLayout());
        this.m_fldClientInfo.setEditable(false);
        this.add(this.m_fldClientInfo, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        ResourceUtils.resButton((AbstractButton)this.m_btnClientConfig, (String)PreferencesArb.getString("BUTTON_CONFIGURE"));
        this.m_btnClientConfig.setActionCommand(CONFIGURE_CLIENT_CMD);
        this.m_btnClientConfig.addActionListener(this);
        this.add(this.m_btnClientConfig, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP));
    }

    public void onEntry(TraversableContext traversableContext) {
        OracleHomeSettings oracleHomeSettings = OracleHomeSettings.createSettings(traversableContext);
        this.updateOracleClient(oracleHomeSettings.getHome());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        OracleHomeSettings oracleHomeSettings = OracleHomeSettings.createSettings(traversableContext);
        oracleHomeSettings.setHome(this.m_home);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (CONFIGURE_CLIENT_CMD.equals(string)) {
            Namespace namespace = new Namespace();
            namespace.put("Dialog.Home", (Object)this.m_home);
            TDialogLauncher tDialogLauncher = this.createDialog(namespace);
            if (tDialogLauncher.showDialog()) {
                OracleHomeSettings.OracleHome oracleHome = (OracleHomeSettings.OracleHome)namespace.get("Dialog.Home");
                this.updateOracleClient(oracleHome);
            }
        }
    }

    private void updateOracleClient(OracleHomeSettings.OracleHome oracleHome) {
        if (ModelUtil.areDifferent((Object)oracleHome, (Object)this.m_home)) {
            this.m_home = oracleHome;
            StringBuilder stringBuilder = new StringBuilder();
            if (oracleHome != null) {
                OracleHomeType oracleHomeType = oracleHome.getType();
                stringBuilder.append(oracleHomeType.toString());
                stringBuilder.append(": ");
                URL uRL = oracleHome.getLocation();
                stringBuilder.append(URLFileSystem.toDisplayString((URL)uRL));
            }
            this.m_fldClientInfo.setText(stringBuilder.toString());
        }
    }

    public TDialogLauncher createDialog(Namespace namespace) {
        ConfigureClientPanel configureClientPanel = new ConfigureClientPanel();
        String string = PreferencesArb.getString("TITLE_CONFIGURE");
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)((Object)this), string, (Traversable)configureClientPanel, namespace);
        tDialogLauncher.setPackDialog(true);
        JEWTDialog jEWTDialog = tDialogLauncher.initDialog();
        jEWTDialog.setInitialFocus(configureClientPanel.getInitialFocusComponent());
        jEWTDialog.getAccessibleContext().setAccessibleName(string);
        JButton jButton = configureClientPanel.getTestButton();
        if (jButton != null) {
            jEWTDialog.addCustomButton((Component)jButton);
        }
        return tDialogLauncher;
    }
}

