/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.util.Properties;
import oracle.dbtools.raptor.connections.ConnectionDialog;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public abstract class IConnectionPanel
extends DefaultTraversablePanel {
    public static final String NAVIGATOR_CONNECTION_TYPE = "RaptorConnectionType";
    public static final String CONNECTION_NAME_KEY = "ConnName";
    public static final String PROPERTY_NO_PASSWORD_CONNECTION = "NoPasswordConnection";
    public static final String UNSHARED_WORKSHEET_ORIGINAL_CONNECTIONNAME = "UnsharedWorksheetOriginalConnectionName";
    protected ConnectionDialog _cd;
    protected Properties m_props;

    public final boolean testConnection(String string, String string2) {
        this.setStatus("");
        Properties properties = this.getConnectionProperties();
        this.setStatus(ConnectionDialogArb.getString("CONNECTION_DIALOG_STATUS"));
        try {
            this.testConnection(properties);
            if (!Thread.currentThread().isInterrupted()) {
                this.setStatus(ConnectionDialogArb.getString("CONNECTION_DIALOG_STATUS_SUCCESS"));
            }
            return true;
        }
        catch (ConnectionException connectionException) {
            this.setErrorStatus(ConnectionDialogArb.getString("CONNECTION_DIALOG_STATUS_FAILURE") + connectionException.getMessage());
            return false;
        }
    }

    public abstract void clear();

    public abstract void updatePrompts(Properties var1);

    public abstract Properties getConnectionProperties();

    public abstract String getDriver();

    public String[] getSupportedDrivers() {
        return new String[]{this.getDriver()};
    }

    public abstract void setDefaultPrompts();

    public abstract String getConnectionType();

    public void setConnectionProperties(Properties properties) {
        this.m_props = properties;
    }

    public void setDialog(ConnectionDialog connectionDialog) {
        this._cd = connectionDialog;
    }

    public ConnectionDialog getDialog() {
        return this._cd;
    }

    public String getUserName() {
        return this._cd.getUserName();
    }

    public String getPassword() {
        return this._cd.getPassword();
    }

    public String getConnectionName() {
        return this._cd.getConnectionName();
    }

    public void setStatus(String string) {
        this._cd.setStatus(string);
    }

    public void setErrorStatus(String string) {
        this._cd.setErrorStatus(string);
    }

    protected void testConnection(Properties properties) throws ConnectionException {
        DatabaseConnections.getInstance().testConnection(properties);
    }

    public void initUI() {
    }
}

