/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections.impexp;

import java.awt.Component;
import java.net.URL;
import javax.swing.JPanel;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.connections.impexp.ImpExpPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

abstract class FilenamePanel
extends ImpExpPanel {
    private static final String XML_EXT = "*.xml";
    private static final String PROPS_EXT = "*.properties";
    private static final String JSON_EXT = "*.json";
    static final URLFilter PROPS_FILTER = new WildcardURLFilter("*.properties", URLFileSystem.isLocalFileSystemCaseSensitive(), ConnectionArb.getString((String)"IMPEXP_PROPS_FILTER_NAME"));
    static final URLFilter XML_FILTER = new WildcardURLFilter("*.xml", URLFileSystem.isLocalFileSystemCaseSensitive(), ConnectionArb.getString((String)"IMPEXP_XML_FILTER_NAME"));
    static final URLFilter JSON_FILTER = new WildcardURLFilter("*.json", URLFileSystem.isLocalFileSystemCaseSensitive(), ConnectionArb.getString((String)"IMPEXP_JSON_FILTER_NAME"));
    private JMultiLineLabel m_descArea = new JMultiLineLabel();
    private ChooserPanel m_filename = new ChooserPanel();

    @Override
    public Object getExitTransition() {
        return super.getExitTransition();
    }

    protected abstract URLFileChooser.URLFileChooserPanel createChooserPanel();

    protected abstract String getDescriptionText();

    @Override
    protected final JPanel createContentPanel() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        this.m_descArea.setText(this.getDescriptionText());
        jPanel.add((Component)this.m_descArea, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.X));
        jPanel.add((Component)this.m_filename.getPanel(), LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.XY, LayoutControl.GBC.Anchor.FIRST_LINE_START));
        return jPanel;
    }

    protected final void setURL(URL uRL) {
        this.m_filename.getPanel().setSelectedURL(uRL);
    }

    protected final URL getURL() {
        return this.m_filename.getPanel().getSelectedURL();
    }

    @Override
    protected final void init(TraversableContext traversableContext) {
        URL uRL = this.getURLFromNamespace(traversableContext);
        this.setURL(uRL);
        this.updateButtonStates(traversableContext);
    }

    @Override
    protected final void commit(TraversableContext traversableContext) throws TraversalException {
        URL uRL = this.getURL();
        if (traversableContext.getDirection() != 2) {
            this.validateURL(uRL);
        }
        this.setURLInNamespace(uRL, traversableContext);
    }

    protected abstract void setURLInNamespace(URL var1, TraversableContext var2) throws TraversalException;

    protected abstract URL getURLFromNamespace(TraversableContext var1);

    abstract boolean isURLAccepted(URL var1);

    protected void validateURL(URL uRL) throws TraversalException {
        if (URLFileSystem.isDirectoryPath((URL)uRL)) {
            throw new TraversalException(ConnectionArb.format((String)"IMPEXP_NEED_FILE_ERROR", (Object[])new Object[]{URLFileSystem.getPlatformPathName((URL)uRL)}), ConnectionArb.getString((String)"IMPEXP_BAD_FILE_TITLE"));
        }
        if (!this.isURLAccepted(uRL)) {
            throw new TraversalException(ConnectionArb.format((String)this.getUnacceptableFileMessageID(), (Object[])new Object[]{URLFileSystem.getPlatformPathName((URL)uRL)}), ConnectionArb.getString((String)"IMPEXP_BAD_FILE_TITLE"));
        }
    }

    protected abstract String getUnacceptableFileMessageID();

    private class ChooserPanel {
        private URLFileChooser.URLFileChooserPanel mPanel;

        private ChooserPanel() {
        }

        synchronized URLFileChooser.URLFileChooserPanel getPanel() {
            if (this.mPanel == null) {
                this.mPanel = FilenamePanel.this.createChooserPanel();
                this.mPanel.setSelectionScope(0);
                this.mPanel.showEncodings(false);
                this.mPanel.setPathContext(FilenamePanel.class.getName() + ".filename");
            }
            return this.mPanel;
        }
    }
}

