/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.controls.display.DisplayScript;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutorTask;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.scriptrunner.utils.OutputRedirector;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.editor.BasicEditorPane;

public class DisplayTaskScript
extends DisplayScript {
    Object LOCK = new Object();
    ScriptExecutorTask next = null;
    ScriptExecutorTask current = null;
    FinishedYet l = null;

    @Override
    public void refresh(boolean bl) {
        final BasicEditorPane basicEditorPane = this.getCodeEditor();
        final Connection connection = this.getConnection();
        final String string = this.getQuery().getSql();
        ScriptExecutorTask scriptExecutorTask = new ScriptExecutorTask(Messages.getString("ResultSetTableModel.8"), IRaptorTaskRunMode.TASKVIEWER, false, true, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void startup() throws ExecutionException {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            DisplayTaskScript.this.init();
                            try {
                                basicEditorPane.getDocument().remove(0, basicEditorPane.getDocument().getLength());
                            }
                            catch (BadLocationException badLocationException) {
                                Logger.getLogger("DisplayTaskScript").log(Level.SEVERE, badLocationException.getStackTrace()[0].toString(), badLocationException);
                            }
                            basicEditorPane.setEditable(true);
                        }
                    });
                    this.setStmt(new BufferedReader(new StringReader(string)));
                    ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
                    Map<String, Bind> map = DisplayTaskScript.this.getFullValueBindMap();
                    scriptRunnerContext.putProperty("BINDMAP", map);
                    this.setScriptRunnerContext(scriptRunnerContext);
                    scriptRunnerContext.setEncoding("UTF-8");
                    PipedInputStream pipedInputStream = new PipedInputStream();
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
                    this.setOut(bufferedOutputStream);
                    this.setConnection(connection);
                    OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, basicEditorPane.getDocument(), basicEditorPane);
                    outputRedirector.setName(Messages.getString("DisplayScript.3"));
                    outputRedirector.start();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            basicEditorPane.setEditable(false);
                        }
                    });
                }
                catch (Exception exception) {
                    if (exception instanceof ExecutionException) {
                        throw (ExecutionException)exception;
                    }
                    DisplayTaskScript.this.handleException(exception);
                }
                if (Connections.getInstance().lock(connection)) {
                    try {
                        super.startup();
                    }
                    finally {
                        Connections.getInstance().unlock(connection);
                    }
                }
            }

            public boolean cancel() {
                boolean bl = super.cancel();
                try {
                    ScriptRunner scriptRunner = this.getScriptRunner();
                    if (scriptRunner != null) {
                        scriptRunner.cancel();
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger("DisplayTaskScript").log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
                return bl;
            }
        };
        this.startOrQueue(scriptExecutorTask);
    }

    @Override
    public void clear() {
        this.getCodeEditor().setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startOrQueue(ScriptExecutorTask scriptExecutorTask) {
        Object object = this.LOCK;
        synchronized (object) {
            this.next = scriptExecutorTask;
            if (this.l != null && !this.l.getFinished()) {
                this.current.requestCancel();
            } else {
                this.runNext(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runNext(FinishedYet finishedYet) {
        Object object = this.LOCK;
        synchronized (object) {
            if (finishedYet != null) {
                finishedYet.setFinished(true);
            }
            if (this.next == null) {
                return;
            }
            this.l = new FinishedYet();
            this.next.getDescriptor().addListener((IRaptorTaskListener)this.l);
            RaptorTaskManager.getInstance().addTask((RaptorTask)this.next);
            this.current = this.next;
            this.next = null;
        }
    }

    public class FinishedYet
    extends RaptorTaskAdapter {
        Object LOCK = new Object();
        private boolean finished = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getFinished() {
            Object object = this.LOCK;
            synchronized (object) {
                return this.finished;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFinished(boolean bl) {
            Object object = this.LOCK;
            synchronized (object) {
                this.finished = bl;
            }
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            DisplayTaskScript.this.runNext(this);
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            DisplayTaskScript.this.runNext(this);
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            DisplayTaskScript.this.runNext(this);
        }
    }
}

