/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.raptor.controls.display.chart.AbstractActionPanel;
import oracle.dbtools.raptor.controls.display.chart.AbstractLayoutPanel;
import oracle.dbtools.raptor.controls.display.chart.ChartPropertyManager;
import oracle.dbtools.raptor.controls.display.chart.EnumProperty;
import oracle.dbtools.raptor.controls.display.chart.PropertyEvent;
import oracle.dbtools.raptor.controls.display.chart.PropertyListener;
import oracle.dbtools.raptor.controls.display.chart.PropertyTable;
import oracle.dbtools.raptor.controls.display.chart.PropertyTableModel;
import oracle.dbtools.raptor.controls.display.chart.PropertyType;
import oracle.javatools.icons.OracleIcons;

abstract class AbstractPropertyPanel
extends AbstractLayoutPanel {
    protected ChartPropertyManager propertyManager;
    private EnumMap<PropertyType, List<ComponentManager>> componentTypeMap;
    private List<AbstractPropertyPanel> childPanels;

    AbstractPropertyPanel(ChartPropertyManager chartPropertyManager, int n) {
        super(n);
        this.propertyManager = chartPropertyManager;
        this.componentTypeMap = new EnumMap(PropertyType.class);
        this.childPanels = new ArrayList<AbstractPropertyPanel>();
    }

    void addLabel(PropertyType propertyType, int n, int n2, int n3, String string) {
        final JLabel jLabel = new JLabel(string);
        this.addToLookup(propertyType, new ComponentManager(){

            @Override
            JComponent component() {
                return jLabel;
            }
        });
        this.addComponent(jLabel, n, n2, n3, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.RIGHT);
    }

    void addComboBox(final PropertyType propertyType, int n, int n2, int n3, AbstractLayoutPanel.Align align, final EnumProperty[] enumPropertyArray) {
        final JComboBox<Object> jComboBox = new JComboBox<Object>();
        for (EnumProperty enumProperty : enumPropertyArray) {
            jComboBox.addItem(enumProperty.label());
        }
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = jComboBox.getSelectedIndex();
                AbstractPropertyPanel.this.propertyManager.set(propertyType, enumPropertyArray[n]);
            }
        });
        this.addToLookup(propertyType, new ComponentManager(){

            @Override
            JComponent component() {
                return jComboBox;
            }

            @Override
            void refreshComponentValue() {
                EnumProperty enumProperty = AbstractPropertyPanel.this.propertyManager.get(propertyType, EnumProperty.class);
                jComboBox.setSelectedItem(enumProperty.label());
            }
        });
        this.addComponent(jComboBox, n, n2, n3, AbstractLayoutPanel.SizeToFit.NEITHER, align);
    }

    void addComboBox(final PropertyType propertyType, int n, int n2, int n3, AbstractLayoutPanel.Align align, final PropertyType propertyType2, boolean bl) {
        final JComboBox jComboBox = new JComboBox();
        jComboBox.setEditable(bl);
        List list = this.propertyManager.get(propertyType2, List.class);
        for (Object e : list) {
            jComboBox.addItem(e);
        }
        this.propertyManager.addPropertyListener(new PropertyListener(){

            @Override
            public void onChange(PropertyEvent propertyEvent) {
                if (propertyEvent.changed(propertyType2)) {
                    jComboBox.removeAllItems();
                    List list = AbstractPropertyPanel.this.propertyManager.get(propertyType2, List.class);
                    for (Object e : list) {
                        jComboBox.addItem(e);
                    }
                }
            }
        });
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractPropertyPanel.this.propertyManager.set(propertyType, jComboBox.getSelectedItem());
            }
        });
        this.addToLookup(propertyType, new ComponentManager(){

            @Override
            JComponent component() {
                return jComboBox;
            }

            @Override
            void refreshComponentValue() {
                Object object = AbstractPropertyPanel.this.propertyManager.get(propertyType);
                jComboBox.setSelectedItem(object);
            }
        });
        this.addComponent(jComboBox, n, n2, n3, AbstractLayoutPanel.SizeToFit.NEITHER, align);
    }

    void addCheckBox(final PropertyType propertyType, int n, int n2, int n3, AbstractLayoutPanel.Align align, String string) {
        final JCheckBox jCheckBox = new JCheckBox();
        if (string != null) {
            jCheckBox.setText(string);
        }
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractPropertyPanel.this.propertyManager.set(propertyType, jCheckBox.isSelected());
            }
        });
        this.addToLookup(propertyType, new ComponentManager(){

            @Override
            JComponent component() {
                return jCheckBox;
            }

            @Override
            void refreshComponentValue() {
                jCheckBox.setSelected(AbstractPropertyPanel.this.propertyManager.get(propertyType, Boolean.class));
            }
        });
        this.addComponent(jCheckBox, n, n2, n3, AbstractLayoutPanel.SizeToFit.NEITHER, align);
    }

    void addTextField(final PropertyType propertyType, int n, int n2, int n3) {
        final JTextField jTextField = new JTextField();
        jTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractPropertyPanel.this.propertyManager.set(propertyType, jTextField.getText());
                    }
                });
            }
        });
        this.addToLookup(propertyType, new ComponentManager(){

            @Override
            JComponent component() {
                return jTextField;
            }

            @Override
            void refreshComponentValue() {
                jTextField.setText(AbstractPropertyPanel.this.propertyManager.get(propertyType, String.class));
            }
        });
        this.addComponent(jTextField, n, n2, n3, AbstractLayoutPanel.SizeToFit.X, AbstractLayoutPanel.Align.LEFT);
    }

    void addSpinner(final PropertyType propertyType, int n, int n2, int n3, SpinnerModel spinnerModel) {
        final JSpinner jSpinner = new JSpinner(spinnerModel);
        jSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AbstractPropertyPanel.this.propertyManager.set(propertyType, jSpinner.getValue());
            }
        });
        this.addToLookup(propertyType, new ComponentManager(){

            @Override
            JComponent component() {
                return jSpinner;
            }

            @Override
            void refreshComponentValue() {
                jSpinner.setValue(AbstractPropertyPanel.this.propertyManager.get(propertyType));
            }
        });
        this.addComponent(jSpinner, n, n2, n3, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.LEFT);
    }

    void addTable(PropertyType propertyType, int n, int n2, int n3, PropertyType[] propertyTypeArray, String[] stringArray, String string, boolean bl) {
        this.addTable(propertyType, n, n2, n3, propertyTypeArray, null, stringArray, string, bl);
    }

    void addTable(PropertyType propertyType, int n, int n2, int n3, PropertyType[] propertyTypeArray, PropertyType[] propertyTypeArray2, String[] stringArray, String string, boolean bl) {
        if (propertyTypeArray.length != stringArray.length) {
            throw new IllegalArgumentException();
        }
        final PropertyTableModel propertyTableModel = new PropertyTableModel(this.propertyManager, propertyType, propertyTypeArray, propertyTypeArray2, stringArray);
        final PropertyTable propertyTable = new PropertyTable(propertyTableModel);
        final JPanel jPanel = new JPanel(new GridBagLayout());
        propertyTable.setBorder(new LineBorder(Color.LIGHT_GRAY));
        propertyTable.getTableHeader().setBorder(new LineBorder(Color.LIGHT_GRAY));
        jPanel.add((Component)propertyTable.getTableHeader(), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)propertyTable, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (bl) {
            JButton jButton = new JButton(OracleIcons.getIcon((String)"add.png"));
            jPanel.add((Component)jButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 10), 0, 0));
            final JButton jButton2 = new JButton(OracleIcons.getIcon((String)"delete.png"));
            jPanel.add((Component)jButton2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 10), 0, 0));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    propertyTableModel.addRow();
                }
            });
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    propertyTableModel.removeRow(propertyTable.getSelectedRow());
                }
            });
            jButton2.setEnabled(false);
            propertyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    jButton2.setEnabled(propertyTable.getSelectedRow() >= 0);
                }
            });
        }
        jPanel.add((Component)new JLabel(), new GridBagConstraints(0, 100, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (string != null) {
            jPanel.setBorder(new TitledBorder(string));
        }
        this.addToLookup(propertyType, new ComponentManager(){

            @Override
            JComponent component() {
                return propertyTable;
            }

            @Override
            void setVisible(boolean bl) {
                jPanel.setVisible(bl);
            }

            @Override
            void refreshComponentValue() {
                propertyTableModel.refreshComponentValue();
            }
        });
        this.addComponent(jPanel, n, n2, n3, AbstractLayoutPanel.SizeToFit.BOTH, AbstractLayoutPanel.Align.LEFT);
    }

    void addButton(final PropertyType propertyType, int n, int n2, int n3, AbstractLayoutPanel.Align align, String string, final AbstractActionPanel abstractActionPanel) {
        final JButton jButton = new JButton(string);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = abstractActionPanel.callDialog(AbstractPropertyPanel.this, AbstractPropertyPanel.this.propertyManager.get(propertyType));
                if (object != null) {
                    AbstractPropertyPanel.this.propertyManager.set(propertyType, object);
                }
            }
        });
        this.addToLookup(propertyType, new ComponentManager(){

            @Override
            JComponent component() {
                return jButton;
            }
        });
        this.addComponent(jButton, n, n2, n3, AbstractLayoutPanel.SizeToFit.NEITHER, align);
    }

    void addPanel(AbstractPropertyPanel abstractPropertyPanel, int n, int n2, int n3, String string) {
        if (string != null) {
            abstractPropertyPanel.setBorder(new TitledBorder(string));
        }
        this.childPanels.add(abstractPropertyPanel);
        this.addComponent(abstractPropertyPanel, n, n2, n3, AbstractLayoutPanel.SizeToFit.BOTH, AbstractLayoutPanel.Align.LEFT);
    }

    void enableProperty(PropertyType propertyType, boolean bl) {
        List<ComponentManager> list = this.componentTypeMap.get((Object)propertyType);
        if (list != null) {
            for (ComponentManager componentManager : list) {
                componentManager.setEnabled(bl);
            }
        }
    }

    boolean refreshVisibility() {
        boolean bl;
        boolean bl2 = false;
        for (PropertyType object : this.componentTypeMap.keySet()) {
            bl = this.propertyManager.isApplicable(object);
            if (bl) {
                bl2 = true;
            }
            List<ComponentManager> list = this.componentTypeMap.get((Object)object);
            for (ComponentManager componentManager : list) {
                componentManager.setVisible(bl);
                if (!bl) continue;
                componentManager.refreshComponentValue();
            }
        }
        for (AbstractPropertyPanel abstractPropertyPanel : this.childPanels) {
            bl = abstractPropertyPanel.refreshVisibility();
            abstractPropertyPanel.setVisible(bl);
            if (!bl) continue;
            bl2 = true;
        }
        if (this.componentTypeMap.isEmpty() && this.childPanels.isEmpty()) {
            bl2 = true;
        }
        return bl2;
    }

    private void addToLookup(PropertyType propertyType, ComponentManager componentManager) {
        List<ComponentManager> list = this.componentTypeMap.get((Object)propertyType);
        if (list == null) {
            list = new ArrayList<ComponentManager>();
            this.componentTypeMap.put(propertyType, list);
        }
        list.add(componentManager);
    }

    private static abstract class ComponentManager {
        private ComponentManager() {
        }

        abstract JComponent component();

        void setEnabled(boolean bl) {
            this.component().setEnabled(bl);
        }

        void setVisible(boolean bl) {
            this.component().setVisible(bl);
        }

        void refreshComponentValue() {
        }
    }
}

